/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.UnresolvedItemInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.UnresolvedSource;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedItem
implements IUnresolvedItem {
    List<ILocalChange> localChanges = new ArrayList<ILocalChange>();
    List<UnresolvedItemInfo> patches = new ArrayList<UnresolvedItemInfo>();
    List<IConflictItem> conflictItems = new ArrayList<IConflictItem>();
    IUnresolvedFolder folder;

    @Override
    public Collection<IConflictItem> getConflictItems() {
        return Collections.unmodifiableCollection(this.conflictItems);
    }

    @Override
    public String getId() {
        return UnresolvedSource.getPath(this, true);
    }

    @Override
    public IUnresolvedFolder getFolder() {
        return this.folder;
    }

    @Override
    public Collection<IVersionableHandle> getHandles() {
        IVersionableHandle localHandle;
        ArrayList<IVersionableHandle> result = new ArrayList<IVersionableHandle>();
        IVersionableHandle iVersionableHandle = localHandle = this.localChanges.size() > 0 ? this.localChanges.get(0).getTarget() : null;
        if (localHandle != null) {
            result.add(localHandle);
        }
        for (IConflictItem conflictItem : this.conflictItems) {
            ILogicalChange logicalChange = conflictItem.getLogicalChange();
            IVersionableHandle conflictedHandle = logicalChange.item();
            if (ModelUtil.containsSameItemId(result, (IItemHandle)conflictedHandle)) continue;
            result.add(conflictedHandle);
        }
        return result;
    }

    @Override
    public Collection<ILocalChange> getLocalChanges() {
        return Collections.unmodifiableCollection(this.localChanges);
    }

    @Override
    public Collection getPatches() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (UnresolvedItemInfo itemInfo : this.patches) {
            result.add(itemInfo.item);
        }
        return result;
    }

    @Override
    public String getResourceName() {
        return UnresolvedSource.getResourceName(this);
    }
}

