/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingWorkspaceNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.UnresolvedSource;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OutgoingWorkspaceNode
implements IOutgoingActivitySource {
    List activities;
    List baselines;
    IContextHandle workspace;
    IAuditable owner;
    ComponentSyncContext context;
    Collection conflicts = null;

    public OutgoingWorkspaceNode(IComponentSyncContext context, IContextHandle workspace) {
        this.context = (ComponentSyncContext)context;
        this.workspace = workspace;
    }

    public List getActivities() {
        return this.activities != null ? Collections.unmodifiableList(this.activities) : Collections.EMPTY_LIST;
    }

    public int size() {
        List activities = this.activities;
        int nBaselines = this.baselines == null ? 0 : this.baselines.size();
        int nActivities = activities == null ? 0 : activities.size();
        return nBaselines + nActivities;
    }

    public List getBaselines() {
        return this.baselines != null ? Collections.unmodifiableList(this.baselines) : Collections.EMPTY_LIST;
    }

    public IComponentSyncContext getModel() {
        return this.context;
    }

    public String getName() {
        return IncomingWorkspaceNode.getWorkspaceName(this.workspace);
    }

    public IAuditable getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return IncomingWorkspaceNode.getOwnerName(this.owner);
    }

    public IWorkspace getWorkspace() {
        return this.workspace instanceof IWorkspace ? (IWorkspace)this.workspace : null;
    }

    public IBaseline getBaseline() {
        return this.workspace instanceof IBaseline ? (IBaseline)this.workspace : null;
    }

    public Collection getConflictItems() {
        return this.conflicts == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this.conflicts);
    }

    public void updateConflictItems() {
        ArrayList newConflicts;
        IUpdateReport updateReport = this.context.root.conflictReport;
        ILogicalConflictReport conflictReport = this.context.root.logicalConflictReport;
        Collection collection = newConflicts = updateReport != null && conflictReport != null ? ComponentConflictUtil.createConflictItems(updateReport, conflictReport, this) : new ArrayList();
        if (this.conflicts != null) {
            ArrayList oldConflicts = new ArrayList(this.conflicts);
            ComponentConflictUtil.update(oldConflicts, newConflicts);
            this.conflicts = oldConflicts;
        } else {
            this.conflicts = newConflicts;
        }
        ((UnresolvedSource)this.getModel().getUnresolvedSource()).update();
    }

    public void update(List activities, List baselines, IContextHandle workspace, IAuditable owner) {
        this.activities = activities;
        this.baselines = baselines;
        this.workspace = workspace;
        this.owner = owner;
    }
}

