/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ChangeInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IMultiComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiComponentSyncContext
implements IMultiComponentSyncContext {
    ComponentSyncModel model;
    public ITeamRepository repo;
    ChangeInput input;
    HashMap<UUID, List<IChangeSetHandle>[]> customChangeSetsPerComponent;

    public MultiComponentSyncContext(IComponentSyncModel model, ITeamRepository repo, ChangeInput input) {
        this.model = (ComponentSyncModel)model;
        this.repo = repo;
        this.input = input;
    }

    @Override
    public IComponentSyncContext[] getComponentSyncContexts() {
        return this.model.getComponentSyncContexts();
    }

    @Override
    public IComponentSyncModel getComponentSyncModel() {
        return this.model;
    }

    @Override
    public ChangeInput getChangeInput() {
        return this.input;
    }

    @Override
    public ITeamRepository teamRepository() {
        return this.repo;
    }

    public void refreshCustomChanges(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = ModelUtil.monitorFor(monitor);
        try {
            monitor.beginTask(Messages.MultiComponentSyncContext_0, 100);
            if (!(this.input instanceof CompareInput)) {
                throw new IllegalStateException("Only Compare Input supports custom change sets");
            }
            CompareInput input = (CompareInput)this.input;
            if (this.repo == null || !input.useCustomQuery()) {
                return;
            }
            this.customChangeSetsPerComponent = ComponentBaselineSetUtil.customChangeSetsPerComponent(input, this.repo, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        finally {
            monitor.done();
        }
    }

    public List<IChangeSetHandle> getCustomChanges(IComponentHandle component, boolean outgoing) throws TeamRepositoryException {
        List<IChangeSetHandle>[] value;
        HashMap<UUID, List<IChangeSetHandle>[]> customChangeSetsPerComponent = this.customChangeSetsPerComponent;
        List<IChangeSetHandle>[] listArray = value = customChangeSetsPerComponent != null ? customChangeSetsPerComponent.get(component.getItemId()) : null;
        return value != null ? value[outgoing ? 0 : 1] : Collections.EMPTY_LIST;
    }

    List<IChangeSetHandle> getCustomChanges() {
        HashMap<UUID, List<IChangeSetHandle>[]> customChangeSetsPerComponent = this.customChangeSetsPerComponent;
        if (customChangeSetsPerComponent == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IChangeSetHandle> result = new ArrayList<IChangeSetHandle>();
        for (List<IChangeSetHandle>[] value : customChangeSetsPerComponent.values()) {
            result.addAll(value[0]);
            result.addAll(value[1]);
        }
        return result;
    }
}

