/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.CompareToNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemBaseReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    public static final String DATA_NOT_AVAILABLE = "";
    public static final Date DATE_NOT_AVAILABLE = new Date();
    public static boolean TRACE_REFRESH = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.team.filesystem.rcp.core/trace.componentsyncmodel.refresh"));
    public static boolean TRACE_CONTEXTS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.team.filesystem.rcp.core/trace.componentsyncmodel.contexts"));
    public static boolean TRACE_ACTIVE_WORKSPACES = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.team.filesystem.rcp.core/trace.activeworkspaces"));

    public static Collection addCounterParts(Collection localChanges) {
        ArrayList<ILocalChange> forCommit = new ArrayList<ILocalChange>(localChanges);
        for (ILocalChange localChange : localChanges) {
            if (!localChange.isType(8)) continue;
            forCommit.add(localChange.getCounterpart());
        }
        return forCommit;
    }

    public static IChangeSetHandle commitToNewActivityLocalChanges(IWorkspaceConnection teamPlace, IComponentHandle component, Collection localChanges, boolean setCurrent, CommitDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        try {
            monitor.beginTask(Messages.ModelUtil_5, 100);
            localChanges = ModelUtil.addCounterParts(localChanges);
            ILocalChange[] toCommit = localChanges.toArray(new ILocalChange[localChanges.size()]);
            IChangeSetHandle changeSet = null;
            changeSet = teamPlace.createChangeSet(component, DATA_NOT_AVAILABLE, setCurrent, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
            if (toCommit.length != 0) {
                ICheckinOperation ncio = IOperationFactory.instance.getCheckinOperation(problemHandler);
                ncio.requestCheckin(teamPlace, component, toCommit, changeSet, null, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                ncio.run((IProgressMonitor)new SubProgressMonitor(monitor, 38));
            }
            IChangeSetHandle iChangeSetHandle = changeSet;
            return iChangeSetHandle;
        }
        finally {
            monitor.done();
        }
    }

    public static IChangeHistorySyncReport getHistorySyncReport(IWorkspaceConnection source, IWorkspaceConnection destination, IProgressMonitor monitor) throws TeamRepositoryException {
        return source.compareTo((IFlowNodeConnection)destination, WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY, Collections.EMPTY_LIST, monitor);
    }

    public static void accept(IWorkspaceConnection teamPlaceTo, IWorkspaceConnection teamPlaceFrom, IChangeHistorySyncReport syncReport, List changeSetHandles, WorkspaceUpdateDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.beginTask(Messages.ModelUtil_7, 100);
        IWorkspaceUpdateOperation acceptOp = IOperationFactory.instance.getWorkspaceUpdateOperation(problemHandler);
        acceptOp.accept(teamPlaceTo, teamPlaceFrom, syncReport, Collections.EMPTY_LIST, changeSetHandles, Collections.EMPTY_LIST);
        acceptOp.run((IProgressMonitor)progress.newChild(50));
        monitor.done();
    }

    public static List sort(List source, List reference) {
        if (source.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (source.size() == 1) {
            return Collections.singletonList(source.get(0));
        }
        ArrayList<IItemHandle> result = new ArrayList<IItemHandle>(source.size());
        for (IItemHandle element : reference) {
            if (!ModelUtil.containsSameItemId(source, element)) continue;
            result.add(element);
        }
        return result;
    }

    public static List sortActivities(Collection source, List reference) {
        if (source.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (source.size() == 1) {
            return Collections.singletonList(source.iterator().next());
        }
        ArrayList<IRemoteActivity> result = new ArrayList<IRemoteActivity>(source.size());
        for (IItemHandle element : reference) {
            IRemoteActivity other = ModelUtil.getSameItemId(source, element);
            if (other == null) continue;
            result.add(other);
        }
        return result;
    }

    public static boolean containsSameItemId(Collection list, IItemHandle handle) {
        for (IItemHandle other : list) {
            if (!handle.sameItemId(other)) continue;
            return true;
        }
        return false;
    }

    private static IRemoteActivity getSameItemId(Collection collection, IItemHandle handle) {
        for (IRemoteActivity other : collection) {
            if (!handle.sameItemId((IItemHandle)other.getChangeSetHandle())) continue;
            return other;
        }
        return null;
    }

    static boolean isUnresolved(ILogicalConflictReport conflictReport, IComponentHandle component, IChangeSummary changeSummary) {
        return !ModelUtil.getConflictsWith(component, changeSummary, conflictReport).isEmpty();
    }

    public static IItemUpdateReport getItemUpdateReport(IUpdateReport report, IChangeSummary changeSummary) {
        IVersionableHandle handle = changeSummary.item();
        Collection changes = report.updates();
        for (IItemUpdateReport itemReport : changes) {
            if (!itemReport.item().sameItemId((IItemHandle)handle)) continue;
            return itemReport;
        }
        return null;
    }

    public static IItemConflictReport getItemConflictReport(IUpdateReport report, IChangeSummary changeSummary) {
        IVersionableHandle handle = changeSummary.item();
        Collection changes = report.conflicts();
        for (IItemConflictReport itemReport : changes) {
            if (!itemReport.item().sameItemId((IItemHandle)handle)) continue;
            return itemReport;
        }
        return null;
    }

    public static boolean hasPotentialConflicts(IUpdateReport report, IComponentHandle component) {
        return !report.getConflictsForComponent(component).isEmpty();
    }

    static Collection<ILogicalChange> getConflictsWith(IComponentHandle component, IChangeSummary appliedChange, ILogicalConflictReport conflictReport) {
        return conflictReport != null ? conflictReport.getPendingChanges(component, appliedChange) : Collections.EMPTY_LIST;
    }

    static Collection<ILogicalChange> getConflictFor(IComponentHandle component, IChangeSummary proposedChange, ILogicalConflictReport conflictReport) {
        return conflictReport != null ? conflictReport.getChange(component, proposedChange.item()) : Collections.EMPTY_LIST;
    }

    static List getVersionableHandles(Collection itemBaseReports) {
        ArrayList<IVersionableHandle> handles = new ArrayList<IVersionableHandle>();
        for (IItemBaseReport itemReport : itemBaseReports) {
            handles.add(itemReport.item());
        }
        return handles;
    }

    static boolean contains(List changeSummaries, IVersionableHandle handle) {
        for (IChangeSummary changeSummary : changeSummaries) {
            if (!changeSummary.item().sameItemId((IItemHandle)handle)) continue;
            return true;
        }
        return false;
    }

    static void print(ITeamRepository repo, IUpdateReport report) {
        Collection updates = report.updates();
        System.out.println("Updates (" + updates.size() + ")");
        for (IItemUpdateReport itemReport : updates) {
            System.out.println(" item: " + itemReport.item());
            System.out.println();
            System.out.println(" NewCurrentState:" + itemReport.getNewCurrentState());
            System.out.println(" PreviousState: " + itemReport.getPreviousState());
            if (!(itemReport.item() instanceof IFileItemHandle)) {
                return;
            }
            System.out.println();
            System.out.println(" NewCurrent content: " + ModelUtil.getContent(repo, (IFileItemHandle)itemReport.getNewCurrentState()));
            System.out.println(" Previous content: " + ModelUtil.getContent(repo, (IFileItemHandle)itemReport.getPreviousState()));
        }
        Collection conflicts = report.conflicts();
        System.out.println("Conflicts (" + conflicts.size() + ")");
        for (IItemConflictReport itemReport : conflicts) {
            System.out.println(" item: " + itemReport.item());
            System.out.println();
            System.out.println(" CommonAncestorState:" + itemReport.getCommonAncestorState());
            System.out.println(" SelectedContributorState:" + itemReport.getSelectedContributorState());
            System.out.println(" ProposedContributorState:" + itemReport.getProposedContributorState());
            if (!(itemReport.item() instanceof IFileItemHandle)) {
                return;
            }
            System.out.println();
            System.out.println(" CommonAncestor content: " + ModelUtil.getContent(repo, (IFileItemHandle)itemReport.getCommonAncestorState()));
            System.out.println(" Selected content: " + ModelUtil.getContent(repo, (IFileItemHandle)itemReport.getSelectedContributorState()));
            System.out.println(" Proposed content: " + ModelUtil.getContent(repo, (IFileItemHandle)itemReport.getProposedContributorState()));
        }
    }

    static String getContent(ITeamRepository repo, IFileItemHandle handle) {
        try {
            IFileItem fileItem = (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState((IVersionableHandle)handle, null);
            ByteArrayOutputStream contents = new ByteArrayOutputStream();
            FileSystemCore.getContentManager((ITeamRepository)repo).retrieveContent((IFileItemHandle)fileItem, fileItem.getContent(), (OutputStream)contents, null);
            return contents.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        return monitor == null ? new NullProgressMonitor() : monitor;
    }

    public static String[] getPathHint(IChangeSummary changeSummary) {
        return !changeSummary.isChangeType(8) ? changeSummary.getPathHint() : changeSummary.getNewPathHint();
    }

    public static IItemHandle find(List itemHandles, IItemHandle item, boolean checkStateId) {
        if (itemHandles == null || item == null) {
            throw new IllegalArgumentException();
        }
        for (IItemHandle current : itemHandles) {
            if (!current.sameItemId(item) || checkStateId && !current.sameStateId(item)) continue;
            return current;
        }
        return null;
    }

    static List excludedComponents(IConnection connection, IComponentHandle target) {
        ArrayList<IComponentHandle> excludedComponents = new ArrayList<IComponentHandle>();
        try {
            List<IComponentHandle> components = null;
            if (connection instanceof IWorkspaceConnection) {
                components = ((IWorkspaceConnection)connection).getComponents();
            } else if (connection instanceof IBaselineConnection) {
                components = Collections.singletonList(((IBaselineConnection)connection).getComponent());
            } else {
                throw new IllegalArgumentException("Unsupported Type " + connection);
            }
            for (IComponentHandle component : components) {
                if (component.sameItemId((IItemHandle)target)) continue;
                excludedComponents.add(component);
            }
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log(CompareToNode.class, (Throwable)e);
        }
        return excludedComponents;
    }

    public static IChangeHistory changeHistory(IConnection connection, IComponentHandle component) throws TeamRepositoryException {
        if (connection instanceof IWorkspaceConnection) {
            return ((IWorkspaceConnection)connection).changeHistory(component);
        }
        if (connection instanceof IBaselineConnection) {
            return ((IBaselineConnection)connection).changeHistory();
        }
        throw new IllegalArgumentException("Unsupported type " + connection);
    }

    public static IChangeHistorySyncReport compareTo(IConnection connectionFrom, IConnection connectionTo, int flags, IComponentHandle target, IProgressMonitor monitor) throws TeamRepositoryException {
        long traceBegin = 0L;
        if (TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("ModelUtil.compareTo");
        }
        try {
            if (connectionTo instanceof IWorkspaceConnection && connectionFrom instanceof IWorkspaceConnection) {
                List excludedComponents = target != null ? ModelUtil.excludedComponents(connectionFrom, target) : Collections.EMPTY_LIST;
                IChangeHistorySyncReport iChangeHistorySyncReport = ((IWorkspaceConnection)connectionFrom).compareTo((IFlowNodeConnection)((IWorkspaceConnection)connectionTo), flags, excludedComponents, monitor);
                return iChangeHistorySyncReport;
            }
            if (target == null) {
                if (connectionTo instanceof IBaselineConnection) {
                    target = ((IBaselineConnection)connectionTo).getComponent();
                } else if (connectionFrom instanceof IBaselineConnection) {
                    target = ((IBaselineConnection)connectionFrom).getComponent();
                }
            }
            IChangeHistorySyncReport iChangeHistorySyncReport = ModelUtil.changeHistory(connectionFrom, target).compareChangeHistories(ModelUtil.changeHistory(connectionTo, target), monitor);
            return iChangeHistorySyncReport;
        }
        finally {
            if (TRACE_REFRESH) {
                ModelUtil.logEnd("ModelUtil.compareTo", traceBegin);
            }
        }
    }

    public static boolean hasComponent(IConnection connection, IComponentHandle component) throws TeamRepositoryException {
        List<IComponentHandle> components = ModelUtil.getComponents(connection);
        for (IComponentHandle current : components) {
            if (!component.sameItemId((IItemHandle)current)) continue;
            return true;
        }
        return false;
    }

    public static List<IComponentHandle> getComponents(IConnection connection) throws TeamRepositoryException {
        try {
            if (connection instanceof IWorkspaceConnection) {
                return ((IWorkspaceConnection)connection).getComponents();
            }
            if (connection instanceof IBaselineConnection) {
                return Collections.singletonList(((IBaselineConnection)connection).getComponent());
            }
            throw new IllegalArgumentException("Unsupported type " + connection);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return Collections.EMPTY_LIST;
        }
    }

    public static List getCommonComponents(IConnection c1, IConnection c2) throws TeamRepositoryException {
        List<IComponentHandle> components1 = ModelUtil.getComponents(c1);
        ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>();
        for (IComponentHandle component : components1) {
            if (!ModelUtil.hasComponent(c2, component)) continue;
            result.add(component);
        }
        return result;
    }

    public static Collection<IChangeSetHandle> newChangeSetsAfterBasis(Collection<IComponentSyncContext> contexts, boolean includeActiveChangeSets, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)contexts.size());
        ArrayList<IChangeSetHandle> result = new ArrayList<IChangeSetHandle>();
        try {
            for (IComponentSyncContext context : contexts) {
                IChangeHistorySyncReport newReport;
                IWorkspaceConnection target;
                context.getComponentSyncModel();
                int flags = ((ComponentSyncModel)context.getComponentSyncModel()).getCompareToFlags();
                IWorkspaceConnection source = context.getOutgoingTeamPlace();
                if (source == null || (target = context.getIncomingTeamPlace()) == null) continue;
                IComponent component = context.getComponent();
                if (includeActiveChangeSets) {
                    result.addAll(source.activeChangeSets((IComponentHandle)component));
                }
                if (context.getType() != 2) continue;
                IChangeHistorySyncReport oldReport = context.getChangeHistorySyncReport();
                SyncCache.SyncDataFlow data = SyncCache.get().fetch(source, target, flags, (IProgressMonitor)progress.newChild(1));
                IChangeHistorySyncReport iChangeHistorySyncReport = newReport = data != null ? data.syncReport : null;
                if (newReport == null) continue;
                if (oldReport == null) {
                    result.addAll(newReport.incomingChangeSetsAfterBasis((IComponentHandle)component));
                    result.addAll(newReport.outgoingChangeSetsAfterBasis((IComponentHandle)component));
                    continue;
                }
                result.addAll(ComponentBaselineUtil.diff(newReport.incomingChangeSetsAfterBasis(), oldReport.incomingChangeSetsAfterBasis()));
                result.addAll(ComponentBaselineUtil.diff(newReport.outgoingChangeSetsAfterBasis(), oldReport.outgoingChangeSetsAfterBasis()));
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public static void log(String log) {
        System.out.println(log);
    }

    public static void log(String log, boolean showStackTrace) {
        new Throwable(log).printStackTrace(System.out);
    }

    public static long logBegin(String log) {
        long begin = System.currentTimeMillis();
        System.out.println("BEGIN:\t" + log + " (" + new Date(begin) + ")");
        return begin;
    }

    public static void logEnd(String log, long begin) {
        long delay = System.currentTimeMillis() - begin;
        System.out.println("END:\t" + log + " (" + delay + " ms" + ModelUtil.marker(delay) + ")");
    }

    private static String marker(long delay) {
        if (delay < 1000L) {
            return DATA_NOT_AVAILABLE;
        }
        if (delay < 10000L) {
            return ">>";
        }
        if (delay < 60000L) {
            return ">>>";
        }
        if (delay < 300000L) {
            return ">>>>";
        }
        return ">>>>>";
    }
}

