/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingWorkspaceNode;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ConflictItemNode
implements IConflictItem {
    IVersionableHandle handle;
    int type;
    IItemConflictReport conflict;
    ILogicalChange logicalChange;
    OutgoingWorkspaceNode parent;

    public ConflictItemNode(OutgoingWorkspaceNode parent, IItemConflictReport conflict, int type, ILogicalChange logicalChange) {
        this.parent = parent;
        this.conflict = conflict;
        this.type = type;
        this.logicalChange = logicalChange;
        this.handle = conflict != null ? conflict.item() : logicalChange.item();
    }

    public IVersionableHandle getItem() {
        return this.handle;
    }

    public int getType() {
        return this.type;
    }

    public IOutgoingActivitySource getOutgoingActivitySource() {
        return this.parent;
    }

    public ILogicalChange getLogicalChange() {
        return this.logicalChange;
    }

    public IItemConflictReport getItemConflictReport() {
        return this.conflict;
    }

    public String getResourceName(boolean includePath) {
        return this.getResourceName(false, includePath);
    }

    public String getResourceName(boolean newPathHint, boolean includePath) {
        StringBuffer result = null;
        if (this.logicalChange != null) {
            String[] path;
            String[] stringArray = path = newPathHint ? this.logicalChange.getNewPathHint() : this.logicalChange.getPathHint();
            if (path == null) {
                path = this.logicalChange.getPathHint();
            }
            if (!includePath && path.length >= 1) {
                return path[path.length - 1];
            }
            result = new StringBuffer();
            int i = 0;
            while (i < path.length) {
                result.append(path[i]);
                if (i < path.length - 1) {
                    result.append('/');
                }
                ++i;
            }
        }
        return result != null && result.length() > 0 ? result.toString() : Messages.ConflictItemNode_0;
    }

    static String getLogDescription(IItemConflictReport conflict) {
        String result = "";
        IVersionableHandle handle = conflict.item();
        result = String.valueOf(result) + "item: " + handle.getItemId().getUuidValue() + " - Proposed state: " + (conflict.getProposedContributorState() != null ? conflict.getProposedContributorState().getStateId().getUuidValue() : "<null>") + " - Selected state: " + (conflict.getSelectedContributorState() != null ? conflict.getSelectedContributorState().getStateId().getUuidValue() : "<null>") + " - Previous state: " + (conflict.getCommonAncestorState() != null ? conflict.getCommonAncestorState().getStateId().getUuidValue() : "<null>");
        return result;
    }

    static String getLogDescription(ILogicalChange logicalChange) {
        StringBuffer result = new StringBuffer();
        IVersionableHandle handle = logicalChange.item();
        result.append("item: ").append(handle.getItemId().getUuidValue());
        String[] path = logicalChange.getPathHint();
        int i = 0;
        while (i < path.length) {
            result.append("/").append(path[i]);
            ++i;
        }
        if (logicalChange.isChangeType(1)) {
            result.append(" (change type: add)");
        } else if (logicalChange.isChangeType(2)) {
            result.append(" (change type: delete)");
        } else if (logicalChange.isChangeType(4) && logicalChange.isChangeType(8)) {
            result.append(" (change type: modify, move)");
        } else if (logicalChange.isChangeType(4)) {
            result.append(" (change type: modify)");
        } else if (logicalChange.isChangeType(8)) {
            result.append(" (change type: move)");
        } else if (logicalChange.isChangeType(16)) {
            result.append(" (change type: noop)");
        }
        if (logicalChange instanceof ILogicalConflict) {
            ILogicalConflict logicalConflict = (ILogicalConflict)logicalChange;
            switch (logicalConflict.conflictType()) {
                case 2: {
                    result.append(" (conflict type: add-delete)");
                    break;
                }
                case 3: {
                    result.append(" (conflict type: delete-add)");
                    break;
                }
                case 5: {
                    result.append(" (conflict type: delete-modify)");
                    break;
                }
                case 10: {
                    result.append(" (conflict type: modify-delete)");
                    break;
                }
                case 1: {
                    result.append(" (conflict type: add-add)");
                    break;
                }
                case 9: {
                    result.append(" (conflict type: modify-modify)");
                    break;
                }
                case 7: {
                    result.append(" (conflict type: move-add)");
                    break;
                }
                case 6: {
                    result.append(" (conflict type: move-move)");
                    break;
                }
                case 8: {
                    result.append(" (conflict type: move-delete)");
                    break;
                }
                case 4: {
                    result.append(" (conflict type: delete-move)");
                }
            }
        }
        return result.toString();
    }

    public void update(ConflictItemNode other) {
        if (!ConflictItemNode.sameItem(this, other)) {
            throw new IllegalStateException("Updating with conflict item representing different item");
        }
        this.conflict = other.conflict;
        this.logicalChange = other.logicalChange;
    }

    public static boolean sameItem(ConflictItemNode node, ConflictItemNode other) {
        if (!node.handle.sameItemId((IItemHandle)other.handle)) {
            return false;
        }
        if (node.parent != other.parent) {
            return false;
        }
        if (node.logicalChange.kind() != other.logicalChange.kind()) {
            return false;
        }
        return node.logicalChange.kind() == 1 && ((ILogicalConflict)node.logicalChange).conflictType() == ((ILogicalConflict)other.logicalChange).conflictType();
    }

    public String getFullPath(boolean newPath, IProgressMonitor progress) {
        List pathHint;
        String name = null;
        IWorkspaceConnection connection = this.getOutgoingActivitySource().getModel().getOutgoingTeamPlace();
        List list = pathHint = newPath ? this.getLogicalChange().getNewAncestorPathHint() : this.getLogicalChange().getAncestorPathHint();
        if (pathHint == null) {
            pathHint = this.getLogicalChange().getAncestorPathHint();
        }
        try {
            IPath relativePath = ComponentSyncUtil.findRelativePath(connection.getContextHandle(), this.getLogicalChange().component(), pathHint, progress);
            if (relativePath != null) {
                name = relativePath.toPortableString();
            }
        }
        catch (FileSystemClientException fileSystemClientException) {}
        if (name == null) {
            StringBuffer result = new StringBuffer();
            Iterator iterator = pathHint.iterator();
            while (iterator.hasNext()) {
                INameItemPair pair = (INameItemPair)iterator.next();
                result.append(pair.getName());
                if (!iterator.hasNext()) continue;
                result.append('/');
            }
            if (result.length() > 0) {
                name = result.toString();
            }
        }
        return name == null ? Messages.ConflictItemNode_0 : name;
    }

    public String getName(boolean newName) {
        if (this.logicalChange != null) {
            String[] path;
            String[] stringArray = path = newName ? this.logicalChange.getNewPathHint() : this.logicalChange.getPathHint();
            if (path == null) {
                path = this.logicalChange.getPathHint();
            }
            if (path.length >= 1) {
                return path[path.length - 1];
            }
        }
        return Messages.ConflictItemNode_0;
    }

    public String getLocalPath(IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        String name = null;
        IWorkspaceConnection connection = this.getOutgoingActivitySource().getModel().getOutgoingTeamPlace();
        try {
            IShareable shareable = ComponentSyncUtil.findShareable(connection.getContextHandle(), this.getLogicalChange().component(), this.getItem(), (IProgressMonitor)monitor.newChild(80));
            if (shareable != null) {
                name = shareable.getLocalPath().toPortableString();
            }
        }
        catch (FileSystemClientException fileSystemClientException) {}
        if (name == null) {
            name = this.getFullPath(false, (IProgressMonitor)monitor.newChild(20));
        }
        return name;
    }
}

