/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.IComponentSyncManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.LocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.QueryCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineSetSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IMultiComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.WorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.listeners.EventManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IMutate;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSyncModel
extends EventSource
implements IComponentSyncModel {
    public static final String REQUEST_INIT = "requestInit";
    public static final boolean DEGRADED_NOCHANGES = Boolean.getBoolean("com.ibm.team.filesystem.rcp.core.degraded.noChanges");
    public static final boolean DEGRADED_NOWORKITEMS = Boolean.getBoolean("com.ibm.team.filesystem.rcp.core.degraded.noWorkItems");
    static ComponentSyncModel INSTANCE;
    ComponentSyncManager syncManager;
    LocalSynchronizationManager localSynchronizationManager;
    EventManager eventManager;
    public IMultiComponentSyncContext multiContext = null;
    public volatile Set<IWorkspaceSyncContext> workspaceContexts = Collections.synchronizedSet(new HashSet());
    public volatile Set<IComponentSyncContext> componentContexts = Collections.synchronizedSet(new HashSet());
    public volatile Set<ITeamRepository> teamRepositories = Collections.synchronizedSet(new HashSet());
    public IBaselineSetSyncContext baselineSetSyncContext;
    public volatile CompareInput input;
    volatile int compareToFlags;
    volatile int maxChangesPerChangeSet;
    volatile boolean isDisposed;
    public QueryCache cache;

    public static synchronized IComponentSyncModel getInstance() {
        if (INSTANCE == null) {
            IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
            boolean hide = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getBoolean("hide_empty_baselines");
            int flags = WorkspaceComparisonFlags.INCLUDE_BASELINE_INFO | WorkspaceComparisonFlags.INCLUDE_REPLACED_COMPONENT_INFO;
            if (!hide) {
                flags |= WorkspaceComparisonFlags.INCLUDE_EMPTY_BASELINES;
            }
            int maxChanges = FileSystemResourcesPlugin.getDefault().getPluginPreferences().getInt("max_changes_per_change_set");
            ComponentSyncModel model = new ComponentSyncModel(manager, flags, maxChanges);
            UserLockCacheManager.init(model);
            model.queueEvent(new Event((IEventSource)model, REQUEST_INIT));
            INSTANCE = model;
        }
        return INSTANCE;
    }

    public ComponentSyncModel(IActiveWorkspaceManager manager, int compareToFlags, int maxChanges) {
        this.localSynchronizationManager = new LocalSynchronizationManager(this);
        this.syncManager = new ComponentSyncManager(manager);
        this.eventManager = new EventManager(this, manager);
        this.compareToFlags = compareToFlags;
        this.maxChangesPerChangeSet = maxChanges;
    }

    @Override
    public IComponentSyncManager getComponentSyncManager() {
        return this.syncManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public ILocalSynchronizationManager getLocalSynchronizationManager() {
        return this.localSynchronizationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMultiComponentSyncContext[] getMultiComponentSyncContexts() {
        if (this.baselineSetSyncContext != null) {
            return new IMultiComponentSyncContext[]{this.baselineSetSyncContext};
        }
        if (this.multiContext != null) {
            return new IMultiComponentSyncContext[]{this.multiContext};
        }
        Set<IWorkspaceSyncContext> set = this.workspaceContexts;
        synchronized (set) {
            return this.workspaceContexts.toArray(new IMultiComponentSyncContext[this.workspaceContexts.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkspaceSyncContext[] getWorkspaceSyncContexts() {
        Set<IWorkspaceSyncContext> set = this.workspaceContexts;
        synchronized (set) {
            return this.workspaceContexts.toArray(new IWorkspaceSyncContext[this.workspaceContexts.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkspaceSyncContext getWorkspaceSyncContext(IWorkspaceConnection wc) {
        Set<IWorkspaceSyncContext> set = this.workspaceContexts;
        synchronized (set) {
            for (IWorkspaceSyncContext wsc : this.workspaceContexts) {
                if (!wsc.getLocal().equals((Object)wc)) continue;
                return wsc;
            }
        }
        return null;
    }

    @Override
    public IBaselineSetSyncContext getBaselineSetSyncContext() {
        return this.baselineSetSyncContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IComponentSyncContext[] getComponentSyncContexts() {
        Set<IComponentSyncContext> set = this.componentContexts;
        synchronized (set) {
            return this.componentContexts.toArray(new IComponentSyncContext[this.componentContexts.size()]);
        }
    }

    @Override
    public IComponentSyncContext getComponentSyncContext(IConnection connection, IComponentHandle component) {
        IComponentSyncContext[] contexts = this.getComponentSyncContexts(connection, component);
        return contexts.length == 0 ? null : contexts[0];
    }

    @Override
    public IComponentSyncContext[] getComponentSyncContexts(IConnection connection, IComponentHandle component) {
        Collection<IComponentSyncContext> result = this.getComponentSyncContexts(connection, component, null);
        return result.toArray(new IComponentSyncContext[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IComponentSyncContext> getComponentSyncContexts(IConnection connection, IComponentHandle component, IConnection remote) {
        ArrayList<IComponentSyncContext> contexts = new ArrayList<IComponentSyncContext>();
        Set<IComponentSyncContext> set = this.componentContexts;
        synchronized (set) {
            for (IComponentSyncContext context : this.componentContexts) {
                if (context.getOutgoingConnection() != connection || !context.getComponent().sameItemId((IItemHandle)component) || remote != null && context.getIncomingConnection() != remote) continue;
                contexts.add(context);
            }
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITeamRepository[] getTeamRepositories() {
        Set<ITeamRepository> set = this.teamRepositories;
        synchronized (set) {
            return this.teamRepositories.toArray(new ITeamRepository[this.teamRepositories.size()]);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose() {
        IComponentSyncContext[] contexts;
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        IComponentSyncContext[] iComponentSyncContextArray = contexts = this.getComponentSyncContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (!context.isDisposed()) {
                context.dispose();
            }
            ++n2;
        }
        if (this.syncManager != null) {
            this.syncManager.dispose();
        }
        if (this.localSynchronizationManager != null) {
            this.localSynchronizationManager.dispose();
        }
        if (this.eventManager != null) {
            this.eventManager.dispose();
        }
        this.eventManager = null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void refresh(boolean full, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        block37: {
            try {
                this.acquire();
                traceBegin = 0L;
                if (ModelUtil.TRACE_REFRESH) {
                    traceBegin = ModelUtil.logBegin("ComponentSyncModel.refresh full " + full);
                }
                progress = SubMonitor.convert((IProgressMonitor)monitor, (String)(full != false ? Messages.ComponentSyncModel_23 : Messages.ComponentSyncModel_24), (int)100);
                try {
                    block38: {
                        if (this.isDisposed) lbl-1000:
                        // 3 sources

                        {
                            return;
                        }
                        if (!full) break block38;
                        this.getComponentSyncManager().update((IProgressMonitor)progress.newChild(10));
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        contexts = this.getComponentSyncContexts();
                        subMonitor = progress.newChild(90);
                        try {
                            subMonitor.beginTask(NLS.bind((String)Messages.ComponentSyncModel_25, (Object)contexts.length), 100);
                            wscs = this.getWorkspaceSyncContexts();
                            loopProgress = subMonitor.newChild(50).setWorkRemaining(wscs.length);
                            i = 0;
                            while (i < wscs.length) {
                                iterProgress = loopProgress.newChild(1).setWorkRemaining(full != false ? 2 : 1);
                                input = wscs[i].getChangeInput();
                                if (input instanceof CompareInput && ((CompareInput)input).useCustomQuery()) {
                                    ((WorkspaceSyncContext)wscs[i]).refreshCustomChanges((IProgressMonitor)iterProgress.newChild(1));
                                    if (full) {
                                        handles = ((WorkspaceSyncContext)wscs[i]).getCustomChanges();
                                        wscs[i].teamRepository().itemManager().fetchCompleteItems(handles, 1, (IProgressMonitor)iterProgress.newChild(1));
                                    }
                                }
                                iterProgress.done();
                                ++i;
                            }
                            loopProgress.done();
                            if (this.input == null) {
                                var13_22 = contexts;
                                input = contexts.length;
                                iterProgress = 0;
                                while (iterProgress < input) {
                                    context = var13_22[iterProgress];
                                    for (IRemoteActivity activity : context.getOutgoingActivitySource().getActivities()) {
                                        if (!context.isActive(activity)) continue;
                                        ((ComponentSyncContext)context).markDirty((IMutate)activity);
                                    }
                                    ++iterProgress;
                                }
                                subMonitor.setWorkRemaining(55);
                                changeSets = ModelUtil.newChangeSetsAfterBasis(Arrays.asList(contexts), true, (IProgressMonitor)subMonitor.newChild(2));
                                this.cache = new QueryCache();
                                this.cache.getChangeSetLinkSummary(changeSets, (IProgressMonitor)subMonitor.newChild(3));
                            }
                            subMonitor.setWorkRemaining(contexts.length);
                            i = 0;
                            while (i < contexts.length) {
                                subMonitor.subTask(String.valueOf(Messages.ComponentSyncModel_16) + contexts[i].getComponent().getName());
                                localChangeSource = contexts[i].getLocalChangeSource();
                                if (localChangeSource != null) {
                                    localChangeSource.update();
                                }
                                subMonitor.subTask("Synchronizing component " + contexts[i].getComponent().getName());
                                v0 = isCompareInput = contexts[i].getWorkspaceSyncContext() != null && contexts[i].getWorkspaceSyncContext().getChangeInput() != null;
                                if (isCompareInput) {
                                    ((ComponentSyncContext)contexts[i]).refresh(true, (IProgressMonitor)subMonitor.newChild(1));
                                } else {
                                    ((ComponentSyncContext)contexts[i]).refreshCompare((IProgressMonitor)subMonitor.newChild(1));
                                }
                                if (subMonitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                if (this.isDisposed) ** GOTO lbl-1000
                                ++i;
                            }
                        }
                        finally {
                            this.cache = null;
                            subMonitor.done();
                            ** continue;
                        }
                        lsm = this.getLocalSynchronizationManager();
                        if (lsm != null) {
                            lsm.update();
                        }
                        break block37;
                    }
                    contexts = this.getComponentSyncContexts();
                    subMonitor = progress.newChild(100);
                    try {
                        subMonitor.beginTask(NLS.bind((String)Messages.ComponentSyncModel_26, (Object)contexts.length), contexts.length);
                        i = 0;
                        while (i < contexts.length) {
                            subMonitor.subTask(NLS.bind((String)Messages.ComponentSyncModel_27, (Object)contexts[i].getComponent().getName()));
                            contexts[i].refresh(false, (IProgressMonitor)subMonitor.newChild(1));
                            if (subMonitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            ++i;
                        }
                    }
                    finally {
                        subMonitor.done();
                    }
                }
                finally {
                    if (ModelUtil.TRACE_REFRESH) {
                        ModelUtil.logEnd("ComponentSyncModel.refresh", traceBegin);
                    }
                    progress.done();
                }
            }
            finally {
                this.release();
            }
        }
        try {
            this.eventManager.updateChangesJob.join();
        }
        catch (InterruptedException v1) {}
    }

    @Override
    public void addGenericListener(IListener listener) {
        this.addGenericListener("autoSaveCompleted", listener);
        this.addGenericListener("currentActivity", listener);
        this.addGenericListener("loggedIn", listener);
        this.addGenericListener("refreshedRemoteStarted", listener);
        this.addGenericListener("refreshedRemoteCompleted", listener);
        this.addGenericListener("refreshedRemoteProgress", listener);
        this.addGenericListener("refreshedRemoteConnectionError", listener);
        this.addGenericListener("shareablesChangedRefreshed", listener);
        this.addGenericListener("loadedComponents", listener);
        this.addGenericListener("refreshedUnresolvedCompleted", listener);
        this.addGenericListener("workspaceSyncContexts", listener);
        this.addGenericListener("componentSyncContexts", listener);
    }

    @Override
    public void removeGenericListener(IListener listener) {
        this.removeGenericListener("autoSaveCompleted", listener);
        this.removeGenericListener("currentActivity", listener);
        this.removeGenericListener("loggedIn", listener);
        this.removeGenericListener("refreshedRemoteStarted", listener);
        this.removeGenericListener("refreshedRemoteCompleted", listener);
        this.removeGenericListener("refreshedRemoteProgress", listener);
        this.removeGenericListener("refreshedRemoteConnectionError", listener);
        this.removeGenericListener("shareablesChangedRefreshed", listener);
        this.removeGenericListener("loadedComponents", listener);
        this.removeGenericListener("refreshedUnresolvedCompleted", listener);
        this.removeGenericListener("workspaceSyncContexts", listener);
        this.removeGenericListener("componentSyncContexts", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        ComponentSyncModel oldModel = null;
        Class<ComponentSyncModel> clazz = ComponentSyncModel.class;
        synchronized (ComponentSyncModel.class) {
            oldModel = INSTANCE;
            INSTANCE = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (oldModel != null) {
                oldModel.syncManager.clear();
                oldModel.dispose();
                UserLockCacheManager.clear();
            }
            return;
        }
    }

    @Override
    public void deliver(Collection syncModelElements, DeliverDilemmaHandler handler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IDeliverOperation deliverOp = IOperationFactory.instance.getDeliverOperation(handler);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor loopProgress = progress.newChild(10).setWorkRemaining(syncModelElements.size());
        for (Object object : syncModelElements) {
            if (object instanceof IWorkspaceSyncContext) {
                IWorkspaceSyncContext wsc = (IWorkspaceSyncContext)object;
                IComponentSyncContext[] contexts = wsc.getComponentSyncContexts();
                SubMonitor componentsProgress = loopProgress.newChild(1).setWorkRemaining(contexts.length);
                IComponentSyncContext[] iComponentSyncContextArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IComponentSyncContext context = iComponentSyncContextArray[n2];
                    if (context.getType() != 1) {
                        IChangeHistorySyncReport report = SyncCache.get().fetch((IWorkspaceConnection)context.getOutgoingTeamPlace(), (IWorkspaceConnection)context.getIncomingTeamPlace(), (int)this.compareToFlags, (IProgressMonitor)componentsProgress.newChild((int)1)).syncReport;
                        deliverOp.deliver(context.getOutgoingTeamPlace(), context.getIncomingTeamPlace(), report, (IComponentHandle)context.getComponent(), true);
                    }
                    ++n2;
                }
                continue;
            }
            if (object instanceof IComponentSyncContext || object instanceof IOutgoingActivitySource) {
                IComponentSyncContext context = ComponentSyncUtil.getContext(object);
                if (context.getType() == 1) continue;
                IChangeHistorySyncReport report = SyncCache.get().fetch((IWorkspaceConnection)context.getOutgoingTeamPlace(), (IWorkspaceConnection)context.getIncomingTeamPlace(), (int)this.compareToFlags, (IProgressMonitor)loopProgress.newChild((int)1)).syncReport;
                deliverOp.deliver(context.getOutgoingTeamPlace(), context.getIncomingTeamPlace(), report, (IComponentHandle)context.getComponent(), false);
                continue;
            }
            if (object instanceof IOutgoingRemoteActivity) {
                IOutgoingRemoteActivity activity = (IOutgoingRemoteActivity)object;
                IComponentSyncContext context = activity.getActivitySource().getModel();
                IChangeHistorySyncReport report = SyncCache.get().fetch((IWorkspaceConnection)context.getOutgoingTeamPlace(), (IWorkspaceConnection)context.getIncomingTeamPlace(), (int)this.compareToFlags, (IProgressMonitor)loopProgress.newChild((int)1)).syncReport;
                deliverOp.deliver(context.getOutgoingTeamPlace(), context.getIncomingTeamPlace(), report, Collections.singletonList(activity.getChangeSetHandle()));
                continue;
            }
            throw new IllegalArgumentException("Deliver requires IWorkspaceSyncContext, IComponentSyncContext, OutgoingWorkspaceNode, IOutgoingRemoteActivity");
        }
        deliverOp.run((IProgressMonitor)progress.newChild(90));
    }

    public void setCompareToFlags(int flags) {
        this.compareToFlags = flags;
    }

    public int getCompareToFlags() {
        return this.compareToFlags;
    }

    public void setMaxChangesPerChangeSet(int nChanges) {
        this.maxChangesPerChangeSet = nChanges;
    }

    @Override
    public int getMaxChangesPerChangeSet() {
        return this.maxChangesPerChangeSet;
    }
}

