/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.UndoChangesOperation;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ILocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IMultiComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISuspendedActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.AutoCommitManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSummaryNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.CompareToNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.LocalChangeSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingWorkspaceNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SuspendedActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SuspendedNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.UnresolvedSource;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.listeners.EventManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.listeners.MutatorListener;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.listeners.RepositoryListener;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IItemCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IModelMutator;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IMutate;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.ModelMutatorFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSyncContext
extends EventSource
implements IComponentSyncContext {
    public ComponentSyncInfo info;
    ComponentSyncModel componentSyncModel;
    public IMultiComponentSyncContext parent;
    public CompareToNode root;
    SuspendedNode suspendedNode;
    LocalChangeSource localChangeSource;
    UnresolvedSource unresolvedSource;
    IModelMutator mutator;
    SuspendedActivitySource suspendedActivitySource;
    EventManager eventManager;
    RepositoryListener repositoryListener;
    MutatorListener mutatorListener;
    volatile boolean isInitialized;
    volatile boolean loggedIn;
    volatile boolean isDisposed;
    volatile boolean isRefreshing;
    ITeamRepository teamRepository;
    volatile Throwable refreshLastError;
    volatile Date refreshLastTime;
    volatile boolean init;
    HashMap<UUID, Collection<ILocalChange>> checkins = new HashMap();

    private ComponentSyncContext(ILocalSynchronizationManager manager) {
        super((EventSource)manager);
    }

    public static IWorkspaceConnection checkWorkspaceConnection(IConnection connection) {
        if (!(connection instanceof IWorkspaceConnection)) {
            throw new IllegalArgumentException("Workspace only operation");
        }
        return (IWorkspaceConnection)connection;
    }

    void checkContext(Collection selection) {
        if (selection.isEmpty()) {
            return;
        }
        Set<IComponentSyncContext> contexts = ComponentSyncUtil.getContexts(selection);
        if (contexts.size() != 1 || contexts.iterator().next() != this) {
            throw new IllegalArgumentException("Selection does not exclusively belong to this context");
        }
    }

    @Override
    public int getType() {
        return this.root != null ? this.root.componentFlowType : 0;
    }

    @Override
    public IComponent getComponent() {
        return this.info != null ? this.info.getComponent() : null;
    }

    @Override
    public boolean isLocal() {
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ComponentSyncInfo getComponentSyncInfo() {
        return this.info;
    }

    @Override
    public IComponentSyncModel getComponentSyncModel() {
        return this.componentSyncModel;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public boolean getLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public List getActivitySources() {
        if (this.root == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SuspendedActivitySource> list = new ArrayList<SuspendedActivitySource>();
        list.addAll(this.root.activitySources);
        if (this.suspendedNode != null) {
            list.add(this.suspendedActivitySource);
        }
        return list;
    }

    @Override
    public IIncomingActivitySource getIncomingActivitySource() {
        return this.root != null ? this.root.toWorkspaceNode : null;
    }

    @Override
    public IOutgoingActivitySource getOutgoingActivitySource() {
        return this.root != null ? this.root.fromWorkspaceNode : null;
    }

    @Override
    public ISuspendedActivitySource getSuspendedActivitySource() {
        return this.suspendedActivitySource;
    }

    @Override
    public IConnection getIncomingConnection() {
        return this.root.teamPlaceTo;
    }

    @Override
    public IConnection getOutgoingConnection() {
        return this.root.teamPlaceFrom;
    }

    @Override
    public IWorkspaceConnection getIncomingTeamPlace() {
        return this.root.teamPlaceTo instanceof IWorkspaceConnection ? (IWorkspaceConnection)this.root.teamPlaceTo : null;
    }

    @Override
    public IWorkspaceConnection getOutgoingTeamPlace() {
        return this.root.teamPlaceFrom instanceof IWorkspaceConnection ? (IWorkspaceConnection)this.root.teamPlaceFrom : null;
    }

    @Override
    public IWorkspaceSyncContext getWorkspaceSyncContext() {
        return this.parent instanceof IWorkspaceSyncContext ? (IWorkspaceSyncContext)this.parent : null;
    }

    @Override
    public IMultiComponentSyncContext getParentContext() {
        return this.parent;
    }

    @Override
    public ILocalChangeSource getLocalChangeSource() {
        return this.localChangeSource;
    }

    @Override
    public IUnresolvedSource getUnresolvedSource() {
        return this.unresolvedSource;
    }

    @Override
    public boolean isActive(IRemoteActivity activity) {
        IChangeSet changeSet = activity.getChangeSet();
        return changeSet != null ? changeSet.isActive() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCheckinIn(IRemoteActivity activity) {
        IComponent component;
        IComponentSyncContext model;
        if (!(activity instanceof IOutgoingRemoteActivity)) {
            return false;
        }
        UUID uuid = ((ChangeSetNode)activity).handle.getItemId();
        UUID uuid2 = null;
        IActivitySource src = activity.getActivitySource();
        if (src != null && (model = src.getModel()) != null && (component = model.getComponent()) != null) {
            uuid2 = component.getItemId();
        }
        HashMap<UUID, Collection<ILocalChange>> hashMap = this.checkins;
        synchronized (hashMap) {
            block7: {
                if (!this.checkins.containsKey(uuid)) break block7;
                return true;
            }
            if (uuid2 != null) {
                return this.checkins.containsKey(uuid2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCheckinIn(IActivityFolder folder) {
        Collection<ILocalChange> localChanges;
        IComponentSyncContext model;
        if (!(folder instanceof IOutgoingActivityFolder)) {
            return false;
        }
        IRemoteActivity activity = folder.getActivity();
        List changes = activity.getChanges(folder);
        UUID uuid = ((ChangeSetNode)activity).handle.getItemId();
        IComponent component = null;
        IActivitySource src = activity.getActivitySource();
        if (src != null && (model = src.getModel()) != null) {
            component = model.getComponent();
        }
        HashMap<UUID, Collection<ILocalChange>> hashMap = this.checkins;
        synchronized (hashMap) {
            localChanges = this.checkins.get(uuid);
            if (localChanges == null && component != null) {
                localChanges = this.checkins.get(component.getItemId());
            }
        }
        if (localChanges != null) {
            for (IRemoteChangeSummary change : changes) {
                IVersionableHandle handle = ((ChangeSummaryNode)change).handle;
                for (ILocalChange local : localChanges) {
                    IVersionableHandle target = local.getTarget();
                    if (target == null || !target.sameItemId((IItemHandle)handle)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCheckinIn(IRemoteChangeSummary change) {
        Collection<ILocalChange> changes;
        IComponent component;
        IComponentSyncContext model;
        if (!(change instanceof IOutgoingRemoteChangeSummary)) {
            return false;
        }
        UUID uuid = ((ChangeSetNode)change.getActivity()).handle.getItemId();
        UUID uuid2 = null;
        IActivitySource src = change.getActivity().getActivitySource();
        if (src != null && (model = src.getModel()) != null && (component = model.getComponent()) != null) {
            uuid2 = component.getItemId();
        }
        IVersionableHandle handle = ((ChangeSummaryNode)change).handle;
        HashMap<UUID, Collection<ILocalChange>> hashMap = this.checkins;
        synchronized (hashMap) {
            changes = this.checkins.get(uuid);
            if (changes == null && uuid2 != null) {
                changes = this.checkins.get(uuid2);
            }
        }
        if (changes != null) {
            for (ILocalChange local : changes) {
                IVersionableHandle target = local.getTarget();
                if (target == null || !target.sameItemId((IItemHandle)handle)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSummary(IRemoteActivity activity) {
        return ComponentSyncContext.getLabel(activity);
    }

    public static String getLabel(IRemoteActivity activity) {
        List<IFileSystemWorkItem> workItems;
        String label;
        IChangeSet changeSet = activity.getChangeSet();
        String string = label = changeSet != null ? changeSet.getComment() : "";
        if ("".equals(label) && (workItems = activity.getWorkItems()).size() > 0) {
            IFileSystemWorkItem workItem = workItems.get(0);
            return workItem.getSummary();
        }
        return label;
    }

    @Override
    public boolean isCurrent(IRemoteActivity activity) {
        if (this.getType() == 0) {
            return false;
        }
        ChangeSetNode node = (ChangeSetNode)activity;
        IWorkspaceConnection wc = ComponentSyncContext.checkWorkspaceConnection(activity.getActivitySource() instanceof OutgoingWorkspaceNode ? this.root.teamPlaceFrom : this.root.teamPlaceTo);
        IChangeSetHandle changeSet = wc.getCurrentChangeSet((IComponentHandle)this.getComponent());
        if (changeSet != null) {
            return changeSet.sameItemId((IItemHandle)node.handle);
        }
        return false;
    }

    @Override
    public void commitLocalChanges(IOutgoingRemoteActivity activity, Collection localChanges, CommitDilemmaHandler commitProblemHandler, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        this.checkDisposed();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        try {
            this.acquire();
            IWorkspaceConnection wc = ComponentSyncContext.checkWorkspaceConnection(this.root.teamPlaceFrom);
            ChangeSetNode node = (ChangeSetNode)((Object)activity);
            this.mutator.markDirty(node);
            localChanges = ModelUtil.addCounterParts(localChanges);
            ILocalChange[] toCommit = localChanges.toArray(new ILocalChange[localChanges.size()]);
            try {
                this.NewCheckInOperationStart(node.handle.getItemId(), localChanges);
                ICheckinOperation ncio = IOperationFactory.instance.getCheckinOperation(commitProblemHandler);
                ncio.requestCheckin(wc, (IComponentHandle)this.getComponent(), toCommit, node.handle, null, (IProgressMonitor)monitor.newChild(1));
                ncio.run((IProgressMonitor)monitor.newChild(9));
                this.localChangeSource.setAutoCheckinLastError(null);
                this.localChangeSource.setAutoCheckinArmed(true);
            }
            finally {
                this.NewCheckInOperationEnd(node.handle.getItemId(), localChanges);
            }
        }
        finally {
            this.release();
        }
    }

    @Override
    public void autoCommitLocalChanges(Collection localChanges, boolean close, CommitDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.autoCommitLocalChanges(localChanges, close, true, problemHandler, monitor);
    }

    /*
     * Loose catch block
     */
    public void autoCommitLocalChanges(Collection localChanges, boolean close, boolean userRequest, CommitDilemmaHandler problemHandler, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        this.checkDisposed();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        try {
            this.acquire();
            int closeChangeSetsTicks = close ? 10 : 0;
            monitor.beginTask(Messages.ComponentSyncContext_5, localChanges.size() * 10 + closeChangeSetsTicks + 2);
            if (!userRequest && !this.getLocalChangeSource().isAutoCheckinArmed()) {
                return;
            }
            IWorkspaceConnection teamPlace = this.info.getLocal();
            this.NewCheckInOperationStart(this.getComponent().getItemId(), localChanges);
            try {
                try {
                    ICheckinOperation commitOp = IOperationFactory.instance.getCheckinOperation(problemHandler);
                    commitOp.requestCheckin(teamPlace, (IComponentHandle)this.getComponent(), localChanges.toArray(new ILocalChange[localChanges.size()]), null, "", (IProgressMonitor)monitor.newChild(2));
                    commitOp.run((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, localChanges.size() * 10));
                    for (IChangeSetHandle changeSet : commitOp.getCommittedChangeSets()) {
                        ChangeSetNode node = this.findOutgoingActivity(changeSet);
                        if (node == null) continue;
                        this.mutator.markDirty(node);
                    }
                    if (close) {
                        teamPlace.closeChangeSets(commitOp.getCommittedChangeSets(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, closeChangeSetsTicks));
                    }
                    if (userRequest) {
                        this.localChangeSource.setAutoCheckinLastError(null);
                        this.localChangeSource.setAutoCheckinArmed(true);
                        AutoCommitManager.getInstance().userCommitted();
                    }
                }
                catch (FileSystemClientException e) {
                    this.localChangeSource.setAutoCheckinLastError(e);
                    this.localChangeSource.setAutoCheckinArmed(false);
                    if (userRequest) {
                        throw e;
                    }
                    this.NewCheckInOperationEnd(this.getComponent().getItemId(), localChanges);
                    this.queueEvent(new Event((IEventSource)this, "autoSaveCompleted"));
                }
                catch (TeamRepositoryException e) {
                    this.localChangeSource.setAutoCheckinLastError(e);
                    this.localChangeSource.setAutoCheckinArmed(false);
                    if (userRequest) {
                        throw e;
                    }
                    this.NewCheckInOperationEnd(this.getComponent().getItemId(), localChanges);
                    this.queueEvent(new Event((IEventSource)this, "autoSaveCompleted"));
                }
                catch (RuntimeException e) {
                    this.localChangeSource.setAutoCheckinLastError(e);
                    this.localChangeSource.setAutoCheckinArmed(false);
                    throw e;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.NewCheckInOperationEnd(this.getComponent().getItemId(), localChanges);
                this.queueEvent(new Event((IEventSource)this, "autoSaveCompleted"));
            }
        }
        finally {
            this.release();
            monitor.done();
        }
    }

    ChangeSetNode findOutgoingActivity(IChangeSetHandle changeSet) {
        List activities = this.getOutgoingActivitySource().getActivities();
        for (ChangeSetNode node : activities) {
            if (!changeSet.sameItemId((IItemHandle)node.handle)) continue;
            return node;
        }
        return null;
    }

    IChangeSetHandle findActiveLocalChangeSet(ILocalChange localChange) {
        if (localChange == null) {
            return null;
        }
        IOutgoingActivitySource source = this.getOutgoingActivitySource();
        if (source == null) {
            return null;
        }
        IVersionableHandle sharedItem = localChange.getTarget();
        for (IRemoteActivity activity : source.getActivities()) {
            if (!this.isActive(activity)) continue;
            IChangeSet changeSet = activity.getChangeSet();
            if (changeSet == null) {
                return null;
            }
            List changes = changeSet.changes();
            for (IChange change : changes) {
                IVersionableHandle item = change.item();
                if (sharedItem == null || !sharedItem.sameItemId((IItemHandle)item)) continue;
                return changeSet;
            }
        }
        return null;
    }

    @Override
    public IOutgoingRemoteActivity createActivityLocalChanges(Collection localChanges, boolean setCurrent, CommitDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.checkDisposed();
        monitor = ModelUtil.monitorFor(monitor);
        try {
            this.acquire();
            monitor.beginTask(Messages.ComponentSyncContext_6, 100);
            IWorkspaceConnection wc = ComponentSyncContext.checkWorkspaceConnection(this.root.teamPlaceFrom);
            IComponent component = this.getComponent();
            localChanges = ModelUtil.addCounterParts(localChanges);
            ILocalChange[] toCommit = localChanges.toArray(new ILocalChange[localChanges.size()]);
            IChangeSetHandle changeSet = null;
            changeSet = wc.createChangeSet((IComponentHandle)component, "", setCurrent, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
            if (toCommit.length != 0) {
                ICheckinOperation ncio = IOperationFactory.instance.getCheckinOperation(problemHandler);
                ncio.requestCheckin(wc, (IComponentHandle)component, toCommit, changeSet, null, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                ncio.run((IProgressMonitor)new SubProgressMonitor(monitor, 38));
                this.localChangeSource.setAutoCheckinLastError(null);
                this.localChangeSource.setAutoCheckinArmed(true);
            }
            OutgoingChangeSetNode node = this.root.addActivity(changeSet);
            this.queueEvent(new Event((IEventSource)this, "refreshedRemoteProgress"));
            OutgoingChangeSetNode outgoingChangeSetNode = node;
            return outgoingChangeSetNode;
        }
        finally {
            this.release();
            monitor.done();
        }
    }

    @Override
    public IWorkspaceConnection getTeamPlace(IActivitySource source) {
        IConnection connection = null;
        if (source instanceof IOutgoingActivitySource || source instanceof ISuspendedActivitySource) {
            connection = this.root.teamPlaceFrom;
        } else if (source instanceof IIncomingActivitySource) {
            connection = this.root.teamPlaceTo;
        }
        IWorkspaceConnection wc = ComponentSyncContext.checkWorkspaceConnection(connection);
        return wc;
    }

    @Override
    public void setComment(IRemoteActivity activity, String reason, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkDisposed();
        monitor = ModelUtil.monitorFor(monitor);
        try {
            this.acquire();
            ChangeSetNode node = (ChangeSetNode)activity;
            this.mutator.markDirty(node);
            SCMPlatform.getWorkspaceManager((ITeamRepository)this.teamRepository).setComment(activity.getChangeSetHandle(), reason, monitor);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void relocate(Collection summaries, IRemoteActivity activity, UpdateDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.checkDisposed();
        monitor = ModelUtil.monitorFor(monitor);
        try {
            this.acquire();
            monitor.beginTask(Messages.ComponentSyncContext_8, 100);
            IWorkspaceConnection wc = ComponentSyncContext.checkWorkspaceConnection(this.root.teamPlaceFrom);
            IChangeSetHandle activeChangeSet = null;
            if (activity == null) {
                activeChangeSet = wc.createChangeSet((IComponentHandle)this.getComponent(), (IProgressMonitor)new SubProgressMonitor(monitor, 15));
            } else {
                IActivitySource targetSource = activity.getActivitySource();
                if (!(targetSource instanceof IOutgoingActivitySource)) {
                    return;
                }
                activeChangeSet = ((ChangeSetNode)activity).handle;
                monitor.worked(15);
            }
            HashSet<UUID> relocations = new HashSet<UUID>();
            ArrayList<IChangeSetHandle> sources = new ArrayList<IChangeSetHandle>();
            ArrayList<IChangeSetHandle> targets = new ArrayList<IChangeSetHandle>();
            ArrayList<IVersionableHandle> items = new ArrayList<IVersionableHandle>();
            for (IRemoteChangeSummary summary : summaries) {
                IRemoteActivity source = summary.getActivity();
                if (source.getActivitySource().getModel() != this) continue;
                ChangeSetNode changeSetNode = (ChangeSetNode)summary.getActivity();
                IChangeSetHandle sourceChangeSet = changeSetNode.handle;
                IChangeSummary changeSummary = summary.getChangeSummary();
                if (!relocations.add(changeSummary.item().getItemId())) continue;
                targets.add(activeChangeSet);
                sources.add(sourceChangeSet);
                items.add(changeSummary.item());
            }
            wc.relocateChanges(targets, items, sources, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
            this.mutator.markDirty();
            monitor.worked(5);
        }
        finally {
            this.release();
            monitor.done();
        }
    }

    @Override
    public void discardChanges(Collection summaries, UndoDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.checkDisposed();
        monitor = ModelUtil.monitorFor(monitor);
        try {
            IChangeSetHandle activeChangeSet;
            this.acquire();
            monitor.beginTask(Messages.ComponentSyncContext_9, 1000);
            IWorkspaceConnection wc = ComponentSyncContext.checkWorkspaceConnection(this.root.teamPlaceFrom);
            Hashtable<IChangeSetHandle, ArrayList<IChange>> changeSetToSummaries = new Hashtable<IChangeSetHandle, ArrayList<IChange>>();
            for (IRemoteChangeSummary summary : summaries) {
                ChangeSetNode changeSetNode = (ChangeSetNode)summary.getActivity();
                activeChangeSet = changeSetNode.handle;
                ArrayList<IChange> summariesToUndo = (ArrayList<IChange>)changeSetToSummaries.get(activeChangeSet);
                if (summariesToUndo == null) {
                    summariesToUndo = new ArrayList<IChange>();
                    changeSetToSummaries.put(activeChangeSet, summariesToUndo);
                }
                summariesToUndo.add(summary.getChange());
            }
            UndoChangesOperation undoOp = new UndoChangesOperation(wc, problemHandler);
            for (Map.Entry entry : changeSetToSummaries.entrySet()) {
                activeChangeSet = (IChangeSetHandle)entry.getKey();
                List changesToUndo = (List)entry.getValue();
                undoOp.addChangesToUndo(activeChangeSet, (Collection)changesToUndo);
            }
            undoOp.run((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            this.mutator.markDirty();
        }
        finally {
            this.release();
            monitor.done();
        }
    }

    @Override
    public ITeamRepository teamRepository() {
        return this.teamRepository;
    }

    public String getDescription() {
        if (this.getType() != 0) {
            return this.getComponent().getName();
        }
        return this.getOutgoingActivitySource().getName();
    }

    private String getLogDescription() {
        String description = "(context ";
        if (this.getType() != 0) {
            description = String.valueOf(description) + this.getComponent().getName() + " ";
            if (this.info.getLocalConnection() != null) {
                description = String.valueOf(description) + this.info.getLocalConnection().getName() + "-";
            }
            if (this.info.getRemote() != null) {
                description = String.valueOf(description) + this.info.getRemote().getName() + " ";
            }
        }
        description = String.valueOf(description) + "type " + this.getType();
        ITeamRepository repo = this.teamRepository();
        if (repo != null) {
            description = String.valueOf(description) + " repo: " + repo.getRepositoryURI() + "," + repo.getUserId() + "," + repo.getState() + "," + repo.getConnectionTimeout();
        }
        return String.valueOf(description) + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void refresh(boolean full, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("ComponentSyncContext.refresh full " + full + " " + this.getLogDescription());
        }
        monitor = ModelUtil.monitorFor(monitor);
        monitor.beginTask(full ? NLS.bind((String)Messages.ComponentSyncContext_4, (Object)this.getDescription()) : NLS.bind((String)Messages.ComponentSyncContext_3, (Object)this.getDescription()), 100);
        this.isRefreshing = true;
        this.queueEvent(new Event((IEventSource)this, "refreshedRemoteStarted"));
        try {
            this.acquire();
            if (!this.getLoggedIn()) {
                return;
            }
            if (this.isDisposed()) {
                return;
            }
            if (full) {
                this.mutator.markDirty();
            }
            this.mutator.refresh((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            this.isRefreshing = false;
            this.refreshLastError = null;
            this.queueEvent(new Event((IEventSource)this, "refreshedRemoteCompleted"));
            return;
        }
        catch (ConnectionException e) {
            this.refreshLastError = e;
            this.queueEvent(new Event((IEventSource)this, "refreshedRemoteConnectionError"));
            throw e;
        }
        catch (NotLoggedInException e) {
            this.refreshLastError = e;
            this.queueEvent(new Event((IEventSource)this, "refreshedRemoteConnectionError"));
            throw e;
        }
        finally {
            this.isRefreshing = false;
            this.release();
            monitor.done();
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("ComponentSyncContext.refresh", traceBegin);
            }
        }
    }

    @Override
    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    public void markDirty(IMutate element) {
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("ComponentSyncContext " + this.getLogDescription() + " setDirty : " + element);
        }
        this.checkDisposed();
        try {
            this.acquire();
            if (!this.getLoggedIn()) {
                return;
            }
            this.mutator.markDirty(element);
        }
        finally {
            this.release();
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("ComponentSyncContext.setDirty", traceBegin);
            }
        }
    }

    public EventManager getEventManager() {
        return this.componentSyncModel.eventManager;
    }

    public void refreshCompare(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.refreshCompare(false, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshCompare(boolean notifyAccept, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("ComponentSyncContext.refreshCompare " + this.getLogDescription());
        }
        monitor = ModelUtil.monitorFor(monitor);
        monitor.beginTask(NLS.bind((String)Messages.ComponentSyncContext_2, (Object)this.getDescription()), 100);
        this.isRefreshing = true;
        this.queueEvent(new Event((IEventSource)this, "refreshedRemoteStarted"));
        try {
            this.acquire();
            if (!this.getLoggedIn()) {
                return;
            }
            if (this.isDisposed()) {
                return;
            }
            this.mutator.markDirty(this.root);
            this.mutator.refresh(monitor);
            this.isRefreshing = false;
            if (notifyAccept) {
                this.queueEvent(new Event((IEventSource)this, "refreshedRemoteAcceptCompleted"));
            }
            this.queueEvent(new Event((IEventSource)this, "refreshedRemoteCompleted"));
            this.refreshLastError = null;
            this.refreshLastTime = new Date();
            return;
        }
        catch (ConnectionException e) {
            this.refreshLastError = e;
            this.queueEvent(new Event((IEventSource)this, "refreshedRemoteConnectionError"));
            throw e;
        }
        catch (NotLoggedInException e) {
            this.refreshLastError = e;
            this.queueEvent(new Event((IEventSource)this, "refreshedRemoteConnectionError"));
            throw e;
        }
        finally {
            this.isRefreshing = false;
            this.release();
            monitor.done();
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("ComponentSyncContext.refreshCompare", traceBegin);
            }
        }
    }

    @Override
    public Throwable getRefreshLastError() {
        return this.refreshLastError;
    }

    @Override
    public Date getRefreshLastTime() {
        return this.refreshLastTime;
    }

    @Override
    public void discardChangeSets(Collection selection, DiscardDilemmaHandler problemHandler, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.checkDisposed();
        monitor = ModelUtil.monitorFor(monitor);
        try {
            IDiscardOperation op;
            int ticks;
            this.acquire();
            monitor.beginTask(Messages.ComponentSyncContext_34, 100);
            IWorkspaceConnection wcFrom = ComponentSyncContext.checkWorkspaceConnection(this.root.teamPlaceFrom);
            this.checkContext(selection);
            Set[] result = ComponentSyncUtil.filter(selection, new Class[]{IOutgoingRemoteActivity.class, Object.class});
            if (!result[1].isEmpty()) {
                throw new IllegalArgumentException("Outgoing activities expected");
            }
            int n = ticks = result[0].size() > 0 && result[1].size() > 0 ? 50 : 100;
            if (!result[0].isEmpty()) {
                op = IOperationFactory.instance.getDiscardOperation(problemHandler);
                op.discard(wcFrom, ComponentSyncUtil.getChangeSetHandles(result[0]));
                op.run((IProgressMonitor)new SubProgressMonitor(monitor, ticks));
            }
            if (!result[1].isEmpty()) {
                op = IOperationFactory.instance.getDiscardOperation(problemHandler);
                op.discard(wcFrom, ComponentSyncUtil.getChangeSetHandles(result[1]));
                op.run((IProgressMonitor)new SubProgressMonitor(monitor, ticks));
            }
        }
        finally {
            this.release();
            monitor.done();
        }
    }

    public void sort(List activities, boolean isIncoming) {
        if (activities.isEmpty()) {
            return;
        }
        IChangeHistorySyncReport report = this.root.changeHistorySyncReport;
        if (report == null) {
            return;
        }
        List reference = isIncoming ? report.incomingChangeSets((IComponentHandle)this.getComponent()) : report.outgoingChangeSets((IComponentHandle)this.getComponent());
        this.sort(activities, reference);
    }

    public void sort(List activities, List referenceHandles) {
        if (activities.isEmpty()) {
            return;
        }
        final HashMap<UUID, Integer> referenceMap = new HashMap<UUID, Integer>((int)((double)referenceHandles.size() / 0.75));
        int index = 0;
        for (IChangeSetHandle cs : referenceHandles) {
            referenceMap.put(cs.getItemId(), index++);
        }
        Collections.sort(activities, new Comparator(){

            public int compare(Object o1, Object o2) {
                ChangeSetNode node1 = (ChangeSetNode)o1;
                ChangeSetNode node2 = (ChangeSetNode)o2;
                Integer pos1 = (Integer)referenceMap.get(node1.handle.getItemId());
                Integer pos2 = (Integer)referenceMap.get(node2.handle.getItemId());
                if (pos1 == null) {
                    if (pos2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (pos2 == null) {
                    return -1;
                }
                return -pos1.compareTo(pos2);
            }
        });
    }

    @Override
    public int compare(IRemoteActivity activity1, IRemoteActivity activity2) {
        ChangeSetNode node1 = (ChangeSetNode)activity1;
        ChangeSetNode node2 = (ChangeSetNode)activity2;
        return node1.id < node2.id ? -1 : (node1.id == node2.id ? 0 : 1);
    }

    private void checkDisposed() {
        if (this.isDisposed) {
            throw new IllegalStateException("Context has been disposed");
        }
    }

    private void checkNonPrivate() {
        if (this.getType() == 1) {
            throw new IllegalStateException("Context is private");
        }
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        try {
            this.acquire();
            this.isDisposed = true;
            this.unhookEvents();
            if (this.mutator != null) {
                this.mutator.dispose();
            }
            if (this.localChangeSource != null) {
                this.localChangeSource.dispose();
            }
            this.loggedIn = false;
            this.queueEvent(new Event((IEventSource)this, "disposed"));
        }
        finally {
            this.release();
        }
    }

    @Override
    public boolean isUnresolved(IRemoteActivity activity) {
        IComponentHandle component;
        if (!(activity.getActivitySource() instanceof IOutgoingActivitySource)) {
            return false;
        }
        if (this.root == null || this.root.conflictReport == null || this.root.logicalConflictReport == null) {
            return false;
        }
        IChangeSet changeSet = activity.getChangeSet();
        IComponentHandle iComponentHandle = component = changeSet != null ? changeSet.getComponent() : null;
        if (component == null) {
            return false;
        }
        List changes = activity.getChanges();
        for (IRemoteChangeSummary change : changes) {
            if (!ModelUtil.isUnresolved(this.root.logicalConflictReport, component, change.getChangeSummary())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnresolved(IRemoteChangeSummary change) {
        IComponentHandle component;
        if (!(change.getActivity().getActivitySource() instanceof IOutgoingActivitySource)) {
            return false;
        }
        if (this.root == null || this.root.conflictReport == null || this.root.logicalConflictReport == null) {
            return false;
        }
        IChangeSet changeSet = change.getActivity().getChangeSet();
        IComponentHandle iComponentHandle = component = changeSet != null ? changeSet.getComponent() : null;
        if (component == null) {
            return false;
        }
        IChangeSummary changeSummary = change.getChangeSummary();
        return ModelUtil.isUnresolved(this.root.logicalConflictReport, component, changeSummary);
    }

    @Override
    public boolean isUnresolved(IUnresolvedSource source) {
        if (source instanceof IUnresolvedSource) {
            IUnresolvedSource s = source;
            Collection<IUnresolvedFolder> folders = s.getFolders();
            for (IUnresolvedFolder folder : folders) {
                if (!this.isUnresolved(folder)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isUnresolved(IActivitySource source) {
        if (!(source instanceof IOutgoingActivitySource) && !(source instanceof IUnresolvedSource)) {
            return false;
        }
        if (this.root == null || this.root.conflictReport == null) {
            return false;
        }
        return !this.root.conflictReport.getConflictsForComponent((IComponentHandle)this.getComponent()).isEmpty();
    }

    @Override
    public boolean isUnresolved(IActivityFolder folder) {
        IComponentHandle component;
        if (!(folder instanceof IOutgoingActivityFolder)) {
            return false;
        }
        if (this.root == null || this.root.conflictReport == null || this.root.logicalConflictReport == null) {
            return false;
        }
        IChangeSet changeSet = folder.getActivity().getChangeSet();
        IComponentHandle iComponentHandle = component = changeSet != null ? changeSet.getComponent() : null;
        if (component == null) {
            return false;
        }
        List changes = folder.getActivity().getChanges(folder);
        for (IRemoteChangeSummary changeSummary : changes) {
            if (!ModelUtil.isUnresolved(this.root.logicalConflictReport, component, changeSummary.getChangeSummary())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ILogicalChange> hasConflict(IRemoteChangeSummary change) {
        if (!(change instanceof IIncomingRemoteChangeSummary) && !(change instanceof IOutgoingRemoteChangeSummary)) {
            return Collections.EMPTY_LIST;
        }
        IChangeSummary changeSummary = change.getChangeSummary();
        if (this.root.freeFlightLogicalConflictReport == null) {
            return Collections.EMPTY_LIST;
        }
        IComponent component = this.getComponent();
        if (change instanceof IIncomingRemoteChangeSummary) {
            return ModelUtil.getConflictFor((IComponentHandle)component, changeSummary, this.root.freeFlightLogicalConflictReport);
        }
        return ModelUtil.getConflictsWith((IComponentHandle)component, changeSummary, this.root.freeFlightLogicalConflictReport);
    }

    @Override
    public boolean hasConflict(IRemoteActivity activity) {
        IComponentHandle component;
        if (!(activity instanceof IIncomingRemoteActivity) && !(activity instanceof IOutgoingRemoteActivity)) {
            return false;
        }
        IChangeSet changeSet = activity.getChangeSet();
        IComponentHandle iComponentHandle = component = changeSet != null ? changeSet.getComponent() : null;
        if (component == null) {
            return false;
        }
        if (this.root.freeFlightLogicalConflictReport == null) {
            return false;
        }
        boolean incoming = activity instanceof IIncomingRemoteActivity;
        for (IRemoteChangeSummary change : activity.getChanges()) {
            if (!(incoming ? !ModelUtil.getConflictFor(component, change.getChangeSummary(), this.root.freeFlightLogicalConflictReport).isEmpty() : !ModelUtil.getConflictsWith(component, change.getChangeSummary(), this.root.freeFlightLogicalConflictReport).isEmpty())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConflict(IActivitySource source) {
        if (!(source instanceof IIncomingActivitySource) && !(source instanceof IOutgoingActivitySource)) {
            return false;
        }
        ILogicalConflictReport report = this.root.freeFlightLogicalConflictReport;
        return report != null && !report.getConflictsForComponent((IComponentHandle)this.getComponent()).isEmpty();
    }

    @Override
    public boolean isUnresolved(IUnresolvedFolder folder) {
        Collection<IUnresolvedItem> items = folder.getItems();
        for (IUnresolvedItem item : items) {
            if (item.getConflictItems().isEmpty() && item.getPatches().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConflict(IActivityFolder folder) {
        IComponentHandle component;
        if (!(folder instanceof IIncomingActivityFolder) && !(folder instanceof IOutgoingActivityFolder)) {
            return false;
        }
        if (this.root == null || this.root.freeFlightLogicalConflictReport == null) {
            return false;
        }
        IChangeSet changeSet = folder.getActivity().getChangeSet();
        IComponentHandle iComponentHandle = component = changeSet != null ? changeSet.getComponent() : null;
        if (component == null) {
            return false;
        }
        List changes = folder.getActivity().getChanges(folder);
        for (IRemoteChangeSummary changeSummary : changes) {
            if (!(folder instanceof IIncomingActivityFolder ? !ModelUtil.getConflictFor(component, changeSummary.getChangeSummary(), this.root.freeFlightLogicalConflictReport).isEmpty() : !ModelUtil.getConflictsWith(component, changeSummary.getChangeSummary(), this.root.freeFlightLogicalConflictReport).isEmpty())) continue;
            return true;
        }
        return false;
    }

    public void setLoggedIn(boolean value) {
        try {
            this.acquire();
            if (this.loggedIn == value) {
                return;
            }
            this.loggedIn = value;
            this.queueEvent(new Event((IEventSource)this, "loggedIn"));
        }
        finally {
            this.release();
        }
    }

    public static ComponentSyncContext create(ComponentSyncInfo info, ComponentSyncModel componentSyncModel, EventManager eventManager, IItemCache itemCache, IMultiComponentSyncContext workspaceContext) {
        ComponentSyncContext model = null;
        IConnection teamPlaceFrom = info.getLocalConnection();
        IConnection teamPlaceTo = info.getRemote();
        if (teamPlaceFrom == null && teamPlaceTo == null) {
            throw new IllegalStateException();
        }
        if (teamPlaceFrom == null) {
            teamPlaceFrom = teamPlaceTo;
        }
        if (teamPlaceTo == null) {
            teamPlaceTo = teamPlaceFrom;
        }
        ITeamRepository repo = teamPlaceFrom.teamRepository();
        model = new ComponentSyncContext(componentSyncModel.getLocalSynchronizationManager());
        model.setLoggedIn(repo.loggedIn());
        model.info = info;
        model.localChangeSource = new LocalChangeSource(model, (EventSource)componentSyncModel.getLocalSynchronizationManager());
        model.unresolvedSource = new UnresolvedSource(model, componentSyncModel);
        model.teamRepository = repo;
        model.componentSyncModel = componentSyncModel;
        model.parent = workspaceContext;
        model.suspendedActivitySource = new SuspendedActivitySource(model, teamPlaceFrom instanceof IWorkspaceConnection ? (IWorkspaceConnection)teamPlaceFrom : null);
        model.root = new CompareToNode(model, teamPlaceFrom, teamPlaceTo, info.getComponent());
        IModelMutator mutator = ModelMutatorFactory.create(itemCache, repo);
        mutator.addMutateRoot(model.root);
        model.suspendedNode = null;
        try {
            ModelUtil.hasComponent(teamPlaceFrom, (IComponentHandle)model.getComponent());
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (teamPlaceFrom instanceof IWorkspaceConnection) {
            SuspendedNode suspendedNode;
            model.suspendedNode = suspendedNode = new SuspendedNode(model, (IWorkspaceConnection)teamPlaceFrom, model.suspendedActivitySource);
            mutator.addMutateRoot(suspendedNode);
        }
        model.mutator = mutator;
        model.eventManager = eventManager;
        return model;
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.queueEvent(new Event((IEventSource)this, "created"));
        this.hookEvents();
        this.init = true;
    }

    void hookEvents() {
        this.eventManager.add(this);
        this.repositoryListener = new RepositoryListener(this, this.teamRepository);
        this.mutatorListener = new MutatorListener(this);
        this.mutator.addListener(this.mutatorListener);
    }

    void unhookEvents() {
        RepositoryListener repositoryListener;
        EventManager eventManager = this.eventManager;
        if (eventManager != null) {
            eventManager.remove(this);
        }
        if ((repositoryListener = this.repositoryListener) != null) {
            repositoryListener.dispose();
        }
        IModelMutator mutator = this.mutator;
        MutatorListener mutatorListener = this.mutatorListener;
        if (mutator != null && mutatorListener != null) {
            mutator.removeListener(mutatorListener);
        }
        eventManager = null;
        repositoryListener = null;
    }

    public void setInitialized() {
        this.isInitialized = true;
    }

    List getVersionableHandles(List fileSystemChanges) {
        ArrayList<IVersionableHandle> result = new ArrayList<IVersionableHandle>(fileSystemChanges.size());
        for (ChangeSummaryNode elt : fileSystemChanges) {
            result.add(elt.changeSummary.item());
        }
        return result;
    }

    @Override
    public String getConflictType(IRemoteChangeSummary change, ILogicalChange logicalChange) {
        if (logicalChange.kind() == 2) {
            return Messages.ComponentSyncContext_38;
        }
        if (logicalChange.kind() == 3) {
            return Messages.ComponentSyncContext_39;
        }
        if (logicalChange.kind() == 1) {
            ILogicalConflict conflict = (ILogicalConflict)logicalChange;
            switch (conflict.conflictType()) {
                case 1: {
                    return Messages.ComponentSyncContext_40;
                }
                case 2: {
                    return change instanceof IIncomingRemoteChangeSummary ? Messages.ComponentSyncContext_41 : Messages.ComponentSyncContext_42;
                }
                case 3: {
                    return change instanceof IIncomingRemoteChangeSummary ? Messages.ComponentSyncContext_43 : Messages.ComponentSyncContext_44;
                }
                case 5: {
                    return change instanceof IIncomingRemoteChangeSummary ? Messages.ComponentSyncContext_45 : Messages.ComponentSyncContext_46;
                }
                case 4: {
                    return change instanceof IIncomingRemoteChangeSummary ? Messages.ComponentSyncContext_47 : Messages.ComponentSyncContext_48;
                }
                case 10: {
                    return change instanceof IIncomingRemoteChangeSummary ? Messages.ComponentSyncContext_49 : Messages.ComponentSyncContext_50;
                }
                case 9: {
                    return Messages.ComponentSyncContext_51;
                }
                case 7: {
                    return change instanceof IIncomingRemoteChangeSummary ? Messages.ComponentSyncContext_52 : Messages.ComponentSyncContext_53;
                }
                case 8: {
                    return change instanceof IIncomingRemoteChangeSummary ? Messages.ComponentSyncContext_54 : Messages.ComponentSyncContext_55;
                }
                case 6: {
                    return Messages.ComponentSyncContext_56;
                }
            }
        }
        return Messages.ComponentSyncContext_57;
    }

    @Override
    public Collection<ILogicalChange> getMergeConflict(IRemoteChangeSummary change) {
        if (!(change instanceof IIncomingRemoteChangeSummary) && !(change instanceof IOutgoingRemoteChangeSummary)) {
            return Collections.EMPTY_LIST;
        }
        if (this.root.freeFlightLogicalConflictReport == null) {
            return Collections.EMPTY_LIST;
        }
        IComponent component = this.getComponent();
        IChangeSummary changeSummary = change.getChangeSummary();
        if (change instanceof IIncomingRemoteChangeSummary) {
            return ModelUtil.getConflictFor((IComponentHandle)component, changeSummary, this.root.logicalConflictReport);
        }
        return ModelUtil.getConflictsWith((IComponentHandle)component, changeSummary, this.root.logicalConflictReport);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void refreshSuspendedActivities(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        long traceBegin = 0L;
        if (ModelUtil.TRACE_REFRESH) {
            traceBegin = ModelUtil.logBegin("ComponentSyncContext.refreshSuspendedActivities " + this.getLogDescription());
        }
        monitor = ModelUtil.monitorFor(monitor);
        monitor.beginTask(NLS.bind((String)Messages.ComponentSyncContext_1, (Object)this.getDescription()), 100);
        try {
            this.acquire();
            if (!this.getLoggedIn()) {
                return;
            }
            if (this.isDisposed()) {
                return;
            }
            this.mutator.markDirty(this.suspendedNode);
            this.mutator.refresh(monitor);
            this.queueEvent(new Event((IEventSource)this, "refreshedRemoteCompleted"));
            return;
        }
        finally {
            this.release();
            monitor.done();
            if (ModelUtil.TRACE_REFRESH) {
                ModelUtil.logEnd("ComponentSyncContext.refreshSuspendedActivities", traceBegin);
            }
        }
    }

    public boolean setCollaboration(IConnection remote) {
        try {
            this.acquire();
            if (remote == null) {
                remote = this.getOutgoingConnection();
            }
            ComponentSyncInfo newInfo = new ComponentSyncInfo(this.getComponent(), (IConnection)this.info.getLocal(), remote);
            if (this.eventManager != null) {
                this.eventManager.remove(this);
            }
            this.info = newInfo;
            this.root.setRemote(remote);
            if (this.eventManager != null) {
                this.eventManager.add(this);
            }
            return true;
        }
        finally {
            this.release();
        }
    }

    @Override
    public boolean isDefaultCollaboration() {
        IWorkspaceConnection wcFrom = ComponentSyncContext.checkWorkspaceConnection(this.root.teamPlaceFrom);
        return this.root.to.sameItemId((IItemHandle)FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)wcFrom));
    }

    @Override
    public IBaseline getLocalBaseline() {
        return this.root.fromBasis;
    }

    @Override
    public IBaseline getRemoteBaseline() {
        return this.root.toBasis;
    }

    @Override
    public void addGenericListener(IListener listener) {
        this.addGenericListener("autoSaveCompleted", listener);
        this.addGenericListener("currentActivity", listener);
        this.addGenericListener("loggedIn", listener);
        this.addGenericListener("refreshedRemoteCompleted", listener);
        this.addGenericListener("refreshedRemoteProgress", listener);
    }

    @Override
    public void removeGenericListener(IListener listener) {
        this.removeGenericListener("autoSaveCompleted", listener);
        this.removeGenericListener("currentActivity", listener);
        this.removeGenericListener("loggedIn", listener);
        this.removeGenericListener("refreshedRemoteCompleted", listener);
        this.removeGenericListener("refreshedRemoteProgress", listener);
    }

    @Override
    public boolean hasChanges() {
        ILocalChangeSource source = this.getLocalChangeSource();
        return source != null && source.size() != 0 || this.getOutgoingActivitySource().size() != 0 || this.getIncomingActivitySource().size() != 0 || this.getSuspendedActivitySource().size() != 0;
    }

    @Override
    public IUpdateReport getConflictReport() {
        CompareToNode root = this.root;
        return root != null ? root.conflictReport : null;
    }

    @Override
    public ILogicalConflictReport getLogicalConflictReport() {
        CompareToNode root = this.root;
        return root != null ? root.logicalConflictReport : null;
    }

    @Override
    public IChangeHistorySyncReport getChangeHistorySyncReport() {
        CompareToNode root = this.root;
        return root != null ? root.changeHistorySyncReport : null;
    }

    public void refreshRoot() {
        this.markDirty(this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void NewCheckInOperationStart(UUID checkin, Collection<ILocalChange> changes) {
        if (checkin == null) {
            return;
        }
        changes = new ArrayList<ILocalChange>(changes);
        HashMap<UUID, Collection<ILocalChange>> hashMap = this.checkins;
        synchronized (hashMap) {
            this.checkins.put(checkin, changes);
        }
        this.queueEvent(new Event((IEventSource)this, "refreshedRemoteProgress"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void NewCheckInOperationEnd(UUID checkin, Collection<ILocalChange> changes) {
        if (checkin == null) {
            return;
        }
        HashMap<UUID, Collection<ILocalChange>> hashMap = this.checkins;
        synchronized (hashMap) {
            this.checkins.remove(checkin);
        }
        this.queueEvent(new Event((IEventSource)this, "refreshedRemoteProgress"));
    }

    @Override
    public void deliver(Collection outgoingActivities, DeliverDilemmaHandler handler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.getComponentSyncModel().deliver(outgoingActivities, handler, monitor);
    }
}

