/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentConflictUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.operations.ChangeSetOperation;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ActivityFolderNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ChangeSummaryNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingChangeSummaryNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.IncomingWorkItemNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingChangeSummaryNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingWorkItemNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SuspendedChangeSetNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SuspendedChangeSummaryNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.SuspendedWorkItemNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.WorkItemNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IItemCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IMutate;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQuery;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.mutator.IQueryContext;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetNode
extends PlatformObject
implements IMutate,
IRemoteActivity {
    static final boolean AGGREGATE_PER_VERSIONABLE = true;
    public List[] children = new List[1];
    public IChangeSetHandle handle;
    public IChangeSet changeSet;
    public volatile List changes = Collections.EMPTY_LIST;
    public IConnection teamPlace;
    IContributor modifiedBy;
    IActivitySource activitySource;
    public List changeSummaries = Collections.EMPTY_LIST;
    public List<IFileSystemWorkItem> links = new ArrayList<IFileSystemWorkItem>();
    public List folders = Collections.EMPTY_LIST;
    public int id;
    static final IQuery QUERY = new IQuery(){

        public void computeItemsAndChildren(List elements, IQueryContext context, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
            ChangeSetOperation operation = new ChangeSetOperation(null);
            operation.computeItemsAndChildren(elements, context);
            operation.run(monitor);
        }
    };

    public ChangeSetNode() {
    }

    public ChangeSetNode(IConnection teamPlace, IChangeSetHandle handle, IActivitySource activitySource) {
        this.teamPlace = teamPlace;
        this.handle = handle;
        this.activitySource = activitySource;
    }

    @Override
    public IQuery getQuery() {
        return QUERY;
    }

    @Override
    public List[] getChildren() {
        return this.children;
    }

    @Override
    public List getItems() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void clean(IItemCache cache, IProgressMonitor monitor) {
        if (this.changeSet == null) {
            return;
        }
        IContributorHandle handle = this.changeSet.getModifiedBy();
        if (handle == null) {
            this.modifiedBy = null;
            return;
        }
        if (handle != null && handle.sameItemId((IItemHandle)this.modifiedBy)) {
            return;
        }
        this.modifiedBy = (IContributor)cache.fetchCurrent(ComponentSyncUtil.getTeamRepository2(this), (IAuditableHandle)handle, monitor);
    }

    @Override
    public boolean errorChanges() {
        return this.changes == null;
    }

    @Override
    public List getChanges() {
        return Collections.unmodifiableList(this.changeSummaries);
    }

    @Override
    public List<IFileSystemWorkItem> getWorkItems() {
        return Collections.unmodifiableList(this.links);
    }

    @Override
    public IActivitySource getActivitySource() {
        return this.activitySource;
    }

    @Override
    public IContributor getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public Date getModified() {
        IChangeSet changeSet = this.changeSet;
        if (changeSet == null) {
            return ModelUtil.DATE_NOT_AVAILABLE;
        }
        return changeSet.getLastChangeDate();
    }

    @Override
    public IChangeSetHandle getChangeSetHandle() {
        return this.handle;
    }

    @Override
    public IChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public List getChanges(IActivityFolder folder) {
        ArrayList<ChangeSummaryNode> result = new ArrayList<ChangeSummaryNode>();
        for (ChangeSummaryNode change : this.changeSummaries) {
            if (!folder.contains(change)) continue;
            result.add(change);
        }
        return result;
    }

    @Override
    public List getFolders() {
        return Collections.unmodifiableList(this.folders);
    }

    IChange getChange(IVersionableHandle item) {
        List changes = this.changes;
        if (changes == null) {
            return null;
        }
        for (IChange change : changes) {
            if (!change.item().sameItemId((IItemHandle)item)) continue;
            return change;
        }
        return null;
    }

    public void updateFileChanges(List newChanges) {
        ArrayList<ChangeSummaryNode> removed = new ArrayList<ChangeSummaryNode>();
        for (ChangeSummaryNode old : this.changeSummaries) {
            boolean found = false;
            Iterator iter2 = newChanges.iterator();
            while (iter2.hasNext()) {
                IChangeSummary newChangeSummary = null;
                newChangeSummary = (IChangeSummary)iter2.next();
                if (!newChangeSummary.item().sameItemId((IItemHandle)old.getItem())) continue;
                old.changeSummary = newChangeSummary;
                found = true;
                break;
            }
            if (found) continue;
            removed.add(old);
        }
        ArrayList<IChangeSummary> added = new ArrayList<IChangeSummary>();
        Iterator iter = newChanges.iterator();
        while (iter.hasNext()) {
            IChangeSummary newChangeSummary = null;
            newChangeSummary = (IChangeSummary)iter.next();
            boolean found = false;
            for (ChangeSummaryNode old : this.changeSummaries) {
                if (!old.isSame(newChangeSummary)) continue;
                found = true;
                break;
            }
            if (found) continue;
            added.add(newChangeSummary);
        }
        ArrayList<OutgoingChangeSummaryNode> newChangeSummaries = new ArrayList<OutgoingChangeSummaryNode>(this.changeSummaries);
        newChangeSummaries.removeAll(removed);
        Iterator iter2 = added.iterator();
        while (iter2.hasNext()) {
            IChangeSummary newChangeSummary = null;
            newChangeSummary = (IChangeSummary)iter2.next();
            ChangeSummaryNode node = null;
            if (this instanceof OutgoingChangeSetNode) {
                node = new OutgoingChangeSummaryNode(newChangeSummary, (OutgoingChangeSetNode)this);
            } else if (this instanceof IncomingChangeSetNode) {
                node = new IncomingChangeSummaryNode(newChangeSummary, (IncomingChangeSetNode)this);
            } else if (this instanceof SuspendedChangeSetNode) {
                node = new SuspendedChangeSummaryNode(newChangeSummary, (SuspendedChangeSetNode)this);
            } else {
                throw new IllegalStateException("Invalid change set node " + this);
            }
            newChangeSummaries.add((OutgoingChangeSummaryNode)node);
        }
        this.changeSummaries = newChangeSummaries;
        ArrayList oldFolders = new ArrayList(this.folders);
        ActivityFolderNode.update(oldFolders, this, this.changeSummaries);
        this.folders = oldFolders;
    }

    public void updateLinks(List<ILink> newLinks, IQueryContext context) {
        ArrayList<IFileSystemWorkItem> oldLinks = new ArrayList<IFileSystemWorkItem>(this.links);
        ArrayList<OutgoingWorkItemNode> updateLinks = new ArrayList<OutgoingWorkItemNode>();
        for (ILink link : newLinks) {
            WorkItemNode node;
            IReference targetRef = link.getTargetRef();
            Object item = targetRef.resolve();
            if (item == null || !(item instanceof IAuditableHandle)) continue;
            if (this instanceof OutgoingChangeSetNode) {
                node = new OutgoingWorkItemNode(link, (OutgoingChangeSetNode)this);
            } else if (this instanceof IncomingChangeSetNode) {
                node = new IncomingWorkItemNode(link, (IncomingChangeSetNode)this);
            } else if (this instanceof SuspendedChangeSetNode) {
                node = new SuspendedWorkItemNode(link, (SuspendedChangeSetNode)this);
            } else {
                throw new IllegalStateException("Invalid type for " + this);
            }
            updateLinks.add((OutgoingWorkItemNode)node);
            context.setAdded(Collections.singletonList(node));
        }
        ComponentConflictUtil.update(oldLinks, updateLinks, new ComponentConflictUtil.UpdateItem(){

            public boolean sameItem(Object object, Object other) {
                return ((IFileSystemWorkItem)object).getWorkItemHandle().sameItemId((IItemHandle)((IFileSystemWorkItem)other).getWorkItemHandle());
            }

            public void updateSameItem(Object object, Object other) {
                WorkItemNode wi = (WorkItemNode)object;
                WorkItemNode wi2 = (WorkItemNode)other;
                wi.link = wi2.link;
            }
        });
        context.setRemoved(this.links);
        context.setAdded(updateLinks);
        this.links = oldLinks;
    }

    boolean hasSameItemIds(ChangeSetNode other) {
        return this.handle.sameItemId((IItemHandle)other.handle);
    }
}

