/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.util;

import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.IAutoCommitParticipant;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.LocalChangeSource;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class AutoCommitManager {
    private static AutoCommitManager instance = null;
    IAutoCommitParticipant participant = null;
    private final Object participantLock = new Object();
    private LinkedList<QueueRecord> queue = new LinkedList();

    public static synchronized AutoCommitManager getInstance() {
        if (instance == null) {
            instance = new AutoCommitManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAutoCommitParticipant getParticipant() {
        Object object = this.participantLock;
        synchronized (object) {
            return this.participant;
        }
    }

    public void enqueueSource(LocalChangeSource source, CommitDilemmaHandler handler, IProgressMonitor progress) {
        IAutoCommitParticipant participant = this.getParticipant();
        if (participant == null) {
            source.autoCheckin(handler, progress);
            return;
        }
        AutoCommitRequest req = new AutoCommitRequest();
        try {
            participant.autocommitRequested(req);
        }
        catch (Exception e) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)e));
            this.enqueueSource(handler, source);
            return;
        }
        if (req.getResult() == RequestResult.ALLOW) {
            source.autoCheckin(handler, progress);
        } else {
            this.enqueueSource(handler, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueSource(CommitDilemmaHandler handler, LocalChangeSource source) {
        ILocalSynchronizationManager syncMgr = source.getModel().getComponentSyncModel().getLocalSynchronizationManager();
        if (!syncMgr.getAutoSave()) {
            return;
        }
        LinkedList<QueueRecord> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(new QueueRecord(source, handler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus autoCommit(IProgressMonitor m) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m);
        int sourcesToProcess = 1;
        int sourcesProcessed = 0;
        MultiStatus errors = new MultiStatus("com.ibm.team.filesystem.rcp.core", -1, Messages.AutoCommitManager_ProgressMessage, null);
        while (true) {
            QueueRecord qr = null;
            try {
                LinkedList<QueueRecord> linkedList = this.queue;
                synchronized (linkedList) {
                    sourcesToProcess = this.queue.size();
                    qr = this.queue.remove();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            ILocalSynchronizationManager syncMgr = qr.source.getModel().getComponentSyncModel().getLocalSynchronizationManager();
            if (!syncMgr.getAutoSave()) continue;
            monitor.setWorkRemaining(sourcesToProcess);
            monitor.setTaskName(NLS.bind((String)Messages.AutoCommitManager_Errors, (Object)sourcesProcessed++, (Object)sourcesToProcess));
            IStatus result = qr.source.autoCheckin(qr.handler, (IProgressMonitor)monitor.newChild(1));
            if (result == null || result.isOK()) continue;
            errors.add(result);
        }
        if (errors.getChildren().length > 0) {
            return errors;
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParticipant(IAutoCommitParticipant part) {
        Object object = this.participantLock;
        synchronized (object) {
            IAutoCommitParticipant oldPart = this.participant;
            this.participant = part;
            if (part != null) {
                part.install(new IAutoCommitParticipant.IAutoCommitController(){

                    public void commit(IProgressMonitor m) {
                        AutoCommitManager.this.autoCommit(m);
                    }
                });
            }
            if (oldPart != null) {
                oldPart.uninstall();
            }
        }
    }

    public void userCommitted() {
        IAutoCommitParticipant participant = this.getParticipant();
        if (participant != null) {
            participant.userCommitted();
        }
    }

    private static class AutoCommitRequest
    implements IAutoCommitParticipant.IAutoCommitRequest {
        RequestResult result = RequestResult.UNSET;

        private AutoCommitRequest() {
        }

        public void allow() {
            this.result = RequestResult.ALLOW;
        }

        public void deny() {
            this.result = RequestResult.DENY;
        }

        RequestResult getResult() {
            return this.result;
        }
    }

    private static class QueueRecord {
        final LocalChangeSource source;
        final CommitDilemmaHandler handler;

        public QueueRecord(LocalChangeSource s, CommitDilemmaHandler h) {
            this.source = s;
            this.handler = h;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestResult {
        UNSET,
        ALLOW,
        DENY;

    }
}

