/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.outofsync;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutOfSyncCache
extends EventSource {
    public static final String OUT_OF_SYNC = "out_of_sync";
    static OutOfSyncCache INSTANCE;
    Job updateJob = new Job(Messages.OutOfSyncCache_0){

        protected IStatus run(IProgressMonitor monitor) {
            return OutOfSyncCache.this.update(monitor);
        }
    };
    volatile HashMap<UUID, HashMap<UUID, HashSet<IShare>>> cache = new HashMap();

    public static synchronized OutOfSyncCache get() {
        if (INSTANCE == null) {
            INSTANCE = new OutOfSyncCache();
        }
        return INSTANCE;
    }

    public Collection<IShare> getOutOfSync(IWorkspaceHandle workspace, IComponentHandle component) {
        Collection result = null;
        HashMap<UUID, HashSet<IShare>> componentCache = this.cache.get(workspace.getItemId());
        if (componentCache != null) {
            result = componentCache.get(component.getItemId());
        }
        return result != null ? result : Collections.EMPTY_LIST;
    }

    public int getOutOfSyncCount(IWorkspaceHandle workspace) {
        int result = 0;
        HashMap<UUID, HashSet<IShare>> componentCache = this.cache.get(workspace.getItemId());
        if (componentCache != null) {
            for (Map.Entry<UUID, HashSet<IShare>> entry : componentCache.entrySet()) {
                result += entry.getValue().size();
            }
        }
        return result;
    }

    public void update() {
        this.updateJob.schedule(1000L);
    }

    private IStatus update(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.OutOfSyncCache_1, (int)100);
        final HashMap cache = new HashMap();
        OutOfSyncDilemmaHandler handler = new OutOfSyncDilemmaHandler(){

            public int outOfSync(Collection<IShareOutOfSync> sharesOutOfSync) {
                for (IShareOutOfSync shareOutOfSync : sharesOutOfSync) {
                    HashSet<IShare> shares;
                    IShare share = shareOutOfSync.getShare();
                    ISharingDescriptor sd = share.getSharingDescriptor();
                    IWorkspaceHandle workspace = sd.associatedWithWorkspace() ? (IWorkspaceHandle)sd.getConnectionHandle() : null;
                    IComponentHandle component = sd.getComponent();
                    if (workspace == null || component == null) continue;
                    HashMap<UUID, HashSet<IShare>> componentCache = (HashMap<UUID, HashSet<IShare>>)cache.get(workspace.getItemId());
                    if (componentCache == null) {
                        componentCache = new HashMap<UUID, HashSet<IShare>>();
                        cache.put(workspace.getItemId(), componentCache);
                    }
                    if ((shares = (HashSet<IShare>)componentCache.get(component.getItemId())) == null) {
                        shares = new HashSet<IShare>();
                        componentCache.put(component.getItemId(), shares);
                    }
                    shares.add(share);
                }
                return 0;
            }
        };
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(handler);
        IComponentSyncContext[] iComponentSyncContextArray = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (context.isLocal()) {
                verifyOp.addToVerify((IConnection)context.getOutgoingTeamPlace(), (IComponentHandle)context.getComponent());
            }
            ++n2;
        }
        verifyOp.setVerifyAgainstCache(true);
        try {
            verifyOp.run((IProgressMonitor)progress);
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            return Status.OK_STATUS;
        }
        catch (TeamRepositoryException e) {
            return FileSystemStatus.getStatusFor((Throwable)e);
        }
        catch (FileSystemClientException e) {
            return FileSystemStatus.getStatusFor((Throwable)e);
        }
        if (!this.cache.equals(cache)) {
            this.cache = cache;
            this.queueEvent(new Event((IEventSource)this, OUT_OF_SYNC));
        }
        return Status.OK_STATUS;
    }
}

