/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IIncomingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceUpdateUtil {
    public static void accept(Collection selection, WorkspaceUpdateDilemmaHandler workspaceDilemmaHandler, boolean replace, boolean forceReplace, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ComponentBaselineUtil_ProgressMessage, (int)(selection.size() * 10));
        IWorkspaceUpdateOperation updateOperation = IOperationFactory.instance.getWorkspaceUpdateOperation(workspaceDilemmaHandler);
        for (Object element : selection) {
            if (element instanceof IWorkspaceSyncContext) {
                IWorkspaceSyncContext wsc = (IWorkspaceSyncContext)element;
                WorkspaceUpdateUtil.accept(wsc, updateOperation, replace, forceReplace, (IProgressMonitor)progress.newChild(1));
            }
            if (element instanceof IComponentSyncContext) {
                IComponentSyncContext context = (IComponentSyncContext)element;
                WorkspaceUpdateUtil.accept(context, updateOperation, replace, forceReplace, (IProgressMonitor)progress.newChild(1));
            }
            if (element instanceof IIncomingActivitySource) {
                IIncomingActivitySource source = (IIncomingActivitySource)element;
                IComponentSyncContext context = source.getModel();
                WorkspaceUpdateUtil.accept(context, updateOperation, replace, forceReplace, (IProgressMonitor)progress.newChild(1));
            }
            if (element instanceof IIncomingBaselineGroup) {
                IIncomingBaselineGroup bg = (IIncomingBaselineGroup)element;
                WorkspaceUpdateUtil.accept(bg, updateOperation, (IProgressMonitor)progress.newChild(1));
            }
            if (!(element instanceof IIncomingRemoteActivity)) continue;
            IIncomingRemoteActivity activity = (IIncomingRemoteActivity)element;
            WorkspaceUpdateUtil.accept(activity, updateOperation, (IProgressMonitor)progress.newChild(1));
        }
        progress.setWorkRemaining(100);
        updateOperation.run((IProgressMonitor)progress.newChild(100));
    }

    private static void accept(IWorkspaceSyncContext wsc, IWorkspaceUpdateOperation updateOperation, boolean replace, boolean forceReplace, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentSyncContext[] contexts = wsc.getComponentSyncContexts();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)contexts.length);
        IComponentSyncContext[] iComponentSyncContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            WorkspaceUpdateUtil.accept(context, updateOperation, replace, forceReplace, (IProgressMonitor)progress.newChild(1));
            ++n2;
        }
    }

    private static void accept(IComponentSyncContext context, IWorkspaceUpdateOperation updateOperation, boolean replace, boolean forceReplace, IProgressMonitor monitor) throws TeamRepositoryException {
        int type = context.getType();
        if (type == 2 || type == 5 || type == 6) {
            boolean replaced;
            IWorkspaceConnection source = context.getOutgoingTeamPlace();
            IWorkspaceConnection target = context.getIncomingTeamPlace();
            int flags = ((ComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel()).getCompareToFlags();
            IChangeHistorySyncReport syncReport = SyncCache.get().fetch((IWorkspaceConnection)source, (IWorkspaceConnection)target, (int)flags, (IProgressMonitor)monitor).syncReport;
            IComponent component = context.getComponent();
            boolean bl = replaced = type == 2 && ComponentSyncUtil.isReplaced(context);
            if (forceReplace || replaced && replace) {
                updateOperation.replace(source, target, Collections.singletonList(component));
            } else {
                updateOperation.accept(source, target, syncReport, Collections.singletonList(component));
            }
        }
    }

    private static void accept(IIncomingBaselineGroup bg, IWorkspaceUpdateOperation updateOperation, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentSyncContext context = bg.getActivitySource().getModel();
        IWorkspaceConnection source = context.getOutgoingTeamPlace();
        IWorkspaceConnection target = context.getIncomingTeamPlace();
        int flags = ((ComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel()).getCompareToFlags();
        IChangeHistorySyncReport syncReport = SyncCache.get().fetch((IWorkspaceConnection)source, (IWorkspaceConnection)target, (int)flags, (IProgressMonitor)monitor).syncReport;
        updateOperation.accept(source, target, syncReport, Collections.singletonList(bg.getBaseline()), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    private static void accept(IIncomingRemoteActivity activity, IWorkspaceUpdateOperation updateOperation, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentSyncContext context = ComponentSyncUtil.getContext(activity);
        IWorkspaceConnection source = context.getOutgoingTeamPlace();
        IWorkspaceConnection target = context.getIncomingTeamPlace();
        int flags = ((ComponentSyncModel)FileSystemResourcesPlugin.getComponentSyncModel()).getCompareToFlags();
        IChangeHistorySyncReport syncReport = SyncCache.get().fetch((IWorkspaceConnection)source, (IWorkspaceConnection)target, (int)flags, (IProgressMonitor)monitor).syncReport;
        updateOperation.accept(source, target, syncReport, Collections.EMPTY_LIST, Collections.singletonList(activity.getChangeSetHandle()), Collections.EMPTY_LIST);
    }
}

