/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.common.CompareWorkspacesException;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.IWorkspaceCompareReport;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SyncIDWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncCache {
    static SyncCache cache;
    HashMap<UUID, SyncDataWorkspace> sourceCache = new HashMap();
    HashMap<String, SyncDataFlow> flowCache = new HashMap();

    public static SyncCache get() {
        if (cache == null) {
            cache = new SyncCache();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncDataWorkspace fetch(IWorkspaceConnection source, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        UUID key = source.getResolvedWorkspace().getItemId();
        HashMap<UUID, SyncDataWorkspace> hashMap = this.sourceCache;
        synchronized (hashMap) {
            IUpdateReport conflictReport;
            IUpdateReport id;
            SyncDataWorkspace value = this.sourceCache.get(key);
            IUpdateReport iUpdateReport = id = value != null ? value.workspace.conflictReport() : null;
            if (value != null && SyncCache.equals(value.id, id)) {
                return value;
            }
            value = new SyncDataWorkspace();
            value.workspace = source;
            value.id = conflictReport = source.conflictReport();
            IFileSystemView fsvSource = FileSystemCore.getFileSystemManager((ITeamRepository)source.teamRepository()).getFileSystemView((IConnection)source);
            value.logicalConflictReport = fsvSource.conflictReport((IProgressMonitor)m.newChild(1));
            value.conflictReport = value.logicalConflictReport.conflictReport();
            m.worked(1);
            this.sourceCache.put(key, value);
            m.done();
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncDataFlow fetch(IWorkspaceConnection source, IWorkspaceConnection target, int flags, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        String key = SyncCache.getKey(source, target);
        HashMap<String, SyncDataFlow> hashMap = this.flowCache;
        synchronized (hashMap) {
            SyncDataFlow value = this.flowCache.get(key);
            if (value != null && value.syncReport != null && value.syncReport.getFlags() == flags && value.id.equals(SyncCache.getId(source, target))) {
                return value;
            }
            boolean miss = value == null;
            value = new SyncDataFlow();
            value.source = source;
            value.target = target;
            value.id = SyncCache.getId(source, target);
            IFileSystemView fsvSource = FileSystemCore.getFileSystemManager((ITeamRepository)source.teamRepository()).getFileSystemView((IConnection)source);
            try {
                IWorkspaceCompareReport compare = fsvSource.compareAsWorkspaces(target, flags, Collections.EMPTY_LIST, (IProgressMonitor)m.newChild(4));
                value.syncReport = compare.syncReport();
                value.extra = miss ? this.prefetchItems(source.teamRepository(), value, (IProgressMonitor)m.newChild(1)) : null;
                value.freeFlightLogicalConflictReport = compare.logicalConflictReport();
            }
            catch (CompareWorkspacesException cwe) {
                value.syncReport = cwe.getSyncReport();
                value.extra = miss ? this.prefetchItems(source.teamRepository(), value, (IProgressMonitor)m.newChild(1)) : null;
                value.freeFlightLogicalConflictReport = null;
                StatusUtil.log((Object)this, (String)"Pre-flight accept failure ", (Throwable)cwe);
            }
            m.done();
            this.flowCache.put(key, value);
            return value;
        }
    }

    private List prefetchItems(ITeamRepository repo, SyncDataFlow data, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList itemHandles = new ArrayList();
        itemHandles.addAll(data.syncReport.incomingBaselines());
        itemHandles.addAll(data.syncReport.outgoingBaselines());
        itemHandles.addAll(data.syncReport.incomingChangeSetsAfterBasis());
        itemHandles.addAll(data.syncReport.outgoingChangeSetsAfterBasis());
        itemHandles.addAll(data.syncReport.commonBaselines());
        itemHandles.addAll(data.syncReport.localBases().values());
        itemHandles.addAll(data.syncReport.remoteBases().values());
        return repo.itemManager().fetchCompleteItems(itemHandles, 0, monitor);
    }

    public void clear() {
        this.sourceCache = new HashMap();
        this.flowCache = new HashMap();
    }

    private static String getKey(IWorkspaceConnection source, IWorkspaceConnection target) {
        return String.valueOf(source.getResolvedWorkspace().getItemId().getUuidValue()) + target.getResolvedWorkspace().getItemId().getUuidValue();
    }

    private static SyncIDFlow getId(IWorkspaceConnection source, IWorkspaceConnection target) {
        return new SyncIDFlow(source, target);
    }

    private static boolean equals(IUpdateReport report, IUpdateReport other) {
        if (report.conflicts().size() != other.conflicts().size()) {
            return false;
        }
        Set<Icr> reportConflicts = SyncCache.getConflicts(report);
        Set<Icr> otherConflicts = SyncCache.getConflicts(other);
        return reportConflicts.equals(otherConflicts);
    }

    private static Set<Icr> getConflicts(IUpdateReport report) {
        HashSet<Icr> result = new HashSet<Icr>();
        for (IItemConflictReport icr : report.conflicts()) {
            result.add(new Icr(icr));
        }
        return result;
    }

    private static class Icr {
        UUID uuid1;
        UUID uuid2;
        UUID uuid3;
        UUID uuid4;
        UUID uuid5;
        UUID uuid6;

        public Icr(IItemConflictReport icr) {
            this.uuid1 = icr.item().getItemId();
            this.uuid2 = icr.getCommonAncestorState() != null ? icr.getCommonAncestorState().getItemId() : null;
            this.uuid3 = icr.getComponent().getItemId();
            this.uuid4 = icr.getOriginalSelectedContributorState() != null ? icr.getOriginalSelectedContributorState().getItemId() : null;
            this.uuid5 = icr.getProposedContributorState() != null ? icr.getProposedContributorState().getItemId() : null;
            this.uuid6 = icr.getSelectedContributorState() != null ? icr.getSelectedContributorState().getItemId() : null;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.uuid1 == null ? 0 : this.uuid1.hashCode());
            result = 31 * result + (this.uuid2 == null ? 0 : this.uuid2.hashCode());
            result = 31 * result + (this.uuid3 == null ? 0 : this.uuid3.hashCode());
            result = 31 * result + (this.uuid4 == null ? 0 : this.uuid4.hashCode());
            result = 31 * result + (this.uuid5 == null ? 0 : this.uuid5.hashCode());
            result = 31 * result + (this.uuid6 == null ? 0 : this.uuid6.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Icr other = (Icr)obj;
            if (this.uuid1 == null ? other.uuid1 != null : !this.uuid1.equals((Object)other.uuid1)) {
                return false;
            }
            if (this.uuid2 == null ? other.uuid2 != null : !this.uuid2.equals((Object)other.uuid2)) {
                return false;
            }
            if (this.uuid3 == null ? other.uuid3 != null : !this.uuid3.equals((Object)other.uuid3)) {
                return false;
            }
            if (this.uuid4 == null ? other.uuid4 != null : !this.uuid4.equals((Object)other.uuid4)) {
                return false;
            }
            if (this.uuid5 == null ? other.uuid5 != null : !this.uuid5.equals((Object)other.uuid5)) {
                return false;
            }
            return !(this.uuid6 == null ? other.uuid6 != null : !this.uuid6.equals((Object)other.uuid6));
        }
    }

    public static class SyncDataFlow {
        public IWorkspaceConnection source;
        public IWorkspaceConnection target;
        public SyncIDFlow id;
        public IChangeHistorySyncReport syncReport;
        public ILogicalConflictReport freeFlightLogicalConflictReport;
        private Object extra;
    }

    public static class SyncDataWorkspace {
        public IWorkspaceConnection workspace;
        public IUpdateReport id;
        public IUpdateReport conflictReport;
        public ILogicalConflictReport logicalConflictReport;
    }

    public static class SyncIDFlow {
        SyncIDWorkspace source;
        SyncIDWorkspace target;

        public SyncIDFlow(IWorkspaceConnection source, IWorkspaceConnection target) {
            this.source = new SyncIDWorkspace((IFlowNodeConnection)source);
            this.target = new SyncIDWorkspace((IFlowNodeConnection)target);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SyncIDFlow)) {
                return false;
            }
            SyncIDFlow other = (SyncIDFlow)obj;
            return this.source.equals(other.source) && this.target.equals(other.target);
        }

        public int hashCode() {
            return this.source.hashCode() ^ this.target.hashCode();
        }
    }
}

