/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineManager
extends EventSource {
    static OfflineManager INSTANCE;
    public static final String UNREACHABLE_DESCRIPTORS = "unreachableDescriptors";
    public static final String UNREACHABLE_WORKSPACES = "unreachableWorkspaces";
    volatile Set<LoadedConfigurationDescriptor> unreachableDescriptors = Collections.EMPTY_SET;
    volatile Set<UnreachableWorkspace> unreachableWorkspaces = Collections.EMPTY_SET;
    ICopyFileAreaListener cfaListener;
    IListener repoListener;
    Job updateJob;

    public static synchronized OfflineManager getInstance() {
        if (INSTANCE == null) {
            OfflineManager om = new OfflineManager();
            om.init();
            INSTANCE = om;
        }
        return INSTANCE;
    }

    private void init() {
        this.updateJob = new Job(Messages.OfflineManager_2){

            protected IStatus run(IProgressMonitor monitor) {
                ISharingManager sharingManager = FileSystemCore.getSharingManager();
                Collection sandboxes = sharingManager.getRegisteredSandboxes();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.OfflineManager_3, (int)(100 * sandboxes.size()));
                HashSet<LoadedConfigurationDescriptor> newUnreachableDescriptors = new HashSet<LoadedConfigurationDescriptor>();
                ArrayList<IStatus> errors = new ArrayList<IStatus>();
                for (ISandbox sandbox : sandboxes) {
                    Collection lcds = null;
                    try {
                        lcds = sandbox.allLoadedConfigurations((IProgressMonitor)progress.newChild(5));
                    }
                    catch (FileSystemClientException e) {
                        errors.add(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
                    }
                    if (lcds == null) continue;
                    List result = OfflineManager.computeUnreachable(lcds, (IProgressMonitor)progress.newChild(95));
                    newUnreachableDescriptors.addAll(result);
                }
                if (!newUnreachableDescriptors.equals(OfflineManager.this.unreachableDescriptors)) {
                    Set<UnreachableWorkspace> unreachableWorkspaces = OfflineManager.this.createUnreachableWorkspaces(newUnreachableDescriptors);
                    OfflineManager.this.unreachableDescriptors = newUnreachableDescriptors;
                    if (!unreachableWorkspaces.equals(OfflineManager.this.unreachableWorkspaces)) {
                        OfflineManager.this.unreachableWorkspaces = unreachableWorkspaces;
                        OfflineManager.this.queueEvent(new Event((IEventSource)OfflineManager.this, OfflineManager.UNREACHABLE_WORKSPACES));
                    }
                    OfflineManager.this.queueEvent(new Event((IEventSource)OfflineManager.this, OfflineManager.UNREACHABLE_DESCRIPTORS));
                }
                if (!errors.isEmpty()) {
                    if (errors.size() == 1) {
                        return (IStatus)errors.get(0);
                    }
                    return StatusUtil.newStatus((Object)((Object)this), (String)Messages.OfflineManager_ErrorsOccurred, errors);
                }
                return Status.OK_STATUS;
            }
        };
        this.cfaListener = new ICopyFileAreaListener(){

            public void change(ICopyFileAreaEvent[] events) {
                int i = events.length - 1;
                while (i >= 0) {
                    int reason = events[i].getReason();
                    if (reason == 7 || reason == 8) {
                        OfflineManager.this.requestUpdate();
                        break;
                    }
                    --i;
                }
            }
        };
        FileSystemCore.getSharingManager().addListener(this.cfaListener);
        this.repoListener = new IListener(){

            public void handleEvents(List events) {
                OfflineManager.this.requestUpdate();
            }
        };
        TeamPlatform.getTeamRepositoryService().addGenericListener((Object)"state", this.repoListener);
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(new ITeamRepositoryService.IRepositoryServiceListener(){

            public void addedRepository(ITeamRepository repository) {
                OfflineManager.this.requestUpdate();
            }

            public void removedRepository(ITeamRepository repository) {
                OfflineManager.this.requestUpdate();
            }
        });
    }

    public void requestUpdate() {
        this.updateJob.schedule(1000L);
    }

    public Collection<LoadedConfigurationDescriptor> getUnreachableDescriptors() {
        return this.unreachableDescriptors;
    }

    public Collection<UnreachableWorkspace> getUnreachableWorkspaces() {
        return this.unreachableWorkspaces;
    }

    public Collection<UnreachableWorkspace> getUnreachableWorkspaces(boolean excludePreviouslyReachable) {
        Collection<UnreachableWorkspace> unreachableWorkspaces = this.getUnreachableWorkspaces();
        IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
        IWorkspaceSyncContext[] contexts = model.getWorkspaceSyncContexts();
        ArrayList<UnreachableWorkspace> result = new ArrayList<UnreachableWorkspace>();
        for (UnreachableWorkspace uw : unreachableWorkspaces) {
            boolean found = false;
            IWorkspaceSyncContext[] iWorkspaceSyncContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkspaceSyncContext context = iWorkspaceSyncContextArray[n2];
                if (context.getLocal().getContextHandle().sameItemId((IItemHandle)uw.getHandle())) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (found) continue;
            result.add(uw);
        }
        return result;
    }

    public Collection<LoadedConfigurationDescriptor> getUnreachableDescriptors(UnreachableWorkspace workspace) {
        ArrayList<LoadedConfigurationDescriptor> result = new ArrayList<LoadedConfigurationDescriptor>();
        Set<LoadedConfigurationDescriptor> unreachableDescriptors = this.unreachableDescriptors;
        for (LoadedConfigurationDescriptor lcd : unreachableDescriptors) {
            if (!workspace.handle.sameItemId((IItemHandle)lcd.connectionHandle)) continue;
            result.add(lcd);
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static List<LoadedConfigurationDescriptor> computeUnreachable(Collection<LoadedConfigurationDescriptor> lcd, IProgressMonitor monitor) {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        result = new ArrayList<LoadedConfigurationDescriptor>();
        visibleRepos = new HashSet<ITeamRepository>(Arrays.asList(TeamPlatform.getTeamRepositoryService().getTeamRepositories()));
        possiblyReachableWorkspaces = new HashMap<ITeamRepository, HashMap<K, V>>();
        possiblyReachableBaselines = new HashMap<ITeamRepository, ArrayList<LoadedConfigurationDescriptor>>();
        for (LoadedConfigurationDescriptor desc : lcd) {
            repo = RepositoryUtils.getTeamRepository((String)desc.uri, (int)4, (UUID)desc.id);
            if (repo == null || !repo.loggedIn() || !visibleRepos.contains(repo)) {
                result.add(desc);
                continue;
            }
            if (desc.connectionHandle instanceof IBaselineHandle) {
                if (repo.itemManager().getSharedItemIfKnown((IItemHandle)desc.connectionHandle) != null) continue;
                baselines = (ArrayList<LoadedConfigurationDescriptor>)possiblyReachableBaselines.get(repo);
                if (baselines == null) {
                    baselines = new ArrayList<LoadedConfigurationDescriptor>();
                    possiblyReachableBaselines.put(repo, baselines);
                }
                baselines.add(desc);
                continue;
            }
            pr = (HashMap<UUID, ArrayList<LoadedConfigurationDescriptor>>)possiblyReachableWorkspaces.get(repo);
            if (pr == null) {
                pr = new HashMap<UUID, ArrayList<LoadedConfigurationDescriptor>>();
                possiblyReachableWorkspaces.put(repo, pr);
                ld = new ArrayList<LoadedConfigurationDescriptor>();
                pr.put(desc.connectionHandle.getItemId(), ld);
            } else {
                ld = (ArrayList<LoadedConfigurationDescriptor>)pr.get(desc.connectionHandle.getItemId());
                if (ld == null) {
                    ld = new ArrayList<E>();
                    pr.put(desc.connectionHandle.getItemId(), ld);
                }
            }
            ld.add(desc);
        }
        visibleRepos = null;
        progress.setWorkRemaining(possiblyReachableBaselines.size() + possiblyReachableWorkspaces.size());
        block7: for (Map.Entry e : possiblyReachableWorkspaces.entrySet()) {
            repo = (ITeamRepository)e.getKey();
            loaded = (Map)e.getValue();
            workspaces = new ArrayList<IWorkspaceHandle>(loaded.size());
            for (List v : loaded.values()) {
                workspaces.add((IWorkspaceHandle)((LoadedConfigurationDescriptor)v.get((int)0)).connectionHandle);
            }
            try {
                connections = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnections(workspaces, (IProgressMonitor)progress.newChild(1));
                it = connections.iterator();
                for (List v : loaded.values()) {
                    workspaces.add((IWorkspaceHandle)((LoadedConfigurationDescriptor)v.get((int)0)).connectionHandle);
                    conn = (IWorkspaceConnection)it.next();
                    for (LoadedConfigurationDescriptor desc : v) {
                        if (conn == null) {
                            result.add(desc);
                            continue;
                        }
                        try {
                            conn.configuration(desc.componentHandle);
                        }
                        catch (TeamRepositoryException v0) {
                            result.add(desc);
                        }
                    }
                }
                continue;
            }
            catch (TeamRepositoryException v1) {
                ** for (v : loaded.values())
            }
lbl-1000:
            // 2 sources

            {
                for (LoadedConfigurationDescriptor desc : v) {
                    result.add(desc);
                }
                continue;
lbl79:
                // 1 sources

            }
        }
        block13: for (Map.Entry e : possiblyReachableBaselines.entrySet()) {
            repo = (ITeamRepository)e.getKey();
            loaded = (List)e.getValue();
            baselines = new ArrayList<IBaselineHandle>(loaded.size());
            it = loaded.iterator();
            while (it.hasNext()) {
                desc = (LoadedConfigurationDescriptor)it.next();
                baselines.add((IBaselineHandle)desc.connectionHandle);
            }
            try {
                fetched = repo.itemManager().fetchCompleteItems(baselines, 0, (IProgressMonitor)progress.newChild(1));
                it = fetched.iterator();
                var15_15 = loaded.iterator();
                while (var15_15.hasNext()) {
                    desc = (LoadedConfigurationDescriptor)var15_15.next();
                    b = (IBaseline)it.next();
                    if (b != null) continue;
                    result.add(desc);
                }
                continue;
            }
            catch (TeamRepositoryException v2) {
                var13_13 = loaded.iterator();
                ** while (var13_13.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                desc = (LoadedConfigurationDescriptor)var13_13.next();
                result.add(desc);
                continue;
lbl109:
                // 1 sources

            }
        }
        return result;
    }

    Set<UnreachableWorkspace> createUnreachableWorkspaces(Collection<LoadedConfigurationDescriptor> lcds) {
        HashSet<UnreachableWorkspace> result = new HashSet<UnreachableWorkspace>();
        for (LoadedConfigurationDescriptor lcd : lcds) {
            result.add(new UnreachableWorkspace(lcd.connectionName, lcd.connectionHandle));
        }
        return result;
    }

    public static class UnreachableWorkspace {
        String name;
        IContextHandle handle;

        public UnreachableWorkspace(String name, IContextHandle handle) {
            this.name = name;
            this.handle = handle;
        }

        public int hashCode() {
            return this.handle.getItemId().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnreachableWorkspace other = (UnreachableWorkspace)obj;
            return other.handle.sameItemId((IItemHandle)this.handle);
        }

        public String getName() {
            return this.name;
        }

        public IContextHandle getHandle() {
            return this.handle;
        }
    }
}

