/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChangeFactory {
    public static FileChange createFromRemoteSummary(IRemoteChangeSummary summary, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = summary.getActivity().getActivitySource().getModel().teamRepository();
        IChange appropriateChange = FileChangeFactory.getChange(summary);
        HashSet toPrefetch = NewCollection.hashSet();
        ConfigurationChangeFactory.prefetchCreateFileChange(summary.getChangeSummary(), appropriateChange, toPrefetch);
        Map fetched = RepoFetcher.fetchItems((ITeamRepository)repo, (Collection)toPrefetch, (IProgressMonitor)monitor);
        return ConfigurationChangeFactory.createFileChange(repo, summary.getChangeSummary(), appropriateChange, fetched);
    }

    static IChange getChange(IRemoteChangeSummary summary) {
        IChangeSet changeSet = summary.getActivity().getChangeSet();
        if (changeSet == null) {
            return null;
        }
        ItemId itemId = new ItemId((IItemHandle)summary.getItem());
        IChange appropriateChange = ChangeSetUtil.getChangeFor((IChangeSet)changeSet, (ItemId)itemId);
        return appropriateChange;
    }

    public static FileChange createFromSummary(ITeamRepository repo, IChangeSummary changeSummary, IChange change, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet toFetch = NewCollection.hashSet();
        ConfigurationChangeFactory.prefetchCreateFileChange(changeSummary, change, toFetch);
        Map fetched = RepoFetcher.fetchItems((ITeamRepository)repo, (Collection)toFetch, (IProgressMonitor)monitor);
        return ConfigurationChangeFactory.createFileChange(repo, changeSummary, change, fetched);
    }

    public static Map<IRemoteChangeSummary, FileChange> createFromRemoteSummaries(Collection<IRemoteChangeSummary> summaries, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap summariesByRepo = NewCollection.hashMap();
        for (IRemoteChangeSummary next : summaries) {
            CollectionUtil.addToMapOfLists((Map)summariesByRepo, (Object)next.getActivity().getActivitySource().getModel().teamRepository(), (Object)next);
        }
        HashMap fileChanges = NewCollection.hashMap();
        for (ITeamRepository repo : summariesByRepo.keySet()) {
            List filteredSummaries = (List)summariesByRepo.get(repo);
            HashSet remoteActivities = NewCollection.hashSet();
            for (IRemoteChangeSummary next : filteredSummaries) {
                remoteActivities.add(next.getActivity());
            }
            Map<IRemoteActivity, IChangeSet> changeSets = ConfigurationChangeFactory.getChangeSets(remoteActivities, shouldRefresh, (IProgressMonitor)progress.newChild(50));
            HashSet toPrefetch = NewCollection.hashSet();
            for (IRemoteChangeSummary next : filteredSummaries) {
                IChangeSet changeSet = changeSets.get(next.getActivity());
                if (changeSet == null) continue;
                ConfigurationChangeFactory.prefetchCreateFileChange(next.getChangeSummary(), FileChangeFactory.getChange(next), toPrefetch);
            }
            Map fetched = RepoFetcher.fetchItems((ITeamRepository)repo, (Collection)toPrefetch, (IProgressMonitor)progress.newChild(50));
            for (IRemoteChangeSummary next : filteredSummaries) {
                IChangeSet changeSet = changeSets.get(next.getActivity());
                if (changeSet == null) continue;
                fileChanges.put(next, ConfigurationChangeFactory.createFileChange(repo, next.getChangeSummary(), FileChangeFactory.getChange(next), fetched));
            }
        }
        return fileChanges;
    }
}

