/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyFileAreaPathResolver
implements IPathResolver {
    private CopyFileAreaPathResolver() {
    }

    public static CopyFileAreaPathResolver create() {
        return new CopyFileAreaPathResolver();
    }

    public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<SiloedItemId<IVersionable>, VersionablePath> result = new HashMap<SiloedItemId<IVersionable>, VersionablePath>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<SiloedItemId<IVersionable>, Collection<IShareable>> shareablesMap = CoreShareablesUtil.findShareables(unresolved, (IProgressMonitor)progress.newChild(50));
        progress.setWorkRemaining(unresolved.size());
        for (SiloedItemId<IVersionable> next : unresolved) {
            Collection<IShareable> shareables = shareablesMap.get(next);
            if (shareables.size() == 1 || shareables.size() > 1) {
                IShareable shareable = shareables.iterator().next();
                IResource resource = (IResource)Adapters.getAdapter((Object)shareable, IResource.class);
                try {
                    if (resource != null) {
                        result.put(next, CoreShareablesUtil.getPathTo(resource, true, (IProgressMonitor)progress.newChild(1)));
                        continue;
                    }
                    result.put(next, CoreShareablesUtil.getPathTo(shareable, true, (IProgressMonitor)progress.newChild(1)));
                    continue;
                }
                catch (FileSystemClientException e) {
                    throw new TeamRepositoryException(e.getMessage(), StatusUtil.getCause((Throwable)e));
                }
            }
            result.put(next, VersionablePath.create((VersionablePathSegment[])new VersionablePathSegment[0], next, (boolean)false, (boolean)false));
        }
        return result;
    }
}

