/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.common.internal.util.ChangeSummaryUtil;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FileChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.patches.FileStateFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.ItemProviderUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import com.ibm.team.scm.common.providers.ProviderFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationChangeFactory {
    public static ConfigurationChange createChange(Collection<ILocalChange> unorderedLocalChanges, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        unorderedLocalChanges = ConfigurationChangeFactory.normalizeChanges(unorderedLocalChanges);
        ArrayList fileChanges = NewCollection.arrayList();
        HashMap groupByRepo = NewCollection.hashMap();
        SubMonitor subProgress = progress.newChild(50).setWorkRemaining(unorderedLocalChanges.size());
        for (ILocalChange next : unorderedLocalChanges) {
            ISharingDescriptor desc = next.getShareable().getShare((IProgressMonitor)subProgress.newChild(1)).getSharingDescriptor();
            ITeamRepository repo = RepositoryUtils.getTeamRepository((String)desc.getRepositoryUri(), (UUID)desc.getRepositoryId());
            CollectionUtil.addToMapOfLists((Map)groupByRepo, (Object)repo, (Object)next);
        }
        boolean componentFound = false;
        ItemId componentId = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        HashSet toFetch = NewCollection.hashSet();
        progress.setWorkRemaining(groupByRepo.size());
        for (ITeamRepository repo : groupByRepo.keySet()) {
            SubMonitor iterationProgress = progress.newChild(1).setWorkRemaining(100);
            List localChanges = (List)groupByRepo.get(repo);
            for (ILocalChange next : localChanges) {
                ConfigurationChangeFactory.prefetchCreateFileChange(next, toFetch);
            }
            Map fetched = RepoFetcher.fetchItems((ITeamRepository)repo, (Collection)toFetch, (IProgressMonitor)iterationProgress.newChild(50));
            iterationProgress.setWorkRemaining(localChanges.size());
            for (ILocalChange next : localChanges) {
                if (!(next.getTarget() instanceof IFileItemHandle) && !(next.getTarget() instanceof ISymbolicLinkHandle)) continue;
                ItemId nextComponentId = CoreShareablesUtil.getComponent(next);
                if (!componentFound) {
                    componentId = nextComponentId;
                    componentFound = true;
                } else if (!componentId.equals(nextComponentId)) {
                    componentId = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
                }
                fileChanges.add(ConfigurationChangeFactory.createFileChange(repo, next, fetched, (IProgressMonitor)iterationProgress.newChild(1)));
            }
        }
        return new ConfigurationChange((Collection)fileChanges);
    }

    private static Collection<ILocalChange> normalizeChanges(Collection<ILocalChange> changes) {
        HashMap map = NewCollection.hashMap();
        for (ILocalChange next : changes) {
            next = ConfigurationChangeFactory.getFromChange(next);
            map.put(next.getTarget().getItemId(), next);
        }
        return map.values();
    }

    private static ILocalChange getFromChange(ILocalChange nextChange) {
        if (nextChange.isType(8)) {
            ILocalChange result = nextChange.getCounterpart();
            if (result == null) {
                return nextChange;
            }
            return result;
        }
        return nextChange;
    }

    static FileChange createFileChange(ITeamRepository repo, IChangeSummary changeSummary, IChange change, Map<StateId<IItem>, IItem> fetchedItems) {
        FileState beforeState = ConfigurationChangeFactory.getBeforeState(repo, changeSummary, change, fetchedItems);
        FileState afterState = ConfigurationChangeFactory.getAfterState(repo, changeSummary, change, fetchedItems);
        FileChange result = new FileChange(beforeState, afterState, ChangeSummaryUtil.getSiloedItem((IChangeSummary)changeSummary));
        return result;
    }

    private static FileChange createFileChange(ITeamRepository repo, ILocalChange next, Map<StateId<IItem>, IItem> fetched, IProgressMonitor monitor) throws FileSystemClientException {
        FileState afterState;
        next = ConfigurationChangeFactory.getFromChange(next);
        StateId beforeStateId = CoreShareablesUtil.getBeforeState(next);
        IItem item = fetched.get(beforeStateId);
        FileState beforeState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)beforeStateId.getItemType(), (IVersionable)((IVersionable)item));
        if (next.isType(4)) {
            afterState = FileState.getDeletedState((IItemType)beforeStateId.getItemType(), null);
        } else {
            IShareable shareable = next.getShareable();
            try {
                afterState = FileStateFactory.create(shareable, monitor);
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(ConfigurationChangeFactory.class, (Throwable)e));
            }
        }
        return new FileChange(beforeState, afterState, CoreShareablesUtil.getSiloedItem(next));
    }

    private static FileState getAfterState(ITeamRepository repo, IChangeSummary changeSummary, IChange change, Map<StateId<IItem>, IItem> fetchedItems) {
        StateId afterState = ConfigurationChangeFactory.getAfterState(changeSummary, change);
        IVersionable item = (IVersionable)fetchedItems.get(afterState);
        return ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)afterState.getItemType(), (IVersionable)item);
    }

    private static FileState getBeforeState(ITeamRepository repo, IChangeSummary changeSummary, IChange change, Map<StateId<IItem>, IItem> fetchedItems) {
        StateId beforeState = ConfigurationChangeFactory.getBeforeState(changeSummary, change);
        IVersionable item = (IVersionable)fetchedItems.get(beforeState);
        return ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)beforeState.getItemType(), (IVersionable)item);
    }

    private static StateId getBeforeState(IChangeSummary changeSummary, IChange appropriateChange) {
        StateId beforeState;
        if (appropriateChange != null) {
            List beforeStates = ChangeSetUtil.getBeforeStates((IChange)appropriateChange);
            beforeState = (StateId)beforeStates.get(beforeStates.size() - 1);
        } else {
            beforeState = ChangeSummaryUtil.getBeforeState((IChangeSummary)changeSummary);
        }
        return beforeState;
    }

    private static StateId getAfterState(IChangeSummary changeSummary, IChange appropriateChange) {
        StateId afterState = appropriateChange != null ? ChangeSetUtil.getAfterState((IChange)appropriateChange) : ChangeSummaryUtil.getAfterState((IChangeSummary)changeSummary);
        return afterState;
    }

    private static void prefetchCreateFileChange(ILocalChange next, Set<StateId<IItem>> toFetch) {
        next = ConfigurationChangeFactory.getFromChange(next);
        toFetch.add((StateId<IItem>)CoreShareablesUtil.getBeforeState(next));
    }

    static void prefetchCreateFileChange(IChangeSummary next, IChange changeSet, Set<StateId<IItem>> toFetch) {
        toFetch.add((StateId<IItem>)ConfigurationChangeFactory.getAfterState(next, changeSet));
        toFetch.add((StateId<IItem>)ConfigurationChangeFactory.getBeforeState(next, changeSet));
    }

    static Map<IRemoteActivity, IChangeSet> getChangeSets(Collection<IRemoteActivity> unsortedActivities, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap result = NewCollection.hashMap();
        Map<ITeamRepository, List<IRemoteActivity>> byRepository = ConfigurationChangeFactory.groupActivitiesByRepository(unsortedActivities);
        for (ITeamRepository nextRepository : byRepository.keySet()) {
            ItemId<IChangeSet> nextChangeSet;
            List<IRemoteActivity> activities = byRepository.get(nextRepository);
            HashMap fetchedChangeSets = NewCollection.hashMap();
            HashSet neededChangeSets = NewCollection.hashSet();
            for (IRemoteActivity next : activities) {
                IChangeSet changeSet;
                nextChangeSet = ConfigurationChangeFactory.getChangeSet(next);
                if (!refresh && (changeSet = next.getChangeSet()) != null) {
                    fetchedChangeSets.put(ItemId.forItem((IItem)changeSet), changeSet);
                    continue;
                }
                neededChangeSets.add(nextChangeSet);
            }
            fetchedChangeSets.putAll(RepoFetcher.fetchCurrents((ITeamRepository)nextRepository, (Collection)neededChangeSets, (boolean)refresh, (IProgressMonitor)monitor));
            for (IRemoteActivity next : activities) {
                nextChangeSet = ConfigurationChangeFactory.getChangeSet(next);
                result.put(next, (IChangeSet)fetchedChangeSets.get(nextChangeSet));
            }
        }
        return result;
    }

    private static ItemId<IChangeSet> getChangeSet(IRemoteActivity remoteActivity) {
        IChangeSetHandle cs = remoteActivity.getChangeSetHandle();
        if (cs == null) {
            return ItemId.getNullItem((IItemType)IChangeSet.ITEM_TYPE);
        }
        return new ItemId((IItemHandle)cs);
    }

    private static Map<ITeamRepository, List<IRemoteActivity>> groupActivitiesByRepository(Collection<IRemoteActivity> activities) {
        HashMap resultMap = NewCollection.hashMap();
        for (IRemoteActivity next : activities) {
            ITeamRepository nextRepository = next.getActivitySource().getModel().teamRepository();
            CollectionUtil.addToMapOfLists((Map)resultMap, (Object)nextRepository, (Object)next);
        }
        return resultMap;
    }

    public static ConfigurationChange createChangeFromConflicts(Collection<IConflictItem> pendingMerges, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap itemsByRepository = NewCollection.hashMap();
        ItemId componentId = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
        boolean isFirst = true;
        for (IConflictItem next : pendingMerges) {
            if (!(next.getItem() instanceof IFileItemHandle)) continue;
            IItemConflictReport report = next.getItemConflictReport();
            ItemId nextComponent = new ItemId((IItemHandle)report.getComponent());
            if (isFirst) {
                componentId = nextComponent;
                isFirst = false;
            } else if (!componentId.equals((Object)nextComponent)) {
                nextComponent = ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
            }
            CollectionUtil.addToMapOfLists((Map)itemsByRepository, (Object)next.getOutgoingActivitySource().getModel().teamRepository(), (Object)next);
        }
        ArrayList fileChanges = NewCollection.arrayList();
        SubMonitor loopProgress = progress.newChild(100).setWorkRemaining(itemsByRepository.size());
        for (Map.Entry next : itemsByRepository.entrySet()) {
            ITeamRepository repo = (ITeamRepository)next.getKey();
            SubMonitor iterationProgress = loopProgress.newChild(1).setWorkRemaining(100);
            HashSet toFetch = NewCollection.hashSet();
            for (IConflictItem nextItem : (List)next.getValue()) {
                IItemConflictReport report = nextItem.getItemConflictReport();
                StateId before = new StateId((IItemHandle)report.getCommonAncestorState());
                StateId after = new StateId((IItemHandle)report.getProposedContributorState());
                toFetch.add(before);
                toFetch.add(after);
            }
            Map fetched = RepoFetcher.fetchItems((ITeamRepository)repo, (Collection)toFetch, (IProgressMonitor)iterationProgress);
            for (IConflictItem nextItem : (List)next.getValue()) {
                IItemConflictReport report = nextItem.getItemConflictReport();
                StateId before = new StateId((IItemHandle)report.getCommonAncestorState());
                StateId after = new StateId((IItemHandle)report.getProposedContributorState());
                IItem beforeItem = (IItem)fetched.get(before);
                IItem afterItem = (IItem)fetched.get(after);
                FileState beforeState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)before.getItemType(), (IVersionable)((IVersionable)beforeItem));
                FileState afterState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)after.getItemType(), (IVersionable)((IVersionable)afterItem));
                IComponent component = nextItem.getOutgoingActivitySource().getModel().getComponent();
                fileChanges.add(new FileChange(beforeState, afterState, SiloedItemId.create((IVersionableHandle)nextItem.getItem(), (IComponentHandle)component)));
            }
        }
        return new ConfigurationChange((Collection)fileChanges);
    }

    public static ChangeDescription getDescriptionForHandles(ITeamRepository repo, List<ItemId<IChangeSet>> changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map fetched = RepoFetcher.fetchCurrents((ITeamRepository)repo, changeSetHandle, (boolean)true, (IProgressMonitor)progress.newChild(10));
        List ordered = CollectionUtil.reorderValues((Map)fetched, changeSetHandle);
        return ConfigurationChangeFactory.getDescription(repo, ordered, (IProgressMonitor)progress);
    }

    public static Map<ItemId<IChangeSet>, ChangeDescription> getDescriptions(ITeamRepository repo, Collection<IChangeSet> changeSet, IProgressMonitor newChild) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)newChild, (int)100);
        Map workItems = ItemProviderUtil.resolveLinks((ProviderFactory)new ClientProviderFactory(repo), (List)ItemLists.itemsToIds(changeSet), (IProgressMonitor)progress.newChild(100));
        HashMap<ItemId<IChangeSet>, ChangeDescription> result = new HashMap<ItemId<IChangeSet>, ChangeDescription>();
        for (IChangeSet next : changeSet) {
            ItemId nextId = ItemId.forItem((IItem)next);
            List wiList = (List)workItems.get(nextId);
            if (wiList == null) {
                wiList = Collections.emptyList();
            }
            ChangeDescription nextDescription = new ChangeDescription(next.getComment(), wiList, ChangeSetUtil.getComponent((IChangeSet)next), Collections.singleton(nextId), next.getLastChangeDate(), Collections.singleton(ChangeSetUtil.getAuthor((IChangeSet)next)));
            result.put((ItemId<IChangeSet>)nextId, nextDescription);
        }
        return result;
    }

    public static ChangeDescription getDescription(ITeamRepository repo, List<IChangeSet> changeSet, IProgressMonitor newChild) throws TeamRepositoryException {
        Map<ItemId<IChangeSet>, ChangeDescription> descriptions = ConfigurationChangeFactory.getDescriptions(repo, changeSet, newChild);
        List orderedDescriptions = CollectionUtil.reorderValues(descriptions, (List)ItemLists.handlesToIds(changeSet));
        return ChangeDescription.merge((List)orderedDescriptions);
    }

    public static ConfigurationChange createChangeForSummaries(List<IRemoteChangeSummary> summaries, boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<IRemoteChangeSummary, FileChange> fileChanges = FileChangeFactory.createFromRemoteSummaries(summaries, shouldRefresh, monitor);
        return new ConfigurationChange(fileChanges.values());
    }
}

