/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ComponentFlowUtil {
    public static int getComponentFlowType(ComponentSyncInfo info) throws TeamRepositoryException {
        boolean workspaceComparison;
        boolean existsRemote;
        if (info.getLocalConnection() == info.getRemote()) {
            return 1;
        }
        IComponent component = info.getComponent();
        boolean existsLocal = info.getLocalConnection() != null && ModelUtil.hasComponent(info.getLocalConnection(), (IComponentHandle)component);
        boolean bl = existsRemote = info.getRemote() != null && ModelUtil.hasComponent(info.getRemote(), (IComponentHandle)component);
        if (existsLocal && existsRemote) {
            return 2;
        }
        if (!existsLocal && !existsRemote) {
            return 7;
        }
        boolean bl2 = workspaceComparison = info.getLocalConnection() instanceof IWorkspaceConnection && info.getRemote() instanceof IWorkspaceConnection;
        if (workspaceComparison) {
            boolean hasFlow;
            boolean bl3 = hasFlow = workspaceComparison && ComponentFlowUtil.hasComponentSyncState(info);
            if (existsLocal && !existsRemote) {
                return hasFlow ? 6 : 3;
            }
            return hasFlow ? 4 : 5;
        }
        return existsLocal && !existsRemote ? 3 : 4;
    }

    private static boolean hasComponentSyncState(ComponentSyncInfo info) throws TeamRepositoryException {
        if (info.getRemote() instanceof IBaselineConnection) {
            return false;
        }
        IFlowTable flowTable = info.getLocal().getFlowTable();
        IWorkspace target = ((IWorkspaceConnection)info.getRemote()).getResolvedWorkspace();
        List componentHandles = ComponentFlowUtil.getComponentsSyncState(flowTable, (IWorkspaceHandle)target);
        for (IComponentHandle componentHandle : componentHandles) {
            if (!info.getComponent().sameItemId((IItemHandle)componentHandle)) continue;
            return true;
        }
        return false;
    }

    private static List getComponentsSyncState(IFlowTable flowTable, IWorkspaceHandle target) {
        IFlowEntry entry = flowTable.getDeliverFlow((IFlowNodeHandle)target);
        return entry == null ? Collections.EMPTY_LIST : entry.getComponentScopes();
    }

    public static void addCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        ComponentFlowUtil.addCollaboration(flowTable, local, remote);
        local.setFlowTable(flowTable, monitor);
    }

    public static void addCollaboration(IFlowTable flowTable, IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        List components = ModelUtil.getCommonComponents((IConnection)local, (IConnection)remote);
        IWorkspaceHandle target = (IWorkspaceHandle)remote.getResolvedWorkspace().getItemHandle();
        UUID remoteRepoId = null;
        String remoteRepoURI = null;
        if (!local.sameRepository((IConnection)remote)) {
            ITeamRepository remoteRepo = remote.teamRepository();
            remoteRepoId = remoteRepo.getId();
            remoteRepoURI = remoteRepo.getRepositoryURI();
        }
        flowTable.addAcceptFlow((IFlowNodeHandle)target, remoteRepoId, remoteRepoURI, (Collection)Collections.EMPTY_LIST, null);
        flowTable.addDeliverFlow((IFlowNodeHandle)target, remoteRepoId, remoteRepoURI, (Collection)components, null);
        if (flowTable.acceptSources().size() == 1) {
            ComponentFlowUtil.setDefaultCollaboration(flowTable, target);
            ComponentFlowUtil.setCurrentCollaboration(flowTable, target);
        }
    }

    public static void removeCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        ComponentFlowUtil.removeCollaboration(flowTable, (IWorkspaceHandle)remote.getResolvedWorkspace());
        local.setFlowTable(flowTable, monitor);
    }

    public static void removeCollaboration(IFlowTable flowTable, IWorkspaceHandle remote) {
        flowTable.removeAcceptFlow((IFlowNodeHandle)remote);
        flowTable.removeDeliverFlow((IFlowNodeHandle)remote);
    }

    public static void removeCollaboration(IWorkspaceConnection local, IFlowNodeHandle remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        flowTable.removeAcceptFlow(remote);
        flowTable.removeDeliverFlow(remote);
        local.setFlowTable(flowTable, monitor);
    }

    public static boolean hasCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        IWorkspace target = remote.getResolvedWorkspace();
        return local.getFlowTable().getAcceptFlow((IFlowNodeHandle)target) != null || local.getFlowTable().getDeliverFlow((IFlowNodeHandle)target) != null;
    }

    public static void setDefaultCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetDefaultAcceptFlow();
            flowTable.unsetDefaultDeliverFlow();
        } else {
            IFlowEntry deliverEntry;
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setDefault(acceptEntry);
            }
            if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                flowTable.setDefault(deliverEntry);
            }
        }
    }

    public static IWorkspaceHandle[] getAllCollaborations(IWorkspaceConnection connection) {
        ArrayList<IWorkspaceHandle> result = new ArrayList<IWorkspaceHandle>();
        IFlowTable flowTable = connection.getFlowTable();
        for (IFlowEntry entry : flowTable.acceptSources()) {
            if (!(entry.getFlowNode() instanceof IWorkspaceHandle)) continue;
            result.add((IWorkspaceHandle)entry.getFlowNode());
        }
        return result.toArray(new IWorkspaceHandle[result.size()]);
    }

    public static IWorkspaceHandle getCurrentCollaboration(IWorkspaceConnection connection) {
        IFlowTable flowTable = connection.getFlowTable();
        return ComponentFlowUtil.getCurrentCollaboration(flowTable);
    }

    public static IWorkspaceHandle getCurrentCollaboration(IFlowTable flowTable) {
        IFlowEntry entry = flowTable.getCurrentAcceptFlow();
        if (entry != null && entry.getFlowNode() instanceof IWorkspaceHandle) {
            return (IWorkspaceHandle)entry.getFlowNode();
        }
        return null;
    }

    public static void setCurrentCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentAcceptFlow();
            flowTable.unsetCurrentDeliverFlow();
        } else {
            IFlowEntry deliverEntry;
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setCurrent(acceptEntry);
            }
            if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                flowTable.setCurrent(deliverEntry);
            }
        }
    }

    public static IWorkspaceHandle getCurrentCollaboration(IWorkspaceConnection connection, IComponentHandle component) {
        IFlowTable flowTable = connection.getFlowTable();
        IFlowEntry entry = flowTable.getCurrentAcceptFlow(component);
        if (entry != null && entry.getFlowNode() instanceof IWorkspaceHandle) {
            return (IWorkspaceHandle)entry.getFlowNode();
        }
        return null;
    }

    public static void setCurrentCollaboration(IFlowTable flowTable, IComponentHandle component, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentAcceptFlow(component);
            flowTable.unsetCurrentDeliverFlow(component);
        } else {
            IFlowEntry deliverEntry;
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setCurrent(acceptEntry, component);
            }
            if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                flowTable.setCurrent(deliverEntry, component);
            }
        }
    }
}

