/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflict;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ConflictItemNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.OutgoingWorkspaceNode;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConflictUtil {
    public static Collection createConflictItems(IUpdateReport updateReport, ILogicalConflictReport conflictReport, OutgoingWorkspaceNode parent) {
        Object value;
        ArrayList<ConflictItemNode> result = new ArrayList<ConflictItemNode>();
        IComponent component = parent.getModel().getComponent();
        ArrayList logicalConflicts = new ArrayList();
        Collection conflicts = conflictReport.getConflictsForComponent((IComponentHandle)component);
        Collection incidentalChanges = conflictReport.getIncidentalChangesForComponent((IComponentHandle)component);
        Collection autoMergeChanges = conflictReport.getAutoMergeChangesForComponent((IComponentHandle)component);
        logicalConflicts.addAll(conflicts);
        logicalConflicts.addAll(incidentalChanges);
        logicalConflicts.addAll(autoMergeChanges);
        Collection itemConflictReports = updateReport.getConflictsForComponent((IComponentHandle)component);
        HashMap<UUID, IItemConflictReport> itemId2LogicalChange = new HashMap<UUID, IItemConflictReport>();
        for (ILogicalChange logicalChange : logicalConflicts) {
            Object key = logicalChange.item().getItemId();
            value = (IItemConflictReport)itemId2LogicalChange.get(key);
            if (value == null) {
                value = Collections.singletonList(logicalChange);
            } else {
                if (value.size() == 1) {
                    value = new ArrayList(value);
                }
                value.add(logicalChange);
            }
            itemId2LogicalChange.put((UUID)key, (IItemConflictReport)value);
        }
        HashMap<UUID, IItemConflictReport> itemId2ItemConflictReport = new HashMap<UUID, IItemConflictReport>();
        for (IItemConflictReport itemConflictReport : itemConflictReports) {
            value = itemId2ItemConflictReport.put(itemConflictReport.item().getItemId(), itemConflictReport);
            if (value == null) continue;
            throw new IllegalStateException();
        }
        for (Object key : itemId2LogicalChange.keySet()) {
            IItemConflictReport itemConflictReport = (IItemConflictReport)itemId2ItemConflictReport.get(key);
            for (ILogicalChange logicalChange : (List)itemId2LogicalChange.get(key)) {
                int type;
                if (conflicts.contains(logicalChange)) {
                    type = 1;
                } else if (incidentalChanges.contains(logicalChange)) {
                    type = 2;
                } else if (autoMergeChanges.contains(logicalChange)) {
                    type = 3;
                } else {
                    throw new IllegalStateException();
                }
                result.add(new ConflictItemNode(parent, itemConflictReport, type, logicalChange));
            }
        }
        return result;
    }

    public static void update(Collection oldConflicts, Collection newConflicts) {
        ComponentConflictUtil.update(oldConflicts, newConflicts, new UpdateItem(){

            public boolean sameItem(Object object, Object other) {
                ConflictItemNode c1 = (ConflictItemNode)object;
                ConflictItemNode c2 = (ConflictItemNode)other;
                return ConflictItemNode.sameItem(c1, c2);
            }

            public void updateSameItem(Object object, Object other) {
                ((ConflictItemNode)object).update((ConflictItemNode)other);
            }
        });
    }

    public static void updateSorted(List oldElements, List newElements, UpdateItem updateItem) {
        for (Object oldElement : oldElements) {
            boolean found = false;
            int index = 0;
            for (Object newElement : newElements) {
                if (updateItem.sameItem(oldElement, newElement)) {
                    found = true;
                    updateItem.updateSameItem(oldElement, newElement);
                    break;
                }
                ++index;
            }
            if (!found) continue;
            newElements.set(index, oldElement);
        }
    }

    public static void update(Collection oldElements, Collection newElements, UpdateItem updateItem) {
        ArrayList removed = new ArrayList();
        ArrayList newElementsList = new ArrayList(newElements);
        for (Object oldElement : oldElements) {
            boolean found = false;
            Iterator iNewElements = newElementsList.iterator();
            while (iNewElements.hasNext()) {
                Object newElement = iNewElements.next();
                if (!updateItem.sameItem(oldElement, newElement)) continue;
                found = true;
                iNewElements.remove();
                updateItem.updateSameItem(oldElement, newElement);
                break;
            }
            if (found) continue;
            removed.add(oldElement);
        }
        oldElements.removeAll(removed);
        oldElements.addAll(newElementsList);
        updateItem.additions = newElementsList;
        updateItem.removals = removed;
    }

    public static List getPending(IComponentSyncContext context) {
        ArrayList result = new ArrayList();
        if (!context.getLocalChangeSource().isAutoCheckinArmed()) {
            result.addAll(context.getLocalChangeSource().getFolders());
        }
        result.addAll(context.getOutgoingActivitySource().getConflictItems());
        return result;
    }

    public static boolean hasConflictItems(IComponentSyncContext context) {
        return !context.getOutgoingActivitySource().getConflictItems().isEmpty();
    }

    public static Collection<IConflictItem> getModModConflictItems(IComponentSyncContext context) {
        Collection conflictItems = context.getOutgoingActivitySource().getConflictItems();
        ArrayList<IConflictItem> modModItems = new ArrayList<IConflictItem>();
        for (IConflictItem conflict : conflictItems) {
            boolean modMod = false;
            if (conflict.getType() == 1) {
                ILogicalChange change = conflict.getLogicalChange();
                boolean bl = modMod = !ComponentConflictUtil.isStructuralChange(change);
            }
            if (!modMod) continue;
            modModItems.add(conflict);
        }
        return modModItems;
    }

    public static List filter(List items, Collection itemsToIgnore) {
        if (itemsToIgnore.isEmpty()) {
            return items;
        }
        ArrayList<IItemHandle> result = new ArrayList<IItemHandle>();
        for (IItemHandle item : items) {
            boolean ignore = false;
            for (IItemHandle toIgnore : itemsToIgnore) {
                if (!item.sameItemId(toIgnore)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            result.add(item);
        }
        return result;
    }

    public static Collection<ILogicalChange> getChanges(ILogicalConflictReport conflictReport, Collection<IConflictItem> conflictItems) {
        ArrayList<ILogicalChange> changes = new ArrayList<ILogicalChange>();
        for (IConflictItem conflictItem : conflictItems) {
            ILogicalChange change = conflictItem.getLogicalChange();
            changes.add(change);
        }
        return changes;
    }

    private static void addStructuralChanges(Collection changesForComponent, Collection<ILogicalChange> changes) {
        for (ILogicalChange change : changesForComponent) {
            if (!ComponentConflictUtil.isStructuralChange(change)) continue;
            changes.add(change);
        }
    }

    public static boolean isStructuralChange(ILogicalChange change) {
        ILogicalConflict lc;
        return change.kind() != 1 || (lc = (ILogicalConflict)change).conflictType() != 9;
    }

    public static abstract class UpdateItem {
        private List additions;
        private List removals;

        public abstract boolean sameItem(Object var1, Object var2);

        public abstract void updateSameItem(Object var1, Object var2);

        public final Collection getAdditions() {
            return this.additions;
        }

        public final Collection getRemovals() {
            return this.removals;
        }
    }
}

