/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncInfo;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentSyncManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.WorkspaceSyncContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentCollaborationUtil {
    public static void setCollaboration(Collection<? extends IComponentSyncContext> contexts, IConnection remote, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<ComponentSyncInfo, ComponentSyncInfo> oldInfo2NewInfo = new HashMap<ComponentSyncInfo, ComponentSyncInfo>();
        for (ComponentSyncContext componentSyncContext : contexts) {
            ComponentSyncInfo oldInfo = componentSyncContext.getComponentSyncInfo();
            if (!componentSyncContext.setCollaboration(remote)) continue;
            oldInfo2NewInfo.put(oldInfo, componentSyncContext.getComponentSyncInfo());
        }
        ComponentSyncManager componentSyncManager = (ComponentSyncManager)FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncManager();
        componentSyncManager.replace(oldInfo2NewInfo);
        progress.setWorkRemaining(contexts.size());
        for (ComponentSyncContext componentSyncContext : contexts) {
            componentSyncContext.refreshCompare((IProgressMonitor)progress.newChild(1));
        }
    }

    public static void setCollaboration(IWorkspaceSyncContext workspaceContext, IConnection remote, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor = ModelUtil.monitorFor(monitor);
        try {
            monitor.beginTask("", 100);
            ((WorkspaceSyncContext)workspaceContext).setRemote(remote);
            IComponentSyncContext[] contexts = workspaceContext.getComponentSyncContexts();
            ArrayList<IComponentSyncContext> recycled = new ArrayList<IComponentSyncContext>();
            int i = 0;
            while (i < contexts.length) {
                IComponentSyncContext context = contexts[i];
                if (context != null && context.isLocal()) {
                    int j = i + 1;
                    while (j < contexts.length) {
                        IComponentSyncContext other = contexts[j];
                        if (other != null && other.getComponent().sameItemId((IItemHandle)context.getComponent())) {
                            contexts[j] = null;
                            if (other.getIncomingConnection() == remote) {
                                context = other;
                                contexts[j] = null;
                            }
                        }
                        ++j;
                    }
                    recycled.add(context);
                }
                ++i;
            }
            ComponentCollaborationUtil.setCollaboration(recycled, remote, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
        }
        finally {
            monitor.done();
        }
    }

    public static void updateCollaborations(IComponentSyncModel model, IActiveWorkspaceManager manager, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        IWorkspaceSyncContext[] workspaceContexts = model.getWorkspaceSyncContexts();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * (workspaceContexts.length + 1)));
        if (manager != null) {
            IWorkspaceSyncContext[] iWorkspaceSyncContextArray = workspaceContexts;
            int n = workspaceContexts.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkspaceSyncContext w = iWorkspaceSyncContextArray[n2];
                try {
                    IConnection remote = ComponentCollaborationUtil.getWorkspaceCollaborationConnection(w.getLocal(), (IProgressMonitor)progress.newChild(10));
                    if (remote == null) {
                        remote = w.getLocal();
                    }
                    if (w.getRemote() != remote) {
                        ComponentCollaborationUtil.setCollaboration(w, remote, (IProgressMonitor)progress.newChild(90));
                    } else {
                        ArrayList<IComponentSyncContext> recycled = new ArrayList<IComponentSyncContext>();
                        IComponentSyncContext[] contexts = w.getComponentSyncContexts();
                        int i = 0;
                        while (i < contexts.length) {
                            IComponentSyncContext context = contexts[i];
                            if (context != null && context.isLocal()) {
                                int j = i + 1;
                                while (j < contexts.length) {
                                    IComponentSyncContext other = contexts[j];
                                    if (other != null && other.getComponent().sameItemId((IItemHandle)context.getComponent())) {
                                        contexts[j] = null;
                                        if (other.getIncomingConnection() == remote) {
                                            context = other;
                                        }
                                    }
                                    ++j;
                                }
                                recycled.add(context);
                            }
                            ++i;
                        }
                        for (IComponentSyncContext context : recycled) {
                            IConnection componentRemote = ComponentCollaborationUtil.getComponentCollaborationConnection(w.getLocal(), (IComponentHandle)context.getComponent(), remote, (IProgressMonitor)progress.newChild(10));
                            ComponentCollaborationUtil.setCollaboration(Collections.singletonList(context), componentRemote, (IProgressMonitor)progress.newChild(70));
                        }
                    }
                }
                catch (ItemNotFoundException itemNotFoundException) {}
                ++n2;
            }
        }
        model.getComponentSyncManager().update((IProgressMonitor)progress.newChild(100));
    }

    public static IConnection[] getAllWorkspaceCollaborationConnections(IWorkspaceConnection connection, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IWorkspaceHandle[] collaborationHandles = ComponentFlowUtil.getAllCollaborations(connection);
        ArrayList<Object> result = new ArrayList<Object>();
        IWorkspaceHandle[] iWorkspaceHandleArray = collaborationHandles;
        int n = collaborationHandles.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceHandle collaborationHandle = iWorkspaceHandleArray[n2];
            try {
                IConnection collaboration = ActiveWorkspaceManager.getConnection((IContextHandle)collaborationHandle, (IProgressMonitor)progress.newChild(1));
                result.add(collaboration);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
            ++n2;
        }
        if (result.isEmpty()) {
            result.add(connection);
        }
        return result.toArray(new IConnection[result.size()]);
    }

    public static IConnection getWorkspaceCollaborationConnection(IWorkspaceConnection connection, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IWorkspaceConnection collaboration = connection;
        IContextHandle collaborationHandle = FileSystemResourcesPlugin.getActiveWorkspaceManager().getWorkspaceCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), (IProgressMonitor)progress.newChild(1));
        if (collaborationHandle != null) {
            try {
                collaboration = ActiveWorkspaceManager.getConnection(collaborationHandle, (IProgressMonitor)progress.newChild(1));
            }
            catch (ItemNotFoundException itemNotFoundException) {
                FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), (IWorkspaceHandle)connection.getResolvedWorkspace(), true, (IProgressMonitor)progress.newChild(1));
            }
        }
        return collaboration;
    }

    public static IConnection getComponentCollaborationConnection(IWorkspaceConnection connection, IComponentHandle component, IConnection fallback, IProgressMonitor monitor) throws TeamRepositoryException {
        IConnection collaboration;
        block4: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            IContextHandle connectionHandle = FileSystemResourcesPlugin.getActiveWorkspaceManager().getComponentCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), component, (IProgressMonitor)progress.newChild(1));
            collaboration = fallback;
            if (connectionHandle != null) {
                try {
                    collaboration = ActiveWorkspaceManager.getConnection(connectionHandle, (IProgressMonitor)progress.newChild(1));
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    if (fallback instanceof IWorkspaceConnection) {
                        IWorkspaceConnection c = (IWorkspaceConnection)fallback;
                        FileSystemResourcesPlugin.getActiveWorkspaceManager().setComponentCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), Collections.singletonList(component), (IWorkspaceHandle)c.getResolvedWorkspace(), true, (IProgressMonitor)progress.newChild(1));
                    }
                    if (!(fallback instanceof IBaselineConnection)) break block4;
                    IBaselineConnection c = (IBaselineConnection)fallback;
                    FileSystemResourcesPlugin.getActiveWorkspaceManager().setComponentCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), Collections.singletonList(component), c.getBaseline(), true, (IProgressMonitor)progress.newChild(1));
                }
            }
        }
        return collaboration;
    }
}

