/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.model;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityIterator {
    IComponentSyncModel model;
    IComponentSyncContext context;
    IActivitySource source;
    Flow flow;

    public ActivityIterator() {
    }

    public ActivityIterator(IComponentSyncModel model, Flow flow) {
        this.model = model;
        this.flow = flow;
    }

    public ActivityIterator(IComponentSyncModel model) {
        this(model, null);
    }

    public ActivityIterator(IComponentSyncContext context) {
        this.context = context;
    }

    public ActivityIterator(IActivitySource source) {
        this.source = source;
    }

    public abstract void visit(IRemoteActivity var1);

    public void iterate() {
        if (this.source != null) {
            this.iterate(this.source);
        }
        if (this.context != null) {
            this.iterate(this.context);
        }
        if (this.model != null) {
            this.iterate(this.model);
        }
    }

    private void iterate(IComponentSyncModel model) {
        IComponentSyncContext[] iComponentSyncContextArray = model.getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            this.iterate(context);
            ++n2;
        }
    }

    private void iterate(IComponentSyncContext context) {
        if (this.flow == Flow.INCOMING) {
            this.iterate(context.getIncomingActivitySource());
        } else if (this.flow == Flow.OUTGOING || this.flow == Flow.OUTGOING_ACTIVE) {
            this.iterate(context.getOutgoingActivitySource());
        } else if (this.flow == Flow.SUSPENDED) {
            this.iterate(context.getSuspendedActivitySource());
        } else {
            for (IActivitySource source : context.getActivitySources()) {
                this.iterate(source);
            }
        }
    }

    private void iterate(IActivitySource source) {
        for (IRemoteActivity activity : source.getActivities()) {
            if (this.flow == Flow.OUTGOING_ACTIVE && !source.getModel().isActive(activity)) continue;
            this.visit(activity);
        }
        if (this.flow == Flow.OUTGOING_ACTIVE) {
            return;
        }
        for (IBaselineGroup baseline : source.getBaselines()) {
            for (IRemoteActivity activity : baseline.getActivities()) {
                this.visit(activity);
            }
        }
    }

    public void iterate(List<IComponentSyncContext> contexts, Flow flow) {
        this.flow = flow;
        for (IComponentSyncContext context : contexts) {
            this.iterate(context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flow {
        INCOMING,
        OUTGOING,
        OUTGOING_ACTIVE,
        SUSPENDED;

    }
}

