/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.locks;

import com.ibm.team.filesystem.rcp.core.internal.changes.locks.CurrentFlowsManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockDelegate;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import java.util.Collection;
import java.util.List;

public class UserLockCacheManager
implements IListener {
    static UserLockCacheManager INSTANCE;
    CurrentFlowsManager cfm;
    Collection<IWorkspaceConnection> currentFlows;
    UserLockDelegate delegate;
    IComponentSyncModel model;

    public static synchronized void init(IComponentSyncModel model) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new UserLockCacheManager();
        UserLockCacheManager.INSTANCE.model = model;
        UserLockCacheManager.INSTANCE.cfm = new CurrentFlowsManager(model);
        UserLockCacheManager.INSTANCE.currentFlows = UserLockCacheManager.INSTANCE.cfm.getCurrentFlows();
        UserLockCacheManager.INSTANCE.cfm.addGenericListener("current_flows_components", INSTANCE);
        model.addGenericListener("shareablesChangedRefreshed", INSTANCE);
        model.addGenericListener("refreshedRemoteCompleted", INSTANCE);
        UserLockCacheManager.INSTANCE.delegate = new UserLockDelegate(INSTANCE);
    }

    public static synchronized void clear() {
        if (INSTANCE == null) {
            return;
        }
        UserLockCacheManager.INSTANCE.cfm.dispose();
        UserLockCacheManager.INSTANCE.cfm.removeGenericListener("current_flows_components", INSTANCE);
        UserLockCacheManager.INSTANCE.model.removeGenericListener("shareablesChangedRefreshed", INSTANCE);
        UserLockCacheManager.INSTANCE.model.removeGenericListener("refreshedRemoteCompleted", INSTANCE);
        UserLockCacheManager.INSTANCE.delegate.dispose();
        UserLockCache.clear();
        INSTANCE = null;
    }

    public void handleEvents(List events) {
        for (IEvent event : events) {
            String type = event.getEventType();
            if (type.equals("current_flows_components")) {
                this.updateCurrentFlows();
                this.updateShareables();
            }
            if (type.equals("refreshedRemoteCompleted") || type.equals("shareablesChangedRefreshed")) {
                this.updateShareables();
            }
            if (!(event instanceof IPropertyChangeEvent)) continue;
            IPropertyChangeEvent pce = (IPropertyChangeEvent)event;
            if (event.getEventSource() instanceof IWorkspaceConnection && pce.getCategories().contains("stream locks")) {
                IWorkspaceConnection stream = (IWorkspaceConnection)event.getEventSource();
                UserLockCache.get().update(stream);
            }
            if (!(event.getEventSource() instanceof IWorkspaceManager) || !pce.getCategories().contains("user_locks")) continue;
            IWorkspaceManager cfr_ignored_0 = (IWorkspaceManager)event.getEventSource();
            UserLockCache.get().updateUserLocks(pce);
        }
    }

    private void updateCurrentFlows() {
        Collection<IWorkspaceConnection> currentFlows = this.cfm.getCurrentFlows();
        for (IWorkspaceConnection stream : this.currentFlows) {
            if (currentFlows.contains(stream)) continue;
            stream.removeGenericListener((Object)"stream locks", (IListener)this);
            UserLockCache.get().remove(stream);
        }
        for (IWorkspaceConnection stream : currentFlows) {
            if (this.currentFlows.contains(stream)) continue;
            stream.addGenericListener((Object)"stream locks", (IListener)this);
            UserLockCache.get().update(stream);
        }
        this.currentFlows = currentFlows;
    }

    private void updateShareables() {
        UserLockCache.get().updateLockedShareables();
        UserLockCache.get().updateUserLockedShareables();
    }
}

