/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.locks;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.CurrentFlowsManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.LockCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.ShareableCache;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserLockCache
extends LockCache {
    static UserLockCache INSTANCE;
    Job updateUserJob = new Job(Messages.UserLockCache_0){

        protected IStatus run(IProgressMonitor monitor) {
            return UserLockCache.this.internalUserCacheUpdate(monitor);
        }
    };
    volatile HashMap<UUID, IStreamLockReport> userCache = new HashMap();
    volatile ShareableCache shareableUserCache = new ShareableCache();
    List<IStreamLockReport> queue = new ArrayList<IStreamLockReport>();

    public static synchronized UserLockCache get() {
        if (INSTANCE == null) {
            INSTANCE = new UserLockCache();
        }
        return INSTANCE;
    }

    public static synchronized void clear() {
        INSTANCE = null;
    }

    public Collection<IStreamLockReport> getStreamLockReportsUserCache() {
        return this.userCache.values();
    }

    public HashMap<IShareable, ShareableCache.ShareableInfo> getShareableUserCache() {
        return this.shareableUserCache.cache;
    }

    @Override
    public IContributor getLock(IVersionableHandle versionable, IWorkspaceConnection stream, IComponentHandle component) {
        IVersionableLock vl;
        IComponentLockReport clr;
        HashMap<UUID, IStreamLockReport> userCache = this.userCache;
        IStreamLockReport slr = userCache.get(stream.getResolvedWorkspace().getItemId());
        IContributor contributor = null;
        if (slr != null && (clr = slr.getComponentLockReport(component)) != null && (vl = clr.getLockReport(versionable)) != null) {
            contributor = stream.teamRepository().loggedInContributor();
        }
        return contributor != null ? contributor : super.getLock(versionable, stream, component);
    }

    public LockInfo getLock(IShareable shareable) throws FileSystemClientException {
        IContributor contributor;
        LockInfo result = null;
        ShareableCache.ShareableInfo info = this.shareableUserCache.getShareableInfo(shareable);
        if (info == null) {
            info = this.shareableCache.getShareableInfo(shareable);
        }
        if (info != null && (contributor = this.getLock(info.versionable, info.stream, info.component)) != null) {
            result = new LockInfo();
            result.owner = contributor;
            result.stream = info.stream;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserLocks(IPropertyChangeEvent userLocksEvent) {
        UserLockCache userLockCache = this;
        synchronized (userLockCache) {
            if (userLocksEvent != null) {
                this.queue.addAll((List)userLocksEvent.getOldValue());
                this.queue.addAll((List)userLocksEvent.getNewValue());
            }
            this.updateUserJob.schedule(1000L);
        }
    }

    public void updateUserLockedShareables() {
        this.updateUserLocks(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus internalUserCacheUpdate(IProgressMonitor monitor) {
        ITeamRepository[] repos;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LockCache_1, (int)100);
        Collection<IWorkspaceConnection> toRefresh = null;
        UserLockCache userLockCache = this;
        synchronized (userLockCache) {
            toRefresh = this.getConnections(this.queue);
            this.queue.clear();
        }
        progress.setWorkRemaining(toRefresh.size() * 2);
        for (IWorkspaceConnection stream : toRefresh) {
            try {
                stream.refresh((IProgressMonitor)progress.newChild(1));
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException e) {
                return FileSystemStatus.getStatusFor((Throwable)e);
            }
        }
        HashMap<UUID, IStreamLockReport> userCache = new HashMap<UUID, IStreamLockReport>();
        ITeamRepository[] iTeamRepositoryArray = repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            try {
                Collection locks = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getLocks();
                for (IStreamLockReport streamReport : locks) {
                    userCache.put(streamReport.getStream().getItemId(), streamReport);
                }
            }
            catch (NotLoggedInException notLoggedInException) {
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)((Object)this), (Throwable)e);
            }
            ++n2;
        }
        boolean changed = this.shareableUserCache.update(userCache.values(), FileSystemResourcesPlugin.getComponentSyncModel(), (IProgressMonitor)progress.newChild(toRefresh.size()));
        if (!changed) {
            changed = this.hasUserCacheChanged(this.userCache, userCache);
        }
        this.userCache = userCache;
        if (changed) {
            this.queueEvent(new Event((IEventSource)this, "lock"));
        }
        return Status.OK_STATUS;
    }

    private Collection<IWorkspaceConnection> getConnections(List<IStreamLockReport> reports) {
        HashSet<IWorkspaceConnection> currentFlows = CurrentFlowsManager.getCurrentFlows(FileSystemResourcesPlugin.getComponentSyncModel());
        HashMap<UUID, IWorkspaceConnection> streams = new HashMap<UUID, IWorkspaceConnection>();
        for (IWorkspaceConnection stream : currentFlows) {
            streams.put(stream.getResolvedWorkspace().getItemId(), stream);
        }
        HashSet<IWorkspaceConnection> result = new HashSet<IWorkspaceConnection>();
        for (IStreamLockReport slr : reports) {
            IWorkspaceConnection stream = (IWorkspaceConnection)streams.get(slr.getStream().getItemId());
            if (stream == null) continue;
            result.add(stream);
        }
        return result;
    }

    private boolean hasUserCacheChanged(HashMap<UUID, IStreamLockReport> userCache, HashMap<UUID, IStreamLockReport> newUserCache) {
        if (userCache.size() != newUserCache.size()) {
            return true;
        }
        for (Map.Entry<UUID, IStreamLockReport> newValue : newUserCache.entrySet()) {
            IStreamLockReport streamLockReport = userCache.get(newValue.getKey());
            if (streamLockReport == null) {
                return true;
            }
            if (!this.hasCacheChanged(newValue.getKey(), streamLockReport, newValue.getValue())) continue;
            return true;
        }
        return false;
    }

    public class LockInfo {
        public IWorkspaceConnection stream;
        public IContributor owner;
    }
}

