/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.locks;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareableCache {
    volatile HashMap<IShareable, ShareableInfo> cache = new HashMap();

    public ShareableInfo getShareableInfo(IShareable shareable) {
        return this.cache.get(shareable);
    }

    public boolean update(Collection<IStreamLockReport> reports, IComponentSyncModel model, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LockCache_1, (int)reports.size());
        HashMap<IShareable, ShareableInfo> cache = new HashMap<IShareable, ShareableInfo>();
        IComponentSyncContext[] contexts = model.getComponentSyncContexts();
        for (IStreamLockReport slr : reports) {
            Collection clrs = slr.getComponentLocks();
            SubMonitor componentProgress = progress.newChild(1);
            componentProgress.setWorkRemaining(clrs.size());
            for (IComponentLockReport clr : clrs) {
                Collection locks = clr.getLocks();
                SubMonitor versionableProgress = componentProgress.newChild(1);
                versionableProgress.setWorkRemaining(locks.size());
                IComponentHandle component = clr.getComponent();
                IWorkspaceConnection[] streamConnection = new IWorkspaceConnection[1];
                List<IWorkspaceHandle> workspaces = this.findWorkspaces(slr.getStream(), component, contexts, streamConnection);
                for (IVersionableLock vl : locks) {
                    SubMonitor workspaceProgress = componentProgress.newChild(1);
                    workspaceProgress.setWorkRemaining(workspaces.size());
                    IVersionableHandle versionable = vl.getVersionable();
                    for (IWorkspaceHandle workspace : workspaces) {
                        IShareable shareable = null;
                        try {
                            shareable = ComponentSyncUtil.findShareable((IContextHandle)workspace, component, versionable, (IProgressMonitor)workspaceProgress.newChild(1));
                        }
                        catch (FileSystemClientException e) {
                            StatusUtil.log((Object)this, (Throwable)e);
                        }
                        if (shareable == null) continue;
                        cache.put(shareable, new ShareableInfo(versionable, streamConnection[0], component));
                        break;
                    }
                    workspaceProgress.done();
                }
                versionableProgress.done();
            }
            componentProgress.done();
        }
        boolean result = this.hasChanged(this.cache, cache);
        this.cache = cache;
        progress.done();
        return result;
    }

    private List<IWorkspaceHandle> findWorkspaces(IWorkspaceHandle stream, IComponentHandle component, IComponentSyncContext[] contexts, IWorkspaceConnection[] streamConnection) {
        ArrayList<IWorkspaceHandle> workspaces = new ArrayList<IWorkspaceHandle>();
        IComponentSyncContext[] iComponentSyncContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            if (context.isLocal() && context.getComponent().sameItemId((IItemHandle)component) && stream.sameItemId((IItemHandle)context.getIncomingTeamPlace().getResolvedWorkspace())) {
                workspaces.add((IWorkspaceHandle)context.getOutgoingTeamPlace().getResolvedWorkspace());
                streamConnection[0] = context.getIncomingTeamPlace();
            }
            ++n2;
        }
        return workspaces;
    }

    private boolean hasChanged(HashMap<IShareable, ShareableInfo> cache, HashMap<IShareable, ShareableInfo> newCache) {
        if (cache.size() != newCache.size()) {
            return true;
        }
        for (Map.Entry<IShareable, ShareableInfo> newEntry : newCache.entrySet()) {
            ShareableInfo info = cache.get(newEntry.getKey());
            if (info == null) {
                return true;
            }
            if (!this.hasChanged(info, newEntry.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean hasChanged(ShareableInfo info, ShareableInfo newInfo) {
        if (!info.versionable.sameItemId((IItemHandle)newInfo.versionable)) {
            return true;
        }
        if (!info.component.sameItemId((IItemHandle)newInfo.component)) {
            return true;
        }
        return info.stream != newInfo.stream;
    }

    public static class ShareableInfo {
        public IVersionableHandle versionable;
        public IWorkspaceConnection stream;
        public IComponentHandle component;

        ShareableInfo(IVersionableHandle versionable, IWorkspaceConnection stream, IComponentHandle component) {
            this.versionable = versionable;
            this.stream = stream;
            this.component = component;
        }
    }
}

