/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.locks;

import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ActivityIterator;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivitySource;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IUnresolvedSource;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockQuery {
    public static LockCount countLocks(Object element) {
        HashMap<Object, Object> result;
        Object source;
        IComponentSyncContext context = null;
        Collection<Object> versionables = null;
        if (element instanceof IActivityFolder) {
            context = ComponentSyncUtil.getContext(element);
            versionables = LockQuery.getVersionables((IActivityFolder)element);
        }
        if (element instanceof IRemoteActivity) {
            context = ComponentSyncUtil.getContext(element);
            versionables = LockQuery.getVersionables((IRemoteActivity)element);
        }
        if (element instanceof IActivitySource) {
            source = (IActivitySource)element;
            context = source.getModel();
            result = new HashMap<UUID, IVersionableHandle>();
            LockQuery.getVersionables((IActivitySource)source, result);
            versionables = result.values();
        }
        if (element instanceof IComponentSyncContext) {
            context = (IComponentSyncContext)element;
            HashMap<UUID, IVersionableHandle> result2 = new HashMap<UUID, IVersionableHandle>();
            LockQuery.getVersionables(context, result2);
            versionables = result2.values();
        }
        if (element instanceof IUnresolvedSource) {
            source = (IUnresolvedSource)element;
            context = source.getModel();
            result = new HashMap();
            LockQuery.getVersionables((IUnresolvedSource)source, result);
            versionables = result.values();
        }
        if (element instanceof IUnresolvedFolder) {
            IUnresolvedFolder folder = (IUnresolvedFolder)element;
            context = folder.getUnresolvedSource().getModel();
            result = new HashMap();
            LockQuery.getVersionables(folder, result);
            versionables = result.values();
        }
        return context != null && versionables != null ? LockQuery.countLocks(context, versionables) : null;
    }

    public static LockCount countLocks(IComponentSyncContext context, Collection<IVersionableHandle> versionables) {
        LockCount result = new LockCount();
        IWorkspaceConnection stream = context.getIncomingTeamPlace();
        IComponent component = context.getComponent();
        IContributor loggedInContributor = context.teamRepository().loggedInContributor();
        UserLockCache cache = UserLockCache.get();
        for (IVersionableHandle versionable : versionables) {
            IContributor lock = cache.getLock(versionable, stream, (IComponentHandle)component);
            if (lock == null) continue;
            if (lock.sameItemId((IItemHandle)loggedInContributor)) {
                ++result.locksOwned;
                continue;
            }
            ++result.locksBlocking;
        }
        return result;
    }

    private static Collection<IVersionableHandle> getVersionables(IActivityFolder folder) {
        ArrayList<IVersionableHandle> result = new ArrayList<IVersionableHandle>();
        for (IRemoteChangeSummary rcs : folder.getActivity().getChanges(folder)) {
            result.add(rcs.getItem());
        }
        return result;
    }

    private static Collection<IVersionableHandle> getVersionables(IRemoteActivity activity) {
        ArrayList<IVersionableHandle> result = new ArrayList<IVersionableHandle>();
        for (IRemoteChangeSummary rcs : activity.getChanges()) {
            result.add(rcs.getItem());
        }
        return result;
    }

    private static void getVersionables(IActivitySource source, final HashMap<UUID, IVersionableHandle> result) {
        new ActivityIterator(source){

            public void visit(IRemoteActivity activity) {
                for (IRemoteChangeSummary rcs : activity.getChanges()) {
                    IVersionableHandle versionable = rcs.getItem();
                    result.put(versionable.getItemId(), versionable);
                }
            }
        }.iterate();
    }

    private static void getVersionables(IComponentSyncContext context, final HashMap<UUID, IVersionableHandle> result) {
        new ActivityIterator(context){

            public void visit(IRemoteActivity activity) {
                for (IRemoteChangeSummary rcs : activity.getChanges()) {
                    IVersionableHandle versionable = rcs.getItem();
                    result.put(versionable.getItemId(), versionable);
                }
            }
        }.iterate();
        LockQuery.getVersionables(context.getUnresolvedSource(), result);
    }

    private static void getVersionables(IUnresolvedFolder folder, HashMap<UUID, IVersionableHandle> result) {
        for (IUnresolvedItem item : folder.getItems()) {
            for (IVersionableHandle versionable : item.getHandles()) {
                result.put(versionable.getItemId(), versionable);
            }
        }
    }

    private static void getVersionables(IUnresolvedSource source, HashMap<UUID, IVersionableHandle> result) {
        for (IUnresolvedFolder folder : source.getFolders()) {
            LockQuery.getVersionables(folder, result);
        }
    }

    public static class LockCount {
        public int locksOwned;
        public int locksBlocking;
    }
}

