/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.locks;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.ShareableCache;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockCache
extends EventSource {
    public static final String LOCK = "lock";
    Job updateJob = new Job(Messages.LockCache_0){

        protected IStatus run(IProgressMonitor monitor) {
            return LockCache.this.internalCacheUpdate(monitor);
        }
    };
    volatile HashMap<IWorkspaceConnection, ILockSearchResult> cache = new HashMap();
    volatile HashMap<UUID, IContributor> contributorsCache = new HashMap();
    volatile ShareableCache shareableCache = new ShareableCache();
    HashSet<IWorkspaceConnection> queue = new HashSet();

    public IContributor getLock(IVersionableHandle versionable, IWorkspaceConnection stream, IComponentHandle component) {
        HashMap<IWorkspaceConnection, ILockSearchResult> cache = this.cache;
        HashMap<UUID, IContributor> contributorsCache = this.contributorsCache;
        ILockSearchResult lsr = cache.get(stream);
        IContributorHandle contributorHandle = null;
        if (lsr != null) {
            for (IStreamLockReport slr : lsr.getReports()) {
                IVersionableLock vl;
                IComponentLockReport clr = slr.getComponentLockReport(component);
                if (clr == null || (vl = clr.getLockReport(versionable)) == null) continue;
                contributorHandle = vl.getContributor();
                break;
            }
        }
        return contributorHandle != null ? contributorsCache.get(contributorHandle.getItemId()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IWorkspaceConnection stream) {
        LockCache lockCache = this;
        synchronized (lockCache) {
            this.queue.add(stream);
            this.updateJob.schedule(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IWorkspaceConnection stream) {
        LockCache lockCache = this;
        synchronized (lockCache) {
            this.queue.add(stream);
            this.updateJob.schedule(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLockedShareables() {
        LockCache lockCache = this;
        synchronized (lockCache) {
            this.updateJob.schedule(1000L);
        }
    }

    public HashMap<IWorkspaceConnection, ILockSearchResult> getStreamLockReportsCache() {
        return this.cache;
    }

    public HashMap<IShareable, ShareableCache.ShareableInfo> getShareableCache() {
        return this.shareableCache.cache;
    }

    public Collection<IContributor> getOwnersCache() {
        return this.contributorsCache.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus internalCacheUpdate(IProgressMonitor monitor) {
        HashSet<IWorkspaceConnection> queue;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LockCache_1, (int)100);
        HashMap<IWorkspaceConnection, ILockSearchResult> cache = new HashMap<IWorkspaceConnection, ILockSearchResult>(this.cache);
        HashMap<UUID, IContributor> contributorsCache = new HashMap<UUID, IContributor>(this.contributorsCache);
        LockCache lockCache = this;
        synchronized (lockCache) {
            queue = new HashSet<IWorkspaceConnection>(this.queue);
            this.queue.clear();
        }
        boolean changed = false;
        try {
            progress.setWorkRemaining(queue.size() * 3);
            for (IWorkspaceConnection stream : queue) {
                ILockSearchResult result;
                try {
                    result = stream.getLocks((IProgressMonitor)progress.newChild(1));
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    continue;
                }
                cache.put(stream, result);
                HashMap<UUID, IContributorHandle> contributorHandles = new HashMap<UUID, IContributorHandle>();
                for (IStreamLockReport streamReport : result.getReports()) {
                    for (IComponentLockReport componentReport : streamReport.getComponentLocks()) {
                        for (IVersionableLock versionableLock : componentReport.getLocks()) {
                            IContributorHandle contributor = versionableLock.getContributor();
                            contributorHandles.put(contributor.getItemId(), contributor);
                        }
                    }
                }
                List contributors = stream.teamRepository().itemManager().fetchCompleteItems(new ArrayList(contributorHandles.values()), 0, (IProgressMonitor)progress.newChild(1));
                contributorHandles = null;
                for (IContributor contributor : contributors) {
                    contributorsCache.put(contributor.getItemId(), contributor);
                }
                contributors = null;
            }
            ArrayList<IStreamLockReport> reports = new ArrayList<IStreamLockReport>();
            for (ILockSearchResult lsr : cache.values()) {
                reports.addAll(lsr.getReports());
            }
            changed = this.shareableCache.update(reports, FileSystemResourcesPlugin.getComponentSyncModel(), (IProgressMonitor)progress.newChild(queue.size()));
        }
        catch (TeamRepositoryException e) {
            return FileSystemStatus.getStatusFor((Throwable)e);
        }
        LockCache lockCache2 = this;
        synchronized (lockCache2) {
            if (!changed && !(changed = this.hasContributorsCacheChanged(this.contributorsCache, contributorsCache))) {
                changed = this.hasCacheChanged(this.cache, cache);
            }
            this.contributorsCache = contributorsCache;
            this.cache = cache;
        }
        if (changed) {
            this.queueEvent(new Event((IEventSource)this, LOCK));
        }
        return Status.OK_STATUS;
    }

    private boolean hasCacheChanged(HashMap<IWorkspaceConnection, ILockSearchResult> cache, HashMap<IWorkspaceConnection, ILockSearchResult> newCache) {
        if (cache.size() != newCache.size()) {
            return true;
        }
        for (Map.Entry<IWorkspaceConnection, ILockSearchResult> newEntry : newCache.entrySet()) {
            ILockSearchResult newLockSearchResult = newEntry.getValue();
            ILockSearchResult lockSearchResult = cache.get(newEntry.getKey());
            if (lockSearchResult == null) {
                return true;
            }
            Collection streamLockReports = lockSearchResult.getReports();
            Collection newStreamLockReports = newLockSearchResult.getReports();
            if (streamLockReports.size() != newStreamLockReports.size()) {
                return true;
            }
            if (streamLockReports.size() == 0) {
                return false;
            }
            if (streamLockReports.size() != 1) {
                return true;
            }
            IStreamLockReport streamLockReport = (IStreamLockReport)streamLockReports.toArray()[0];
            IStreamLockReport newStreamLockReport = (IStreamLockReport)newStreamLockReports.toArray()[0];
            if (!this.hasCacheChanged(newEntry.getKey().getResolvedWorkspace().getItemId(), streamLockReport, newStreamLockReport)) continue;
            return true;
        }
        return false;
    }

    boolean hasCacheChanged(UUID workspaceItemId, IStreamLockReport streamLockReport, IStreamLockReport newStreamLockReport) {
        if (!streamLockReport.getStream().getItemId().equals((Object)workspaceItemId)) {
            throw new IllegalArgumentException();
        }
        if (!newStreamLockReport.getStream().getItemId().equals((Object)workspaceItemId)) {
            throw new IllegalArgumentException();
        }
        if (streamLockReport.getComponentLocks().size() != newStreamLockReport.getComponentLocks().size()) {
            return true;
        }
        for (IComponentLockReport newComponentLockReport : newStreamLockReport.getComponentLocks()) {
            IComponentLockReport componentLockReport = streamLockReport.getComponentLockReport(newComponentLockReport.getComponent());
            if (componentLockReport == null) {
                return true;
            }
            if (newComponentLockReport.getLocks().size() != componentLockReport.getLocks().size()) {
                return true;
            }
            for (IVersionableLock newVersionableLock : newComponentLockReport.getLocks()) {
                IVersionableLock versionableLock = componentLockReport.getLockReport(newVersionableLock.getVersionable());
                if (versionableLock == null) {
                    return true;
                }
                if (newVersionableLock.getContributor().sameItemId((IItemHandle)versionableLock.getContributor())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasContributorsCacheChanged(HashMap<UUID, IContributor> contributorsCache, HashMap<UUID, IContributor> newContributorsCache) {
        if (contributorsCache.size() != newContributorsCache.size()) {
            return true;
        }
        for (Map.Entry<UUID, IContributor> newEntry : newContributorsCache.entrySet()) {
            IContributor contributor = contributorsCache.get(newEntry.getKey());
            if (contributor == null) {
                return true;
            }
            if (contributor.sameStateId((IItemHandle)newEntry.getValue())) continue;
            return true;
        }
        return false;
    }
}

