/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes.locks;

import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentFlowsManager
extends EventSource
implements IListener {
    volatile HashMap<IWorkspaceConnection, HashSet<UUID>> stream2ComponentItemIds;
    IComponentSyncModel model;
    public static final String CURRENT_FLOWS = "current_flows";
    public static final String CURRENT_FLOWS_AND_COMPONENTS = "current_flows_components";
    Job updateJob = new Job(Messages.LockCache_0){

        protected IStatus run(IProgressMonitor monitor) {
            return CurrentFlowsManager.this.update(monitor);
        }
    };

    public CurrentFlowsManager(IComponentSyncModel model) {
        this.model = model;
        this.stream2ComponentItemIds = CurrentFlowsManager.getCurrentFlowsAndComponents(model);
        model.addGenericListener("refreshedRemoteCompleted", this);
        model.addGenericListener("componentSyncContexts", this);
    }

    public Collection<IWorkspaceConnection> getCurrentFlows() {
        return this.stream2ComponentItemIds.keySet();
    }

    public HashMap<IWorkspaceConnection, HashSet<UUID>> getCurrentFlowsAndComponents() {
        return this.stream2ComponentItemIds;
    }

    public void handleEvents(List events) {
        this.updateJob.schedule(1000L);
    }

    public void dispose() {
        this.model.removeGenericListener("refreshedRemoteCompleted", this);
        this.model.removeGenericListener("componentSyncContexts", this);
    }

    public static HashMap<IWorkspaceConnection, HashSet<UUID>> getCurrentFlowsAndComponents(IComponentSyncModel model) {
        HashMap<IWorkspaceConnection, HashSet<UUID>> result = new HashMap<IWorkspaceConnection, HashSet<UUID>>();
        IComponentSyncContext[] iComponentSyncContextArray = model.getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            IWorkspaceConnection wc = context.getIncomingTeamPlace();
            if (wc != null && wc.isStream()) {
                HashSet<Object> value = result.get(wc);
                if (value == null) {
                    value = new HashSet();
                    result.put(wc, value);
                }
                value.add(context.getComponent().getItemId());
            }
            ++n2;
        }
        return result;
    }

    public static HashSet<IWorkspaceConnection> getCurrentFlows(IComponentSyncModel model) {
        HashSet<IWorkspaceConnection> streams = new HashSet<IWorkspaceConnection>();
        IComponentSyncContext[] iComponentSyncContextArray = model.getComponentSyncContexts();
        int n = iComponentSyncContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentSyncContext context = iComponentSyncContextArray[n2];
            IWorkspaceConnection wc = context.getIncomingTeamPlace();
            if (wc != null && wc.isStream()) {
                streams.add(wc);
            }
            ++n2;
        }
        return streams;
    }

    private IStatus update(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LockCache_1, (int)100);
        HashMap<IWorkspaceConnection, HashSet<UUID>> newStream2ComponentItemIds = CurrentFlowsManager.getCurrentFlowsAndComponents(this.model);
        if (!newStream2ComponentItemIds.equals(this.stream2ComponentItemIds)) {
            boolean sameStreams = this.stream2ComponentItemIds.keySet().equals(newStream2ComponentItemIds.keySet());
            this.stream2ComponentItemIds = newStream2ComponentItemIds;
            this.queueEvent(new Event((IEventSource)this, CURRENT_FLOWS_AND_COMPONENTS));
            if (!sameStreams) {
                this.queueEvent(new Event((IEventSource)this, CURRENT_FLOWS));
            }
        }
        progress.done();
        return Status.OK_STATUS;
    }
}

