/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changes;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changes.ComponentCollaborationEvent;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveWorkspaceManager
extends EventSource
implements IActiveWorkspaceManager,
ITeamRepositoryService.IRepositoryServiceListener,
ICopyFileAreaListener {
    Map<UUID, IWorkspaceHandle> activeWorkspaces = Collections.synchronizedMap(new HashMap());
    CollaborationWorkspaceManager cwm = new CollaborationWorkspaceManager();
    static final String PREF_LOADEDWORKSPACES = "loadedWorkspaces";
    static ActiveWorkspaceManager INSTANCE;
    volatile boolean disposed;
    private UpdateJob updateJob = new UpdateJob();

    public static synchronized ActiveWorkspaceManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActiveWorkspaceManager();
            TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)INSTANCE);
            FileSystemCore.getSharingManager().addListener((ICopyFileAreaListener)INSTANCE);
            INSTANCE.update();
        }
        return INSTANCE;
    }

    public static synchronized void restart() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    private void update() {
        if (this.disposed) {
            return;
        }
        try {
            this.read();
        }
        catch (TeamRepositoryException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }

    public void addedRepository(ITeamRepository repository) {
        this.update();
    }

    public void removedRepository(ITeamRepository repository) {
    }

    public void dispose() {
        if (ModelUtil.TRACE_ACTIVE_WORKSPACES) {
            ModelUtil.log("ActiveWorkspaceManager.dispose ", true);
        }
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
        FileSystemCore.getSharingManager().removeListener((ICopyFileAreaListener)this);
    }

    public void clear() {
        try {
            Preferences loadWorkspacePrefs = this.getPrefsNode();
            loadWorkspacePrefs.removeNode();
            this.activeWorkspaces.clear();
        }
        catch (BackingStoreException e) {
            StatusUtil.log((Object)this, (String)"Unable to clear loaded workspace list", (Throwable)e);
        }
    }

    void saveActiveWorkspaces() {
        Preferences loadWorkspacePrefs;
        if (ModelUtil.TRACE_ACTIVE_WORKSPACES) {
            ModelUtil.log("ActiveWorkspaceManager.save", true);
        }
        if ((loadWorkspacePrefs = this.getPrefsNode()) == null) {
            return;
        }
        try {
            loadWorkspacePrefs.removeNode();
            loadWorkspacePrefs = this.getPrefsNode();
            int i = 0;
            IWorkspaceHandle[] iWorkspaceHandleArray = this.getActiveWorkspaces();
            int n = iWorkspaceHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkspaceHandle workspace = iWorkspaceHandleArray[n2];
                Preferences prefs = loadWorkspacePrefs.node("" + i);
                prefs.put(IWorkspace.ITEM_ID_PROPERTY, workspace.getItemId().getUuidValue());
                ITeamRepository repo = (ITeamRepository)workspace.getOrigin();
                prefs.put("uri", repo.getRepositoryURI());
                if (repo.getId() != null) {
                    prefs.put("id", repo.getId().getUuidValue());
                }
                ++i;
                ++n2;
            }
            loadWorkspacePrefs.flush();
            if (ModelUtil.TRACE_ACTIVE_WORKSPACES) {
                ModelUtil.log("ActiveWorkspaceManager.save - " + i + " active workspaces saved");
            }
        }
        catch (BackingStoreException e) {
            StatusUtil.log((Object)this, (String)"Unable to save active workspaces list", (Throwable)e);
        }
    }

    private Preferences getPrefsNode() {
        Preferences loadWorkspacePrefs = new InstanceScope().getNode("com.ibm.team.filesystem.rcp.core").node(PREF_LOADEDWORKSPACES);
        return loadWorkspacePrefs;
    }

    private void read() throws TeamRepositoryException {
        Preferences serverPrefs;
        if (ModelUtil.TRACE_ACTIVE_WORKSPACES) {
            ModelUtil.log("ActiveWorkspaceManager.read ", true);
        }
        if ((serverPrefs = this.getPrefsNode()) == null) {
            return;
        }
        try {
            try {
                this.acquire();
                String[] allLoadedPrefs = serverPrefs.childrenNames();
                int i = 0;
                while (i < allLoadedPrefs.length) {
                    block14: {
                        Preferences prefs = null;
                        try {
                            prefs = serverPrefs.node(allLoadedPrefs[i]);
                        }
                        catch (IllegalStateException illegalStateException) {
                            break block14;
                        }
                        String uuidValue = prefs.get("id", "");
                        ITeamRepository repo = uuidValue.length() == 0 ? RepositoryUtils.getTeamRepository((String)prefs.get("uri", ""), (int)4) : RepositoryUtils.getTeamRepository((String)prefs.get("uri", ""), (int)4, (UUID)UUID.valueOf((String)uuidValue));
                        if (repo == null) {
                            if (ModelUtil.TRACE_ACTIVE_WORKSPACES) {
                                ModelUtil.log("ActiveWorkspaceManager.read - skipping workspace, no connection to repo: " + prefs.get("uri", ""));
                            }
                        } else {
                            String itemid = prefs.get(IWorkspace.ITEM_ID_PROPERTY, null);
                            IWorkspaceHandle workspace = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemid), null);
                            this.activeWorkspaces.put(workspace.getItemId(), workspace);
                            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyAdd", (Object)this, (Object)"activeWorkspaces", null, (Object)workspace));
                        }
                    }
                    ++i;
                }
                if (ModelUtil.TRACE_ACTIVE_WORKSPACES) {
                    ModelUtil.log("ActiveWorkspaceManager.read - " + allLoadedPrefs.length + " active workspaces read, " + this.activeWorkspaces.size() + " currently active workspaces");
                }
            }
            catch (BackingStoreException e) {
                StatusUtil.log((Object)this, (String)"Unable to read persisted active workspaces list", (Throwable)e);
                this.release();
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorkspaceHandle[] getActiveWorkspaces() {
        Map<UUID, IWorkspaceHandle> map = this.activeWorkspaces;
        synchronized (map) {
            return this.activeWorkspaces.values().toArray(new IWorkspaceHandle[this.activeWorkspaces.values().size()]);
        }
    }

    @Override
    public void activate(IWorkspaceHandle workspace) {
        if (ModelUtil.TRACE_ACTIVE_WORKSPACES) {
            ModelUtil.log("activate " + workspace, true);
        }
        if (workspace.getOrigin() == null) {
            throw new IllegalArgumentException("Origin not set");
        }
        try {
            this.acquire();
            this.activeWorkspaces.put(workspace.getItemId(), workspace);
            this.saveActiveWorkspaces();
            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyAdd", (Object)this, (Object)"activeWorkspaces", null, (Object)workspace));
        }
        finally {
            this.release();
        }
    }

    @Override
    public void deactivate(IWorkspaceHandle workspace) {
        if (ModelUtil.TRACE_ACTIVE_WORKSPACES) {
            ModelUtil.log("deactivate " + workspace, true);
        }
        try {
            this.acquire();
            this.activeWorkspaces.remove(workspace.getItemId());
            this.saveActiveWorkspaces();
            this.queueEvent(new PropertyChangeEvent((IEventSource)this, "com.ibm.team.repository.PropertyRemove", (Object)this, (Object)"activeWorkspaces", (Object)workspace, null));
        }
        finally {
            this.release();
        }
    }

    @Override
    public void validateWorkspaces(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                this.acquire();
                IWorkspaceHandle[] activeWorkspaces = this.getActiveWorkspaces();
                progress.setWorkRemaining(activeWorkspaces.length * 2);
                IWorkspaceHandle[] iWorkspaceHandleArray = activeWorkspaces;
                int n = activeWorkspaces.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkspaceHandle activeWorkspace = iWorkspaceHandleArray[n2];
                    IWorkspaceConnection wc = null;
                    List<IComponentHandle> components = null;
                    try {
                        wc = (IWorkspaceConnection)ActiveWorkspaceManager.getConnection((IContextHandle)activeWorkspace, (IProgressMonitor)progress.newChild(1));
                        components = ModelUtil.getComponents((IConnection)wc);
                    }
                    catch (ItemNotFoundException itemNotFoundException) {
                        this.deactivate(activeWorkspace);
                    }
                    catch (NotLoggedInException notLoggedInException) {
                    }
                    catch (ConnectionException connectionException) {}
                    if (wc == null || components == null) {
                        progress.worked(1);
                    } else {
                        SubMonitor componentProgress = progress.newChild(1);
                        componentProgress.setWorkRemaining(components.size() * 3);
                        for (IComponentHandle component : components) {
                            IContextHandle context = this.getComponentCollaboration(activeWorkspace, component, (IProgressMonitor)componentProgress.newChild(1));
                            if (!(context instanceof IWorkspaceHandle)) continue;
                            try {
                                ActiveWorkspaceManager.getConnection((IContextHandle)((IWorkspaceHandle)context), (IProgressMonitor)progress.newChild(1));
                                progress.worked(1);
                            }
                            catch (ItemNotFoundException itemNotFoundException) {
                                this.setComponentCollaboration(activeWorkspace, Collections.singletonList(component), activeWorkspace, true, (IProgressMonitor)progress.newChild(1));
                            }
                            catch (NotLoggedInException notLoggedInException) {
                            }
                            catch (ConnectionException connectionException) {}
                        }
                    }
                    ++n2;
                }
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log((Object)this, (Throwable)e);
                this.release();
                progress.done();
            }
        }
        finally {
            this.release();
            progress.done();
        }
    }

    @Override
    public boolean isActive(IWorkspaceHandle workspace) {
        return this.activeWorkspaces.get(workspace.getItemId()) != null;
    }

    @Override
    public IContextHandle getWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.cwm.getWorkspaceCollaboration(activeWorkspace, monitor);
    }

    @Override
    public IContextHandle getComponentCollaboration(IWorkspaceHandle activeWorkspace, IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.cwm.getComponentCollaboration(activeWorkspace, component, monitor);
    }

    @Override
    public void setWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IWorkspaceHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
        this.cwm.setWorkspaceCollaboration(activeWorkspace, collaboration, persist, monitor);
    }

    @Override
    public void setWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IBaselineHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
        this.cwm.setWorkspaceCollaboration(activeWorkspace, collaboration, persist, monitor);
    }

    @Override
    public void setComponentCollaboration(IWorkspaceHandle activeWorkspace, Collection<? extends IComponentHandle> components, IWorkspaceHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
        this.cwm.setComponentCollaboration(activeWorkspace, components, collaboration, persist, monitor);
    }

    @Override
    public void setComponentCollaboration(IWorkspaceHandle activeWorkspace, Collection<? extends IComponentHandle> components, IBaselineHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
        this.cwm.setComponentCollaboration(activeWorkspace, components, collaboration, persist, monitor);
    }

    public static IConnection getConnection(IContextHandle connectionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (connectionHandle instanceof IWorkspaceHandle) {
            return SCMPlatform.getWorkspaceManager((ITeamRepository)((ITeamRepository)connectionHandle.getOrigin())).getWorkspaceConnection((IWorkspaceHandle)connectionHandle, monitor);
        }
        if (connectionHandle instanceof IBaselineHandle) {
            return SCMPlatform.getWorkspaceManager((ITeamRepository)((ITeamRepository)connectionHandle.getOrigin())).getBaselineConnection((IBaselineHandle)connectionHandle, monitor);
        }
        return null;
    }

    public void change(ICopyFileAreaEvent[] events) {
        ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
            if (event.getReason() == 9) {
                IPath copyFileAreaRoot = event.getCopyFileAreaRoot();
                ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox(copyFileAreaRoot, true);
                if (sandbox != null) {
                    this.updateJob.queueUpdate(sandbox);
                }
            }
            ++n2;
        }
        FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager().update();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CollaborationWorkspaceManager {
        Hashtable<UUID, WorkspaceCollaboration> workspaceCollaborations = new Hashtable();

        CollaborationWorkspaceManager() {
        }

        public IContextHandle getWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress);
            return c.collaboration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WorkspaceCollaboration internalGetCollaboration(IWorkspaceHandle activeWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
            Hashtable<UUID, WorkspaceCollaboration> hashtable = this.workspaceCollaborations;
            synchronized (hashtable) {
                WorkspaceCollaboration c = this.workspaceCollaborations.get(activeWorkspace.getItemId());
                if (c == null) {
                    c = this.load(activeWorkspace, monitor);
                    this.workspaceCollaborations.put(activeWorkspace.getItemId(), c);
                }
                return c;
            }
        }

        private WorkspaceCollaboration load(IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkspaceConnection connection = this.getWorkspaceConnection(workspace, monitor);
            IWorkspaceHandle workspaceCollaboration = ComponentFlowUtil.getCurrentCollaboration(connection);
            if (workspaceCollaboration == null) {
                workspaceCollaboration = FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)connection);
            }
            WorkspaceCollaboration result = new WorkspaceCollaboration(workspace, (IContextHandle)workspaceCollaboration);
            for (IComponentHandle component : connection.getComponents()) {
                IWorkspaceHandle componentCollaboration = ComponentFlowUtil.getCurrentCollaboration(connection, component);
                if (componentCollaboration == null) continue;
                result.setComponentCollaboration(component, (IContextHandle)componentCollaboration);
            }
            return result;
        }

        private IWorkspaceConnection getWorkspaceConnection(IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
            return (IWorkspaceConnection)ActiveWorkspaceManager.getConnection((IContextHandle)workspace, monitor);
        }

        public IContextHandle getComponentCollaboration(IWorkspaceHandle activeWorkspace, IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
            return c.getCollaboration(component);
        }

        public void setWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IWorkspaceHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            if (persist) {
                IWorkspaceConnection local = this.getWorkspaceConnection(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                IWorkspaceConnection remote = this.getWorkspaceConnection(collaboration, (IProgressMonitor)progress.newChild(1));
                IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
                boolean modified = false;
                if (!ComponentFlowUtil.hasCollaboration(local, remote)) {
                    ComponentFlowUtil.addCollaboration(flowTable, local, remote);
                    modified = true;
                }
                if (!collaboration.sameItemId((IItemHandle)ComponentFlowUtil.getCurrentCollaboration(local))) {
                    ComponentFlowUtil.setCurrentCollaboration(flowTable, collaboration);
                    for (IComponentHandle component : local.getComponents()) {
                        ComponentFlowUtil.setCurrentCollaboration(flowTable, component, null);
                    }
                    modified = true;
                }
                if (modified) {
                    local.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(1));
                }
            }
            try {
                ActiveWorkspaceManager.this.acquire();
                WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                IContextHandle old = c.resetCollaboration((IContextHandle)collaboration);
                ActiveWorkspaceManager.this.queueEvent(new PropertyChangeEvent((IEventSource)ActiveWorkspaceManager.this, "com.ibm.team.repository.PropertySet", (Object)activeWorkspace, (Object)"workspaceCollaboration", (Object)old, (Object)collaboration));
            }
            finally {
                ActiveWorkspaceManager.this.release();
                progress.done();
            }
        }

        public void setWorkspaceCollaboration(IWorkspaceHandle activeWorkspace, IBaselineHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            try {
                ActiveWorkspaceManager.this.acquire();
                WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                IContextHandle old = c.resetCollaboration((IContextHandle)collaboration);
                ActiveWorkspaceManager.this.queueEvent(new PropertyChangeEvent((IEventSource)ActiveWorkspaceManager.this, "com.ibm.team.repository.PropertySet", (Object)activeWorkspace, (Object)"workspaceCollaboration", (Object)old, (Object)collaboration));
            }
            finally {
                ActiveWorkspaceManager.this.release();
                progress.done();
            }
        }

        public void setComponentCollaboration(IWorkspaceHandle activeWorkspace, Collection<? extends IComponentHandle> components, IWorkspaceHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            if (persist) {
                IWorkspaceConnection local = this.getWorkspaceConnection(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                IWorkspaceConnection iWorkspaceConnection = this.getWorkspaceConnection(collaboration, (IProgressMonitor)progress.newChild(1));
                IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
                boolean modified = false;
                if (!ComponentFlowUtil.hasCollaboration(local, iWorkspaceConnection)) {
                    ComponentFlowUtil.addCollaboration(flowTable, local, iWorkspaceConnection);
                    modified = true;
                }
                for (IComponentHandle iComponentHandle : components) {
                    if (collaboration.sameItemId((IItemHandle)ComponentFlowUtil.getCurrentCollaboration(local, iComponentHandle))) continue;
                    ComponentFlowUtil.setCurrentCollaboration(flowTable, iComponentHandle, collaboration);
                    modified = true;
                }
                if (modified) {
                    local.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(1));
                }
            }
            try {
                ActiveWorkspaceManager.this.acquire();
                WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                for (IComponentHandle iComponentHandle : components) {
                    c.setComponentCollaboration(iComponentHandle, (IContextHandle)collaboration);
                    ActiveWorkspaceManager.this.queueEvent(new ComponentCollaborationEvent(ActiveWorkspaceManager.this, activeWorkspace, iComponentHandle, (IContextHandle)collaboration));
                }
            }
            finally {
                ActiveWorkspaceManager.this.release();
                progress.done();
            }
        }

        public void setComponentCollaboration(IWorkspaceHandle activeWorkspace, Collection<? extends IComponentHandle> components, IBaselineHandle collaboration, boolean persist, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            try {
                ActiveWorkspaceManager.this.acquire();
                WorkspaceCollaboration c = this.internalGetCollaboration(activeWorkspace, (IProgressMonitor)progress.newChild(1));
                for (IComponentHandle iComponentHandle : components) {
                    c.setComponentCollaboration(iComponentHandle, (IContextHandle)collaboration);
                    ActiveWorkspaceManager.this.queueEvent(new ComponentCollaborationEvent(ActiveWorkspaceManager.this, activeWorkspace, iComponentHandle, (IContextHandle)collaboration));
                }
            }
            finally {
                ActiveWorkspaceManager.this.release();
                progress.done();
            }
        }

        class WorkspaceCollaboration {
            IWorkspaceHandle workspace;
            IContextHandle collaboration;
            Hashtable<UUID, IContextHandle> componentCollaborations = new Hashtable();

            public WorkspaceCollaboration(IWorkspaceHandle workspace, IContextHandle collaboration) {
                this.workspace = workspace;
                this.collaboration = collaboration;
            }

            public IContextHandle setComponentCollaboration(IComponentHandle component, IContextHandle collaboration) {
                return this.componentCollaborations.put(component.getItemId(), collaboration);
            }

            public IContextHandle resetCollaboration(IContextHandle newCollaboration) {
                IContextHandle old = this.collaboration;
                this.componentCollaborations.clear();
                this.collaboration = newCollaboration;
                return old;
            }

            public IContextHandle getCollaboration(IComponentHandle component) {
                IContextHandle collaboration = this.componentCollaborations.get(component.getItemId());
                return collaboration != null ? collaboration : this.collaboration;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateJob
    extends Job {
        private List<ISandbox> updates;

        public UpdateJob() {
            super(Messages.ActiveWorkspaceManager_UpdateJobName);
            this.updates = new ArrayList<ISandbox>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (true) {
                ISandbox next;
                List<ISandbox> list = this.updates;
                synchronized (list) {
                    if (this.updates.isEmpty()) {
                        return Status.OK_STATUS;
                    }
                    next = this.updates.remove(0);
                }
                try {
                    this.activateWorkspaces(next, monitor);
                    continue;
                }
                catch (FileSystemClientException e) {
                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueUpdate(ISandbox sandbox) {
            List<ISandbox> list = this.updates;
            synchronized (list) {
                if (!this.updates.contains(sandbox)) {
                    this.updates.add(sandbox);
                    this.schedule();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueUpdates(Collection<ISandbox> toAdd) {
            List<ISandbox> list = this.updates;
            synchronized (list) {
                for (ISandbox sandbox : toAdd) {
                    this.queueUpdate(sandbox);
                }
            }
        }

        private void activateWorkspaces(ISandbox sandbox, IProgressMonitor monitor) throws FileSystemClientException {
            Collection<IWorkspaceHandle> workspaces = this.getWorkspaces(sandbox, monitor);
            IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
            for (IWorkspaceHandle handle : workspaces) {
                manager.activate(handle);
            }
        }

        private Collection<IWorkspaceHandle> getWorkspaces(ISandbox sandbox, IProgressMonitor monitor) throws FileSystemClientException {
            ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
            IShare[] allShares = sandbox.allShares(monitor);
            HashMap<UUID, IWorkspaceHandle> toActivate = new HashMap<UUID, IWorkspaceHandle>();
            IShare[] iShareArray = allShares;
            int n = allShares.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                if (descriptor.associatedWithWorkspace()) {
                    IContextHandle handle = descriptor.getConnectionHandle();
                    descriptor.getRepositoryUri();
                    if (handle instanceof IWorkspaceHandle) {
                        ITeamRepository origin;
                        ItemId id = ItemId.create((IItemHandle)((IWorkspaceHandle)handle));
                        try {
                            origin = teamRepositoryService.getTeamRepository(descriptor.getRepositoryUri(), monitor);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            origin = teamRepositoryService.getTeamRepository(descriptor.getRepositoryUri());
                        }
                        toActivate.put(handle.getItemId(), (IWorkspaceHandle)id.toHandle((Object)origin));
                    }
                }
                ++n2;
            }
            return toActivate.values();
        }
    }
}

