/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changelog;

import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogBaselineEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogChangeSetEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogComponentEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogDirectionEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogRootEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogWorkItemEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.FilesystemRestClientDTOchangelogFactory;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogEntryVisitor2;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogItemComparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemRerootVisitor {
    final ChangeLogRootEntryDTO oldRoot;
    final int rerootParent;
    final Map<String, ChangeLogEntryDTO> newByUuid = new HashMap<String, ChangeLogEntryDTO>();
    private ChangeLogRootEntryDTO newRoot;

    public WorkItemRerootVisitor(ChangeLogRootEntryDTO root, String workItemRerootDepth) {
        this.oldRoot = root;
        this.rerootParent = ChangeLogItemComparator.ord(workItemRerootDepth);
    }

    public ChangeLogRootEntryDTO run() {
        ChangeLogEntryVisitor2.visit(new ChangeLogEntryVisitor2(){

            @Override
            public boolean visit(Stack<ChangeLogEntryDTO> ancestors, ChangeLogEntryDTO item) {
                return WorkItemRerootVisitor.this.visitOldAncestor(ancestors, item);
            }
        }, (ChangeLogEntryDTO)this.oldRoot);
        return this.newRoot;
    }

    protected boolean visitOldAncestor(Stack<ChangeLogEntryDTO> oldAncestors, ChangeLogEntryDTO oldDto) {
        if (this.isAboveRootPoint(oldDto)) {
            Object newDto = WorkItemRerootVisitor.copy(oldDto);
            this.newByUuid.put(oldDto.getItemId(), (ChangeLogEntryDTO)newDto);
            if (oldAncestors.size() == 0) {
                this.newRoot = (ChangeLogRootEntryDTO)newDto;
            } else {
                ChangeLogEntryDTO newParent = this.newByUuid.get(oldAncestors.peek().getItemId());
                newParent.getChildEntries().add(newDto);
            }
            return true;
        }
        this.rerootDescendents(this.newByUuid.get(oldAncestors.peek().getItemId()), oldDto);
        return false;
    }

    private void rerootDescendents(final ChangeLogEntryDTO newParent, ChangeLogEntryDTO oldDto) {
        ChangeLogEntryVisitor2.visit(new ChangeLogEntryVisitor2(){

            @Override
            public boolean visit(Stack<ChangeLogEntryDTO> oldAncestors, ChangeLogEntryDTO item) {
                if (item instanceof ChangeLogChangeSetEntryDTO) {
                    ChangeLogChangeSetEntryDTO csDto = (ChangeLogChangeSetEntryDTO)item;
                    boolean hasWis = false;
                    for (ChangeLogEntryDTO wi : csDto.getWorkItems()) {
                        WorkItemRerootVisitor.this.reroot(newParent, oldAncestors, item, wi);
                        hasWis = true;
                    }
                    if (!hasWis) {
                        WorkItemRerootVisitor.this.copyPathAndLast(newParent, oldAncestors, item, null);
                    }
                    return false;
                }
                if (item instanceof ChangeLogWorkItemEntryDTO) {
                    if (newParent.getItemId().equals(item.getItemId())) {
                        return false;
                    }
                    WorkItemRerootVisitor.this.reroot(newParent, oldAncestors, item, item);
                    return false;
                }
                if (item.getChildEntries().isEmpty()) {
                    WorkItemRerootVisitor.this.copyPathAndLast(newParent, oldAncestors, item, null);
                }
                return true;
            }
        }, oldDto);
    }

    protected boolean alreadyVisitingRerootableItem(Stack<ChangeLogEntryDTO> oldAncestors) {
        for (ChangeLogEntryDTO oldAncestor : oldAncestors) {
            if (oldAncestor instanceof ChangeLogChangeSetEntryDTO) {
                return true;
            }
            if (!(oldAncestor instanceof ChangeLogWorkItemEntryDTO)) continue;
            return true;
        }
        return false;
    }

    protected void reroot(ChangeLogEntryDTO newParent, Stack<ChangeLogEntryDTO> oldAncestors, ChangeLogEntryDTO oldItem, ChangeLogEntryDTO wi) {
        Object newItem = this.findChildWithUuid(newParent, wi.getItemId());
        if (newItem == null) {
            newItem = WorkItemRerootVisitor.copy(wi);
            newParent.getChildEntries().add(newItem);
        }
        this.copyPathAndLast((ChangeLogEntryDTO)newItem, oldAncestors, oldItem, wi);
    }

    private void copyPathAndLast(ChangeLogEntryDTO newParent, Stack<ChangeLogEntryDTO> oldAncestors, ChangeLogEntryDTO oldItem, ChangeLogEntryDTO toExclude) {
        ChangeLogEntryDTO lastOnPath = newParent;
        for (ChangeLogEntryDTO oldAncestor : oldAncestors) {
            if (toExclude != null && oldAncestor.getItemId().equals(toExclude.getItemId())) continue;
            Object child = this.findChildWithUuid(lastOnPath, oldAncestor.getItemId());
            if (child == null) {
                child = WorkItemRerootVisitor.copy(oldAncestor);
                lastOnPath.getChildEntries().add(child);
            }
            lastOnPath = child;
        }
        if (toExclude == null || !oldItem.getItemId().equals(toExclude.getItemId())) {
            Object child = this.findChildWithUuid(lastOnPath, oldItem.getItemId());
            if (child == null) {
                child = WorkItemRerootVisitor.copy(oldItem, toExclude);
                lastOnPath.getChildEntries().add(child);
            }
            lastOnPath = child;
        }
        for (ChangeLogEntryDTO oldChild : oldItem.getChildEntries()) {
            lastOnPath.getChildEntries().add(this.copySubtree(oldChild, toExclude));
        }
    }

    private ChangeLogEntryDTO copySubtree(ChangeLogEntryDTO oldDto, final ChangeLogEntryDTO toExclude) {
        Object newDto = WorkItemRerootVisitor.copy(oldDto, toExclude);
        final HashMap family = new HashMap();
        family.put(newDto.getItemId(), newDto);
        ChangeLogEntryVisitor2.visit(new ChangeLogEntryVisitor2(){

            @Override
            public boolean visit(Stack<ChangeLogEntryDTO> ancestors, ChangeLogEntryDTO item) {
                if (ancestors.size() == 0) {
                    return true;
                }
                if (item instanceof ChangeLogWorkItemEntryDTO && ancestors.peek() instanceof ChangeLogChangeSetEntryDTO) {
                    return true;
                }
                if (toExclude != null && item.getItemId().equals(toExclude.getItemId())) {
                    return true;
                }
                ChangeLogEntryDTO copy = WorkItemRerootVisitor.copy(item, toExclude);
                family.put(copy.getItemId(), copy);
                ChangeLogEntryDTO parent = (ChangeLogEntryDTO)family.get(ancestors.peek().getItemId());
                parent.getChildEntries().add(copy);
                return true;
            }
        }, oldDto);
        return newDto;
    }

    protected ChangeLogEntryDTO findChildWithUuid(ChangeLogEntryDTO dto, String uuid) {
        for (ChangeLogEntryDTO child : dto.getChildEntries()) {
            if (!uuid.equals(child.getItemId())) continue;
            return child;
        }
        return null;
    }

    private boolean isAboveRootPoint(ChangeLogEntryDTO dto) {
        return ChangeLogItemComparator.ord(dto.getEntryType()) <= this.rerootParent;
    }

    private static <T extends ChangeLogEntryDTO> T copy(ChangeLogEntryDTO dto) {
        return WorkItemRerootVisitor.copy(dto, null);
    }

    private static <T extends ChangeLogEntryDTO> T copy(ChangeLogEntryDTO dto, ChangeLogEntryDTO toExclude) {
        if (dto instanceof ChangeLogWorkItemEntryDTO) {
            ChangeLogWorkItemEntryDTO wiDto = (ChangeLogWorkItemEntryDTO)dto;
            ChangeLogWorkItemEntryDTO newDto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogWorkItemEntryDTO();
            WorkItemRerootVisitor.copyCommonFields((ChangeLogEntryDTO)newDto, (ChangeLogEntryDTO)wiDto);
            newDto.setResolver(wiDto.getResolver());
            newDto.setWorkItemNumber(wiDto.getWorkItemNumber());
            return (T)newDto;
        }
        if (dto instanceof ChangeLogDirectionEntryDTO) {
            ChangeLogDirectionEntryDTO dirDto = (ChangeLogDirectionEntryDTO)dto;
            ChangeLogDirectionEntryDTO newDto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogDirectionEntryDTO();
            WorkItemRerootVisitor.copyCommonFields((ChangeLogEntryDTO)newDto, (ChangeLogEntryDTO)dirDto);
            newDto.setFlowDirection(dirDto.getFlowDirection());
            return (T)newDto;
        }
        if (dto instanceof ChangeLogBaselineEntryDTO) {
            ChangeLogBaselineEntryDTO clDto = (ChangeLogBaselineEntryDTO)dto;
            ChangeLogBaselineEntryDTO newDto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogBaselineEntryDTO();
            WorkItemRerootVisitor.copyCommonFields((ChangeLogEntryDTO)newDto, (ChangeLogEntryDTO)clDto);
            newDto.setBaselineId(clDto.getBaselineId());
            newDto.setCreationDate(clDto.getCreationDate());
            newDto.setCreator(clDto.getCreator());
            return (T)newDto;
        }
        if (dto instanceof ChangeLogVersionableEntryDTO) {
            ChangeLogVersionableEntryDTO verDto = (ChangeLogVersionableEntryDTO)dto;
            ChangeLogVersionableEntryDTO newDto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogVersionableEntryDTO();
            WorkItemRerootVisitor.copyCommonFields((ChangeLogEntryDTO)newDto, (ChangeLogEntryDTO)verDto);
            newDto.setResolved(verDto.isResolved());
            newDto.getSegments().addAll(verDto.getSegments());
            return (T)newDto;
        }
        if (dto instanceof ChangeLogChangeSetEntryDTO) {
            ChangeLogChangeSetEntryDTO csDto = (ChangeLogChangeSetEntryDTO)dto;
            ChangeLogChangeSetEntryDTO newDto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogChangeSetEntryDTO();
            WorkItemRerootVisitor.copyCommonFields((ChangeLogEntryDTO)newDto, (ChangeLogEntryDTO)csDto);
            newDto.setCreationDate(csDto.getCreationDate());
            newDto.setCreator(csDto.getCreator());
            for (ChangeLogWorkItemEntryDTO wiDto : csDto.getWorkItems()) {
                if (toExclude != null && toExclude.getItemId().equals(wiDto.getItemId())) continue;
                newDto.getWorkItems().add(WorkItemRerootVisitor.copy((ChangeLogEntryDTO)wiDto));
            }
            return (T)newDto;
        }
        if (dto instanceof ChangeLogComponentEntryDTO) {
            ChangeLogComponentEntryDTO compDto = (ChangeLogComponentEntryDTO)dto;
            ChangeLogComponentEntryDTO newDto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogComponentEntryDTO();
            WorkItemRerootVisitor.copyCommonFields((ChangeLogEntryDTO)newDto, (ChangeLogEntryDTO)compDto);
            newDto.setChangeType(compDto.getChangeType());
            return (T)newDto;
        }
        if (dto instanceof ChangeLogRootEntryDTO) {
            ChangeLogRootEntryDTO oldDto = (ChangeLogRootEntryDTO)dto;
            ChangeLogRootEntryDTO newDto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogRootEntryDTO();
            WorkItemRerootVisitor.copyCommonFields((ChangeLogEntryDTO)newDto, (ChangeLogEntryDTO)oldDto);
            newDto.setRepositoryUri(oldDto.getRepositoryUri());
            return (T)newDto;
        }
        throw new IllegalArgumentException();
    }

    private static void copyCommonFields(ChangeLogEntryDTO newDto, ChangeLogEntryDTO oldDto) {
        newDto.setEntryName(oldDto.getEntryName());
        newDto.setEntryType(oldDto.getEntryType());
        newDto.setItemId(oldDto.getItemId());
    }
}

