/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changelog;

import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogComponentEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogDirectionEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogWorkItemEntryDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.IChangeLogOutput;
import org.eclipse.osgi.util.NLS;

public class VerbatimChangeLogEntryVisitor
extends ChangeLogEntryVisitor {
    private IChangeLogOutput out;
    int indent = 0;

    public VerbatimChangeLogEntryVisitor(IChangeLogOutput out) {
        this.out = out;
    }

    public boolean enter(ChangeLogEntryDTO item) {
        ++this.indent;
        return true;
    }

    public void exit(ChangeLogEntryDTO item) {
        --this.indent;
    }

    public void visitChild(ChangeLogEntryDTO parent, ChangeLogEntryDTO child) {
        this.out.setIndent(this.indent);
        String entryType = child.getEntryType();
        if ("clentry_root".equals(entryType)) {
            this.out.writeLine(Messages.VerbatimChangeLogEntryVisitor_ROOT_MESSAGE);
        } else if ("clentry_direction".equals(entryType)) {
            ChangeLogDirectionEntryDTO dto = (ChangeLogDirectionEntryDTO)child;
            String dir = Messages.VerbatimChangeLogEntryVisitor_OUTGOING;
            if ("incoming".equals(dto.getFlowDirection())) {
                dir = Messages.VerbatimChangeLogEntryVisitor_INCOMING;
            }
            this.out.writeLine(NLS.bind((String)dir, (Object)dto.getItemId()));
        } else if ("clentry_component".equals(entryType)) {
            ChangeLogComponentEntryDTO dto = (ChangeLogComponentEntryDTO)child;
            this.out.writeLine(NLS.bind((String)Messages.VerbatimChangeLogEntryVisitor_COMPONENT_MESSAGE, (Object[])new String[]{dto.getEntryName(), dto.getChangeType(), dto.getItemId()}));
        } else if ("clentry_changeset".equals(entryType)) {
            this.out.writeLine(NLS.bind((String)Messages.VerbatimChangeLogEntryVisitor_CHANGE_SET_MESSAGE, (Object)child.getEntryName(), (Object)child.getItemId()));
        } else if ("clentry_baseline".equals(entryType)) {
            this.out.writeLine(NLS.bind((String)Messages.VerbatimChangeLogEntryVisitor_BASELINE_MESSAGE, (Object)child.getEntryName(), (Object)child.getItemId()));
        } else if ("clentry_versionable".equals(entryType)) {
            this.out.writeLine(NLS.bind((String)Messages.VerbatimChangeLogEntryVisitor_VERSIONABLE_MESSAGE, (Object)child.getEntryName(), (Object)child.getItemId()));
        } else if ("clentry_workitem".equals(entryType)) {
            ChangeLogWorkItemEntryDTO wiDto = (ChangeLogWorkItemEntryDTO)child;
            this.out.writeLine(NLS.bind((String)Messages.VerbatimChangeLogEntryVisitor_WORK_ITEM_MESSAGE, (Object[])new String[]{child.getEntryName(), child.getItemId(), Long.toString(wiDto.getWorkItemNumber())}));
        } else {
            this.out.writeLine(NLS.bind((String)Messages.VerbatimChangeLogEntryVisitor_UNKNOWN_TYPE_MESSAGE, (Object)entryType));
        }
    }
}

