/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changelog;

import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogBaselineEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogChangeSetEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogComponentEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogDirectionEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogWorkItemEntryDTO;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.IChangeLogOutput;

public class TypedChangeLogEntryVisitor
extends ChangeLogEntryVisitor {
    protected IChangeLogOutput out;
    private boolean inChangeSet = false;
    private boolean inWorkItem = false;
    int indent = 0;

    public TypedChangeLogEntryVisitor(IChangeLogOutput out) {
        this.out = out;
    }

    public boolean enter(ChangeLogEntryDTO item) {
        ++this.indent;
        this.inChangeSet |= "clentry_changeset".equals(item.getEntryType());
        this.inWorkItem |= "clentry_workitem".equals(item.getEntryType());
        return true;
    }

    public void exit(ChangeLogEntryDTO item) {
        --this.indent;
        if (this.inChangeSet && "clentry_changeset".equals(item.getEntryType())) {
            this.inChangeSet = false;
        }
        if (this.inWorkItem && "clentry_workitem".equals(item.getEntryType())) {
            this.inWorkItem = false;
        }
    }

    public void visitChild(ChangeLogEntryDTO parent, ChangeLogEntryDTO child) {
        this.out.setIndent(this.indent);
        String entryType = child.getEntryType();
        if ("clentry_root".equals(entryType)) {
            this.visitRoot(parent, child);
        } else if ("clentry_direction".equals(entryType)) {
            ChangeLogDirectionEntryDTO dto = (ChangeLogDirectionEntryDTO)child;
            this.visitDirection(parent, dto);
        } else if ("clentry_component".equals(entryType)) {
            ChangeLogComponentEntryDTO dto = (ChangeLogComponentEntryDTO)child;
            this.visitComponent(parent, dto);
        } else if ("clentry_changeset".equals(entryType)) {
            ChangeLogChangeSetEntryDTO dto = (ChangeLogChangeSetEntryDTO)child;
            this.visitChangeSet(parent, dto);
        } else if ("clentry_baseline".equals(entryType)) {
            ChangeLogBaselineEntryDTO dto = (ChangeLogBaselineEntryDTO)child;
            this.visitBaseline(parent, dto);
        } else if ("clentry_versionable".equals(entryType)) {
            ChangeLogVersionableEntryDTO dto = (ChangeLogVersionableEntryDTO)child;
            this.visitVersionable(parent, dto);
        } else if ("clentry_workitem".equals(entryType)) {
            ChangeLogWorkItemEntryDTO dto = (ChangeLogWorkItemEntryDTO)child;
            this.visitWorkItem(parent, dto, this.inChangeSet);
        } else {
            this.visitUnknown(parent, child);
        }
    }

    protected void visitDirection(ChangeLogEntryDTO parent, ChangeLogDirectionEntryDTO dto) {
    }

    protected void visitVersionable(ChangeLogEntryDTO parent, ChangeLogVersionableEntryDTO dto) {
    }

    protected void visitWorkItem(ChangeLogEntryDTO parent, ChangeLogWorkItemEntryDTO dto, boolean inChangeSet) {
    }

    protected void visitUnknown(ChangeLogEntryDTO parent, ChangeLogEntryDTO child) {
    }

    protected void visitChangeSet(ChangeLogEntryDTO parent, ChangeLogChangeSetEntryDTO dto) {
    }

    protected void visitBaseline(ChangeLogEntryDTO parent, ChangeLogBaselineEntryDTO dto) {
    }

    protected void visitComponent(ChangeLogEntryDTO parent, ChangeLogComponentEntryDTO dto) {
    }

    protected void visitRoot(ChangeLogEntryDTO parent, ChangeLogEntryDTO child) {
    }

    public boolean isInChangeSet() {
        return this.inChangeSet;
    }

    public boolean isInWorkItem() {
        return this.inWorkItem;
    }
}

