/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changelog;

import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.snapshot.ComponentSyncReportFragment;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReport;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotSyncReportFragment;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogBaselineEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogChangeSetEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogComponentEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogDirectionEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogRootEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogWorkItemEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.FilesystemRestClientDTOchangelogFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.ContributorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogCustomizer;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogItemComparator;
import com.ibm.team.filesystem.rcp.core.internal.changelog.WorkItemRerootVisitor;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateChangeLogOperation {
    protected ITeamRepository repo;
    protected SnapshotSyncReport report;
    protected IPathResolver pathResolver;
    private ChangeLogCustomizer customizer;
    protected List<DelayedChangeSetResolution> delayedPathResolutions = new LinkedList<DelayedChangeSetResolution>();
    protected HashMap<UUID, DelayedContributorResolution> delayedContributorResolutions = new HashMap();
    protected HashMap<UUID, DelayedWorkItemResolution> delayedWorkItemResolutions = new HashMap();
    private final Map<ItemId<IBaseline>, IBaseline> completeBaselines = new HashMap<ItemId<IBaseline>, IBaseline>();
    private final Map<ItemId<IComponent>, IComponent> completeComponents = new HashMap<ItemId<IComponent>, IComponent>();
    private final Map<ItemId<IChangeSet>, IChangeSet> completeChangeSets = new HashMap<ItemId<IChangeSet>, IChangeSet>();

    private static final IVersionableHandle findVersionableFor(IChange change) {
        if (change.kind() == 0) {
            return change.item();
        }
        if (change.kind() == 16) {
            return change.beforeState();
        }
        return change.afterState();
    }

    public void setChangeLogRequest(ITeamRepository repo, SnapshotSyncReport syncReport, IPathResolver pathResolver, ChangeLogCustomizer customizer) {
        if (customizer == null || syncReport == null) {
            throw new IllegalArgumentException();
        }
        this.repo = repo;
        this.report = syncReport;
        this.pathResolver = pathResolver;
        this.customizer = customizer;
    }

    public ChangeLogEntryDTO run(IProgressMonitor progress) throws TeamRepositoryException {
        if (this.customizer == null || this.report == null) {
            throw new IllegalStateException();
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.GenerateChangeLogOperation_INITIAL_STATUS, (int)(1 + (this.shouldIncludePaths() ? 3 : 0) + (this.shouldIncludeContributors() ? 1 : 0) + (this.shouldIncludeWorkItems() ? 2 : 0)));
        ChangeLogRootEntryDTO root = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogRootEntryDTO();
        root.setRepositoryUri(this.repo.getRepositoryURI());
        root.setEntryType("clentry_root");
        root.setItemId(UUID.generate().getUuidValue());
        ChangeLogDirectionEntryDTO outgoing = null;
        if (this.customizer.shouldIncludeOutgoing()) {
            outgoing = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogDirectionEntryDTO();
            outgoing.setEntryType("clentry_direction");
            outgoing.setFlowDirection("outgoing");
            outgoing.setItemId(UUID.generate().getUuidValue());
            root.getChildEntries().add(outgoing);
        }
        ChangeLogDirectionEntryDTO incoming = null;
        if (this.customizer.shouldIncludeIncoming()) {
            incoming = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogDirectionEntryDTO();
            incoming.setEntryType("clentry_direction");
            incoming.setFlowDirection("incoming");
            incoming.setItemId(UUID.generate().getUuidValue());
            root.getChildEntries().add(incoming);
        }
        this.buildTree(incoming, outgoing, mon.newChild(1));
        if (this.shouldIncludeWorkItems()) {
            this.resolveWorkItems(mon.newChild(2));
        }
        if (this.shouldIncludePaths()) {
            this.resolvePaths(mon.newChild(3));
        }
        if (this.shouldIncludeContributors()) {
            this.resolveContributors(mon.newChild(1));
        }
        this.prune(root);
        if (this.shouldMakeWorkItemsRoots()) {
            root = this.makeWorkItemsRoots(root);
        }
        this.customizer.postPruneFixup((ChangeLogEntryDTO)root);
        ChangeLogItemComparator.sort(root);
        return root;
    }

    private ChangeLogRootEntryDTO makeWorkItemsRoots(ChangeLogRootEntryDTO root) {
        return new WorkItemRerootVisitor(root, this.customizer.getWorkItemRerootDepth()).run();
    }

    private void buildTree(ChangeLogDirectionEntryDTO incoming, ChangeLogDirectionEntryDTO outgoing, SubMonitor mon) throws TeamRepositoryException {
        mon.setWorkRemaining(2);
        if (this.customizer.shouldIncludeIncoming()) {
            this.populateComponents(this.report.get(FlowType.Incoming), incoming.getChildEntries(), mon.newChild(1));
        }
        if (this.customizer.shouldIncludeOutgoing()) {
            this.populateComponents(this.report.get(FlowType.Outgoing), outgoing.getChildEntries(), mon.newChild(1));
        }
        mon.done();
    }

    private void prune(ChangeLogRootEntryDTO root) {
        if (this.customizer.shouldPruneUnchangedComponents()) {
            for (ChangeLogDirectionEntryDTO dir : root.getChildEntries()) {
                Iterator i = dir.getChildEntries().iterator();
                while (i.hasNext()) {
                    ChangeLogComponentEntryDTO component = (ChangeLogComponentEntryDTO)i.next();
                    if (!"none".equals(component.getChangeType()) || !component.getChildEntries().isEmpty()) continue;
                    i.remove();
                }
            }
        }
        if (this.customizer.shouldPruneEmptyDirections()) {
            Iterator i = root.getChildEntries().iterator();
            while (i.hasNext()) {
                ChangeLogEntryDTO dir = (ChangeLogEntryDTO)i.next();
                if (!dir.getChildEntries().isEmpty()) continue;
                i.remove();
            }
        }
        this.pruneByType((ChangeLogEntryDTO)root);
    }

    private List<ChangeLogEntryDTO> pruneByType(ChangeLogEntryDTO node) {
        List oldChildren = node.getChildEntries();
        List<ChangeLogEntryDTO> newChildren = new ArrayList<ChangeLogEntryDTO>(oldChildren.size());
        for (ChangeLogEntryDTO item : oldChildren) {
            newChildren.addAll(this.pruneByType(item));
        }
        newChildren = this.merge(newChildren, null);
        if ("clentry_changeset".equals(node.getEntryType()) && !this.shouldIncludeChangeSets() && this.shouldIncludeWorkItems()) {
            ChangeLogChangeSetEntryDTO csDto = (ChangeLogChangeSetEntryDTO)node;
            if (csDto.getWorkItems().isEmpty()) {
                return newChildren;
            }
            for (ChangeLogWorkItemEntryDTO wiDto : csDto.getWorkItems()) {
                wiDto.getChildEntries().addAll(newChildren);
            }
            return csDto.getWorkItems();
        }
        if (this.shouldInclude(node.getEntryType())) {
            oldChildren.clear();
            oldChildren.addAll(newChildren);
            return Collections.singletonList(node);
        }
        return newChildren;
    }

    private List<ChangeLogEntryDTO> merge(List<ChangeLogEntryDTO> items1, List<ChangeLogEntryDTO> items2) {
        if (items2 == null) {
            items2 = Collections.EMPTY_LIST;
        }
        HashMap<String, Integer> itemLocations = new HashMap<String, Integer>(items1.size() + items2.size());
        ArrayList<ChangeLogEntryDTO> toReturn = new ArrayList<ChangeLogEntryDTO>(items1.size() + items2.size());
        this.mergeList(toReturn, itemLocations, items1);
        this.mergeList(toReturn, itemLocations, items2);
        return toReturn;
    }

    private void mergeList(ArrayList<ChangeLogEntryDTO> toReturn, HashMap<String, Integer> itemLocations, List<ChangeLogEntryDTO> items) {
        int i = 0;
        while (i < items.size()) {
            ChangeLogEntryDTO potentialDupe = items.get(i);
            Integer previousIndex = itemLocations.get(potentialDupe.getItemId());
            if (previousIndex == null || this.isArtificial(potentialDupe)) {
                itemLocations.put(potentialDupe.getItemId(), toReturn.size());
                toReturn.add(potentialDupe);
            } else {
                ChangeLogEntryDTO dto = toReturn.get(previousIndex);
                if ("clentry_workitem".equals(dto.getEntryType())) {
                    List<ChangeLogEntryDTO> newChildren = this.merge(dto.getChildEntries(), potentialDupe.getChildEntries());
                    dto.getChildEntries().clear();
                    dto.getChildEntries().addAll(newChildren);
                }
            }
            ++i;
        }
    }

    private void populateComponents(SnapshotSyncReportFragment frag, List<ChangeLogEntryDTO> comps, SubMonitor mon) throws TeamRepositoryException {
        Map modifications = frag.getComponentModifications();
        Set additions = frag.getComponentChanges().getAdditions();
        Set deletions = frag.getComponentChanges().getRemovals();
        mon.setWorkRemaining(3);
        this.prefetch(modifications, additions, deletions, mon.newChild(2));
        for (Map.Entry entry : modifications.entrySet()) {
            this.populateComponent(comps, this.completeComponents.get(entry.getKey()), (ComponentSyncReportFragment)entry.getValue(), mon.newChild(1));
        }
        for (ItemId itemId : additions) {
            this.populateComponentAddition(comps, this.completeComponents.get(itemId));
        }
        for (ItemId itemId : deletions) {
            this.populateComponentDeletion(comps, this.completeComponents.get(itemId));
        }
    }

    private void prefetch(Map<ItemId<IComponent>, ComponentSyncReportFragment> modifications, Set<ItemId<IComponent>> additions, Set<ItemId<IComponent>> removals, SubMonitor mon) throws TeamRepositoryException {
        if (mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        mon.subTask(Messages.GenerateChangeLogOperation_STATUS_PREFETCH);
        mon.setWorkRemaining(3);
        mon.setTaskName(Messages.GenerateChangeLogOperation_PREFETCH_COMPONENTS);
        ArrayList compHandles = new ArrayList(modifications.size() + additions.size() + removals.size());
        compHandles.addAll(ItemLists.idsToHandles(modifications.keySet()));
        compHandles.addAll(ItemLists.idsToHandles(additions));
        compHandles.addAll(ItemLists.idsToHandles(removals));
        List components = this.repo.itemManager().fetchCompleteItems(compHandles, 0, (IProgressMonitor)mon.newChild(1));
        ItemLists.updateIdMap(this.completeComponents, (Collection)components);
        ArrayList baselineIds = new ArrayList();
        ArrayList csHandles = new ArrayList();
        for (ComponentSyncReportFragment frag : modifications.values()) {
            baselineIds.addAll(frag.getBaselines());
            csHandles.addAll(frag.computeNetChange(this.repo, (IProgressMonitor)mon.newChild(1)).getChangeSets());
        }
        if (mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        mon.setTaskName(Messages.GenerateChangeLogOperation_PREFETCH_BASELINES);
        List baselines = this.repo.itemManager().fetchCompleteItems(ItemLists.idsToHandles(baselineIds), 0, (IProgressMonitor)mon.newChild(1));
        ItemLists.updateIdMap(this.completeBaselines, (Collection)baselines);
        if (mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        mon.setTaskName(Messages.GenerateChangeLogOperation_PREFETCH_CHANGESETS);
        List changesets = this.repo.itemManager().fetchCompleteItems(ItemLists.idsToHandles(csHandles), 0, (IProgressMonitor)mon.newChild(1));
        ItemLists.updateIdMap(this.completeChangeSets, (Collection)changesets);
    }

    private void resolvePaths(SubMonitor mon) throws TeamRepositoryException {
        mon.subTask(Messages.GenerateChangeLogOperation_RESOLVING_PATHS_IN_CHANGE_SET);
        ArrayList<SiloedItemId<IVersionable>> allVersionables = new ArrayList<SiloedItemId<IVersionable>>(this.delayedPathResolutions.size() * 10);
        IdentityHashMap<DelayedChangeSetResolution, Collection<SiloedItemId<IVersionable>>> pathMapping = new IdentityHashMap<DelayedChangeSetResolution, Collection<SiloedItemId<IVersionable>>>();
        for (DelayedChangeSetResolution r : this.delayedPathResolutions) {
            Collection<SiloedItemId<IVersionable>> v = r.getVersionables();
            allVersionables.addAll(v);
            pathMapping.put(r, v);
        }
        Map paths = this.pathResolver.resolve(allVersionables, (IProgressMonitor)mon);
        int i = this.delayedPathResolutions.size() - 1;
        while (i >= 0) {
            DelayedChangeSetResolution r = this.delayedPathResolutions.get(i);
            Collection versionables = (Collection)pathMapping.get(r);
            ArrayList<ChangeLogVersionableEntryDTO> populatedPaths = new ArrayList<ChangeLogVersionableEntryDTO>(paths.size());
            for (SiloedItemId item : versionables) {
                VersionablePath path = (VersionablePath)paths.get(item);
                ChangeLogVersionableEntryDTO fsItem = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogVersionableEntryDTO();
                fsItem.setItemId(item.getItemId().getItemUUID().getUuidValue());
                fsItem.setEntryType("clentry_versionable");
                fsItem.setEntryName(this.customizer.makeVersionablePath(path.getStringSegments(), path.isResolved()));
                fsItem.setResolved(path.isResolved());
                String[] stringArray = path.getStringSegments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    fsItem.getSegments().add(segment);
                    ++n2;
                }
                populatedPaths.add(fsItem);
            }
            r.setPaths(populatedPaths);
            --i;
        }
    }

    private void resolveContributors(SubMonitor mon) throws TeamRepositoryException {
        mon.subTask(Messages.GenerateChangeLogOperation_RESOLVING_CONTRIBUTORS);
        ArrayList<IContributorHandle> handles = new ArrayList<IContributorHandle>(this.delayedContributorResolutions.size());
        ArrayList<List<ContributorDTO>> dtoLists = new ArrayList<List<ContributorDTO>>(this.delayedContributorResolutions.size());
        for (DelayedContributorResolution c : this.delayedContributorResolutions.values()) {
            handles.add(c.handle);
            dtoLists.add(c.dtos);
        }
        List contributors = this.repo.itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)mon);
        int i = 0;
        while (i < contributors.size()) {
            IContributor contrib = (IContributor)contributors.get(i);
            if (contrib != null) {
                for (ContributorDTO dto : (List)dtoLists.get(i)) {
                    dto.setContributorItemId(contrib.getItemId().getUuidValue());
                    dto.setUserId(contrib.getUserId());
                    dto.setFullName(contrib.getName());
                    dto.setEmailAddress(contrib.getEmailAddress());
                }
            }
            ++i;
        }
    }

    private void resolveWorkItems(SubMonitor mon) throws TeamRepositoryException {
        assert (this.shouldIncludeWorkItems());
        if (mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        mon.subTask(Messages.GenerateChangeLogOperation_RESOLVING_WORKITEMS);
        mon.setWorkRemaining(3);
        ArrayList<IChangeSet> cses = new ArrayList<IChangeSet>(this.delayedWorkItemResolutions.size());
        for (DelayedWorkItemResolution wiRes : this.delayedWorkItemResolutions.values()) {
            cses.add(wiRes.changeSet);
        }
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repo);
        List summaries = cses.isEmpty() ? Collections.EMPTY_LIST : wm.getChangeSetLinkSummary(cses, (IProgressMonitor)mon.newChild(1));
        ArrayList linkHandles = new ArrayList(this.delayedWorkItemResolutions.size());
        for (IChangeSetLinkSummary summary : summaries) {
            linkHandles.addAll(summary.getLinks());
        }
        List links = this.repo.itemManager().fetchCompleteItems(linkHandles, 0, (IProgressMonitor)mon.newChild(1));
        linkHandles = null;
        HashMap<UUID, ArrayList<UUID>> workItem2changeSet = new HashMap<UUID, ArrayList<UUID>>();
        ArrayList<IManagedItemHandle> wiHandles = new ArrayList<IManagedItemHandle>(this.delayedWorkItemResolutions.size());
        for (ILink link : links) {
            IReference targetRef = link.getTargetRef();
            if (!targetRef.isItemReference() || !link.getSourceRef().isItemReference()) continue;
            IManagedItemHandle wiHandle = (IManagedItemHandle)((IItemReference)targetRef).getReferencedItem();
            ArrayList<UUID> changes = (ArrayList<UUID>)workItem2changeSet.get(wiHandle.getItemId());
            if (changes == null) {
                changes = new ArrayList<UUID>(2);
                workItem2changeSet.put(wiHandle.getItemId(), changes);
                wiHandles.add(wiHandle);
            }
            changes.add(((IItemReference)link.getSourceRef()).getReferencedItem().getItemId());
        }
        List wis = this.repo.itemManager().fetchCompleteItems(wiHandles, 0, (IProgressMonitor)mon.newChild(1));
        int i = 0;
        while (i < wis.size()) {
            for (UUID csUuid : (List)workItem2changeSet.get(((IManagedItem)wis.get(i)).getItemId())) {
                DelayedWorkItemResolution res = this.delayedWorkItemResolutions.get(csUuid);
                if (res == null) {
                    LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((int)4, (String)Messages.GenerateChangeLogOperation_MISSING_CHANGESET, null));
                    continue;
                }
                ChangeLogWorkItemEntryDTO wiDto = this.populateWorkItemByReflection(res, (IManagedItem)wis.get(i));
                res.container.getWorkItems().add(wiDto);
                if (res.resolvedWorkItems == null) {
                    res.resolvedWorkItems = new ArrayList<ChangeLogWorkItemEntryDTO>(2);
                }
                res.resolvedWorkItems.add(wiDto);
            }
            ++i;
        }
    }

    private ChangeLogWorkItemEntryDTO populateWorkItemByReflection(DelayedWorkItemResolution res, IManagedItem managedItem) {
        ChangeLogWorkItemEntryDTO wiDto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogWorkItemEntryDTO();
        wiDto.setEntryType("clentry_workitem");
        wiDto.setItemId(managedItem.getItemId().getUuidValue());
        try {
            Class<?> type = managedItem.getClass();
            Method idMethod = type.getMethod("getId", new Class[0]);
            int id = (Integer)idMethod.invoke((Object)managedItem, new Object[0]);
            wiDto.setWorkItemNumber((long)id);
            Method summaryMethod = type.getMethod("getHTMLSummary", new Class[0]);
            String summary = ((XMLString)summaryMethod.invoke((Object)managedItem, new Object[0])).getPlainText();
            wiDto.setEntryName(summary);
            if (this.shouldIncludeContributors()) {
                Method resolverMethod = type.getMethod("getResolver", new Class[0]);
                IContributorHandle resolver = (IContributorHandle)resolverMethod.invoke((Object)managedItem, new Object[0]);
                wiDto.setResolver(this.populateContributor(resolver));
            }
        }
        catch (Exception e) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((int)4, (String)Messages.GenerateChangeLogOperation_REFLECTION_FAILED, (Throwable)e));
        }
        return wiDto;
    }

    private void populateComponent(List<ChangeLogEntryDTO> container, IComponent comp, ComponentSyncReportFragment componentSyncReportFragment, SubMonitor mon) throws TeamRepositoryException {
        if (mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        mon.setWorkRemaining(7);
        ChangeLogComponentEntryDTO compEntry = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogComponentEntryDTO();
        compEntry.setEntryName(comp.getName());
        compEntry.setItemId(comp.getItemId().getUuidValue());
        compEntry.setEntryType("clentry_component");
        compEntry.setChangeType("none");
        container.add((ChangeLogEntryDTO)compEntry);
        container = compEntry.getChildEntries();
        this.populateBaselines(container, comp, componentSyncReportFragment, mon.newChild(4));
        this.populateChangeSets(container, componentSyncReportFragment.getChangeSets().getChangeSets(), mon.newChild(3));
    }

    private void populateComponentAddition(Collection<ChangeLogEntryDTO> comps, IComponent comp) throws TeamRepositoryException {
        ChangeLogComponentEntryDTO compEntry = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogComponentEntryDTO();
        compEntry.setEntryName(comp.getName());
        compEntry.setItemId(comp.getItemId().getUuidValue());
        compEntry.setEntryType("clentry_component");
        compEntry.setChangeType("addComponent");
        comps.add((ChangeLogEntryDTO)compEntry);
    }

    private void populateComponentDeletion(Collection<ChangeLogEntryDTO> comps, IComponent comp) throws TeamRepositoryException {
        ChangeLogComponentEntryDTO compEntry = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogComponentEntryDTO();
        compEntry.setEntryName(comp.getName());
        compEntry.setItemId(comp.getItemId().getUuidValue());
        compEntry.setEntryType("clentry_component");
        compEntry.setChangeType("removeComponent");
        comps.add((ChangeLogEntryDTO)compEntry);
    }

    private void populateChangeSets(List<ChangeLogEntryDTO> container, List<ItemId<IChangeSet>> changeSets, SubMonitor mon) throws TeamRepositoryException {
        if (mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        mon.setWorkRemaining(changeSets.size() * 2);
        int i = 0;
        while (i < changeSets.size()) {
            IChangeSet cs = this.completeChangeSets.get(changeSets.get(i));
            ChangeLogChangeSetEntryDTO dto = this.populateChangeSet(cs, mon.newChild(1));
            if (this.shouldIncludeWorkItems()) {
                this.delayedWorkItemResolutions.put(cs.getItemId(), new DelayedWorkItemResolution(cs, dto));
            }
            if (this.shouldIncludePaths()) {
                this.delayedPathResolutions.add(new DelayedChangeSetResolution(cs, dto));
            }
            container.add((ChangeLogEntryDTO)dto);
            ++i;
        }
    }

    private ChangeLogChangeSetEntryDTO populateChangeSet(IChangeSet cs, SubMonitor mon) {
        ChangeLogChangeSetEntryDTO dto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogChangeSetEntryDTO();
        dto.setEntryType("clentry_changeset");
        dto.setItemId(cs.getItemId().getUuidValue());
        dto.setEntryName(cs.getComment());
        if (this.shouldIncludeChangeSets()) {
            dto.setCreator(this.populateContributor(cs.getAuthor()));
        }
        dto.setCreationDate(new Timestamp(cs.getLastChangeDate().getTime()));
        return dto;
    }

    private void populateBaselines(List<ChangeLogEntryDTO> container, IComponent comp, ComponentSyncReportFragment mods, SubMonitor mon) throws TeamRepositoryException {
        if (mon.isCanceled()) {
            throw new OperationCanceledException();
        }
        mon = SubMonitor.convert((IProgressMonitor)mon, (int)(mods.getBaselines().size() * 5 + 1));
        List blIds = mods.getBaselines();
        int i = mods.getBaselines().size() - 1;
        while (i >= 0) {
            IBaseline baseline = this.completeBaselines.get(blIds.get(i));
            ChangeLogBaselineEntryDTO dto = FilesystemRestClientDTOchangelogFactory.eINSTANCE.createChangeLogBaselineEntryDTO();
            dto.setEntryName(baseline.getName());
            dto.setItemId(baseline.getItemId().getUuidValue());
            dto.setBaselineId(baseline.getId());
            dto.setEntryType("clentry_baseline");
            if (this.shouldIncludeBaselines()) {
                dto.setCreator(this.populateContributor(baseline.getCreator()));
            }
            dto.setCreationDate(new Timestamp(baseline.getCreationDate().getTime()));
            container.add((ChangeLogEntryDTO)dto);
            ItemId current = (ItemId)mods.getBaselines().get(i);
            ItemId prev = i + 1 == mods.getBaselines().size() ? mods.commonAncestor() : (ItemId)mods.getBaselines().get(i + 1);
            HashSet<ItemId<IChangeSet>> allChangeSets = new HashSet<ItemId<IChangeSet>>();
            allChangeSets.addAll(mods.computeNetChange(this.repo, (IProgressMonitor)mon.newChild(1)).getChangeSets());
            List<ItemId<IChangeSet>> differentChangeSets = SyncViewDTOUtil.fetchDifferentChangeSets(this.repo, (ItemId<IBaseline>)current, (ItemId<IBaseline>)prev, allChangeSets, mon.newChild(1));
            this.populateChangeSets(dto.getChildEntries(), differentChangeSets, mon.newChild(3));
            --i;
        }
    }

    private ContributorDTO populateContributor(IContributorHandle contrib) {
        if (!this.customizer.shouldIncludeContributors()) {
            return null;
        }
        ContributorDTO dto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createContributorDTO();
        DelayedContributorResolution res = this.delayedContributorResolutions.get(contrib.getItemId());
        if (res == null) {
            res = new DelayedContributorResolution(contrib);
            this.delayedContributorResolutions.put(contrib.getItemId(), res);
        }
        res.dtos.add(dto);
        return dto;
    }

    private boolean isArtificial(ChangeLogEntryDTO dto) {
        return "clentry_direction".equals(dto.getEntryType()) || "clentry_root".equals(dto.getEntryType());
    }

    private boolean shouldInclude(String type) {
        if ("clentry_root".equals(type)) {
            return true;
        }
        if ("clentry_direction".equals(type)) {
            return this.customizer.shouldIncludeDirection();
        }
        if ("clentry_component".equals(type)) {
            return this.customizer.shouldIncludeComponents();
        }
        if ("clentry_baseline".equals(type)) {
            return this.customizer.shouldIncludeBaselines();
        }
        if ("clentry_workitem".equals(type)) {
            return this.customizer.shouldIncludeWorkItems();
        }
        if ("clentry_changeset".equals(type)) {
            return this.customizer.shouldIncludeChangeSets();
        }
        if ("clentry_versionable".equals(type)) {
            return this.customizer.shouldIncludePaths();
        }
        throw new IllegalArgumentException();
    }

    private boolean shouldIncludePaths() {
        return this.customizer.shouldIncludePaths();
    }

    private boolean shouldIncludeChangeSets() {
        return this.customizer.shouldIncludeChangeSets();
    }

    private boolean shouldIncludeWorkItems() {
        return this.customizer.shouldIncludeWorkItems();
    }

    private boolean shouldIncludeBaselines() {
        return this.customizer.shouldIncludeBaselines();
    }

    private boolean shouldIncludeContributors() {
        return this.customizer.shouldIncludeContributors();
    }

    private boolean shouldMakeWorkItemsRoots() {
        return this.customizer.getWorkItemRerootDepth() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelayedChangeSetResolution {
        final IChangeSet cs;
        final ChangeLogChangeSetEntryDTO dto;

        DelayedChangeSetResolution(IChangeSet cs, ChangeLogChangeSetEntryDTO dto) {
            this.cs = cs;
            this.dto = dto;
        }

        public Collection<SiloedItemId<IVersionable>> getVersionables() {
            List changes = this.cs.changes();
            ArrayList<SiloedItemId<IVersionable>> toResolve = new ArrayList<SiloedItemId<IVersionable>>(changes.size());
            IComponentHandle comp = this.cs.getComponent();
            for (IChange change : changes) {
                IVersionableHandle versionable = GenerateChangeLogOperation.findVersionableFor(change);
                if (versionable == null) continue;
                toResolve.add((SiloedItemId<IVersionable>)SiloedItemId.create((IVersionableHandle)versionable, (IComponentHandle)comp));
            }
            return toResolve;
        }

        public void setPaths(Collection<ChangeLogVersionableEntryDTO> entries) {
            this.dto.getChildEntries().addAll(entries);
        }
    }

    private static final class DelayedContributorResolution {
        final IContributorHandle handle;
        final List<ContributorDTO> dtos = new ArrayList<ContributorDTO>();

        DelayedContributorResolution(IContributorHandle handle) {
            this.handle = handle;
        }
    }

    private static final class DelayedWorkItemResolution {
        final IChangeSet changeSet;
        final ChangeLogChangeSetEntryDTO container;
        List<ChangeLogWorkItemEntryDTO> resolvedWorkItems = null;

        DelayedWorkItemResolution(IChangeSet cs, ChangeLogChangeSetEntryDTO container) {
            this.changeSet = cs;
            this.container = container;
        }
    }
}

