/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changelog;

import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogBaselineEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogChangeSetEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogComponentEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogDirectionEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogRootEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogWorkItemEntryDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogItemComparator
implements Comparator<ChangeLogEntryDTO> {
    public static int ord(String type) {
        if ("clentry_root".equals(type)) {
            return 0;
        }
        if ("clentry_direction".equals(type)) {
            return 1;
        }
        if ("clentry_component".equals(type)) {
            return 2;
        }
        if ("clentry_baseline".equals(type)) {
            return 3;
        }
        if ("clentry_changeset".equals(type)) {
            return 4;
        }
        if ("clentry_workitem".equals(type)) {
            return 5;
        }
        if ("clentry_versionable".equals(type)) {
            return 6;
        }
        throw new IllegalArgumentException();
    }

    private static int typePriority(ChangeLogEntryDTO item) {
        if (item instanceof ChangeLogRootEntryDTO) {
            return 0;
        }
        if (item instanceof ChangeLogDirectionEntryDTO) {
            return 1;
        }
        if (item instanceof ChangeLogComponentEntryDTO) {
            return 2;
        }
        if (item instanceof ChangeLogBaselineEntryDTO) {
            return 3;
        }
        if (item instanceof ChangeLogWorkItemEntryDTO) {
            return 4;
        }
        if (item instanceof ChangeLogChangeSetEntryDTO) {
            return 5;
        }
        if (item instanceof ChangeLogVersionableEntryDTO) {
            return 6;
        }
        throw new IllegalArgumentException();
    }

    public static void sort(ChangeLogRootEntryDTO entry) {
        ArrayList<ChangeLogRootEntryDTO> queue = new ArrayList<ChangeLogRootEntryDTO>();
        queue.add(entry);
        ChangeLogItemComparator comparator = new ChangeLogItemComparator();
        while (!queue.isEmpty()) {
            ChangeLogEntryDTO item = (ChangeLogEntryDTO)queue.remove(queue.size() - 1);
            queue.addAll(item.getChildEntries());
            if (item instanceof ChangeLogChangeSetEntryDTO) {
                ChangeLogChangeSetEntryDTO csDto = (ChangeLogChangeSetEntryDTO)item;
                queue.addAll(csDto.getWorkItems());
                ArrayList wis = new ArrayList(csDto.getWorkItems());
                csDto.getWorkItems().clear();
                Collections.sort(wis, comparator);
                csDto.getWorkItems().addAll(wis);
            }
            if (item.getChildEntries().size() <= 1) continue;
            ArrayList entries = new ArrayList(item.getChildEntries());
            item.getChildEntries().clear();
            Collections.sort(entries, comparator);
            item.getChildEntries().addAll(entries);
        }
    }

    @Override
    public int compare(ChangeLogEntryDTO o1, ChangeLogEntryDTO o2) {
        if (!o1.getClass().equals(o2.getClass())) {
            return ChangeLogItemComparator.typePriority(o1) - ChangeLogItemComparator.typePriority(o2);
        }
        if (o1 instanceof ChangeLogRootEntryDTO) {
            return o1.getItemId().compareTo(o2.getItemId());
        }
        if (o1 instanceof ChangeLogDirectionEntryDTO) {
            ChangeLogDirectionEntryDTO dir1 = (ChangeLogDirectionEntryDTO)o1;
            ChangeLogDirectionEntryDTO dir2 = (ChangeLogDirectionEntryDTO)o2;
            return dir1.getFlowDirection().compareTo(dir2.getFlowDirection()) * -1;
        }
        if (o1 instanceof ChangeLogComponentEntryDTO) {
            ChangeLogComponentEntryDTO c1 = (ChangeLogComponentEntryDTO)o1;
            ChangeLogComponentEntryDTO c2 = (ChangeLogComponentEntryDTO)o2;
            if ("removeComponent".equals(c1.getEntryType()) && !"removeComponent".equals(c2.getEntryType())) {
                return -1;
            }
            if ("addComponent".equals(c1.getEntryType()) && !"addComponent".equals(c2.getEntryType())) {
                return 1;
            }
            return c1.getEntryName().compareTo(c2.getEntryName());
        }
        if (o1 instanceof ChangeLogBaselineEntryDTO) {
            if (o2 instanceof ChangeLogBaselineEntryDTO) {
                ChangeLogBaselineEntryDTO b1 = (ChangeLogBaselineEntryDTO)o1;
                ChangeLogBaselineEntryDTO b2 = (ChangeLogBaselineEntryDTO)o2;
                return b1.getCreationDate().compareTo(b2.getCreationDate());
            }
            throw new IllegalArgumentException();
        }
        if (o1 instanceof ChangeLogChangeSetEntryDTO) {
            if (o2 instanceof ChangeLogChangeSetEntryDTO) {
                ChangeLogChangeSetEntryDTO c1 = (ChangeLogChangeSetEntryDTO)o1;
                ChangeLogChangeSetEntryDTO c2 = (ChangeLogChangeSetEntryDTO)o2;
                return c1.getCreationDate().compareTo(c2.getCreationDate());
            }
            throw new IllegalArgumentException();
        }
        if (o1 instanceof ChangeLogVersionableEntryDTO) {
            if (o2 instanceof ChangeLogVersionableEntryDTO) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1.getEntryName(), o2.getEntryName());
            }
            throw new IllegalArgumentException();
        }
        if (o1 instanceof ChangeLogWorkItemEntryDTO) {
            if (o2 instanceof ChangeLogWorkItemEntryDTO) {
                ChangeLogWorkItemEntryDTO w1 = (ChangeLogWorkItemEntryDTO)o1;
                ChangeLogWorkItemEntryDTO w2 = (ChangeLogWorkItemEntryDTO)o2;
                return (int)(w1.getWorkItemNumber() - w2.getWorkItemNumber());
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }
}

