/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changelog;

import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntryDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class ChangeLogCustomizer {
    private boolean includeComponents = true;
    private boolean includePaths = true;
    private boolean includeChangeSets = true;
    private boolean includeWorkItems = true;
    private boolean includeBaselines = true;
    private boolean includeContributors = true;
    private boolean includeDirection = true;
    private boolean makeWorkItemsRoots = false;
    private FlowType flowtype = FlowType.Both;
    private String workItemRerootDepth = null;
    private boolean pruneUnchangedComponents = false;
    private boolean pruneEmptyDirections = false;

    public String makeVersionablePath(String[] pathSegments, boolean resolved) {
        if (!resolved) {
            return Messages.ChangeLogCustomizer_UNRESOLVED_PATH;
        }
        StringBuffer buf = new StringBuffer();
        String[] stringArray = pathSegments;
        int n = pathSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            buf.append("/");
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    public ChangeLogCustomizer setIncludeComponents(boolean b) {
        this.includeComponents = b;
        return this;
    }

    public boolean shouldIncludeComponents() {
        return this.includeComponents;
    }

    public ChangeLogCustomizer setIncludePaths(boolean includePaths) {
        this.includePaths = includePaths;
        return this;
    }

    public ChangeLogCustomizer setMakeWorkItemsRoots(boolean make) {
        this.makeWorkItemsRoots = make;
        return this;
    }

    public boolean shouldIncludePaths() {
        return this.includePaths;
    }

    public boolean shouldMakeWorkItemsRoots() {
        return this.makeWorkItemsRoots;
    }

    public ChangeLogCustomizer setIncludeChangeSets(boolean b) {
        this.includeChangeSets = b;
        return this;
    }

    public boolean shouldIncludeChangeSets() {
        return this.includeChangeSets;
    }

    public ChangeLogCustomizer setIncludeWorkItems(boolean includeWorkItems) {
        this.includeWorkItems = includeWorkItems;
        return this;
    }

    public boolean shouldIncludeWorkItems() {
        return this.includeWorkItems;
    }

    public boolean shouldIncludeBaselines() {
        return this.includeBaselines;
    }

    public boolean shouldIncludeDirection() {
        return this.includeDirection;
    }

    public ChangeLogCustomizer setIncludeDirection(boolean b) {
        this.includeDirection = b;
        return this;
    }

    public ChangeLogCustomizer setFlowsToInclude(FlowType f) {
        this.flowtype = f;
        return this;
    }

    public ChangeLogCustomizer setIncludeBaselines(boolean includeBaselines) {
        this.includeBaselines = includeBaselines;
        return this;
    }

    public boolean shouldIncludeContributors() {
        return this.includeContributors;
    }

    public ChangeLogCustomizer setIncludeContributors(boolean includeContributors) {
        this.includeContributors = includeContributors;
        return this;
    }

    public void postPruneFixup(ChangeLogEntryDTO root) {
        LinkedList<ChangeLogEntryDTO> todo = new LinkedList<ChangeLogEntryDTO>();
        todo.add(root);
        while (!todo.isEmpty()) {
            ChangeLogEntryDTO dto = (ChangeLogEntryDTO)todo.remove(0);
            this.fixupVersionableChildren(dto);
            todo.addAll(dto.getChildEntries());
        }
    }

    protected void fixupVersionableChildren(ChangeLogEntryDTO dto) {
        Iterator i = dto.getChildEntries().iterator();
        ArrayList<ChangeLogVersionableEntryDTO> versionables = null;
        while (i.hasNext()) {
            ChangeLogEntryDTO child = (ChangeLogEntryDTO)i.next();
            if (!"clentry_versionable".equals(child.getEntryType())) continue;
            if (versionables == null) {
                versionables = new ArrayList<ChangeLogVersionableEntryDTO>(dto.getChildEntries().size());
            }
            versionables.add((ChangeLogVersionableEntryDTO)child);
            i.remove();
        }
        if (versionables != null && versionables.size() > 0) {
            dto.getChildEntries().addAll(versionables);
        }
    }

    public boolean shouldIncludeIncoming() {
        return this.flowtype == FlowType.Incoming || this.flowtype == FlowType.Both;
    }

    public boolean shouldIncludeOutgoing() {
        return this.flowtype == FlowType.Outgoing || this.flowtype == FlowType.Both;
    }

    public String getWorkItemRerootDepth() {
        return this.workItemRerootDepth;
    }

    public ChangeLogCustomizer setWorkItemRerootDepth(String workItemRerootDepth) {
        this.workItemRerootDepth = workItemRerootDepth;
        return this;
    }

    public ChangeLogCustomizer setPruneUnchangedComponents(boolean p) {
        this.pruneUnchangedComponents = p;
        return this;
    }

    public boolean shouldPruneUnchangedComponents() {
        return this.pruneUnchangedComponents;
    }

    public ChangeLogCustomizer setPruneEmptyDirections(boolean b) {
        this.pruneEmptyDirections = b;
        return this;
    }

    public boolean shouldPruneEmptyDirections() {
        return this.pruneEmptyDirections;
    }
}

