/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal.changelog;

import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogBaselineEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogChangeSetEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogComponentEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogDirectionEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogWorkItemEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ContributorDTO;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.filesystem.rcp.core.internal.changelog.IChangeLogOutput;
import com.ibm.team.filesystem.rcp.core.internal.changelog.TypedChangeLogEntryVisitor;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseChangeLogEntryVisitor
extends TypedChangeLogEntryVisitor {
    private boolean showBaselineCreator = true;
    private boolean showChangeSetCreator = true;
    private String contribFormat = "{name} <{email}>";
    private String dateFormat = "yyyy/MM/dd";
    private boolean showBaselineCreationDate = true;
    private boolean showChangeSetCreationDate = true;
    private boolean showChangeSetWorkItem = false;
    private boolean showDirectionNodes = true;

    public boolean getShowBaselineCreator() {
        return this.showBaselineCreator;
    }

    public boolean getShowChangeSetCreator() {
        return this.showChangeSetCreator;
    }

    public String getContribFormat() {
        return this.contribFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public boolean getShowBaselineCreationDate() {
        return this.showBaselineCreationDate;
    }

    public boolean getShowChangeSetCreationDate() {
        return this.showChangeSetCreationDate;
    }

    public BaseChangeLogEntryVisitor() {
        super(null);
    }

    public void setOutput(IChangeLogOutput out) {
        this.out = out;
    }

    public static String sanitizeText(String str) {
        return ChangeSetLocationFactory.replaceLineEnding((String)str, (String)".");
    }

    protected String findComponentName(ChangeLogComponentEntryDTO dto) {
        return dto.getEntryName();
    }

    @Override
    public boolean enter(ChangeLogEntryDTO item) {
        if (this.shouldShow(item)) {
            return super.enter(item);
        }
        return true;
    }

    @Override
    public void exit(ChangeLogEntryDTO item) {
        if (this.shouldShow(item)) {
            super.exit(item);
        }
    }

    private boolean shouldShow(ChangeLogEntryDTO item) {
        if ("clentry_root".equals(item.getEntryType())) {
            return false;
        }
        if ("clentry_direction".equals(item.getEntryType())) {
            return this.getShowDirectionNodes();
        }
        return true;
    }

    @Override
    protected void visitDirection(ChangeLogEntryDTO parent, ChangeLogDirectionEntryDTO dto) {
        if (this.getShowDirectionNodes()) {
            String direction = Messages.BaseChangeLogEntryVisitor_INCOMING;
            if (!"incoming".equals(dto.getFlowDirection())) {
                direction = Messages.BaseChangeLogEntryVisitor_OUTGOING;
            }
            this.out.writeLine(direction);
        }
    }

    @Override
    protected void visitComponent(ChangeLogEntryDTO parent, ChangeLogComponentEntryDTO dto) {
        String output = "addComponent".equals(dto.getChangeType()) ? NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_COMPONENT_ADDED, (Object)this.findComponentName(dto)) : ("removeComponent".equals(dto.getChangeType()) ? NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_COMPONENT_REMOVED, (Object)this.findComponentName(dto)) : NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_COMPONENT, (Object)this.findComponentName(dto)));
        this.out.writeLine(output);
    }

    protected String findChangeSetName(ChangeLogChangeSetEntryDTO dto) {
        String comment = BaseChangeLogEntryVisitor.sanitizeText(dto.getEntryName());
        if (dto.getWorkItems().size() > 0) {
            String wiText = this.findMultiWorkItemName(dto.getWorkItems());
            comment = comment == null || "".equals(comment) ? wiText : NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_WORKITEM_TEXT_AND_CHANGESET_COMMENT, (Object)wiText, (Object)BaseChangeLogEntryVisitor.sanitizeText(comment));
        } else if (comment == null || "".equals(comment)) {
            comment = Messages.EclipseChangeLogEntryVisitor_MISSING_CHANGESET_COMMENT;
        }
        if (this.showChangeSetCreator && dto.getCreator() != null) {
            comment = NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_CHANGESET_AND_CREATOR, (Object)this.substituteName(dto.getCreator()), (Object)comment);
        }
        if (this.showChangeSetCreationDate && dto.getCreationDate() != null) {
            comment = NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_CHANGESET_AND_DATE, (Object)comment, (Object)this.substituteDate(dto.getCreationDate()));
        }
        return comment;
    }

    private String findMultiWorkItemName(List<ChangeLogWorkItemEntryDTO> list) {
        String numberBuf = Long.toString(list.get(0).getWorkItemNumber());
        int i = 1;
        while (i < list.size()) {
            numberBuf = NLS.bind((String)Messages.BaseChangeLogEntryVisitor_WORKITEM_LIST_GENERATOR, (Object)numberBuf, (Object)Long.toString(list.get(i).getWorkItemNumber()));
            ++i;
        }
        return NLS.bind((String)Messages.BaseChangeLogEntryVisitor_MULTIPLE_WORKITEM_NUMBERS_AND_SINGLE_NAME, (Object)numberBuf, (Object)list.get(0).getEntryName());
    }

    private String substitute(String format, Map<String, String> bindings) {
        StringBuffer output;
        block2: {
            output = new StringBuffer(80);
            int length = format.length();
            int start = -1;
            int end = length;
            while ((end = format.indexOf(123, start)) > -1) {
                output.append(format.substring(start + 1, end));
                start = format.indexOf(125, end);
                if (start > -1) {
                    String key = format.substring(end + 1, start);
                    String s = bindings.get(key);
                    if (s == null) continue;
                    output.append(s);
                    continue;
                }
                output.append(format.substring(end, length));
                break block2;
            }
            output.append(format.substring(start + 1, length));
        }
        return output.toString();
    }

    private String substituteName(ContributorDTO contrib) {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("userid", contrib.getUserId());
        bindings.put("name", contrib.getFullName());
        bindings.put("email", contrib.getEmailAddress());
        bindings.put("itemid", contrib.getContributorItemId());
        return this.substitute(this.getContribFormat(), bindings);
    }

    private String substituteDate(Timestamp time) {
        SimpleDateFormat formatter = new SimpleDateFormat(this.getDateFormat());
        return formatter.format(time);
    }

    @Override
    protected void visitChangeSet(ChangeLogEntryDTO parent, ChangeLogChangeSetEntryDTO dto) {
        this.out.writeLine(this.findChangeSetName(dto));
    }

    protected String findBaselineName(ChangeLogBaselineEntryDTO dto) {
        String name = dto.getEntryName();
        if (name == null || "".equals(name)) {
            name = Messages.EclipseChangeLogEntryVisitor_BASELINE_NAME_MISSING;
        }
        name = NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_BASELINE_NUMBER_NAME, (Object)dto.getBaselineId(), (Object)name);
        if (this.getShowBaselineCreator() && dto.getCreator() != null) {
            name = NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_BASELINE_NAME_CREATOR, (Object)name, (Object)this.substituteName(dto.getCreator()));
        }
        if (this.getShowBaselineCreationDate() && dto.getCreationDate() != null) {
            name = NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_BASELINE_NAME_DATE, (Object)name, (Object)this.substituteDate(dto.getCreationDate()));
        }
        return name;
    }

    @Override
    protected void visitBaseline(ChangeLogEntryDTO parent, ChangeLogBaselineEntryDTO dto) {
        this.out.writeLine(NLS.bind((String)Messages.EclipseChangeLogEntryVisitor_BASELINE_TITLE, (Object)this.findBaselineName(dto)));
    }

    @Override
    protected void visitVersionable(ChangeLogEntryDTO parent, ChangeLogVersionableEntryDTO dto) {
        this.out.writeLine(dto.getEntryName());
    }

    protected String findWorkItemName(ChangeLogWorkItemEntryDTO dto) {
        return NLS.bind((String)Messages.BaseChangeLogEntryVisitor_WORKITEM_NUMBER_AND_SUMMARY, (Object)dto.getWorkItemNumber(), (Object)dto.getEntryName());
    }

    @Override
    protected void visitWorkItem(ChangeLogEntryDTO parent, ChangeLogWorkItemEntryDTO dto, boolean inChangeSet) {
        if (!inChangeSet || this.showChangeSetWorkItem) {
            this.out.writeLine(this.findWorkItemName(dto));
        }
    }

    public void setShowBaselineCreator(boolean show) {
        this.showBaselineCreator = show;
    }

    public void setShowChangeSetCreator(boolean show) {
        this.showChangeSetCreator = show;
    }

    public void setContributorFormat(String text) {
        this.contribFormat = text;
    }

    public void setDateFormat(String text) {
        this.dateFormat = text;
    }

    public void setShowBaselineCreationDate(boolean show) {
        this.showBaselineCreationDate = show;
    }

    public void setShowChangeSetCreationDate(boolean show) {
        this.showChangeSetCreationDate = show;
    }

    public void setShowChangeSetWorkItems(boolean selection) {
        this.showChangeSetWorkItem = selection;
    }

    public boolean getShowDirectionNodes() {
        return this.showDirectionNodes;
    }

    public void setShowDirectionNodes(boolean showDirectionNodes) {
        this.showDirectionNodes = showDirectionNodes;
    }
}

