/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal;

import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.filesystem.rcp.core.internal.changes.ActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.externalcompare.ExternalCompareToolsUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.osgi.framework.BundleContext;

public class FileSystemResourcesPlugin
extends Plugin {
    public static final String ID = "com.ibm.team.filesystem.rcp.core";
    public static final String PROVIDER_ID = "com.ibm.team.filesystem.rcp.core.provider";
    public static final String SHOW_ALL_FLOW_TARGETS_PREFERENCE = "show_all_flow_targets";
    public static final boolean SHOW_ALL_FLOW_TARGETS_PREFERENCE_DEFAULT = false;
    public static final String HIDE_EMPTY_BASELINES_PREFERENCE = "hide_empty_baselines";
    public static final boolean HIDE_EMPTY_BASELINES_PREFERENCE_DEFAULT = false;
    public static final String MAX_CHANGES_PER_CHANGE_SET = "max_changes_per_change_set";
    public static final int MAX_CHANGES_PER_CHANGE_SET_DEFAULT = 1000;
    public static final String LOGICAL_MODEL_SUPPORT = "logical_model_support";
    public static final boolean LOGICAL_MODEL_SUPPORT_DEFAULT = false;
    public static final String BACKUP_IN_SHED_ENABLED = "backup_in_shed_enabled";
    public static final boolean BACKUP_IN_SHED_ENABLED_DEFAULT = false;
    public static final String BACKUP_IN_SHED_MAX_FILE_SIZE = "backup_in_shed_max_file_size";
    public static final int BACKUP_IN_SHED_MAX_FILE_SIZE_DEFAULT = 1;
    public static final String BACKUP_IN_SHED_LIFESPAN = "backup_in_shed_lifespan";
    public static final int BACKUP_IN_SHED_LIFESPAN_DEFAULT = 7;
    public static final String NON_ATOMIC_COMMIT_PREFERENCE = "non_atomic_commit";
    public static final String NON_ATOMIC_COMMIT_FILE_UPDATE_LIMIT_PREFERENCE = "non_atomic_commit_file_update_limit";
    public static final String AUTO_REFRESH_ENABLED = "autorefresh_enabled";
    public static final boolean AUTO_REFRESH_ENABLED_DEFAULT = false;
    private static FileSystemResourcesPlugin plugin;

    public FileSystemResourcesPlugin() {
        if (plugin != null) {
            throw new IllegalStateException("FileSystemResourcesPlugin is being instantiated twice.");
        }
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace();
    }

    public void stop(BundleContext context) throws Exception {
        ExternalCompareToolsUtil.stopAllThreads();
        super.stop(context);
        plugin = null;
    }

    public static FileSystemResourcesPlugin getDefault() {
        return plugin;
    }

    public static IActiveWorkspaceManager getActiveWorkspaceManager() {
        return ActiveWorkspaceManager.getInstance();
    }

    public static IComponentSyncModel getComponentSyncModel() {
        return ComponentSyncModel.getInstance();
    }

    public static void log(Throwable e) {
        FileSystemResourcesPlugin.getDefault().getLog().log(StatusUtil.newStatus((Object)FileSystemResourcesPlugin.getDefault().getBundle(), (Throwable)e));
    }

    public static void configureOperation(IFileSystemOperation operation) {
        Preferences prefStore = FileSystemResourcesPlugin.getDefault().getPluginPreferences();
        if (operation instanceof IRefreshingOperation) {
            ((IRefreshingOperation)operation).setRefreshBeforeRun(false);
        }
        if (operation instanceof ICheckinOptions) {
            boolean enabled = prefStore.getBoolean(NON_ATOMIC_COMMIT_PREFERENCE);
            if (enabled) {
                int numberUploads = prefStore.getInt(NON_ATOMIC_COMMIT_FILE_UPDATE_LIMIT_PREFERENCE);
                ((ICheckinOptions)operation).enableNonAtomicCommit(numberUploads);
            } else {
                ((ICheckinOptions)operation).disableNonAtomicCommit();
            }
        }
    }
}

