/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.internal.Messages;
import com.ibm.team.internal.repository.rcp.streams.InputStreamUtil;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStorageUtil {
    public static void copy(IFileStore destination, IFileStore source, IProgressMonitor monitor) throws FileSystemClientException {
        IFileInfo sourceInfo = source.fetchInfo();
        IFileInfo destInfo = destination.fetchInfo();
        if (destInfo.exists() && sourceInfo.isDirectory() != destInfo.isDirectory()) {
            throw new FileSystemClientException(StatusUtil.newStatus(FileStorageUtil.class, (String)NLS.bind((String)Messages.FileStorageUtil_0, (Object)source.toURI().toString())));
        }
        if (sourceInfo.isDirectory()) {
            try {
                destination.mkdir(0, null);
            }
            catch (CoreException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e));
            }
            List<IFileStore> children = FileStorageUtil.getChildren(source);
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)children.size());
            for (IFileStore child : children) {
                IFileStore targetChild = destination.getChild(child.getName());
                FileStorageUtil.copy(targetChild, child, (IProgressMonitor)progress.newChild(1));
            }
        } else {
            try {
                InputStream sourceContents = source.openInputStream(0, null);
                try {
                    OutputStream outputStream = destination.openOutputStream(0, null);
                    try {
                        InputStreamUtil.write((OutputStream)outputStream, (InputStream)sourceContents, (IProgressMonitor)monitor);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    sourceContents.close();
                }
            }
            catch (IOException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e));
            }
        }
    }

    public static List<IFileStore> getChildren(IFileStore subtree) throws FileSystemClientException {
        try {
            return Arrays.asList(subtree.childStores(0, null));
        }
        catch (CoreException e) {
            throw new FileSystemClientException(e.getStatus());
        }
    }

    public static Map<String, IFileStore> getChildMap(IFileStore subtree) throws FileSystemClientException {
        HashMap<String, IFileStore> result = new HashMap<String, IFileStore>();
        for (IFileStore next : FileStorageUtil.getChildren(subtree)) {
            result.put(NullUtil.safeString((String)next.getName()), next);
        }
        return result;
    }

    public static void createFolder(IFileStorage theFile, ItemId<IFolder> itemId, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (itemId.isNull()) {
                theFile.create(false, (IProgressMonitor)progress.newChild(100));
                return;
            }
            SharingManager sharingManager = SharingManager.getInstance();
            itemId = new ItemId(IFolder.ITEM_TYPE, itemId.getItemUUID());
            Shareable shareable = theFile.getShareable();
            if (shareable.getShare((IProgressMonitor)progress.newChild(33)) == null) {
                theFile.create(false, (IProgressMonitor)progress.newChild(67));
                return;
            }
            Set<IShareable> existingSharables = null;
            try {
                existingSharables = CoreShareablesUtil.findShareables(itemId, (IProgressMonitor)progress.newChild(33));
            }
            catch (TeamRepositoryException e1) {
                StatusUtil.log((IStatus)StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e1));
            }
            if (existingSharables == null || !existingSharables.isEmpty()) {
                theFile.create(false, (IProgressMonitor)progress.newChild(34));
                return;
            }
            try {
                sharingManager.restoreFolder((IShareable)shareable, (IFolderHandle)itemId.toHandle(), (IProgressMonitor)progress.newChild(33));
            }
            catch (FileSystemClientException fileSystemClientException) {
                theFile.create(false, (IProgressMonitor)progress.newChild(1));
            }
        }
        catch (CoreException e) {
            throw new FileSystemClientException(StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e));
        }
    }

    public static void createFile(IFileStorage theFile, InputStream fileContents, ItemId<IVersionable> itemId, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (itemId.isNull()) {
            try {
                theFile.create(fileContents, monitor);
            }
            catch (CoreException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e));
            }
            return;
        }
        SharingManager sharingManager = SharingManager.getInstance();
        Shareable shareable = theFile.getShareable();
        try {
            if (shareable.getShare((IProgressMonitor)progress.newChild(33)) == null) {
                theFile.create(fileContents, (IProgressMonitor)progress.newChild(67));
                return;
            }
            Set<IShareable> existingSharables = null;
            try {
                existingSharables = CoreShareablesUtil.findShareables(itemId, (IProgressMonitor)progress.newChild(33));
            }
            catch (TeamRepositoryException e1) {
                StatusUtil.log((IStatus)StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e1));
            }
            if (existingSharables == null || !existingSharables.isEmpty()) {
                theFile.create(fileContents, (IProgressMonitor)progress.newChild(34));
                return;
            }
            try {
                sharingManager.restoreFile((IShareable)shareable, fileContents, (IVersionableHandle)itemId.toHandle(), (IProgressMonitor)progress.newChild(33));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                theFile.create(fileContents, (IProgressMonitor)progress.newChild(1));
            }
        }
        catch (IOException e) {
            throw new FileSystemClientException(StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e));
        }
    }

    public static void createLink(IFileStorage storage, String target, ItemId itemId, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (itemId.isNull()) {
            try {
                storage.create(target, monitor);
            }
            catch (CoreException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e));
            }
            return;
        }
        SharingManager sharingManager = SharingManager.getInstance();
        Shareable shareable = storage.getShareable();
        if (shareable.getShare((IProgressMonitor)progress.newChild(33)) == null) {
            storage.create(target, (IProgressMonitor)progress.newChild(67));
            return;
        }
        Set<IShareable> existingSharables = null;
        try {
            existingSharables = CoreShareablesUtil.findShareables(itemId, (IProgressMonitor)progress.newChild(33));
        }
        catch (TeamRepositoryException e1) {
            StatusUtil.log((IStatus)StatusUtil.newStatus(FileStorageUtil.class, (Throwable)e1));
        }
        if (existingSharables == null || !existingSharables.isEmpty()) {
            storage.create(target, (IProgressMonitor)progress.newChild(34));
            return;
        }
        try {
            sharingManager.restoreLink((IShareable)shareable, target, (ISymbolicLinkHandle)itemId.toHandle(), (IProgressMonitor)progress.newChild(33));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            storage.create(target, (IProgressMonitor)progress.newChild(1));
        }
    }
}

