/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.core.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileStorageUtil;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreShareablesUtil {
    public static VersionablePath getPathTo(IResource resource, IProgressMonitor monitor) throws FileSystemClientException {
        return CoreShareablesUtil.getPathTo(resource, true, monitor);
    }

    public static VersionablePath getPathTo(IResource resource, boolean stopAtFirstMissingSegment, IProgressMonitor monitor) throws FileSystemClientException {
        LinkedList<VersionablePathSegment> segments = new LinkedList<VersionablePathSegment>();
        boolean resolved = true;
        IResource current = resource;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SubMonitor subProgress = progress.newChild(50).setWorkRemaining(current.getFullPath().segmentCount());
        while (current.getParent() != null && !(current instanceof IWorkspaceRoot)) {
            VersionablePathSegment nextSegment = CoreShareablesUtil.getSegment(current, (IProgressMonitor)subProgress.newChild(1));
            if (!(current instanceof IProject) && nextSegment.getParent().isNull() && stopAtFirstMissingSegment) {
                resolved = false;
                break;
            }
            segments.addFirst(nextSegment);
            current = current.getParent();
        }
        return VersionablePath.create(segments, CoreShareablesUtil.getSiloedItem(resource, (IProgressMonitor)progress.newChild(50)), (boolean)false, (boolean)resolved);
    }

    public static VersionablePath getPathTo(IShareable shareable, boolean stopAtFirstMissingSegment, IProgressMonitor monitor) throws FileSystemClientException {
        LinkedList<VersionablePathSegment> segments = new LinkedList<VersionablePathSegment>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean resolved = true;
        IShareable current = shareable;
        SubMonitor subProgress = progress.newChild(50).setWorkRemaining(current == null ? 0 : current.getLocalPath().segmentCount());
        while (current != null && current.getLocalPath().segmentCount() > 0) {
            IShareable parent = CoreShareablesUtil.getParent(current);
            VersionablePathSegment nextSegment = CoreShareablesUtil.getSegment(current, (IProgressMonitor)subProgress.newChild(1));
            segments.addFirst(nextSegment);
            if (current.getLocalPath().segmentCount() != 1 && nextSegment.getParent().isNull() && stopAtFirstMissingSegment) {
                resolved = false;
                break;
            }
            current = parent;
        }
        return VersionablePath.create(segments, CoreShareablesUtil.getSiloedItem(shareable, (IProgressMonitor)progress.newChild(50)), (boolean)false, (boolean)resolved);
    }

    public static IShareable getParent(IShareable shareable) {
        if (shareable.getLocalPath().segmentCount() <= 1) {
            return null;
        }
        return new Shareable(shareable.getSandbox(), shareable.getLocalPath().removeLastSegments(1), ResourceType.FOLDER);
    }

    public static VersionablePathSegment getSegment(IShareable sharable, IProgressMonitor monitor) throws FileSystemClientException {
        ItemId parent;
        IShareable parentShareable = CoreShareablesUtil.getParent(sharable);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (parentShareable == null || parentShareable.getVersionable((IProgressMonitor)progress.newChild(50)) == null) {
            parent = ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
        } else {
            progress.setWorkRemaining(50);
            parent = CoreShareablesUtil.getItem(parentShareable, (IProgressMonitor)progress.newChild(50));
        }
        return VersionablePathSegment.create((ItemId)parent, (String)sharable.getLocalPath().lastSegment());
    }

    public static VersionablePathSegment getSegment(IResource resource, IProgressMonitor monitor) throws FileSystemClientException {
        ItemId parent = CoreShareablesUtil.getItem((IResource)resource.getParent(), monitor);
        if (resource instanceof IProject) {
            parent = ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE);
        }
        return VersionablePathSegment.create((ItemId)parent, (String)resource.getName());
    }

    public static IResource getResourceFor(VersionablePath desiredPath, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(desiredPath.segmentCount() + 1));
        SiloedItemId itemId = desiredPath.getSiloedItemId();
        IResource res = CoreShareablesUtil.getResourceFor((SiloedItemId<IVersionable>)itemId, (IProgressMonitor)progress.newChild(1));
        if (res != null) {
            return res;
        }
        Path suffix = new Path("");
        int idx = desiredPath.segmentCount() - 1;
        while (idx >= 0) {
            VersionablePathSegment segment = desiredPath.segment(idx);
            suffix = new Path(segment.getName()).append((IPath)suffix);
            ItemId parent = ItemId.upcast((ItemId)segment.getParent());
            res = CoreShareablesUtil.getResourceFor((SiloedItemId<IVersionable>)SiloedItemId.create((ItemId)parent, (ItemId)desiredPath.getSiloedItemId().getComponent()), (IProgressMonitor)progress.newChild(1));
            if (res != null) {
                return ResourceUtil.getResource(res.getFullPath().append((IPath)suffix));
            }
            --idx;
        }
        return ResourceUtil.getResource(desiredPath.toPath());
    }

    public static Collection<IShareable> getShareablesFor(VersionablePath desiredPath, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * desiredPath.segmentCount() + 1));
        SiloedItemId itemId = desiredPath.getSiloedItemId();
        Collection<IShareable> shareables = CoreShareablesUtil.getShareablesFor((SiloedItemId<IVersionable>)itemId, (IProgressMonitor)progress.newChild(1));
        if (!shareables.isEmpty()) {
            return shareables;
        }
        ResourceType typeHint = ResourceType.getResourceType((IVersionableHandle)itemId.toHandle());
        Path suffix = new Path("");
        int idx = desiredPath.segmentCount() - 1;
        while (idx >= 0) {
            VersionablePathSegment segment = desiredPath.segment(idx);
            suffix = new Path(segment.getName()).append((IPath)suffix);
            ItemId parent = ItemId.upcast((ItemId)segment.getParent());
            shareables = CoreShareablesUtil.getShareablesFor((SiloedItemId<IVersionable>)SiloedItemId.create((ItemId)parent, (ItemId)desiredPath.getSiloedItemId().getComponent()), (IProgressMonitor)progress.newChild(1));
            if (!shareables.isEmpty()) {
                ArrayList<IShareable> result = new ArrayList<IShareable>();
                for (IShareable shareable : shareables) {
                    result.add(CoreShareablesUtil.getShareable(shareable, (IPath)suffix, typeHint, (IProgressMonitor)progress.newChild(1)));
                }
                return result;
            }
            --idx;
        }
        return Collections.emptySet();
    }

    public static IShareable getShareableFor(VersionablePath desiredPath, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * desiredPath.segmentCount() + 1));
        SiloedItemId itemId = desiredPath.getSiloedItemId();
        Collection<IShareable> shareables = CoreShareablesUtil.getShareablesFor((SiloedItemId<IVersionable>)itemId, (IProgressMonitor)progress.newChild(1));
        IShareable shareable = CoreShareablesUtil.pickAShareable(shareables);
        if (shareable != null) {
            return shareable;
        }
        ResourceType typeHint = ResourceType.FOLDER;
        if (itemId.getItemType() == IFolder.ITEM_TYPE) {
            typeHint = ResourceType.FILE;
        } else if (itemId.getItemType() == ISymbolicLink.ITEM_TYPE) {
            typeHint = ResourceType.SYMBOLIC_LINK;
        }
        Path suffix = new Path("");
        int idx = desiredPath.segmentCount() - 1;
        while (idx >= 0) {
            VersionablePathSegment segment = desiredPath.segment(idx);
            suffix = new Path(segment.getName()).append((IPath)suffix);
            ItemId parent = ItemId.upcast((ItemId)segment.getParent());
            shareables = CoreShareablesUtil.getShareablesFor((SiloedItemId<IVersionable>)SiloedItemId.create((ItemId)parent, (ItemId)desiredPath.getSiloedItemId().getComponent()), (IProgressMonitor)progress.newChild(1));
            shareable = CoreShareablesUtil.pickAShareable(shareables);
            if (shareable != null) {
                return CoreShareablesUtil.getShareable(shareable, (IPath)suffix, typeHint, (IProgressMonitor)progress.newChild(1));
            }
            --idx;
        }
        return null;
    }

    private static IShareable pickAShareable(Collection<IShareable> shareables) {
        if (!shareables.isEmpty()) {
            for (IShareable next : shareables) {
                IResource resource = (IResource)next.getAdapter(IResource.class);
                if (resource == null) continue;
                return next;
            }
            return shareables.iterator().next();
        }
        return null;
    }

    private static IShareable getShareable(IShareable shareable, IPath suffix, ResourceType typeHint, IProgressMonitor monitor) throws FileSystemClientException {
        IFileStorage file = CoreShareablesUtil.getFileStorage(shareable);
        IFileStorage child = file.getChild(suffix.toString(), monitor);
        if (child != null) {
            return child.getShareable();
        }
        return ((SharingManager)FileSystemCore.getSharingManager()).findShareable(shareable.getSandbox(), shareable.getLocalPath().append(suffix), typeHint);
    }

    public static Map<SiloedItemId<IVersionable>, Collection<IShareable>> findShareables(Collection<SiloedItemId<IVersionable>> toFind, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toFind.size());
        HashMap itemsByComponent = new HashMap();
        for (SiloedItemId<IVersionable> next : toFind) {
            CollectionUtil.addToMapOfLists(itemsByComponent, (Object)next.getComponent(), next);
        }
        HashMap<SiloedItemId<IVersionable>, Collection<IShareable>> result = new HashMap<SiloedItemId<IVersionable>, Collection<IShareable>>();
        for (Map.Entry next : itemsByComponent.entrySet()) {
            for (SiloedItemId nextItem : (List)next.getValue()) {
                result.put((SiloedItemId<IVersionable>)nextItem, CoreShareablesUtil.findShareables((SiloedItemId<IVersionable>)nextItem, (IProgressMonitor)progress.newChild(1)));
            }
        }
        return result;
    }

    public static Collection<IShareable> findShareables(SiloedItemId<IVersionable> versionable, IProgressMonitor monitor) throws TeamRepositoryException {
        ISharingManager mgr = FileSystemCore.getSharingManager();
        try {
            if (versionable.isUntyped()) {
                Collection shareables = mgr.findShareables(versionable.getComponentHandle(), versionable.toHandle(IFileItem.ITEM_TYPE), monitor);
                if (!shareables.isEmpty()) {
                    return shareables;
                }
                return mgr.findShareables(versionable.getComponentHandle(), versionable.toHandle(IFolder.ITEM_TYPE), monitor);
            }
            return mgr.findShareables(versionable.getComponentHandle(), versionable.toHandle(), monitor);
        }
        catch (FileSystemClientException e) {
            throw new TeamRepositoryException(e.getMessage(), StatusUtil.getCause((Throwable)e));
        }
    }

    public static ItemId<IVersionable> getItem(IResource resource, IProgressMonitor monitor) throws FileSystemClientException {
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        return CoreShareablesUtil.getItem(shareable, monitor);
    }

    public static SiloedItemId<IVersionable> getSiloedItem(IResource resource, IProgressMonitor monitor) throws FileSystemClientException {
        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
        return CoreShareablesUtil.getSiloedItem(shareable, monitor);
    }

    public static SiloedItemId<IVersionable> getSiloedItem(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        if (shareable == null) {
            return SiloedItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IShare share = shareable.getShare((IProgressMonitor)progress.newChild(50));
        if (share == null) {
            return SiloedItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE);
        }
        return SiloedItemId.create((ItemId)CoreShareablesUtil.getItem(shareable, (IProgressMonitor)progress.newChild(50)), CoreShareablesUtil.getComponent(share.getSharingDescriptor()));
    }

    public static ItemId getItem(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        if (shareable == null) {
            return ItemId.getNullItem((IItemType)IFileItem.ITEM_TYPE);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
        IItemType itemType = type == ResourceType.FOLDER ? IFolder.ITEM_TYPE : (type == ResourceType.FILE ? IFileItem.ITEM_TYPE : (type == ResourceType.SYMBOLIC_LINK ? ISymbolicLink.ITEM_TYPE : IFileItem.ITEM_TYPE));
        IVersionableHandle remote = shareable.getVersionable((IProgressMonitor)progress.newChild(1));
        if (remote == null) {
            return ItemId.getNullItem((IItemType)itemType);
        }
        return new ItemId((IItemHandle)remote);
    }

    public static IResource getResourceFor(SiloedItemId<IVersionable> ver, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (ver.isNull()) {
            return null;
        }
        Collection<IShareable> shareables = CoreShareablesUtil.findShareables(ver, (IProgressMonitor)progress.newChild(50));
        for (IShareable next : shareables) {
            IResource resource = (IResource)next.getAdapter(IResource.class);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private static Collection<IShareable> getShareablesFor(SiloedItemId<IVersionable> itemId, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (itemId.isNull()) {
            return Collections.emptySet();
        }
        return CoreShareablesUtil.findShareables(itemId, (IProgressMonitor)progress.newChild(50));
    }

    public static ItemId<IComponent> getComponent(ISharingDescriptor sharingDescriptor) {
        return ItemUtil.getComponent((IComponentHandle)sharingDescriptor.getComponent());
    }

    public static ItemId<IComponent> getComponent(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        ISharingDescriptor descriptor;
        IShare share;
        if (shareable != null && (share = shareable.getShare(monitor)) != null && (descriptor = share.getSharingDescriptor()) != null) {
            return CoreShareablesUtil.getComponent(descriptor);
        }
        return ItemId.getNullItem((IItemType)IComponent.ITEM_TYPE);
    }

    public static ItemId<IComponent> getComponent(ILocalChange next) {
        return new ItemId((IItemHandle)next.getComponent());
    }

    public static SiloedItemId<IVersionable> getSiloedItem(ILocalChange next) {
        return SiloedItemId.create((IVersionableHandle)next.getTarget(), (IComponentHandle)next.getComponent());
    }

    public static StateId getBeforeState(ILocalChange next) {
        IVersionableHandle itemHandle = next.getTarget();
        if ((next.getType() & 2) != 0) {
            return new StateId(itemHandle.getItemType(), itemHandle.getItemId(), StateId.STATE_DELETED);
        }
        return new StateId((IItemHandle)itemHandle);
    }

    public static Map<ItemNamespace, List<IShareable>> groupByContributorPlace(Collection<IShareable> shareables, IProgressMonitor monitor) throws FileSystemClientException {
        HashMap resultMap = NewCollection.hashMap();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        for (IShareable next : shareables) {
            ItemNamespace nextNamespace = CoreShareablesUtil.getContributorPlace(next, (IProgressMonitor)progress.newChild(1));
            if (nextNamespace == null) continue;
            CollectionUtil.addToMapOfLists((Map)resultMap, (Object)nextNamespace, (Object)next);
        }
        return resultMap;
    }

    public static ItemNamespace getContributorPlace(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        ISharingDescriptor sd;
        IShare share = shareable.getShare(monitor);
        if (share != null && (sd = share.getSharingDescriptor()) != null) {
            return CoreShareablesUtil.getNamespace(sd);
        }
        return null;
    }

    public static Set<ItemNamespace> findDescriptors(ItemNamespace namespace, boolean workspacesOnly, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ISharingManager mgr = FileSystemCore.getSharingManager();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList allDescriptors = NewCollection.arrayList();
        IShare[] shares = mgr.allShares((IProgressMonitor)progress.newChild(20));
        int i = 0;
        while (i < shares.length) {
            IShare share = shares[i];
            ISharingDescriptor descriptor = share.getSharingDescriptor();
            if (!workspacesOnly || descriptor.associatedWithWorkspace()) {
                allDescriptors.add(CoreShareablesUtil.getNamespace(descriptor));
            }
            ++i;
        }
        return CoreShareablesUtil.findBestDescriptors(allDescriptors, namespace, (IProgressMonitor)progress.newChild(80));
    }

    public static Set<ItemNamespace> findBestDescriptors(Collection<ItemNamespace> potentialDescriptors, ItemNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashSet exactMatches = NewCollection.hashSet();
        HashSet potentialMatches = NewCollection.hashSet();
        ItemId targetComponent = namespace.fetchComponentId(monitor);
        progress.setWorkRemaining(potentialDescriptors.size());
        for (ItemNamespace descriptor : potentialDescriptors) {
            SubMonitor iterationProgress = progress.newChild(1);
            if (descriptor.equals((Object)namespace)) {
                exactMatches.add(descriptor);
                continue;
            }
            ItemId nextComponent = descriptor.fetchComponentId((IProgressMonitor)iterationProgress);
            if (!nextComponent.equals((Object)targetComponent)) continue;
            potentialMatches.add(descriptor);
        }
        if (!exactMatches.isEmpty()) {
            return exactMatches;
        }
        return potentialMatches;
    }

    public static Set<ItemNamespace> getSharingDescriptors(Collection<IShareable> shareables, IProgressMonitor monitor) throws FileSystemClientException {
        HashSet result = NewCollection.hashSet();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)shareables.size());
        for (IShareable next : shareables) {
            result.add(CoreShareablesUtil.getNamespace(next.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor()));
        }
        return result;
    }

    public static Set<IShareable> getShareablesFor(Collection<IShareable> inputShareables, Set<ItemNamespace> descriptors, IProgressMonitor monitor) throws FileSystemClientException {
        HashSet result = NewCollection.hashSet();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)inputShareables.size());
        for (IShareable next : inputShareables) {
            ItemNamespace namespace = CoreShareablesUtil.getNamespace(next.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor());
            if (!descriptors.contains(namespace)) continue;
            result.add(next);
        }
        return result;
    }

    public static Set<IShareable> findShareables(ItemId versionable, ItemNamespace namespace, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISharingManager mgr = FileSystemCore.getSharingManager();
        Collection shareables = mgr.findShareables((IVersionableHandle)versionable.toHandle(), (IProgressMonitor)progress.newChild(25));
        if (shareables.size() == 1) {
            HashSet result = NewCollection.hashSet();
            result.addAll(shareables);
            return result;
        }
        Set<ItemNamespace> descriptors = CoreShareablesUtil.getSharingDescriptors(shareables, (IProgressMonitor)progress.newChild(25));
        Set<ItemNamespace> bestMatches = CoreShareablesUtil.findBestDescriptors(descriptors, namespace, (IProgressMonitor)progress.newChild(25));
        return CoreShareablesUtil.getShareablesFor(shareables, bestMatches, (IProgressMonitor)progress.newChild(25));
    }

    public static Set<IShareable> findShareables(ItemId versionable, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISharingManager mgr = FileSystemCore.getSharingManager();
        Collection shareables = mgr.findShareables((IVersionableHandle)versionable.toHandle(), (IProgressMonitor)progress.newChild(50));
        HashSet result = NewCollection.hashSet();
        result.addAll(shareables);
        return result;
    }

    public static Set<IShareable> findShareables(IContextHandle contextHandle, IComponentHandle componentHandle, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        ISharingManager mgr = FileSystemCore.getSharingManager();
        Collection shareables = mgr.findShareables(contextHandle, componentHandle, versionable, monitor);
        HashSet result = NewCollection.hashSet();
        result.addAll(shareables);
        return result;
    }

    public static List<ILocalChange> getLocalChanges(ISandbox sandbox, ItemNamespace namespace, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        IContextHandle contextHandle = namespace.getContextHandle();
        SharingManager sharingManager = SharingManager.getInstance();
        ILocalChangeManager localChangeManager = sharingManager.getLocalChangeManager();
        if (contextHandle == null) {
            return Collections.emptyList();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IComponentHandle ch = (IComponentHandle)namespace.fetchComponentId((IProgressMonitor)progress.newChild(50)).toHandle();
        if (refresh) {
            localChangeManager.syncPendingChanges(contextHandle, ch, sandbox, (IProgressMonitor)progress.newChild(50));
        }
        ILocalChange[] array = localChangeManager.getPendingChanges(contextHandle, ch, sandbox);
        ArrayList result = NewCollection.arrayList();
        int i = 0;
        while (i < array.length) {
            ILocalChange localChange = array[i];
            result.add(localChange);
            ++i;
        }
        return result;
    }

    public static ItemNamespace getNamespace(ISharingDescriptor descriptor) {
        ITeamRepository repository = CoreShareablesUtil.getRepository(descriptor);
        if (descriptor.associatedWithWorkspace()) {
            ItemId workspace = new ItemId((IItemHandle)((IWorkspaceHandle)descriptor.getConnectionHandle()));
            ItemId component = new ItemId((IItemHandle)descriptor.getComponent());
            return WorkspaceNamespace.create((ITeamRepository)repository, (ItemId)workspace, (ItemId)component);
        }
        ItemId baseline = new ItemId((IItemHandle)((IBaselineHandle)descriptor.getConnectionHandle()));
        return BaselineNamespace.create((ITeamRepository)repository, (ItemId)baseline);
    }

    public static ITeamRepository getRepository(ISharingDescriptor descr) {
        return RepositoryUtils.getTeamRepository((String)descr.getRepositoryUri(), (UUID)descr.getRepositoryId());
    }

    public static void createFile(IFile theFile, IInputStreamProvider fileContents, VersionablePath verPath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            InputStream theStream = fileContents.getInputStream((IProgressMonitor)progress.newChild(5));
            try {
                CoreShareablesUtil.createFile(theFile, theStream, verPath, (IProgressMonitor)progress.newChild(95));
            }
            finally {
                theStream.close();
            }
        }
        catch (IOException e) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e));
        }
    }

    public static void createFile(IFile theFile, InputStream fileContents, VersionablePath verPath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            CoreShareablesUtil.createFolder(theFile.getParent(), verPath.removeLastSegment(), (IProgressMonitor)progress.newChild(20));
        }
        catch (CoreException e1) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e1));
        }
        IPath fullPath = theFile.getFullPath();
        if (fullPath.lastSegment().equals(".project") && fullPath.segmentCount() == 2 && theFile.exists()) {
            try {
                theFile.delete(true, (IProgressMonitor)progress.newChild(50));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e));
            }
            progress.setWorkRemaining(100);
        }
        ItemId itemId = verPath.getItemId();
        IShareable shareable = (IShareable)theFile.getAdapter(IShareable.class);
        if (shareable == null) {
            try {
                theFile.create(fileContents, false, (IProgressMonitor)progress.newChild(80));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor((Throwable)e));
            }
        } else {
            FileStorageUtil.createFile(((Shareable)shareable).getFileStorage(), fileContents, (ItemId<IVersionable>)itemId, (IProgressMonitor)progress.newChild(80));
        }
    }

    public static void createFolder(IContainer theFolder, VersionablePath path, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (theFolder.exists()) {
            return;
        }
        try {
            if (!(theFolder instanceof org.eclipse.core.resources.IFolder)) {
                ResourceUtil.createPath(theFolder, (IProgressMonitor)progress.newChild(100));
                return;
            }
            CoreShareablesUtil.createFolder(theFolder.getParent(), path.removeLastSegment(), (IProgressMonitor)progress.newChild(50));
            ItemId itemId = path.getItemId();
            if (theFolder instanceof org.eclipse.core.resources.IFolder && !itemId.isNull()) {
                IShareable shareable = (IShareable)theFolder.getAdapter(IShareable.class);
                if (shareable == null) {
                    ResourceUtil.createPath(theFolder, (IProgressMonitor)progress.newChild(100));
                } else {
                    FileStorageUtil.createFolder(((Shareable)shareable).getFileStorage(), (ItemId<IFolder>)itemId, (IProgressMonitor)progress.newChild(50));
                }
            } else {
                ResourceUtil.createPath(theFolder, (IProgressMonitor)progress.newChild(100));
            }
        }
        catch (CoreException e) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e));
        }
    }

    public static void createFile(IFileStorage theFile, InputStream fileContents, VersionablePath verPath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IFileStorage parent = CoreShareablesUtil.getParent(theFile);
            CoreShareablesUtil.createFolder(parent, verPath.removeLastSegment(), (IProgressMonitor)progress.newChild(20));
        }
        catch (CoreException e1) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e1));
        }
        ItemId itemId = verPath.getItemId();
        FileStorageUtil.createFile(theFile, fileContents, (ItemId<IVersionable>)itemId, (IProgressMonitor)progress.newChild(80));
    }

    public static void createLink(IFileStorage storage, String target, VersionablePath versionablePath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IFileStorage parent = CoreShareablesUtil.getParent(storage);
            CoreShareablesUtil.createFolder(parent, versionablePath.removeLastSegment(), (IProgressMonitor)progress.newChild(20));
        }
        catch (CoreException e1) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e1));
        }
        ItemId itemId = versionablePath.getItemId();
        FileStorageUtil.createLink(storage, target, itemId, (IProgressMonitor)progress.newChild(80));
    }

    public static void createFile(IFileStorage fileStorage, IInputStreamProvider fileContents, VersionablePath verPath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            InputStream theStream = fileContents.getInputStream((IProgressMonitor)progress.newChild(5));
            try {
                CoreShareablesUtil.createFile(fileStorage, theStream, verPath, (IProgressMonitor)progress.newChild(95));
            }
            finally {
                theStream.close();
            }
        }
        catch (IOException e) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e));
        }
    }

    public static void createFolder(IFileStorage theFolder, VersionablePath path, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (theFolder.exists((IProgressMonitor)progress.newChild(25))) {
            return;
        }
        try {
            ItemId itemId;
            IFileStorage parent = CoreShareablesUtil.getParent(theFolder);
            if (parent != null) {
                CoreShareablesUtil.createFolder(parent, path.removeLastSegment(), (IProgressMonitor)progress.newChild(25));
            }
            if (!(itemId = path.getItemId()).isNull()) {
                FileStorageUtil.createFolder(theFolder, (ItemId<IFolder>)itemId, (IProgressMonitor)progress.newChild(50));
            } else {
                theFolder.create(true, (IProgressMonitor)progress.newChild(50));
            }
        }
        catch (CoreException e) {
            throw new FileSystemClientException(StatusUtil.newStatus(CoreShareablesUtil.class, (Throwable)e));
        }
    }

    private static IFileStorage getParent(IFileStorage fileStorage) {
        IShareable parent;
        Shareable shareable = fileStorage.getShareable();
        if (shareable != null && (parent = shareable.getParent()) != null) {
            return CoreShareablesUtil.getFileStorage(parent);
        }
        return null;
    }

    public static IFileStorage getFileStorage(IShareable shareable) {
        return ((Shareable)shareable).getFileStorage();
    }
}

