/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ui.internal.editor;

import com.ibm.team.ui.editor.ITeamFormConfiguration;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.internal.editor.TeamFormConfiguration;
import com.ibm.team.ui.internal.editor.TeamFormData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TeamFormLayout
implements ITeamFormLayout {
    private static final String LAYOUT_KEY = String.valueOf(TeamFormLayout.class.getName()) + "_layout";
    private static final String NULL_GUIDE = String.valueOf(TeamFormLayout.class.getName()) + "_null";
    private Composite fContainer;
    private TeamFormConfiguration fConfiguration;
    private List<InternalGuide> fHorizGuides = new ArrayList<InternalGuide>();
    private Map<String, Integer> fHorizGuideIndices = new HashMap<String, Integer>();
    private int fLastHorizIndex = Integer.MAX_VALUE;
    private List<InternalGuide> fVertGuides = new ArrayList<InternalGuide>();

    public static ITeamFormLayout createLayout(Composite composite, ITeamFormConfiguration configuration) {
        return new TeamFormLayout(composite, (TeamFormConfiguration)configuration);
    }

    public static ITeamFormLayout getLayout(Composite composite) {
        Object data = composite.getData(LAYOUT_KEY);
        if (data instanceof ITeamFormLayout) {
            return (ITeamFormLayout)data;
        }
        return null;
    }

    private TeamFormLayout(Composite container, TeamFormConfiguration configuration) {
        this.fContainer = container;
        this.fConfiguration = configuration;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setData(LAYOUT_KEY, (Object)this);
    }

    public void fill(Control control, boolean stretchHorizontally, boolean stretchVertically) {
        Assert.isTrue((this.fContainer == control.getParent() ? 1 : 0) != 0);
        this.add(control, NULL_GUIDE, new TeamFormData(new GridData(4, 4, stretchHorizontally, stretchVertically)));
    }

    public void add(Control control, String guideId, ITeamFormData layoutData) {
        TeamFormLayouts.setLayoutData(control, layoutData);
        this.add(control, guideId);
    }

    public void add(Control control, String guideId) {
        Integer index;
        Assert.isTrue((this.fContainer == control.getParent() ? 1 : 0) != 0);
        TeamFormData layoutData = (TeamFormData)TeamFormLayouts.getLayoutData(control);
        if (layoutData == null) {
            layoutData = (TeamFormData)ITeamFormData.SINGLE_LINE_FIXED;
            TeamFormLayouts.setLayoutData(control, layoutData);
        }
        if (this.fConfiguration.isHorizontal()) {
            index = this.fLastHorizIndex == Integer.MAX_VALUE ? Integer.valueOf(0) : Integer.valueOf(this.fLastHorizIndex + 1);
            this.addGuide(guideId, index);
        } else {
            index = this.fHorizGuideIndices.get(guideId);
            if (index == null) {
                index = NULL_GUIDE.equals(guideId) ? Integer.valueOf(0) : Integer.valueOf(this.fConfiguration.getIndex(guideId));
                if (index == -1) {
                    index = this.fHorizGuides.size();
                }
                this.addGuide(guideId, index);
            }
        }
        if (index <= this.fLastHorizIndex && index > 0) {
            Label filler = new Label(this.fContainer, 0);
            filler.setVisible(false);
            filler.moveAbove(control);
            this.add((Control)filler, NULL_GUIDE, ITeamFormData.SINGLE_LINE_FIXED);
        }
        if (index > this.fLastHorizIndex) {
            InternalGuide last = this.fHorizGuides.get(this.fLastHorizIndex);
            List<Control> controls = last.getControls();
            Control lastControl = (Control)controls.get(controls.size() - 1);
            Assert.isNotNull((Object)lastControl);
            ((GridData)lastControl.getLayoutData()).horizontalSpan = index - this.fLastHorizIndex;
        } else {
            for (InternalGuide guide : this.fHorizGuides) {
                guide.addCell();
            }
            this.fVertGuides.add(new InternalGuide(0, false));
        }
        GridData data = layoutData.getGridData();
        control.setLayoutData((Object)data);
        InternalGuide horizGuide = this.fHorizGuides.get(index);
        horizGuide.putControl(control, layoutData);
        InternalGuide vertGuide = this.fVertGuides.get(this.fVertGuides.size() - 1);
        vertGuide.addCell();
        vertGuide.putControl(control, layoutData);
        data.horizontalSpan = this.fHorizGuides.size() - index;
        this.fLastHorizIndex = index;
    }

    private void addGuide(String guideId, int index) {
        this.fHorizGuideIndices.put(guideId, index);
        int columns = index + 1;
        if (columns > this.fHorizGuides.size()) {
            int rows = 0;
            if (this.fHorizGuides.size() > 0) {
                rows = this.fHorizGuides.get(0).getControls().size();
            }
            int row = 0;
            while (row < rows) {
                Control lastControl = null;
                ListIterator<InternalGuide> iter = this.fHorizGuides.listIterator(this.fHorizGuides.size());
                while (iter.hasPrevious()) {
                    lastControl = iter.previous().getControls().get(row);
                    if (lastControl != null) break;
                }
                if (lastControl != null) {
                    ((GridData)lastControl.getLayoutData()).horizontalSpan += columns - this.fHorizGuides.size();
                }
                ++row;
            }
            while (this.fHorizGuides.size() < columns) {
                this.fHorizGuides.add(new InternalGuide(rows, true));
            }
            ((GridLayout)this.fContainer.getLayout()).numColumns = this.fHorizGuides.size();
        }
    }

    public void nextGuide() {
        if (!this.fConfiguration.isHorizontal()) {
            this.fLastHorizIndex = Integer.MAX_VALUE;
        }
    }

    public Composite getContainer() {
        return this.fContainer;
    }

    public int getNumberOfVerticalGuides() {
        return this.fVertGuides.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalGuide {
        private int fMaxOffset = 0;
        private List<Control> fControls = new ArrayList<Control>();
        private boolean fHorizontal;

        public InternalGuide(int initialCells, boolean horizontal) {
            this.fHorizontal = horizontal;
            int i = 0;
            while (i < initialCells) {
                this.addCell();
                ++i;
            }
        }

        public void putControl(Control control, TeamFormData layoutData) {
            Assert.isTrue((this.fControls.get(this.fControls.size() - 1) == null ? 1 : 0) != 0);
            int offset = this.fHorizontal ? layoutData.getHorizOffset(control) : layoutData.getVertOffset(control);
            if (offset > this.fMaxOffset) {
                int delta = offset - this.fMaxOffset;
                for (Control current : this.fControls) {
                    if (current == null) continue;
                    GridData data = (GridData)current.getLayoutData();
                    if (this.fHorizontal) {
                        data.horizontalIndent += delta;
                        continue;
                    }
                    data.verticalIndent += delta;
                }
                this.fMaxOffset = offset;
            }
            GridData data = (GridData)control.getLayoutData();
            if (this.fHorizontal) {
                data.horizontalIndent = this.fMaxOffset - offset;
            } else {
                data.verticalIndent = this.fMaxOffset - offset;
            }
            this.fControls.set(this.fControls.size() - 1, control);
        }

        public void addCell() {
            this.fControls.add(null);
        }

        public List<Control> getControls() {
            return this.fControls;
        }
    }
}

