/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.ui.internal.editor;

import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.TeamFormLayouts;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;

public class TeamFormData
implements ITeamFormData {
    private static boolean GTK = "gtk".equals(SWT.getPlatform());
    private static boolean CARBON = "carbon".equals(SWT.getPlatform());
    private static final int COMBO_HORIZ_OFFSET = 4;
    private static final int COMBO_VERT_OFFSET = 3;
    private static final int READ_ONLY_COMBO_HORIZ_OFFSET;
    private static final int READ_ONLY_COMBO_VERT_OFFSET;
    public static final int HORIZ_BORDER_OFFSET = 4;
    private static final int LABEL_HORIZ_OFFSET = 0;
    private static final int LABEL_VERT_OFFSET = 0;
    private static final int HYPERLINK_HORIZ_OFFSET;
    private static final int HYPERLINK_VERT_OFFSET = 1;
    private static final int BUTTON_HORIZ_OFFSET = 6;
    private static final int BUTTON_VERT_OFFSET;
    private static final int RADIO_HORIZ_OFFSET = 5;
    private static final int RADIO_VERT_OFFSET = 1;
    private static final int CHECKBOX_HORIZ_OFFSET = 4;
    private static final int CHECKBOX_VERT_OFFSET = 1;
    private static final int STYLED_TEXT_HORIZ_OFFSET = 0;
    private static final int STYLED_TEXT_VERT_OFFSET = 0;
    private static final int TEXT_HORIZ_OFFSET = 3;
    private static final int TEXT_VERT_OFFSET;
    private static final int LIST_HORIZ_OFFSET = 2;
    private static final int LIST_VERT_OFFSET = 0;
    private static final int BORDERED_LIST_HORIZ_OFFSET = 4;
    private static final int BORDERED_LIST_VERT_OFFSET = 2;
    public static final ITeamFormData SINGLE_LINE_FIXED;
    public static final ITeamFormData SINGLE_LINE_GROW;
    public static final ITeamFormData MULTI_LINE_GROW;
    public static final ITeamFormData LABEL;
    public static final ITeamFormData HYPERLINK;
    public static final ITeamFormData BUTTON;
    public static final ITeamFormData RADIO;
    public static final ITeamFormData CHECKBOX;
    public static final ITeamFormData COMBO;
    public static final ITeamFormData READ_ONLY_COMBO;
    public static final ITeamFormData SINGLE_LINE_TEXT;
    public static final ITeamFormData SINGLE_LINE_READONLY_TEXT;
    public static final ITeamFormData MULTI_LINE_TEXT;
    public static final ITeamFormData SINGLE_LINE_STYLED_TEXT;
    public static final ITeamFormData MULTI_LINE_STYLED_TEXT;
    public static final ITeamFormData LIST;
    public static final ITeamFormData BORDERED_LIST;
    public static final ITeamFormData FIXED_LIST;
    public static final ITeamFormData FIXED_BORDERED_LIST;
    private static final String LAYOUT_DATA_KEY;
    private GridData fGridData;
    private int fHorizOffset;
    private int fVertOffset;
    private boolean fAddVertFontOffset;

    static {
        int n = GTK ? 8 : (READ_ONLY_COMBO_HORIZ_OFFSET = CARBON ? 13 : 4);
        READ_ONLY_COMBO_VERT_OFFSET = GTK ? 5 : (CARBON ? 6 : 4);
        HYPERLINK_HORIZ_OFFSET = CARBON ? 2 : 1;
        int n2 = BUTTON_VERT_OFFSET = GTK ? 7 : 5;
        TEXT_VERT_OFFSET = GTK ? 2 : (CARBON ? 1 : 0);
        SINGLE_LINE_FIXED = new TeamFormData(new GridData(4, 128, false, false));
        SINGLE_LINE_GROW = new TeamFormData(new GridData(4, 128, true, false));
        MULTI_LINE_GROW = new TeamFormData(new GridData(4, 4, true, true));
        LABEL = SINGLE_LINE_FIXED.addOffset(0, 0);
        HYPERLINK = SINGLE_LINE_FIXED.addOffset(HYPERLINK_HORIZ_OFFSET, 1);
        BUTTON = SINGLE_LINE_FIXED.addOffset(6, BUTTON_VERT_OFFSET);
        RADIO = SINGLE_LINE_FIXED.addOffset(5, 1);
        CHECKBOX = SINGLE_LINE_FIXED.addOffset(4, 1);
        COMBO = SINGLE_LINE_FIXED.addOffset(4, 3);
        READ_ONLY_COMBO = SINGLE_LINE_FIXED.addOffset(READ_ONLY_COMBO_HORIZ_OFFSET, READ_ONLY_COMBO_VERT_OFFSET);
        SINGLE_LINE_TEXT = SINGLE_LINE_GROW.addOffset(3, TEXT_VERT_OFFSET);
        SINGLE_LINE_READONLY_TEXT = SINGLE_LINE_FIXED.addOffset(3, TEXT_VERT_OFFSET);
        MULTI_LINE_TEXT = MULTI_LINE_GROW.addOffset(3, TEXT_VERT_OFFSET);
        SINGLE_LINE_STYLED_TEXT = SINGLE_LINE_GROW.addOffset(0, 0);
        MULTI_LINE_STYLED_TEXT = MULTI_LINE_GROW.addOffset(0, 0);
        LIST = MULTI_LINE_GROW.addOffset(2, 0);
        BORDERED_LIST = MULTI_LINE_GROW.addOffset(4, 2);
        FIXED_LIST = SINGLE_LINE_GROW.addOffset(2, 0);
        FIXED_BORDERED_LIST = SINGLE_LINE_GROW.addOffset(4, 2);
        LAYOUT_DATA_KEY = String.valueOf(TeamFormData.class.getName()) + "_layoutData";
    }

    public static ITeamFormData getLayoutData(Control control) {
        Object data = control.getData(LAYOUT_DATA_KEY);
        if (data instanceof ITeamFormData) {
            return (ITeamFormData)data;
        }
        return null;
    }

    public static void setLayoutData(Control control, ITeamFormData layoutData) {
        Object data;
        boolean update = TeamFormLayouts.getLayoutData(control) != null;
        control.setData(LAYOUT_DATA_KEY, (Object)layoutData);
        if (update && (data = control.getLayoutData()) instanceof GridData) {
            TeamFormData.update(((TeamFormData)layoutData).fGridData, (GridData)data);
        }
    }

    TeamFormData(GridData baseData) {
        this(baseData, 0, 0, true);
    }

    private TeamFormData(GridData baseData, int horizOffset, int vertOffset, boolean addVertFontOffset) {
        this.fGridData = baseData;
        this.fHorizOffset = horizOffset;
        this.fVertOffset = vertOffset;
        this.fAddVertFontOffset = addVertFontOffset;
    }

    public ITeamFormData addOffset(int horizOffset, int vertOffset) {
        if (horizOffset == 0 && vertOffset == 0) {
            return this;
        }
        return new TeamFormData(this.fGridData, this.fHorizOffset + horizOffset, this.fVertOffset + vertOffset, this.fAddVertFontOffset);
    }

    public ITeamFormData addVertFontOffset(boolean addVertFontOffset) {
        if (this.fAddVertFontOffset == addVertFontOffset) {
            return this;
        }
        return new TeamFormData(this.fGridData, this.fHorizOffset, this.fVertOffset, addVertFontOffset);
    }

    public ITeamFormData maxVertOffset(ITeamFormData other) {
        TeamFormData internal = (TeamFormData)other;
        Assert.isTrue((this.fAddVertFontOffset == internal.fAddVertFontOffset ? 1 : 0) != 0);
        if (this.fVertOffset == internal.fVertOffset) {
            return this;
        }
        return new TeamFormData(this.fGridData, this.fHorizOffset, Math.max(this.fVertOffset, internal.fVertOffset), this.fAddVertFontOffset);
    }

    public ITeamFormData maxOffset(ITeamFormData other) {
        TeamFormData internal = (TeamFormData)other;
        Assert.isTrue((this.fAddVertFontOffset == internal.fAddVertFontOffset ? 1 : 0) != 0);
        if (this.fHorizOffset == internal.fHorizOffset && this.fVertOffset == internal.fVertOffset) {
            return this;
        }
        return new TeamFormData(this.fGridData, Math.max(this.fHorizOffset, internal.fHorizOffset), Math.max(this.fVertOffset, internal.fVertOffset), this.fAddVertFontOffset);
    }

    public ITeamFormData setIgnore(boolean ignore) {
        if (ignore == this.fGridData.exclude) {
            return this;
        }
        GridData gridData = TeamFormData.copy(this.fGridData);
        gridData.exclude = ignore;
        return new TeamFormData(gridData, this.fHorizOffset, this.fVertOffset, this.fAddVertFontOffset);
    }

    public ITeamFormData setWidthHint(int widthHint) {
        if (widthHint == this.fGridData.widthHint) {
            return this;
        }
        GridData gridData = TeamFormData.copy(this.fGridData);
        gridData.widthHint = widthHint;
        return new TeamFormData(gridData, this.fHorizOffset, this.fVertOffset, this.fAddVertFontOffset);
    }

    public GridData getGridData() {
        return TeamFormData.copy(this.fGridData);
    }

    public int getHorizOffset(Control control) {
        return this.fHorizOffset;
    }

    public int getVertOffset(Control control) {
        if (!this.fAddVertFontOffset) {
            return this.fVertOffset;
        }
        GC gc = new GC((Drawable)control);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return this.fVertOffset + fontMetrics.getAscent() + fontMetrics.getLeading();
    }

    public boolean isFixedHeight() {
        return !this.fGridData.grabExcessVerticalSpace;
    }

    private static GridData copy(GridData original) {
        GridData copy = new GridData();
        TeamFormData.update(original, copy);
        return copy;
    }

    private static void update(GridData source, GridData target) {
        target.horizontalAlignment = source.horizontalAlignment;
        target.verticalAlignment = source.verticalAlignment;
        target.grabExcessHorizontalSpace = source.grabExcessHorizontalSpace;
        target.grabExcessVerticalSpace = source.grabExcessVerticalSpace;
        target.widthHint = source.widthHint;
        target.exclude = source.exclude;
    }
}

