/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class MarkupUtil {
    static final boolean IS_MAC = "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform());
    static final boolean IS_WIN = "win32".equals(SWT.getPlatform());

    public static String getFont() {
        FontData defaultFont = JFaceResources.getDefaultFont().getFontData()[0];
        return MarkupUtil.getFont(defaultFont.getName(), defaultFont.getHeight(), defaultFont.getStyle());
    }

    public static String getGlobalFont() {
        FontData defaultFont = JFaceResources.getDefaultFont().getFontData()[0];
        return MarkupUtil.getFont(defaultFont.getName(), defaultFont.getHeight(), defaultFont.getStyle(), IS_WIN);
    }

    public static String getFont(String name) {
        FontData defaultFont = JFaceResources.getDefaultFont().getFontData()[0];
        return MarkupUtil.getFont(name, defaultFont.getHeight(), defaultFont.getStyle());
    }

    public static String getFont(String name, int height) {
        return MarkupUtil.getFont(name, height, 0);
    }

    public static String getDefaultFont() {
        return MarkupUtil.getFont();
    }

    public static String getFont(String name, int height, int style) {
        return MarkupUtil.getFont(name, height, style, false);
    }

    public static String getFont(String name, int height, int style, boolean skipNormalWeight) {
        StringBuffer cssBuf = new StringBuffer();
        cssBuf.append(" font-family: ").append(name).append(';');
        String fontMetric = IS_MAC ? "px" : "pt";
        cssBuf.append(" font-size: ").append(height).append(fontMetric).append(';');
        if ((style & 1) != 0) {
            cssBuf.append(" font-weight: bold;");
        } else if (!skipNormalWeight) {
            cssBuf.append(" font-weight: normal;");
        }
        if ((style & 2) != 0) {
            cssBuf.append(" font-style: italic;");
        }
        return cssBuf.toString();
    }

    public static String toCSS(RGB rgb) {
        return "rgb(" + rgb.red + ", " + rgb.green + ", " + rgb.blue + ")";
    }

    public static String normalizeString(String str) {
        if (str == null) {
            return "";
        }
        char[] c = str.toCharArray();
        char[] n = new char[c.length];
        boolean whiteSpace = true;
        int pos = 0;
        int i = 0;
        while (i < c.length) {
            if (" \t\n\r".indexOf(c[i]) != -1) {
                if (!whiteSpace) {
                    n[pos++] = 32;
                    whiteSpace = true;
                }
            } else {
                n[pos++] = c[i];
                whiteSpace = false;
            }
            ++i;
        }
        if (whiteSpace && pos > 0) {
            --pos;
        }
        return new String(n, 0, pos);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String trim(String str, int limit) {
        str = MarkupUtil.normalizeString(str);
        if (limit <= 0) {
            return "";
        }
        StringBuffer tag = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        boolean inTag = false;
        int i = 0;
        while (i < str.length()) {
            block12: {
                char c = str.charAt(i);
                switch (c) {
                    case '<': {
                        inTag = true;
                        tag = new StringBuffer();
                        break;
                    }
                    case '>': {
                        tag.append(c);
                        inTag = false;
                        String t = tag.toString();
                        if (t.startsWith("<img ")) break block12;
                        if ("<br>".equals(t) || "<br/>".equals(t)) {
                            if (i < limit) {
                                sb.append(t);
                            }
                            break block12;
                        } else {
                            sb.append(t);
                        }
                        break block12;
                    }
                }
                if (inTag) {
                    tag.append(c);
                } else if (i < limit) {
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append("...");
        return sb.toString();
    }
}

