/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import com.ibm.team.foundation.common.IEventGroup;
import com.ibm.team.foundation.rcp.core.ClientEventTypeManager;
import com.ibm.team.jface.ColorUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.util.LoggingUIJob;
import com.ibm.team.jface.itemview.IItemViewListener;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.itemview.Messages;
import com.ibm.team.jface.itemview.NotifyingFilterSet;
import com.ibm.team.jface.timeline.ITimelineContentProvider;
import com.ibm.team.jface.timeline.TimelineLabelProvider;
import com.ibm.team.jface.timeline.TimelineUtils;
import com.ibm.team.jface.timeline.TimelineViewer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ItemViewControl {
    private static final int TIMELINE_HEIGHT = 50;
    private static final int DEFAULT_SCROLL_BUTTON_HEIGHT = 23;
    private static final int MAX_FILTERS = 5;
    private ResourceManager fResourceManager;
    private Composite fParent;
    private FormToolkit fToolkit;
    private boolean fIsEmbedded;
    private Composite fHeaderContainer;
    private Composite fBrowserContainer;
    private Composite fSideBarContainer;
    private List fItemViewListener = new ArrayList();
    private Composite fTimelineContainer;
    private TimelineViewer fTimelineViewer;
    private ITimelineContentProvider fTimelineContentProvider;
    private ItemViewUIConfigurer fConfigurer;
    private String fSelectedSorterId;
    private Set fSelectedFilterIds;
    private boolean fSideBarHidden;
    private Map<String, Button> fFilterIdToButton = new HashMap<String, Button>();
    private Button fAllScopedButton;
    private static boolean fIsMac = "carbon".equals(SWT.getPlatform());
    private NotifyingFilterSet.IFilterSelectionChangedListener fFilterSelectionListener = new NotifyingFilterSet.IFilterSelectionChangedListener(){

        public void filterSelectionChanged(Collection enabledFilters, Collection disabledFilters) {
            if (ItemViewControl.this.fSideBarContainer != null && !ItemViewControl.this.fSideBarContainer.isDisposed()) {
                Button button;
                boolean isShowFilter;
                List filters;
                for (String filterid : enabledFilters) {
                    filters = ItemViewControl.this.fConfigurer.getFilters();
                    for (ItemViewerFilter filter : filters) {
                        if (!filter.getId().equals(filterid)) continue;
                        isShowFilter = filter.getGroup() == 0;
                        button = (Button)ItemViewControl.this.fFilterIdToButton.get(filterid);
                        if (button == null) continue;
                        button.setSelection(!isShowFilter);
                        ItemViewControl.this.notifyFiltered(filterid, true);
                    }
                }
                for (String filterid : disabledFilters) {
                    filters = ItemViewControl.this.fConfigurer.getFilters();
                    for (ItemViewerFilter filter : filters) {
                        if (!filter.getId().equals(filterid)) continue;
                        isShowFilter = filter.getGroup() == 0;
                        button = (Button)ItemViewControl.this.fFilterIdToButton.get(filterid);
                        if (button == null) continue;
                        button.setSelection(isShowFilter);
                        ItemViewControl.this.notifyFiltered(filterid, false);
                    }
                }
                boolean containsScopeFilters = false;
                List filters2 = ItemViewControl.this.fConfigurer.getFilters();
                for (ItemViewerFilter filter : filters2) {
                    if (filter.getGroup() != 2 || !ItemViewControl.this.fSelectedFilterIds.contains(filter.getId())) continue;
                    containsScopeFilters = true;
                }
                if (ItemViewControl.this.fAllScopedButton != null) {
                    ItemViewControl.this.fAllScopedButton.setSelection(!containsScopeFilters);
                }
            }
        }
    };

    public ItemViewControl(ItemViewUIConfigurer configurer, ITimelineContentProvider timelineContentProvider) {
        this(configurer, timelineContentProvider, null, null, true);
    }

    public ItemViewControl(ItemViewUIConfigurer configurer, ITimelineContentProvider timelineContentProvider, String sorterId, Set filterIds, boolean sideBarHidden) {
        this.fConfigurer = configurer;
        this.fTimelineContentProvider = timelineContentProvider;
        this.fSelectedSorterId = sorterId;
        this.fSelectedFilterIds = filterIds;
        if (this.fSelectedFilterIds instanceof NotifyingFilterSet) {
            ((NotifyingFilterSet)this.fSelectedFilterIds).addFilterSelectionChangedListener(this.fFilterSelectionListener);
        }
        this.fSideBarHidden = sideBarHidden;
    }

    public void create(Composite parent) {
        this.create(parent, null);
    }

    public void create(Composite parent, FormToolkit toolkit) {
        this.fParent = parent;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fParent);
        this.fToolkit = toolkit;
        this.fIsEmbedded = toolkit != null;
        this.fParent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ItemViewControl.this.fSelectedFilterIds instanceof NotifyingFilterSet) {
                    ((NotifyingFilterSet)ItemViewControl.this.fSelectedFilterIds).removeFilterSelectionChangeListener(ItemViewControl.this.fFilterSelectionListener);
                }
            }
        });
        if (!this.fIsEmbedded) {
            GridLayout headerLayout = new GridLayout(1, false);
            headerLayout.marginHeight = 0;
            headerLayout.marginWidth = 0;
            this.fHeaderContainer = this.createComposite(this.fParent, 0);
            this.fHeaderContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fHeaderContainer.setLayout((Layout)headerLayout);
        }
        GridLayout contentLayout = new GridLayout(this.fSideBarHidden ? 1 : 2, false);
        contentLayout.marginHeight = 0;
        contentLayout.marginWidth = 0;
        contentLayout.verticalSpacing = 0;
        contentLayout.horizontalSpacing = 0;
        Composite contentContainer = this.createComposite(this.fParent, 0);
        contentContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        contentContainer.setLayout((Layout)contentLayout);
        GridLayout timelineLayout = new GridLayout(4, false);
        timelineLayout.marginWidth = 0;
        timelineLayout.marginLeft = 5;
        timelineLayout.horizontalSpacing = 0;
        this.fTimelineContainer = this.createComposite(contentContainer, 0);
        this.fTimelineContainer.setLayout((Layout)timelineLayout);
        this.fTimelineContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fTimelineContainer.setBackground(contentContainer.getDisplay().getSystemColor(25));
        this.createTimeline();
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginLeft = 1;
        this.fSideBarContainer = this.createComposite(contentContainer, 0);
        this.fSideBarContainer.setLayout((Layout)layout);
        this.fSideBarContainer.setLayoutData((Object)new GridData(4, 4, false, true));
        ((GridData)this.fSideBarContainer.getLayoutData()).verticalSpan = 2;
        ((GridData)this.fSideBarContainer.getLayoutData()).exclude = this.fSideBarHidden;
        ((GridData)this.fSideBarContainer.getLayoutData()).heightHint = 64;
        this.fSideBarContainer.setBackground(this.fParent.getDisplay().getSystemColor(1));
        this.fSideBarContainer.setVisible(!this.fSideBarHidden);
        this.fSideBarContainer.setBackground(JazzResources.getColor("com.ibm.team.jface.itemview.SidebarColor"));
        this.fSideBarContainer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(JazzResources.getColor("com.ibm.team.jface.itemview.OutlineColor"));
                gc.drawLine(0, 0, 0, ((ItemViewControl)ItemViewControl.this).fSideBarContainer.getSize().y);
            }
        });
        this.createSideBar();
        GridLayout browserLayout = new GridLayout(1, false);
        browserLayout.marginWidth = 0;
        browserLayout.marginHeight = 0;
        this.fBrowserContainer = this.createComposite(contentContainer, 0);
        this.fBrowserContainer.setLayout((Layout)browserLayout);
        this.fBrowserContainer.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public void addItemViewListener(IItemViewListener listener) {
        if (!this.fItemViewListener.contains(listener)) {
            this.fItemViewListener.add(listener);
        }
    }

    public void removeItemViewListener(IItemViewListener listener) {
        this.fItemViewListener.remove(listener);
    }

    void notifyQuicksearched(String quicksearch) {
        for (IItemViewListener listener : this.fItemViewListener) {
            listener.quickSearched(quicksearch);
        }
    }

    void notifyQuicksearchCanceld() {
        for (IItemViewListener listener : this.fItemViewListener) {
            listener.quickSearchCanceld();
        }
    }

    void notifyExpandedAll() {
        for (IItemViewListener listener : this.fItemViewListener) {
            listener.expandedAll();
        }
    }

    void notifySideBarToggled(boolean visible) {
        for (IItemViewListener listener : this.fItemViewListener) {
            listener.sideBarToggled(visible);
        }
    }

    void notifyCollapsedAll() {
        for (IItemViewListener listener : this.fItemViewListener) {
            listener.collapsedAll();
        }
    }

    void notifySort(String id) {
        for (IItemViewListener listener : this.fItemViewListener) {
            listener.sorted(id);
        }
    }

    void notifyFiltered(String filterId, boolean enabled) {
        for (IItemViewListener listener : this.fItemViewListener) {
            listener.filtered(filterId, enabled);
        }
    }

    private int getButtonHeight() {
        int currentTheme = ColorUtils.getCurrentTheme();
        if (currentTheme == 3) {
            return 22;
        }
        return 23;
    }

    private void createTimeline() {
        final Button scrollLeft = new Button(this.fTimelineContainer, 16388);
        scrollLeft.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        ((GridData)scrollLeft.getLayoutData()).heightHint = this.getButtonHeight();
        this.fTimelineViewer = new TimelineViewer(this.fTimelineContainer, 0);
        this.fTimelineViewer.getControl().setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fTimelineViewer.getControl().getLayoutData()).heightHint = 50;
        this.fTimelineViewer.setContentProvider(this.fTimelineContentProvider);
        this.fTimelineViewer.setLabelProvider(new TimelineLabelProvider());
        Button scrollRight = new Button(this.fTimelineContainer, 131076);
        scrollRight.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        ((GridData)scrollRight.getLayoutData()).heightHint = this.getButtonHeight();
        if (fIsMac) {
            scrollLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ItemViewControl.this.fTimelineViewer.scrollLeft(1);
                }
            });
            scrollRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ItemViewControl.this.fTimelineViewer.scrollRight(1);
                }
            });
        } else {
            Listener scrollListener = new Listener(){
                ScrollJob scrollJob;

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 3: {
                            if (this.scrollJob != null) break;
                            this.scrollJob = new ScrollJob(event.widget == scrollLeft);
                            this.scrollJob.setSystem(true);
                            this.scrollJob.schedule();
                            break;
                        }
                        case 4: 
                        case 7: {
                            if (this.scrollJob == null) break;
                            this.scrollJob.cancel();
                            this.scrollJob = null;
                        }
                    }
                }
            };
            scrollLeft.addListener(3, scrollListener);
            scrollLeft.addListener(4, scrollListener);
            scrollLeft.addListener(7, scrollListener);
            scrollRight.addListener(3, scrollListener);
            scrollRight.addListener(4, scrollListener);
            scrollRight.addListener(7, scrollListener);
        }
        Composite fTimelineControls = new Composite(this.fTimelineContainer, 0);
        fTimelineControls.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        fTimelineControls.setLayout((Layout)new FillLayout());
        ((FillLayout)fTimelineControls.getLayout()).marginWidth = 5;
        fTimelineControls.setBackground(this.fTimelineContainer.getDisplay().getSystemColor(25));
        ToolBarManager timelineToolBar = new ToolBarManager(0x800000);
        timelineToolBar.add(TimelineUtils.createZoomInAction(this.fTimelineViewer));
        timelineToolBar.add(TimelineUtils.createZoomOutAction(this.fTimelineViewer));
        timelineToolBar.add(TimelineUtils.createZoomToSelectionAction(this.fTimelineViewer));
        timelineToolBar.add((IContributionItem)new Separator());
        timelineToolBar.add(TimelineUtils.createResetViewAction(this.fTimelineViewer));
        timelineToolBar.add(TimelineUtils.createShowTodayAction(this.fTimelineViewer));
        timelineToolBar.createControl(fTimelineControls);
        timelineToolBar.getControl().setBackground(this.fTimelineContainer.getDisplay().getSystemColor(25));
    }

    private void createSideBar() {
        ItemViewerSorter[] sortedSortersA;
        Button b;
        Composite filterByButtonContainer;
        Composite filterByContainer;
        Color bgColor = JazzResources.getColor("com.ibm.team.jface.itemview.SidebarColor");
        Composite quickFilterContainer = this.createComposite(this.fSideBarContainer, 0);
        quickFilterContainer.setLayoutData((Object)new GridData(4, 1, false, false));
        quickFilterContainer.setLayout((Layout)new GridLayout(2, false));
        quickFilterContainer.setBackground(bgColor);
        ((GridLayout)quickFilterContainer.getLayout()).marginTop = 5;
        final Text fSearchInput = new Text(quickFilterContainer, 2436);
        fSearchInput.setLayoutData((Object)new GridData(4, 1, true, false));
        fSearchInput.setMessage(Messages.ItemViewControl_TYPE_FILTER_TEXT);
        fSearchInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ItemViewControl.this.notifyQuicksearched(fSearchInput.getText());
            }
        });
        fSearchInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    fSearchInput.setText("");
                    ItemViewControl.this.notifyQuicksearchCanceld();
                }
            }
        });
        fSearchInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    fSearchInput.setText("");
                    ItemViewControl.this.notifyQuicksearchCanceld();
                }
            }
        });
        if ((fSearchInput.getStyle() & 0x100) == 0) {
            ToolBar bar = new ToolBar(quickFilterContainer, 0x800000);
            bar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
            bar.setBackground(bgColor);
            ToolItem clearItem = new ToolItem(bar, 8);
            clearItem.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.CLEAR));
            clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fSearchInput.setText("");
                    ItemViewControl.this.notifyQuicksearchCanceld();
                }
            });
        }
        new Label(this.fSideBarContainer, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        final TreeSet<ItemViewerFilter> sortedTeamFilter = new TreeSet<ItemViewerFilter>();
        TreeSet<ItemViewerFilter> sortedDisplayFilter = new TreeSet<ItemViewerFilter>();
        TreeSet<ItemViewerFilter> sortedExcludeFilter = new TreeSet<ItemViewerFilter>();
        TreeSet sortedSorters = new TreeSet();
        sortedSorters.addAll(this.fConfigurer.getSorters());
        List filters = this.fConfigurer.getFilters();
        for (ItemViewerFilter filter : filters) {
            if (filter.getGroup() == 0) {
                sortedDisplayFilter.add(filter);
                continue;
            }
            if (filter.getGroup() == 1) {
                sortedExcludeFilter.add(filter);
                continue;
            }
            if (filter.getGroup() != 2) continue;
            sortedTeamFilter.add(filter);
        }
        if (sortedTeamFilter.size() > 0) {
            filterByContainer = this.createComposite(this.fSideBarContainer, 0);
            filterByContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            filterByContainer.setLayout((Layout)new GridLayout(1, false));
            filterByContainer.setBackground(bgColor);
            this.createTitle(filterByContainer, Messages.ItemViewControl_SCOPE, 0).setBackground(bgColor);
            filterByButtonContainer = this.createComposite(filterByContainer, 0);
            filterByButtonContainer.setLayout((Layout)new GridLayout(1, false));
            filterByButtonContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            filterByButtonContainer.setBackground(bgColor);
            this.fAllScopedButton = this.createButton(filterByButtonContainer, Messages.ItemViewControl_ALL, 16);
            this.fAllScopedButton.setBackground(bgColor);
            this.fAllScopedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ItemViewControl.this.fAllScopedButton.getSelection()) {
                        for (ItemViewerFilter filter : sortedTeamFilter) {
                            ItemViewControl.this.notifyFiltered(filter.getId(), false);
                        }
                    }
                }
            });
            boolean selectAllFilter = true;
            for (final ItemViewerFilter filter : sortedTeamFilter) {
                b = this.createButton(filterByButtonContainer, filter.getName(), 16);
                b.setBackground(bgColor);
                b.setSelection(this.fSelectedFilterIds != null && this.fSelectedFilterIds.contains(filter.getId()));
                if (b.getSelection()) {
                    selectAllFilter = false;
                }
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ItemViewControl.this.notifyFiltered(filter.getId(), b.getSelection());
                    }
                });
                this.fFilterIdToButton.put(filter.getId(), b);
            }
            if (selectAllFilter) {
                this.fAllScopedButton.setSelection(true);
            }
        }
        if (sortedDisplayFilter.size() > 0) {
            filterByContainer = this.createComposite(this.fSideBarContainer, 0);
            filterByContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            filterByContainer.setLayout((Layout)new GridLayout(1, false));
            filterByContainer.setBackground(bgColor);
            this.createTitle(filterByContainer, Messages.ItemViewControl_SHOW, 0).setBackground(bgColor);
            filterByButtonContainer = this.createComposite(filterByContainer, 0);
            filterByButtonContainer.setLayout((Layout)new GridLayout(1, false));
            filterByButtonContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            filterByButtonContainer.setBackground(bgColor);
            Collection eventGroups = ClientEventTypeManager.getDefault().getEventGroups();
            HashMap<String, ImageDescriptor> filterIdToImage = new HashMap<String, ImageDescriptor>();
            for (IEventGroup group : eventGroups) {
                filterIdToImage.put(group.getId(), ImageDescriptor.createFromURL((URL)group.getIconUrl()));
            }
            int counter = 0;
            for (final ItemViewerFilter filter : sortedDisplayFilter) {
                final Button b2 = this.createButton(filterByButtonContainer, filter.getName(), 32);
                GridData data = new GridData(1, 1, true, false);
                b2.setLayoutData((Object)data);
                if (filterIdToImage.containsKey(filter.getId())) {
                    b2.setImage(this.fResourceManager.createImage((ImageDescriptor)filterIdToImage.get(filter.getId())));
                }
                b2.setSelection(this.fSelectedFilterIds == null || !this.fSelectedFilterIds.contains(filter.getId()));
                b2.setBackground(bgColor);
                b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ItemViewControl.this.notifyFiltered(filter.getId(), !b2.getSelection());
                    }
                });
                this.fFilterIdToButton.put(filter.getId(), b2);
                if (++counter <= 5) continue;
                data.exclude = true;
            }
            if (sortedDisplayFilter.size() > 5) {
                this.createToggle(filterByButtonContainer);
            }
        }
        if (sortedExcludeFilter.size() > 0) {
            filterByContainer = this.createComposite(this.fSideBarContainer, 0);
            filterByContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            filterByContainer.setLayout((Layout)new GridLayout(1, false));
            filterByContainer.setBackground(bgColor);
            this.createTitle(filterByContainer, Messages.ItemViewControl_EXCLUDE, 0).setBackground(bgColor);
            filterByButtonContainer = this.createComposite(filterByContainer, 0);
            filterByButtonContainer.setLayout((Layout)new GridLayout(1, false));
            filterByButtonContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            filterByButtonContainer.setBackground(bgColor);
            int counter = 0;
            for (final ItemViewerFilter filter : sortedExcludeFilter) {
                b = this.createButton(filterByButtonContainer, filter.getName(), 32);
                GridData data = new GridData(1, 1, true, false);
                b.setLayoutData((Object)data);
                b.setBackground(bgColor);
                b.setSelection(this.fSelectedFilterIds != null && this.fSelectedFilterIds.contains(filter.getId()));
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ItemViewControl.this.notifyFiltered(filter.getId(), b.getSelection());
                    }
                });
                this.fFilterIdToButton.put(filter.getId(), b);
                if (++counter <= 5) continue;
                data.exclude = true;
            }
            if (sortedExcludeFilter.size() > 5) {
                this.createToggle(filterByButtonContainer);
            }
        }
        if ((sortedSortersA = sortedSorters.toArray(new ItemViewerSorter[sortedSorters.size()])).length > 0) {
            Composite sortByContainer = this.createComposite(this.fSideBarContainer, 0);
            sortByContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            sortByContainer.setLayout((Layout)new GridLayout(1, false));
            sortByContainer.setBackground(bgColor);
            this.createTitle(sortByContainer, Messages.ItemViewControl_SORT_BY, 0).setBackground(bgColor);
            Composite sortByComboContainer = this.createComposite(sortByContainer, 0);
            sortByComboContainer.setLayout((Layout)new GridLayout(1, false));
            sortByComboContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            sortByComboContainer.setBackground(bgColor);
            final Combo sortByCombo = new Combo(sortByComboContainer, 8);
            sortByCombo.setLayoutData((Object)new GridData(4, 1, true, false));
            sortByCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ItemViewerSorter sorter = sortedSortersA[sortByCombo.getSelectionIndex()];
                    ItemViewControl.this.notifySort(sorter.getId());
                }
            });
            int selectedSorter = 0;
            int i = 0;
            while (i < sortedSortersA.length) {
                ItemViewerSorter sorter = sortedSortersA[i];
                sortByCombo.add(sorter.getName());
                if (sorter.getId().equals(this.fSelectedSorterId)) {
                    selectedSorter = i;
                }
                ++i;
            }
            sortByCombo.select(selectedSorter);
        }
    }

    private void createToggle(final Composite container) {
        final CLabel toggleLabel = new CLabel(container, 0);
        toggleLabel.setText(Messages.ItemViewControl_MORE);
        toggleLabel.setData((Object)Toggle.LESS);
        toggleLabel.setLayoutData((Object)new GridData(1, 1, true, false));
        toggleLabel.setCursor(toggleLabel.getDisplay().getSystemCursor(21));
        toggleLabel.setImage(this.fResourceManager.createImage(ImagePool.CHEVRON_DN));
        toggleLabel.setBackground(container.getBackground());
        toggleLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Toggle state = (Toggle)((Object)toggleLabel.getData());
                Control[] children = container.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control control = children[i];
                    if (control instanceof Button && i >= 5) {
                        ((GridData)control.getLayoutData()).exclude = state != Toggle.LESS;
                        control.setVisible(state == Toggle.LESS);
                    }
                    ++i;
                }
                toggleLabel.setText(state == Toggle.LESS ? Messages.ItemViewControl_SHOW_LESS : Messages.ItemViewControl_MORE);
                toggleLabel.setImage(state == Toggle.LESS ? ItemViewControl.this.fResourceManager.createImage(ImagePool.CHEVRON_UP) : ItemViewControl.this.fResourceManager.createImage(ImagePool.CHEVRON_DN));
                ItemViewControl.this.fSideBarContainer.getParent().layout(true, true);
                toggleLabel.setData((Object)(state == Toggle.LESS ? Toggle.MORE : Toggle.LESS));
            }
        });
    }

    public FormToolkit getToolkit() {
        return this.fToolkit;
    }

    public Composite getBrowserContainer() {
        return this.fBrowserContainer;
    }

    public Composite getHeaderContainer() {
        return this.fHeaderContainer;
    }

    public Composite getSideBarContainer() {
        return this.fSideBarContainer;
    }

    public void setSidebarHidden(boolean isHidden) {
        this.fSideBarHidden = isHidden;
    }

    private Button createButton(Composite parent, String text, int style) {
        if (!this.fIsEmbedded) {
            Button b = new Button(parent, style);
            b.setText(text);
            return b;
        }
        return this.fToolkit.createButton(parent, text, style);
    }

    private Composite createComposite(Composite parent, int style) {
        if (!this.fIsEmbedded) {
            Composite c = new Composite(parent, style);
            return c;
        }
        Composite c = this.fToolkit.createComposite(parent, style);
        this.fToolkit.adapt(c);
        return c;
    }

    private Label createTitle(Composite parent, String text, int style) {
        if (!this.fIsEmbedded) {
            Label l = new Label(parent, style);
            l.setText(text);
            l.setFont(JazzResources.getFont("com.ibm.team.jface.itemview.TitleFont"));
            l.setForeground(JazzResources.getColor("com.ibm.team.jface.itemview.TitleColor"));
            return l;
        }
        Label l = this.fToolkit.createLabel(parent, text, style);
        l.setFont(JazzResources.getFont("com.ibm.team.jface.itemview.TitleFont"));
        l.setBackground(parent.getBackground());
        l.setForeground(JazzResources.getColor("com.ibm.team.jface.itemview.TitleColor"));
        return l;
    }

    public TimelineViewer getTimelineViewer() {
        return this.fTimelineViewer;
    }

    class ScrollJob
    extends LoggingUIJob {
        private boolean fLeft;

        public ScrollJob(boolean left) {
            super(Messages.ItemViewControl_SCROLLER);
            this.fLeft = left;
        }

        public IStatus runProtectedInUI(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                if (this.fLeft) {
                    ItemViewControl.this.fTimelineViewer.scrollLeft(1);
                } else {
                    ItemViewControl.this.fTimelineViewer.scrollRight(1);
                }
                this.schedule(200L);
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Toggle {
        MORE,
        LESS;

    }
}

