/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.tooltip;

import com.ibm.team.jface.BrowserLocationListener;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.tooltip.IHoverSite;
import com.ibm.team.jface.internal.tooltip.Messages;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.util.CommunicatableBrowser;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;

public class FocusTooltip
extends Tooltip {
    public static final Point PREFERRED_SIZE = new Point(240, 70);
    private static final Point FOCUS_TOOLTIP_MIN_SIZE = new Point(100, 100);
    private static final String TOOLTIP_ID = FocusTooltip.class.getName();
    private static final String CALLBACK_SHELL_SIZE = "updateShellSize";
    private static final float MAX_WIDTH_RATIO = 0.5f;
    private static final float MAX_HEIGHT_RATIO = 0.5f;
    private static final int SIZE_UPDATE_DELAY = 50;
    private static final boolean IS_LINUX = "gtk".equals(SWT.getPlatform());
    private static final boolean IS_MAC = "carbon".equals(SWT.getPlatform());
    private static final int SCROLLBAR_SIZE = 24;
    private Browser fBrowser;
    private boolean fIsOpenable;
    protected LocalResourceManager fResources;
    private CLabel fTitleLabel;
    private ToolItem fOpenItem;

    protected FocusTooltip(Shell parent, IHoverSite hoverSite, boolean isOpenable, Point preferredSize) {
        super(parent, hoverSite, preferredSize);
        this.fIsOpenable = isOpenable;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }

    public Control createContents(Composite parent) {
        Composite browserContainer = new Composite(parent, 0);
        browserContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout grid = new GridLayout(1, false);
        grid.marginWidth = 0;
        grid.marginHeight = 0;
        browserContainer.setLayout((Layout)grid);
        this.fBrowser = this.createBrowser(browserContainer);
        this.updateSize();
        return browserContainer;
    }

    protected Browser createBrowser(Composite parent) {
        final CommunicatableBrowser browser = new CommunicatableBrowser(parent, 0){

            public void callback(String id, String value) {
                if (FocusTooltip.CALLBACK_SHELL_SIZE.equals(id)) {
                    String[] sizeVal = value.split(" ");
                    if (sizeVal.length != 2) {
                        return;
                    }
                    int contentWidth = Integer.parseInt(sizeVal[0]);
                    int contentHeight = Integer.parseInt(sizeVal[1]);
                    FocusTooltip.this.onContentLoaded(contentWidth, contentHeight);
                }
            }
        };
        browser.getBrowser().addLocationListener((LocationListener)new BrowserLocationListener(this.getContextProvider()){

            public void changing(LocationEvent event) {
                if ("about:blank".equals(event.location)) {
                    return;
                }
                super.changing(event);
                if (!event.doit) {
                    FocusTooltip.this.close();
                }
            }
        });
        browser.getBrowser().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    FocusTooltip.this.close();
                }
            }
        });
        browser.getBrowser().addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                if (event.location != null && event.location.contains("#")) {
                    return;
                }
                FocusTooltip.this.getShell().getDisplay().timerExec(50, new Runnable(){

                    public void run() {
                        String js = "if(this.propagateContentSize) { propagateContentSize(); }";
                        if (!browser.getBrowser().isDisposed()) {
                            browser.getBrowser().execute(js);
                        }
                    }
                });
            }
        });
        return browser.getBrowser();
    }

    private String injectSizeDiv(StringBuilder html) {
        String htmlStr = html.toString();
        int headIndex = htmlStr.indexOf("<head>");
        if (headIndex >= 0) {
            headIndex += "<head>".length();
            StringBuilder builder = new StringBuilder(htmlStr);
            StringBuilder js = new StringBuilder();
            js.append("<script type=\"text/javascript\">\n");
            js.append("function propagateContentSize() {\n");
            js.append("var sizediv = document.getElementById('sizerdiv');\n");
            js.append("communicateToJava('updateShellSize', sizediv.offsetWidth + ' ' + sizediv.offsetHeight)\n");
            js.append("}\n");
            js.append("function communicateToJava(id, value) {\n\t");
            js.append("window.status = 'comBrowser://' + id + '/' + value;\n");
            js.append("window.status = '';\n");
            js.append(" }\n");
            js.append("</script>");
            builder.insert(headIndex, js);
            htmlStr = builder.toString();
        }
        int bodyStartIndex = htmlStr.indexOf("<body");
        bodyStartIndex = htmlStr.indexOf(62, bodyStartIndex);
        int bodyEndIndex = htmlStr.indexOf("</body>");
        if (bodyStartIndex >= 0 && bodyEndIndex >= 0) {
            ++bodyStartIndex;
            StringBuilder builder = new StringBuilder(htmlStr);
            StringBuilder table = new StringBuilder();
            table.append("<table cellspacing=\"0\" cellpadding=\"0\" style=\"border: 0; padding: 0; margin: 0; " + MarkupUtil.getGlobalFont() + "\" id=\"sizerdiv\">\n");
            table.append("<tr><td style=\"border: 0;\">");
            builder.insert(bodyStartIndex, table);
            bodyEndIndex = builder.lastIndexOf("</body>");
            builder.insert(bodyEndIndex, "</td></tr></table>");
            htmlStr = builder.toString();
        }
        return htmlStr;
    }

    public Control createFooter(Composite parent) {
        return null;
    }

    public Control createHeader(Composite parent) {
        Composite headContainer = new Composite(parent, 0);
        headContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        Listener shellMovement = new Listener(){
            Point origin;

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 3: {
                        this.origin = new Point(e.x, e.y);
                        break;
                    }
                    case 4: {
                        this.origin = null;
                        break;
                    }
                    case 5: {
                        if (this.origin == null) break;
                        Point p = FocusTooltip.this.getShell().getDisplay().map((Control)FocusTooltip.this.getShell(), null, e.x, e.y);
                        FocusTooltip.this.getShell().setLocation(p.x - this.origin.x, p.y - this.origin.y);
                    }
                }
            }
        };
        headContainer.addListener(3, shellMovement);
        headContainer.addListener(4, shellMovement);
        headContainer.addListener(5, shellMovement);
        headContainer.setCursor(this.getShell().getDisplay().getSystemCursor(IS_MAC ? 21 : 5));
        GridLayout titleBarLayout = new GridLayout(2, false);
        titleBarLayout.marginHeight = 0;
        titleBarLayout.marginWidth = 0;
        titleBarLayout.horizontalSpacing = 0;
        titleBarLayout.verticalSpacing = 0;
        headContainer.setLayout((Layout)titleBarLayout);
        this.fTitleLabel = new CLabel(headContainer, 0);
        this.fTitleLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        this.fTitleLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, true));
        this.fTitleLabel.addListener(3, shellMovement);
        this.fTitleLabel.addListener(4, shellMovement);
        this.fTitleLabel.addListener(5, shellMovement);
        this.fTitleLabel.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                FocusTooltip.this.fTitleLabel.setForeground(FocusTooltip.this.fIsOpenable ? JFaceColors.getActiveHyperlinkText((Display)FocusTooltip.this.fTitleLabel.getDisplay()) : null);
            }

            public void mouseExit(MouseEvent e) {
                FocusTooltip.this.fTitleLabel.setForeground(FocusTooltip.this.fIsOpenable ? JFaceColors.getHyperlinkText((Display)FocusTooltip.this.fTitleLabel.getDisplay()) : null);
            }
        });
        this.fTitleLabel.addMouseListener((MouseListener)new MouseAdapter(){
            private Point location;

            public void mouseDown(MouseEvent e) {
                this.location = new Point(e.x, e.y);
            }

            public void mouseUp(MouseEvent e) {
                if (FocusTooltip.this.fIsOpenable && new Point(e.x, e.y).equals((Object)this.location)) {
                    FocusTooltip.this.getHoverSite().openRequested();
                    FocusTooltip.this.close();
                }
            }
        });
        if (this.fIsOpenable) {
            this.fTitleLabel.setForeground(JFaceColors.getHyperlinkText((Display)this.fTitleLabel.getDisplay()));
            this.fTitleLabel.setCursor(this.fTitleLabel.getDisplay().getSystemCursor(21));
        }
        Composite barContainer = this.createHeaderBar(headContainer);
        barContainer.setCursor(barContainer.getDisplay().getSystemCursor(0));
        barContainer.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        new Label(headContainer, 258).setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        return headContainer;
    }

    private void updateOpenable(boolean isOpenAble) {
        this.fTitleLabel.setForeground(isOpenAble ? JFaceColors.getHyperlinkText((Display)this.fTitleLabel.getDisplay()) : null);
        this.fTitleLabel.setCursor(isOpenAble ? this.fTitleLabel.getDisplay().getSystemCursor(21) : null);
        this.fOpenItem.setEnabled(isOpenAble);
    }

    public void setTitle(String title) {
        if (this.fTitleLabel == null || this.fTitleLabel.isDisposed() || !this.isVisible()) {
            return;
        }
        if (title != null) {
            title = title.replaceAll("&", "&&");
        }
        this.fTitleLabel.setText(title);
        this.fTitleLabel.setToolTipText(null);
        this.fTitleLabel.getParent().getParent().layout(true, true);
    }

    protected Composite createHeaderBar(Composite parent) {
        Composite barContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        barContainer.setLayout((Layout)layout);
        ToolBar bar = new ToolBar(barContainer, 0x800000);
        this.fOpenItem = new ToolItem(bar, 8);
        this.fOpenItem.setToolTipText(Messages.FocusTooltip_OPEN);
        this.fOpenItem.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.LNCH_VIEW));
        this.fOpenItem.setDisabledImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.LNCH_VIEW_DISABLED));
        this.fOpenItem.setEnabled(this.isOpenable());
        this.fOpenItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FocusTooltip.this.getHoverSite().openRequested();
                FocusTooltip.this.close();
            }
        });
        bar = new ToolBar(barContainer, 0x800000);
        ToolItem close = new ToolItem(bar, 8);
        close.setToolTipText(Messages.FocusTooltip_CLOSE);
        close.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.CLOSE));
        close.setHotImage(JazzResources.getImageWithDefault((ResourceManager)this.fResources, ImagePool.CLOSE_ACTIVE));
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FocusTooltip.this.close();
            }
        });
        return barContainer;
    }

    protected String getBackgroundAsCSS() {
        StringBuffer background = new StringBuffer();
        RGB bgColor = this.getBackground().getRGB();
        background.append("background: rgb(").append(bgColor.red);
        background.append(",").append(bgColor.green).append(",").append(bgColor.blue).append(");");
        return background.toString();
    }

    protected String getFontAsCSS() {
        StringBuffer font = new StringBuffer();
        Font defFont = JFaceResources.getDefaultFont();
        font.append("font: ").append(defFont.getFontData()[0].getHeight()).append(fIsMac ? "px" : "pt");
        font.append(" ").append(defFont.getFontData()[0].getName()).append(";");
        return font.toString();
    }

    protected int getShellStyle() {
        return IS_LINUX ? 16 : 18448;
    }

    protected boolean isOpenable() {
        return this.fIsOpenable;
    }

    public void open(Point location) {
        super.open(location);
        this.fBrowser.setFocus();
        Shell toolTipShell = this.getShell();
        toolTipShell.setMinimumSize(FOCUS_TOOLTIP_MIN_SIZE);
    }

    public void close() {
        if (this.fBrowser != null && !this.fBrowser.isDisposed()) {
            this.resetBrowser();
            this.resetTitle();
        }
        super.close();
    }

    private void resetBrowser() {
        StringBuffer html = new StringBuffer();
        html.append("<html><body style=\"margin: 1; overflow: auto; ");
        html.append(this.getBackgroundAsCSS());
        html.append("\"></body></html>");
        this.fBrowser.setText(html.toString());
    }

    private void resetTitle() {
        if (this.fTitleLabel != null && !this.fTitleLabel.isDisposed()) {
            this.fTitleLabel.setText(null);
            this.fTitleLabel.setToolTipText(null);
        }
    }

    protected void setOpenable(boolean openable) {
        this.fIsOpenable = openable;
    }

    public void setText(String text) {
        super.setText(text);
        if (this.fBrowser == null) {
            this.create();
        }
        StringBuilder html = new StringBuilder();
        String body = "<body style=\"margin: 1; overflow: auto; " + this.getFontAsCSS() + this.getBackgroundAsCSS() + "\">\n";
        String BODY_TAG = "<body>";
        int pos = text.indexOf(BODY_TAG);
        if (pos >= 0) {
            String part1 = text.substring(0, pos);
            String part2 = text.substring(pos + BODY_TAG.length());
            html.append(part1);
            html.append(body);
            html.append(part2);
        } else {
            html.append("<html>\n");
            html.append("<head>\n");
            html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
            html.append("</head>\n");
            html.append(body);
            html.append(text);
            html.append("\n</body></html>\n");
        }
        String htmlStr = this.injectSizeDiv(html);
        this.fBrowser.setText(htmlStr);
    }

    public static FocusTooltip createTooltip(Shell parent, IHoverSite hoverSite, boolean isOpenable, Point preferredSize) {
        Object data;
        if (parent.getData(TOOLTIP_ID) != null && (data = parent.getData(TOOLTIP_ID)).getClass().getName().equals(FocusTooltip.class.getName()) && !((Tooltip)data).isDisposed()) {
            FocusTooltip toolTip = (FocusTooltip)data;
            toolTip.setHoverSite(hoverSite);
            boolean oldOpenableState = toolTip.isOpenable();
            toolTip.setOpenable(isOpenable);
            if (oldOpenableState && !isOpenable || !oldOpenableState && isOpenable) {
                toolTip.updateOpenable(isOpenable);
            }
            toolTip.setPreferredSize(preferredSize);
            return toolTip;
        }
        return new FocusTooltip(parent, hoverSite, isOpenable, preferredSize);
    }

    protected void updateSize() {
        if (this.fBrowser == null || this.fBrowser.isDisposed()) {
            return;
        }
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.getPreferredWidth();
        data.heightHint = this.getPreferredHeight();
        this.fBrowser.setLayoutData((Object)data);
    }

    protected void onContentLoaded(int preferredWidth, int preferredHeight) {
        Rectangle monitorClientArea = this.getShell().getMonitor().getClientArea();
        Point shellSize = this.getShell().getSize();
        Point shellLocation = this.getShell().getLocation();
        Point browserSize = this.fBrowser.getSize();
        int trimWidth = shellSize.x - browserSize.x + 2;
        int trimHeight = shellSize.y - browserSize.y + 8;
        if (IS_LINUX) {
            trimWidth += 24;
            trimWidth -= 4;
        }
        shellSize.x = Math.max(shellSize.x, preferredWidth + trimWidth);
        shellSize.y = Math.max(shellSize.y, preferredHeight + trimHeight);
        this.trimSize(shellSize, shellLocation, monitorClientArea);
        int widthOverlap = shellLocation.x + shellSize.x - (monitorClientArea.x + monitorClientArea.width);
        int heightOverlap = shellLocation.y + shellSize.y - (monitorClientArea.y + monitorClientArea.height);
        if (widthOverlap > 0) {
            shellLocation.x = shellLocation.x - shellSize.x - 16;
        }
        if (heightOverlap > 0) {
            shellLocation.y -= heightOverlap;
            if (widthOverlap <= 0) {
                shellLocation.x += 8;
            }
        }
        Rectangle newShellBounds = new Rectangle(shellLocation.x, shellLocation.y, shellSize.x, shellSize.y);
        this.getShell().setBounds(newShellBounds);
    }

    private void trimSize(Point sizeHint, Point tooltipLocation, Rectangle monitorBounds) {
        Point originalSizeHint = new Point(sizeHint.x, sizeHint.y);
        float maxWidth = (float)monitorBounds.width * 0.5f;
        float maxHeight = (float)monitorBounds.height * 0.5f;
        sizeHint.x = (int)Math.min(maxWidth, (float)sizeHint.x);
        sizeHint.y = (int)Math.min(maxHeight, (float)sizeHint.y);
        if ((float)sizeHint.x == maxWidth) {
            sizeHint.y += 24;
        }
        if ((float)sizeHint.y == maxHeight) {
            sizeHint.x += 24;
        }
        if (originalSizeHint.x > sizeHint.x && tooltipLocation.x + sizeHint.x < monitorBounds.x + monitorBounds.width) {
            sizeHint.x = Math.min(originalSizeHint.x, monitorBounds.x + monitorBounds.width - tooltipLocation.x);
        }
        if (originalSizeHint.y > sizeHint.y && tooltipLocation.y + sizeHint.y < monitorBounds.y + monitorBounds.height) {
            sizeHint.y = Math.min(originalSizeHint.y, monitorBounds.y + monitorBounds.height - tooltipLocation.y);
        }
    }

    private static Rectangle track(Control control, int flags) {
        Rectangle bounds = control.getBounds();
        Tracker tracker = new Tracker(control.getDisplay(), flags);
        tracker.setRectangles(new Rectangle[]{bounds});
        if (tracker.open()) {
            return tracker.getRectangles()[0];
        }
        return null;
    }

    class WindowMover
    implements Listener {
        Point fOrigin;

        WindowMover() {
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 3: {
                    if (IS_MAC || IS_LINUX) {
                        Rectangle bounds = FocusTooltip.track((Control)FocusTooltip.this.getShell(), 0);
                        if (bounds == null) break;
                        FocusTooltip.this.getShell().setLocation(bounds.x, bounds.y);
                        break;
                    }
                    this.fOrigin = new Point(e.x, e.y);
                    ((Control)e.widget).addListener(5, (Listener)this);
                    ((Control)e.widget).addListener(7, (Listener)this);
                    break;
                }
                case 4: 
                case 7: {
                    this.fOrigin = null;
                    ((Control)e.widget).removeListener(5, (Listener)this);
                    ((Control)e.widget).removeListener(7, (Listener)this);
                    break;
                }
                case 5: {
                    if (this.fOrigin == null) break;
                    Point p = FocusTooltip.this.getShell().getDisplay().map((Control)FocusTooltip.this.getShell(), null, e.x, e.y);
                    FocusTooltip.this.getShell().setLocation(p.x - this.fOrigin.x, p.y - this.fOrigin.y);
                }
            }
        }
    }
}

