/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.alerts;

import com.ibm.team.foundation.rcp.core.notification.NotificationInfo;
import com.ibm.team.jface.internal.alerts.IAlertControlCreator;
import com.ibm.team.jface.internal.alerts.IAlertSite;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InfoPop
implements IAlertSite {
    private static final int INFO_TIMEOUT = 5000;
    private static final int WARNING_TIMEOUT = 8000;
    private static final int ERROR_TIMEOUT = 30000;
    public static final int INFOPOP_WIDTH = 200;
    static final int STATE_REQUEST_OPEN = 0;
    static final int STATE_DISPOSED = 3;
    static final int STATE_OPEN = 1;
    static final int STATE_REQUEST_DISPOSE = 2;
    private int fAutoCloseTimeout;
    private Point fCachedSize;
    private IAlertControlCreator fControlCreator;
    private Shell fParentShell;
    private Shell fPopupShell;
    private int fState;
    private long fVisibleSince;
    private List<NotificationInfo> fEvents = new ArrayList<NotificationInfo>();
    boolean fMouseInPopup;
    private NotificationInfo fEvent;
    private boolean fSticky;
    private String fTriggerId;

    InfoPop(Shell parent, NotificationInfo event, IAlertControlCreator controlCreator) {
        this.fParentShell = parent;
        this.fControlCreator = controlCreator;
        this.fEvent = event;
        this.fEvents.add(this.fEvent);
        this.updateAutoCloseTimeout(event);
    }

    private void updateAutoCloseTimeout(NotificationInfo event) {
        if (event.getSeverity() == 0) {
            this.fAutoCloseTimeout = 30000;
        } else if (event.getSeverity() == 1 && this.fAutoCloseTimeout < 8000) {
            this.fAutoCloseTimeout = 8000;
        } else if (this.fAutoCloseTimeout < 5000) {
            this.fAutoCloseTimeout = 5000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(NotificationInfo event) {
        List<NotificationInfo> list = this.fEvents;
        synchronized (list) {
            for (NotificationInfo storedEvent : this.fEvents) {
                if (!storedEvent.isSameTo(event)) continue;
                return;
            }
            this.fEvents.add(event);
        }
        this.updateAutoCloseTimeout(event);
        this.fControlCreator.eventAdded();
        this.fVisibleSince = System.currentTimeMillis();
        if (this.fState == 2) {
            this.fState = 1;
        }
    }

    void close() {
        if (this.fPopupShell != null && !this.fPopupShell.isDisposed()) {
            this.fPopupShell.close();
        }
    }

    public void closeAlert() {
        this.fParentShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                InfoPop.this.close();
            }
        });
    }

    public Shell getParentShell() {
        return this.fParentShell;
    }

    public String getTriggerId() {
        return this.fTriggerId;
    }

    public void setAutoCloseTimeout(int timeout) {
        this.fAutoCloseTimeout = timeout;
    }

    public void setSticky(boolean sticky) {
        this.fSticky = sticky;
        if (this.fState == 2) {
            this.fState = 1;
        }
    }

    void create() {
        this.fPopupShell = new Shell(this.fParentShell.getDisplay(), 16392);
        this.fPopupShell.setLayout((Layout)new FillLayout());
        this.fPopupShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InfoPop.this.setState(3);
                InfoPop.this.fMouseInPopup = false;
            }
        });
        this.fControlCreator.init(this, this.fEvents);
        this.fControlCreator.createControl((Composite)this.fPopupShell);
        this.setupMouseTrackListener((Control)this.fPopupShell);
        this.fPopupShell.pack();
        this.fCachedSize = this.fPopupShell.getSize();
        this.fPopupShell.setSize(200, this.fCachedSize.y);
    }

    NotificationInfo getEvent() {
        return this.fEvent;
    }

    int getAutoCloseTimeout() {
        return this.fAutoCloseTimeout;
    }

    Point getCachedSize() {
        return this.fCachedSize;
    }

    int getHeight() {
        if (this.fPopupShell.isDisposed()) {
            return this.fCachedSize.y;
        }
        return this.fPopupShell.getSize().y;
    }

    Shell getParent() {
        return this.fParentShell;
    }

    Shell getShell() {
        return this.fPopupShell;
    }

    int getState() {
        return this.fState;
    }

    void setState(int state) {
        this.fState = state;
    }

    long getVisibleSince() {
        return this.fVisibleSince;
    }

    void setVisibleSince(long visibleSince) {
        this.fVisibleSince = visibleSince;
    }

    private void setupMouseTrackListener(Control control) {
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                InfoPop.this.fMouseInPopup = true;
            }

            public void mouseExit(MouseEvent e) {
                InfoPop.this.fMouseInPopup = false;
            }
        });
        if (control instanceof Composite) {
            int i = 0;
            while (i < ((Composite)control).getChildren().length) {
                this.setupMouseTrackListener(((Composite)control).getChildren()[i]);
                ++i;
            }
        }
    }

    void setTriggerId(String triggerId) {
        this.fTriggerId = triggerId;
    }

    boolean isSticky() {
        return this.fSticky;
    }
}

