/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.alerts;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.rcp.core.ILinkProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.internal.notification.NotificationManager;
import com.ibm.team.foundation.rcp.core.notification.NotificationInfo;
import com.ibm.team.foundation.rcp.core.notification.NotificationTrigger;
import com.ibm.team.jface.GradientUtilities;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.alerts.IAlertControlCreator;
import com.ibm.team.jface.internal.alerts.IAlertSite;
import com.ibm.team.jface.internal.alerts.Messages;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class DefaultInfoPopControlCreator
implements IAlertControlCreator {
    private static final String NEW_ITEM_INDICATOR = "*";
    private static final RGB TITLE_BACKGROUND = new RGB(216, 228, 248);
    private static final RGB INNER_BORDER = new RGB(49, 106, 197);
    private static final RGB OUTER_BORDER = new RGB(157, 185, 235);
    private ResourceManager fResourceManager;
    private List fEvents;
    private Label fLeftHeaderImage;
    private Label fNavLabel;
    private int fShowingIndex = 0;
    private ToolItem fNavRight;
    private ToolItem fNavLeft;
    private Label fContentImage;
    private StyledText fContentText;
    private IAlertSite fAlertSite;
    private MouseTrackAdapter fMouseTrackAdapter;
    private MouseListener fMouseAdapter;
    private boolean fInitialized;
    private ToolBar fLeftBar;
    private ToolBar fRightBar;
    private Composite fNavigation;
    private Composite fHeaderContainer;

    public void init(IAlertSite alertSite, List events) {
        this.fInitialized = true;
        this.fEvents = events;
        this.fAlertSite = alertSite;
    }

    public Control createControl(Composite parent) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        boolean useReducedColors = "org.eclipse.ui.ide.systemDefault".equals(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());
        Color titleBg = null;
        Color innerBorder = null;
        Color outerBorder = null;
        if (useReducedColors) {
            innerBorder = titleBg = parent.getDisplay().getSystemColor(18);
            outerBorder = titleBg;
        } else {
            titleBg = JazzResources.getColor(this.fResourceManager, TITLE_BACKGROUND);
            innerBorder = JazzResources.getColor(this.fResourceManager, INNER_BORDER);
            outerBorder = JazzResources.getColor(this.fResourceManager, OUTER_BORDER);
        }
        Composite outerBorderComposite = this.createBorderComposite(parent, outerBorder, false);
        Composite innerBorderComposite = this.createBorderComposite(outerBorderComposite, innerBorder, false);
        Composite window = this.createBorderComposite(innerBorderComposite, null, false);
        window.setBackground(parent.getDisplay().getSystemColor(1));
        this.fHeaderContainer = this.createHeader(window);
        GradientUtilities.setVerticalGradient(this.fHeaderContainer, titleBg, parent.getDisplay().getSystemColor(1));
        Control control = this.createContent(window);
        GridData contentLayoutData = new GridData(4, 4, true, false);
        contentLayoutData.widthHint = 194;
        control.setLayoutData((Object)contentLayoutData);
        this.showInfo(0);
        this.addBorderPaintListener(innerBorderComposite, outerBorderComposite.getBackground(), 2, true);
        this.addBorderPaintListener(window, innerBorderComposite.getBackground(), 1, true);
        this.addBorderPaintListener(this.fHeaderContainer, window.getBackground(), 1, false);
        if (!"carbon".equals(SWT.getPlatform())) {
            this.roundEdges(parent.getShell());
        }
        return outerBorderComposite;
    }

    public void eventAdded() {
        if (!this.fInitialized) {
            return;
        }
        this.showInfo(this.fShowingIndex + 1);
        ImageDescriptor overlay = ImagePool.NEWINFO_OVRL;
        ImageDescriptor baseImageDescriptor = this.getHeaderImageDescriptor((NotificationInfo)this.fEvents.get(this.fShowingIndex));
        Image baseImage = JazzResources.getImageWithDefault(this.fResourceManager, baseImageDescriptor);
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = overlay;
        OverlayIcon ovIcon = new OverlayIcon(baseImageDescriptor, baseImage, imageDescriptorArray, new Point(16, 16), 131200);
        this.fLeftHeaderImage.setImage(JazzResources.getImageWithDefault(this.fResourceManager, (ImageDescriptor)ovIcon));
    }

    protected Composite createHeader(Composite parent) {
        Composite titleContainer = new Composite(parent, 0);
        GridLayout titleBarLayout = new GridLayout(4, false);
        titleBarLayout.marginHeight = 0;
        titleBarLayout.marginWidth = 2;
        titleBarLayout.horizontalSpacing = 0;
        titleContainer.setLayout((Layout)titleBarLayout);
        GridData titleBarLayoutData = new GridData(4, 1, true, false);
        titleContainer.setLayoutData((Object)titleBarLayoutData);
        this.fLeftHeaderImage = new Label(titleContainer, 0);
        this.fLeftHeaderImage.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        this.fNavigation = this.createNavigation(titleContainer);
        this.fNavigation.setLayoutData((Object)new GridData(0x1000000, 1, true, false));
        ToolBar headerBar = this.createHeaderBar(titleContainer);
        headerBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        return titleContainer;
    }

    protected Composite createNavigation(Composite parent) {
        Composite navContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginLeft = 20;
        layout.horizontalSpacing = 3;
        navContainer.setLayout((Layout)layout);
        this.fLeftBar = new ToolBar(navContainer, 0x800000);
        this.fNavLeft = new ToolItem(this.fLeftBar, 8);
        this.fNavLeft.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.NAV_LEFT));
        this.fNavLeft.setDisabledImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.NAV_LEFT_DISABLED));
        this.fNavLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultInfoPopControlCreator.this.showInfo(DefaultInfoPopControlCreator.this.fShowingIndex - 1);
            }
        });
        this.fNavLabel = new Label(navContainer, 0);
        this.fRightBar = new ToolBar(navContainer, 0x800000);
        this.fNavRight = new ToolItem(this.fRightBar, 8);
        this.fNavRight.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.NAV_RIGHT));
        this.fNavRight.setDisabledImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.NAV_RIGHT_DISABLED));
        this.fNavRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultInfoPopControlCreator.this.showInfo(DefaultInfoPopControlCreator.this.fShowingIndex + 1);
            }
        });
        return navContainer;
    }

    protected ToolBar createHeaderBar(Composite parent) {
        final ToolBar bar = new ToolBar(parent, 0x800000);
        final Menu prefMenu = new Menu((Control)bar);
        bar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                prefMenu.dispose();
            }
        });
        MenuItem open = new MenuItem(prefMenu, 0);
        open.setText(Messages.DefaultInfoPopControlCreator_OPEN);
        open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultInfoPopControlCreator.this.onClick((NotificationInfo)DefaultInfoPopControlCreator.this.fEvents.get(DefaultInfoPopControlCreator.this.fShowingIndex));
            }
        });
        final MenuItem sticky = new MenuItem(prefMenu, 32);
        sticky.setText(Messages.DefaultInfoPopControlCreator_MAKE_STICKY);
        sticky.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultInfoPopControlCreator.this.fAlertSite.setSticky(sticky.getSelection());
            }
        });
        new MenuItem(prefMenu, 2);
        final MenuItem disable = new MenuItem(prefMenu, 32);
        disable.setText(Messages.DefaultInfoPopControlCreator_DISABLE_TRIGGER);
        disable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationTrigger trigger = NotificationManager.getInstance().getTrigger(DefaultInfoPopControlCreator.this.fAlertSite.getTriggerId());
                if (trigger != null) {
                    trigger.setEnabled(!disable.getSelection());
                }
            }
        });
        new MenuItem(prefMenu, 2);
        MenuItem showPrefs = new MenuItem(prefMenu, 0);
        showPrefs.setText(Messages.DefaultInfoPopControlCreator_PREFERENCES);
        showPrefs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)DefaultInfoPopControlCreator.this.fAlertSite.getParentShell(), (String)"NotificationsPreferencePage", null, (Object)DefaultInfoPopControlCreator.this.fAlertSite.getTriggerId());
                dialog.open();
            }
        });
        final ToolItem pref = new ToolItem(bar, 8);
        pref.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.DROP_DOWN));
        pref.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = pref.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = bar.toDisplay(pt);
                prefMenu.setLocation(pt.x, pt.y);
                prefMenu.setVisible(true);
            }
        });
        ToolBar bar2 = new ToolBar(parent, 0x800000);
        bar2.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        ToolItem close = new ToolItem(bar2, 8);
        close.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.CLOSE));
        close.setHotImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.CLOSE_ACTIVE));
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultInfoPopControlCreator.this.fAlertSite.closeAlert();
            }
        });
        return bar;
    }

    protected Control createContent(Composite parent) {
        Display display = parent.getDisplay();
        Font fPopupNormalFont = JFaceResources.getFontRegistry().get("");
        Composite contentContainer = new Composite(parent, 0);
        contentContainer.setBackground(display.getSystemColor(1));
        contentContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        contentContainer.setLayout((Layout)new GridLayout(2, false));
        this.fContentImage = new Label(contentContainer, 0);
        this.fContentImage.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.fContentImage.setBackground(contentContainer.getBackground());
        this.fContentText = new StyledText(contentContainer, 74);
        this.fContentText.setFont(fPopupNormalFont);
        this.fContentText.setCursor(display.getSystemCursor(21));
        GridData contentLayoutData = new GridData(4, 0x1000000, true, false);
        this.fContentText.setLayoutData((Object)contentLayoutData);
        return contentContainer;
    }

    protected String getContentTitle(NotificationInfo event) {
        String title = event.getTitle();
        if (title != null && title.startsWith(NEW_ITEM_INDICATOR)) {
            title = title.substring(NEW_ITEM_INDICATOR.length());
            title = title.trim();
        }
        return title;
    }

    protected String getContentText(NotificationInfo event) {
        return event.getMessage();
    }

    protected Image getContentImage(NotificationInfo event) {
        ImageDescriptor descriptor;
        boolean decorateWithSparkle = false;
        if (event.getTitle() != null && event.getTitle().startsWith(NEW_ITEM_INDICATOR)) {
            decorateWithSparkle = true;
        }
        if (event.getImageUrl() != null) {
            try {
                URL imageUrl = new URL(event.getImageUrl());
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageUrl);
                if (imageDescriptor != null) {
                    if (decorateWithSparkle) {
                        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                        imageDescriptorArray[1] = ImagePool.NEWINFO_OVRL;
                        return this.fResourceManager.createImageWithDefault((ImageDescriptor)new OverlayIcon(imageDescriptor, imageDescriptorArray, 131200));
                    }
                    return this.fResourceManager.createImageWithDefault(imageDescriptor);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (event.getCategory() != null && (descriptor = JFacePlugin.getDefault().getItemImage(event.getCategory())) != null) {
            if (decorateWithSparkle) {
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                imageDescriptorArray[1] = ImagePool.NEWINFO_OVRL;
                return JazzResources.getImageWithDefault(this.fResourceManager, (ImageDescriptor)new OverlayIcon(descriptor, imageDescriptorArray, 131200));
            }
            return JazzResources.getImageWithDefault(this.fResourceManager, descriptor);
        }
        return null;
    }

    protected Runnable getRunnable(NotificationInfo event) {
        ILinkProvider linkProvider;
        Object reason;
        if (event.getRunnable() != null) {
            return event.getRunnable();
        }
        if (event.getDetail() != null && !((reason = event.getDetail()) instanceof Object[]) && (linkProvider = this.getLinkProvider(reason)) != null) {
            try {
                IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter(reason);
                final URI link = new URI(linkProvider.getLink());
                final String title = adapter != null ? adapter.generateTitle(reason) : link.toString();
                Runnable runnable = new Runnable(){

                    public void run() {
                        new FoundationJob(NLS.bind((String)Messages.DefaultInfoPopControlCreator_OPENING_ALERT, (Object)title)){

                            protected IStatus runProtected(IProgressMonitor monitor) {
                                Hyperlinks.openHyperlink((URI)link);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                };
                return runnable;
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    protected Image getHeaderImage(NotificationInfo event) {
        ImageDescriptor descr = this.getHeaderImageDescriptor(event);
        if (descr != null) {
            return JazzResources.getImageWithDefault(this.fResourceManager, descr);
        }
        return null;
    }

    private ImageDescriptor getHeaderImageDescriptor(NotificationInfo event) {
        switch (event.getSeverity()) {
            case 2: {
                return ImagePool.INFO_ICON;
            }
            case 1: {
                return ImagePool.WARN_ICON;
            }
            case 0: {
                return ImagePool.ERROR_ICON;
            }
        }
        return null;
    }

    protected void onClick(NotificationInfo event) {
        if (this.fEvents.size() == 1) {
            this.fAlertSite.closeAlert();
        } else {
            int index = this.fEvents.indexOf(event);
            this.fEvents.remove(index);
            if (this.fEvents.size() > index) {
                this.showInfo(index);
            } else if (index - 1 >= 0) {
                this.showInfo(index - 1);
            }
        }
        final Runnable runnable = this.getRunnable(event);
        if (runnable != null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    JFacePlugin.log(exception);
                }

                public void run() throws Exception {
                    runnable.run();
                }
            });
        }
    }

    private void showInfo(int index) {
        StyleRange[] ranges;
        String text;
        this.fShowingIndex = index;
        NotificationInfo event = (NotificationInfo)this.fEvents.get(index);
        Image image = this.getHeaderImage(event);
        if (image != null) {
            this.fLeftHeaderImage.setImage(image);
        }
        this.fNavLabel.setVisible(this.fEvents.size() > 1);
        this.fNavLabel.setText(NLS.bind((String)Messages.DefaultInfoPopControlCreator_X_OF_Y, (Object)(index + 1), (Object)this.fEvents.size()));
        this.fLeftBar.setVisible(this.fEvents.size() > 1);
        this.fNavLeft.setEnabled(index > 0);
        this.fRightBar.setVisible(this.fEvents.size() > 1);
        this.fNavRight.setEnabled(this.fEvents.size() > index + 1);
        this.fHeaderContainer.layout();
        this.fContentImage.setImage(this.getContentImage(event));
        String titleText = this.getContentTitle(event);
        String messageText = this.getContentText(event);
        if (titleText != null && messageText != null) {
            text = String.valueOf(titleText) + "\n" + messageText;
            ranges = new StyleRange[]{new StyleRange(), new StyleRange()};
            ranges[0].length = titleText.length();
            ranges[0].fontStyle = 1;
            ranges[1].start = ranges[0].length + 1;
            ranges[1].length = messageText.length();
        } else if (titleText != null) {
            text = titleText;
            ranges = new StyleRange[]{new StyleRange()};
            ranges[0].length = text.length();
            ranges[0].fontStyle = 1;
        } else if (messageText != null) {
            text = messageText;
            ranges = new StyleRange[]{new StyleRange()};
            ranges[0].length = text.length();
        } else {
            text = "";
            ranges = new StyleRange[]{};
        }
        this.fContentText.setText(text);
        this.fContentText.setStyleRanges(ranges);
        if (this.fMouseAdapter == null) {
            this.fMouseAdapter = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    DefaultInfoPopControlCreator.this.onClick((NotificationInfo)DefaultInfoPopControlCreator.this.fEvents.get(DefaultInfoPopControlCreator.this.fShowingIndex));
                }
            };
            this.fContentText.addMouseListener(this.fMouseAdapter);
        }
        if (this.fMouseTrackAdapter != null) {
            this.fContentText.removeMouseTrackListener((MouseTrackListener)this.fMouseTrackAdapter);
        }
        this.fMouseTrackAdapter = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                int i = 0;
                while (i < ranges.length) {
                    ranges[i].underline = true;
                    ++i;
                }
                DefaultInfoPopControlCreator.this.fContentText.setStyleRanges(ranges);
            }

            public void mouseExit(MouseEvent e) {
                int i = 0;
                while (i < ranges.length) {
                    ranges[i].underline = false;
                    ++i;
                }
                DefaultInfoPopControlCreator.this.fContentText.setStyleRanges(ranges);
            }
        };
        this.fContentText.addMouseTrackListener((MouseTrackListener)this.fMouseTrackAdapter);
    }

    private void addBorderPaintListener(Composite composite, final Color color, final int width, final boolean roundBottomEdges) {
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point size = ((Composite)e.widget).computeSize(-1, -1);
                if (!roundBottomEdges) {
                    size.x = 194;
                }
                e.gc.setForeground(color);
                e.gc.drawPoint(0, 0);
                e.gc.drawPoint(size.x - 1, 0);
                if (roundBottomEdges) {
                    e.gc.drawPoint(0, size.y - 1);
                    e.gc.drawPoint(size.x - 1, size.y - 1);
                }
                if (width == 2) {
                    e.gc.drawPoint(0, 1);
                    e.gc.drawPoint(1, 0);
                    e.gc.drawPoint(size.x - 2, 0);
                    e.gc.drawPoint(size.x - 1, 1);
                    if (roundBottomEdges) {
                        e.gc.drawPoint(1, size.y - 1);
                        e.gc.drawPoint(0, size.y - 2);
                        e.gc.drawPoint(size.x - 2, size.y - 1);
                        e.gc.drawPoint(size.x - 1, size.y - 2);
                    }
                }
            }
        });
    }

    private ILinkProvider getLinkProvider(Object element) {
        IAdaptable adapter;
        if (element instanceof ILinkProvider) {
            return (ILinkProvider)element;
        }
        if (element instanceof IAdaptable && (adapter = (IAdaptable)element).getAdapter(ILinkProvider.class) != null) {
            return (ILinkProvider)adapter.getAdapter(ILinkProvider.class);
        }
        return null;
    }

    private Composite createBorderComposite(Composite parent, Color color, boolean onlyBottomBorder) {
        Composite borderComposite = new Composite(parent, 0);
        GridLayout borderLayout = new GridLayout(1, false);
        if (onlyBottomBorder) {
            borderLayout.marginHeight = 0;
            borderLayout.marginWidth = 0;
            borderLayout.marginBottom = 1;
        } else {
            borderLayout.marginHeight = 1;
            borderLayout.marginWidth = 1;
        }
        borderLayout.verticalSpacing = 0;
        borderComposite.setLayout((Layout)borderLayout);
        if (color != null) {
            borderComposite.setBackground(color);
        }
        return borderComposite;
    }

    private void roundEdges(Shell shell) {
        Point size = shell.computeSize(-1, -1);
        int x = size.x;
        int y = size.y;
        final Region region = new Region();
        region.add(0, 0, x, y);
        region.subtract(0, 0, 2, 1);
        region.subtract(0, 1, 1, 1);
        region.subtract(x - 2, 0, 2, 1);
        region.subtract(x - 1, 1, 1, 1);
        region.subtract(0, y - 1, 2, 1);
        region.subtract(0, y - 2, 1, 1);
        region.subtract(x - 2, y - 1, 2, 1);
        region.subtract(x - 1, y - 2, 1, 1);
        shell.setRegion(region);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                region.dispose();
            }
        });
    }
}

