/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.calendar;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.team.jface.calendar.Messages;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class DatePicker {
    public static final int LONG = 1;
    public static final int SHORT = 3;
    private Calendar fCalendar;
    private Shell fPicker;
    private DateTime fDateTime;
    private Locale fLocale;
    private boolean fSelected;
    private boolean fExit;
    private int fFormatStyle;

    public DatePicker(Shell parentShell, Locale locale, int formatStyle) {
        this.init(parentShell, locale, formatStyle);
    }

    public DatePicker(Shell parentShell, Locale locale) {
        this.init(parentShell, locale, 2);
    }

    public DatePicker(Shell parentShell, int formatStyle) {
        this.init(parentShell, null, formatStyle);
    }

    public DatePicker(Shell parentShell) {
        this.init(parentShell, null, 2);
    }

    private void init(Shell parentShell, Locale locale, int formatStyle) {
        this.fLocale = locale;
        this.fPicker = new Shell(parentShell, 0);
        this.fPicker.setLayout((Layout)new GridLayout(1, false));
        this.fPicker.setLayoutData((Object)new GridData(1808));
        this.fPicker.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                DatePicker.this.close();
            }
        });
        this.fFormatStyle = formatStyle;
        this.createPickerArea();
        Dialog.applyDialogFont((Control)this.fPicker);
    }

    private void createPickerArea() {
        Link cancel;
        Link ok;
        Composite okcancel;
        Color white = this.fPicker.getDisplay().getSystemColor(1);
        this.fPicker.setBackground(white);
        Composite area = new Composite((Composite)this.fPicker, 0);
        area.setBackground(white);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        area.setLayout((Layout)layout);
        area.setLayoutData((Object)new GridData(1808));
        this.fDateTime = new DateTime(area, 1024);
        this.fCalendar = this.fLocale != null ? Calendar.getInstance((Locale)this.fLocale) : Calendar.getInstance();
        this.fDateTime.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (DatePicker.this.closeOnDoubleClick(e.x, e.y)) {
                    DatePicker.this.rememberDate();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.fDateTime.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\n' || e.character == '\r') {
                    DatePicker.this.rememberDate();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        if (!"win32".equals(SWT.getPlatform())) {
            Composite comp = new Composite(area, 0);
            comp.setBackground(white);
            layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            comp.setLayout((Layout)layout);
            comp.setLayoutData((Object)new GridData(1808));
            Link today = new Link(comp, 0);
            today.setBackground(white);
            GridData todaydata = new GridData();
            todaydata.horizontalIndent = 0;
            today.setLayoutData((Object)todaydata);
            today.setText(NLS.bind((String)"<a>{0}</a>", (Object)Messages.DatePicker_TODAY));
            today.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DatePicker.this.setDate(new Date());
                    DatePicker.this.rememberDate();
                }
            });
            Label todaylabel = new Label(comp, 0);
            todaylabel.setBackground(white);
            todaylabel.setText(DateFormat.getDateInstance().format(new Date()));
            GridData data = new GridData();
            data.horizontalIndent = 0;
            todaylabel.setLayoutData((Object)data);
            okcancel = new Composite(comp, 0);
            okcancel.setLayoutData((Object)new GridData(131072, 4, true, true));
        } else {
            okcancel = new Composite(area, 0);
            okcancel.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        okcancel.setBackground(white);
        GridLayout okcancellayout = new GridLayout(2, false);
        okcancellayout.marginHeight = 0;
        okcancellayout.marginWidth = 0;
        okcancel.setLayout((Layout)okcancellayout);
        if (!"carbon".equals(SWT.getPlatform())) {
            ok = new Link(okcancel, 0);
            cancel = new Link(okcancel, 0);
        } else {
            cancel = new Link(okcancel, 0);
            ok = new Link(okcancel, 0);
        }
        ok.setBackground(white);
        ok.setLayoutData((Object)new GridData(1, 4, true, true));
        ok.setText(NLS.bind((String)"<a>{0}</a>", (Object)IDialogConstants.OK_LABEL));
        ok.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this.rememberDate();
            }
        });
        cancel.setBackground(white);
        cancel.setLayoutData((Object)new GridData(131072, 4, true, true));
        cancel.setText(NLS.bind((String)"<a>{0}</a>", (Object)IDialogConstants.CANCEL_LABEL));
        cancel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DatePicker.this.close();
            }
        });
    }

    boolean closeOnDoubleClick(int x, int y) {
        if ("win32".equals(SWT.getPlatform()) || "gtk".equals(SWT.getPlatform())) {
            return y >= 32;
        }
        return true;
    }

    public void setLocation(int x, int y) {
        this.fPicker.setLocation(x, y);
    }

    public void setDate(Date date) {
        this.fCalendar.setTime(date);
        this.fDateTime.setYear(this.fCalendar.get(1));
        this.fDateTime.setMonth(this.fCalendar.get(2));
        this.fDateTime.setDay(this.fCalendar.get(5));
    }

    public Date getDateObject() {
        if (this.fSelected) {
            return this.fCalendar.getTime();
        }
        return null;
    }

    public String getDate() {
        if (this.fSelected) {
            java.text.DateFormat df = this.fLocale != null ? java.text.DateFormat.getDateInstance(this.fFormatStyle, this.fLocale) : java.text.DateFormat.getDateInstance(this.fFormatStyle);
            return df.format(this.fCalendar.getTime());
        }
        return null;
    }

    public String getDate(int style) {
        if (this.fSelected) {
            java.text.DateFormat df = this.fLocale != null ? java.text.DateFormat.getDateInstance(style, this.fLocale) : java.text.DateFormat.getDateInstance(style);
            return df.format(this.fCalendar.getTime());
        }
        return null;
    }

    private void rememberDate() {
        this.fSelected = true;
        this.fCalendar.clear();
        this.fCalendar.set(this.fDateTime.getYear(), this.fDateTime.getMonth(), this.fDateTime.getDay());
        this.close();
    }

    public void open() {
        this.fPicker.pack();
        this.fPicker.open();
        Display display = this.fPicker.getDisplay();
        this.fExit = false;
        while (!this.fPicker.isDisposed() && !this.fExit) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!this.fPicker.isDisposed()) {
            this.fPicker.close();
            this.fPicker.dispose();
        }
    }

    public void close() {
        this.fExit = true;
    }
}

