/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface;

import com.ibm.team.jface.internal.JFacePlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.osgi.framework.Bundle;

public class JazzResources {
    public static final String TITLE_FONT = "com.ibm.team.jface.itemview.TitleFont";
    public static final String OUTLINE_COLOR = "com.ibm.team.jface.itemview.OutlineColor";
    public static final String GRADIENT_COLOR = "com.ibm.team.jface.itemview.GradientColor";
    public static final String TITLE_COLOR = "com.ibm.team.jface.itemview.TitleColor";
    public static final String SIDEBAR_COLOR = "com.ibm.team.jface.itemview.SidebarColor";
    public static final String REDUCED_COLORS_THEME = "org.eclipse.ui.ide.systemDefault";
    private static final RGB WHITE = new RGB(255, 255, 255);
    private static final RGB BLACK = new RGB(0, 0, 0);
    private static final int BUFF_LEN = 4096;
    private static Map<ImageDescriptor, String> fgPathMap = Collections.synchronizedMap(new HashMap());
    private static Map<ImageDescriptor, String> fgPluginMap = Collections.synchronizedMap(new HashMap());
    private static Map<ImageDescriptor, URL> fgUrlMap = Collections.synchronizedMap(new HashMap());
    private static boolean fgInitialized;

    public static Color getColor(String id) {
        if (!fgInitialized) {
            JazzResources.init();
        }
        return JFaceResources.getColorRegistry().get(id);
    }

    public static RGB getRGB(String id) {
        if (!fgInitialized) {
            JazzResources.init();
        }
        return JFaceResources.getColorRegistry().getRGB(id);
    }

    public static Font getFont(String id) {
        if (!fgInitialized) {
            JazzResources.init();
        }
        return JFaceResources.getFont((String)id);
    }

    public static Image getImage(ResourceManager mgr, ImageDescriptor imageDesc, Image defaultImage) {
        if (imageDesc != null) {
            Object o = mgr.find((DeviceResourceDescriptor)imageDesc);
            if (o != null) {
                return (Image)o;
            }
            if (mgr.getDevice() != null) {
                try {
                    return mgr.createImage(imageDesc);
                }
                catch (DeviceResourceException e) {
                    JFacePlugin.log(e);
                }
            }
        }
        return defaultImage;
    }

    public static Image getImageWithDefault(ResourceManager mgr, ImageDescriptor imageDesc) {
        Object o = mgr.find((DeviceResourceDescriptor)imageDesc);
        if (o != null) {
            return (Image)o;
        }
        if (mgr.getDevice() != null) {
            return mgr.createImageWithDefault(imageDesc);
        }
        return null;
    }

    public static Font getFont(ResourceManager mgr, FontDescriptor fontDesc, Font defaultFont) {
        Object o = mgr.find((DeviceResourceDescriptor)fontDesc);
        if (o != null) {
            return (Font)o;
        }
        if (mgr.getDevice() != null) {
            try {
                return mgr.createFont(fontDesc);
            }
            catch (DeviceResourceException e) {
                JFacePlugin.log(e);
            }
        }
        return defaultFont;
    }

    public static Color getColor(ResourceManager mgr, ColorDescriptor colorDesc) {
        Object o = mgr.find((DeviceResourceDescriptor)colorDesc);
        if (o != null) {
            return (Color)o;
        }
        if (mgr.getDevice() != null) {
            try {
                return mgr.createColor(colorDesc);
            }
            catch (DeviceResourceException e) {
                JFacePlugin.log(e);
            }
        }
        return null;
    }

    public static Color getColor(ResourceManager mgr, RGB color) {
        return JazzResources.getColor(mgr, ColorDescriptor.createFrom((RGB)color));
    }

    public static void registerPath(ImageDescriptor id, String plugin, String path) {
        fgPluginMap.put(id, plugin);
        fgPathMap.put(id, path);
    }

    public static void registerUrl(ImageDescriptor id, URL url) {
        fgUrlMap.put(id, url);
    }

    public static URL createURL(ImageDescriptor id) {
        URL url = fgUrlMap.get(id);
        if (url != null) {
            return url;
        }
        String path = fgPathMap.get(id);
        String plugins = fgPluginMap.get(id);
        if (path != null && plugins != null) {
            try {
                return JazzResources.createImageURL(plugins, path);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static URL createImageURL(String pluginId, String pathRelToPlugin) throws IOException {
        URL bundleEntryURL = JazzResources.getBundleEntryURL(pluginId, pathRelToPlugin);
        if (bundleEntryURL != null) {
            return JazzResources.createImageURL(bundleEntryURL);
        }
        return null;
    }

    public static URL createImageURL(URL url) throws FileNotFoundException, IOException {
        File createdFile = JazzResources.createFileFromURL(url);
        if (createdFile != null) {
            return createdFile.toURL();
        }
        return null;
    }

    public static String createResourceURL(String pluginId, String pathRelToPlugin) {
        File file;
        block7: {
            URL bundleEntryURL;
            block6: {
                bundleEntryURL = JazzResources.getBundleEntryURL(pluginId, pathRelToPlugin);
                if (bundleEntryURL != null) break block6;
                return "";
            }
            file = JazzResources.createFileFromURL(bundleEntryURL);
            if (file != null) break block7;
            return "";
        }
        try {
            URI uri = file.toURI();
            String s = uri.toASCIIString();
            return s.replaceFirst("/", "///");
        }
        catch (FileNotFoundException e) {
            JFacePlugin.getDefault().log("Error while creating resource URL", e);
        }
        catch (MalformedURLException e) {
            JFacePlugin.getDefault().log("Error while creating resource URL", e);
        }
        catch (IOException e) {
            JFacePlugin.getDefault().log("Error while creating resource URL", e);
        }
        return "";
    }

    public static String getConformingURL(URL url) {
        String s = url.toExternalForm();
        if (s.startsWith("file:/")) {
            return s.replaceFirst("/", "///");
        }
        return s;
    }

    private JazzResources() {
    }

    private static RGB getTitleBarGradientRGB() {
        RGB tbBg = Display.getDefault().getSystemColor(32).getRGB();
        Color bg = Display.getDefault().getSystemColor(25);
        RGB formBackground = bg.getRGB();
        tbBg = FormColors.blend((RGB)formBackground, (RGB)tbBg, (int)77);
        if (JazzResources.isWhiteBackground(Display.getDefault())) {
            if (FormColors.testTwoPrimaryColors((RGB)tbBg, (int)241, (int)256)) {
                tbBg = FormColors.blend((RGB)tbBg, (RGB)BLACK, (int)90);
            } else if (FormColors.testTwoPrimaryColors((RGB)tbBg, (int)0, (int)231)) {
                if (FormColors.testAnyPrimaryColor((RGB)tbBg, (int)214, (int)231)) {
                    tbBg = FormColors.blend((RGB)tbBg, (RGB)WHITE, (int)95);
                } else if (FormColors.testAnyPrimaryColor((RGB)tbBg, (int)199, (int)215)) {
                    tbBg = FormColors.blend((RGB)tbBg, (RGB)WHITE, (int)90);
                }
            }
        } else if (FormColors.testTwoPrimaryColors((RGB)tbBg, (int)209, (int)256)) {
            if (FormColors.testAnyPrimaryColor((RGB)tbBg, (int)210, (int)236)) {
                tbBg = FormColors.blend((RGB)tbBg, (RGB)BLACK, (int)60);
            } else if (FormColors.testAnyPrimaryColor((RGB)tbBg, (int)235, (int)256)) {
                tbBg = FormColors.blend((RGB)tbBg, (RGB)BLACK, (int)20);
            }
        }
        RGB tbGbg = FormColors.blend((RGB)formBackground, (RGB)tbBg, (int)50);
        return tbGbg;
    }

    private static RGB getTitleBarOutlineRGB() {
        RGB tbBorder = Display.getDefault().getSystemColor(35).getRGB();
        if (JazzResources.isWhiteBackground(Display.getDefault())) {
            if (FormColors.testTwoPrimaryColors((RGB)tbBorder, (int)215, (int)256)) {
                if (FormColors.testAnyPrimaryColor((RGB)tbBorder, (int)215, (int)226)) {
                    tbBorder = FormColors.blend((RGB)tbBorder, (RGB)BLACK, (int)90);
                } else if (FormColors.testAnyPrimaryColor((RGB)tbBorder, (int)225, (int)256)) {
                    tbBorder = FormColors.blend((RGB)tbBorder, (RGB)BLACK, (int)70);
                }
            } else if (FormColors.testTwoPrimaryColors((RGB)tbBorder, (int)0, (int)186)) {
                if (FormColors.testAnyPrimaryColor((RGB)tbBorder, (int)175, (int)186)) {
                    tbBorder = FormColors.blend((RGB)tbBorder, (RGB)WHITE, (int)95);
                } else if (FormColors.testTwoPrimaryColors((RGB)tbBorder, (int)154, (int)176)) {
                    tbBorder = FormColors.blend((RGB)tbBorder, (RGB)WHITE, (int)90);
                } else if (FormColors.testTwoPrimaryColors((RGB)tbBorder, (int)124, (int)155)) {
                    tbBorder = FormColors.blend((RGB)tbBorder, (RGB)WHITE, (int)80);
                }
            }
        } else if (FormColors.testTwoPrimaryColors((RGB)tbBorder, (int)200, (int)256)) {
            tbBorder = FormColors.blend((RGB)tbBorder, (RGB)BLACK, (int)50);
        }
        return tbBorder;
    }

    private static RGB getTitleRGB() {
        RGB rgb = Display.getDefault().getSystemColor(26).getRGB();
        if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)120, (int)151)) {
            rgb = FormColors.blend((RGB)rgb, (RGB)BLACK, (int)80);
        } else if (FormColors.testTwoPrimaryColors((RGB)rgb, (int)150, (int)256)) {
            rgb = FormColors.blend((RGB)rgb, (RGB)BLACK, (int)50);
        }
        return rgb;
    }

    private static RGB getSideBarRGB() {
        return new RGB(248, 248, 248);
    }

    private static boolean isWhiteBackground(Display d) {
        Color bg = d.getSystemColor(25);
        return bg.getRed() == 255 && bg.getGreen() == 255 && bg.getBlue() == 255;
    }

    private static void init() {
        boolean useReducedColors = REDUCED_COLORS_THEME.equals(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());
        Display display = Display.getDefault();
        if (!JFaceResources.getColorRegistry().hasValueFor(GRADIENT_COLOR)) {
            if (!useReducedColors) {
                JFaceResources.getColorRegistry().put(GRADIENT_COLOR, JazzResources.getTitleBarGradientRGB());
            } else {
                JFaceResources.getColorRegistry().put(GRADIENT_COLOR, display.getSystemColor(25).getRGB());
            }
        }
        if (!JFaceResources.getColorRegistry().hasValueFor(SIDEBAR_COLOR)) {
            if (!useReducedColors) {
                JFaceResources.getColorRegistry().put(SIDEBAR_COLOR, JazzResources.getSideBarRGB());
            } else {
                JFaceResources.getColorRegistry().put(SIDEBAR_COLOR, display.getSystemColor(25).getRGB());
            }
        }
        if (!JFaceResources.getColorRegistry().hasValueFor(OUTLINE_COLOR)) {
            if (!useReducedColors) {
                JFaceResources.getColorRegistry().put(OUTLINE_COLOR, JazzResources.getTitleBarOutlineRGB());
            } else {
                JFaceResources.getColorRegistry().put(OUTLINE_COLOR, display.getSystemColor(26).getRGB());
            }
        }
        if (!JFaceResources.getColorRegistry().hasValueFor(TITLE_COLOR)) {
            if (!useReducedColors) {
                JFaceResources.getColorRegistry().put(TITLE_COLOR, JazzResources.getTitleRGB());
            } else {
                JFaceResources.getColorRegistry().put(TITLE_COLOR, display.getSystemColor(26).getRGB());
            }
        }
        if (!JFaceResources.getFontRegistry().hasValueFor(TITLE_FONT)) {
            FontData[] data = Display.getDefault().getSystemFont().getFontData();
            int i = 0;
            while (i < data.length) {
                FontData data2 = data[i];
                data2.setStyle(1);
                ++i;
            }
            JFaceResources.getFontRegistry().put(TITLE_FONT, data);
        }
        fgInitialized = true;
    }

    private static URL getBundleEntryURL(String pluginId, String pathRelToPlugin) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (!JazzResources.isReady(bundle)) {
            return null;
        }
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(pathRelToPlugin), null);
        return url;
    }

    private static File createFileFromURL(URL url) throws IOException, FileNotFoundException {
        File file;
        if ("file".equals(url.getProtocol())) {
            URI uri;
            block9: {
                try {
                    uri = url.toURI();
                    if (uri.getAuthority() == null) break block9;
                    return null;
                }
                catch (URISyntaxException e) {
                    JFacePlugin.log(e);
                    return null;
                }
            }
            file = new File(uri);
        }
        Path relpath = new Path(url.getFile());
        file = new File(JazzResources.getRootURL().append(String.valueOf(url.getHost()) + "_" + relpath.lastSegment()).toOSString());
        if (!file.exists()) {
            InputStream inputStream = url.openStream();
            FileOutputStream outputStream = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            try {
                int readCount;
                while ((readCount = inputStream.read(buf, 0, 4096)) != -1) {
                    outputStream.write(buf, 0, readCount);
                }
            }
            finally {
                inputStream.close();
                outputStream.close();
            }
        }
        return file;
    }

    public static File createFile(String pluginId, String pathRelToPlugin, byte[] data) throws IOException, FileNotFoundException, MalformedURLException {
        String filePath = JazzResources.getFilePathFromConfigArea0(pluginId, pathRelToPlugin).toOSString();
        if (filePath != null) {
            File file = new File(filePath);
            if (!file.exists()) {
                FileOutputStream outputStream = new FileOutputStream(file);
                try {
                    outputStream.write(data, 0, data.length);
                }
                finally {
                    outputStream.close();
                }
            }
            return file;
        }
        return null;
    }

    private static IPath getFilePathFromConfigArea0(String pluginId, String relPath) {
        File file;
        block5: {
            URL bundleURL = JazzResources.getBundleEntryURL(pluginId, relPath);
            if (bundleURL == null) {
                return null;
            }
            file = JazzResources.createFileFromURL(bundleURL);
            if (file != null) break block5;
            return null;
        }
        try {
            Path path = new Path(file.getAbsolutePath());
            return path;
        }
        catch (FileNotFoundException e) {
            JFacePlugin.getDefault().log("Error while creating file from URL", e);
        }
        catch (IOException e) {
            JFacePlugin.getDefault().log("Error while creating file from URL", e);
        }
        return null;
    }

    public static IPath getFilePathFromConfigArea(String plugin, String relPath) {
        return JazzResources.getRootURL().append(String.valueOf(plugin) + "_" + relPath);
    }

    public static ImageDescriptor getImageDescriptorFromFileCache(String pluginId, String relPath) {
        ImageDescriptor imgDesc = null;
        URL bundleURL = JazzResources.getBundleEntryURL(pluginId, relPath);
        if (bundleURL == null) {
            return null;
        }
        try {
            URL fileUrl;
            File file = JazzResources.createFileFromURL(bundleURL);
            if (file.exists() && (imgDesc = ImageDescriptor.createFromURL((URL)(fileUrl = file.toURL()))) != null) {
                JazzResources.registerUrl(imgDesc, fileUrl);
                return imgDesc;
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return imgDesc;
    }

    public static IPath getRootURL() {
        ConfigurationScope configurationScope = new ConfigurationScope();
        IPath path = configurationScope.getLocation();
        File root = new File((path = path.append("com.ibm.team.jface")).toOSString());
        if (!root.exists()) {
            root.mkdir();
        }
        return path;
    }

    private static boolean isReady(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return (bundle.getState() & 0x3C) != 0;
    }
}

