/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.views.markers.internal.AbstractField;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.Util;

public class FieldCategory
extends AbstractField {
    public String getDescription() {
        return MarkerMessages.description_type;
    }

    public Image getDescriptionImage() {
        return null;
    }

    public String getColumnHeaderText() {
        return this.getDescription();
    }

    public Image getColumnHeaderImage() {
        return null;
    }

    public String getValue(Object obj) {
        if (obj instanceof ConcreteMarker) {
            ConcreteMarker marker = (ConcreteMarker)obj;
            if (marker.getGroup() == null) {
                if (!marker.getMarker().exists()) {
                    return MarkerMessages.FieldCategory_Uncategorized;
                }
                String groupName = MarkerSupportRegistry.getInstance().getCategory(marker.getMarker());
                if (groupName == null) {
                    String typeId;
                    try {
                        typeId = marker.getMarker().getType();
                    }
                    catch (CoreException e) {
                        Policy.handle(e);
                        return MarkerMessages.FieldCategory_Uncategorized;
                    }
                    MarkerType type = MarkerTypesModel.getInstance().getType(typeId);
                    groupName = type.getLabel();
                }
                marker.setGroup(groupName);
            }
            return (String)marker.getGroup();
        }
        return Util.EMPTY_STRING;
    }

    public Image getImage(Object obj) {
        return null;
    }

    public int compare(Object obj1, Object obj2) {
        return this.getValue(obj1).compareTo(this.getValue(obj2));
    }

    public int getDefaultDirection() {
        return 1;
    }

    public int getPreferredWidth() {
        return 200;
    }
}

