/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    int dialog;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String fileName = "";
    String filterPath = "";
    String fullPath;
    int filterIndex = -1;
    boolean overwrite = false;
    static final String FILTER = "*";
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    int cancelPressed(int widget, int client, int call) {
        OS.XtUnmanageChild(widget);
        return 0;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    int itemSelected(int widget, int client, int call) {
        int fileList = OS.XmFileSelectionBoxGetChild(this.dialog, 8);
        if (fileList == 0) {
            return 0;
        }
        int selectionText = OS.XmFileSelectionBoxGetChild(this.dialog, 13);
        if (selectionText == 0) {
            return 0;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNselectedItems;
        nArray[2] = OS.XmNselectedItemCount;
        int[] argList = nArray;
        OS.XtGetValues(fileList, argList, argList.length / 2);
        int items = argList[1];
        int itemCount = argList[3];
        int ptr = 0;
        if (itemCount == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNdirectory;
            int[] argList2 = nArray2;
            OS.XtGetValues(this.dialog, argList2, argList2.length / 2);
            ptr = argList2[1];
        } else {
            int[] buffer = new int[1];
            OS.memmove(buffer, items, 4);
            ptr = buffer[0];
        }
        if (ptr == 0) {
            return 0;
        }
        Display display = this.parent.getDisplay();
        int[] table = new int[]{display.tabMapping, display.crMapping};
        int address = OS.XmStringUnparse(ptr, null, 0, 0, table, table.length, 0);
        if (itemCount == 0) {
            OS.XmStringFree(ptr);
        }
        if (address == 0) {
            return 0;
        }
        int length = OS.strlen(address);
        byte[] buffer = new byte[length + 1];
        OS.memmove(buffer, address, length);
        OS.XtFree(address);
        OS.XmTextSetString(selectionText, buffer);
        OS.XmTextSetInsertionPosition(selectionText, OS.XmTextGetLastPosition(selectionText));
        return 0;
    }

    int okPressed(int widget, int client, int call) {
        String fullPath = null;
        String fileName = null;
        String[] fileNames = null;
        int[] nArray = new int[4];
        nArray[0] = OS.XmNdirSpec;
        nArray[2] = OS.XmNdirectory;
        int[] argList = nArray;
        OS.XtGetValues(this.dialog, argList, argList.length / 2);
        int xmString1 = argList[1];
        Display display = this.parent.getDisplay();
        int[] table = new int[]{display.tabMapping, display.crMapping};
        int ptr = OS.XmStringUnparse(xmString1, null, 0, 0, table, table.length, 0);
        if (ptr != 0) {
            int length = OS.strlen(ptr);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, ptr, length);
            OS.XtFree(ptr);
            fullPath = new String(Converter.mbcsToWcs(null, buffer)).trim();
        }
        OS.XmStringFree(xmString1);
        int n = this.filterIndex = this.filterExtensions == null || this.filterExtensions.length == 0 ? -1 : 0;
        if ((this.style & 2) != 0) {
            int fileList = OS.XmFileSelectionBoxGetChild(this.dialog, 8);
            if (fileList == 0) {
                return 0;
            }
            int[] nArray2 = new int[4];
            nArray2[0] = OS.XmNselectedItems;
            nArray2[2] = OS.XmNselectedItemCount;
            int[] argList2 = nArray2;
            OS.XtGetValues(fileList, argList2, argList2.length / 2);
            int items = argList2[1];
            int itemCount = argList2[3];
            int[] buffer1 = new int[1];
            fileNames = new String[itemCount];
            boolean match = false;
            int i = 0;
            while (i < itemCount) {
                OS.memmove(buffer1, items, 4);
                ptr = buffer1[0];
                int address = OS.XmStringUnparse(ptr, null, 0, 0, table, table.length, 0);
                if (address != 0) {
                    int length = OS.strlen(address);
                    byte[] buffer = new byte[length];
                    OS.memmove(buffer, address, length);
                    OS.XtFree(address);
                    String fullFilename = new String(Converter.mbcsToWcs(null, buffer));
                    int index = fullFilename.lastIndexOf(SEPARATOR);
                    fileNames[i] = fullFilename.substring(index + 1, fullFilename.length());
                    if (fullFilename.equals(fullPath)) {
                        match = true;
                    }
                }
                items += 4;
                ++i;
            }
            if (match) {
                fileName = fileNames[0];
            } else {
                int index = fullPath.lastIndexOf(SEPARATOR);
                fileName = fullPath.substring(index + 1, fullPath.length());
                fileNames = new String[]{fileName};
            }
        } else {
            int index = fullPath.lastIndexOf(SEPARATOR);
            fileName = fullPath.substring(index + 1, fullPath.length());
            fileNames = new String[]{fileName};
        }
        if (fileName.equals("")) {
            int[] nArray3 = new int[2];
            nArray3[0] = OS.XmNdirMask;
            int[] argList1 = nArray3;
            OS.XtGetValues(this.dialog, argList1, argList1.length / 2);
            int directoryHandle = argList1[1];
            int[] argList2 = new int[]{OS.XmNpattern, directoryHandle};
            OS.XtSetValues(this.dialog, argList2, argList2.length / 2);
            OS.XmStringFree(directoryHandle);
            return 0;
        }
        int xmString2 = argList[3];
        ptr = OS.XmStringUnparse(xmString2, null, 0, 0, table, table.length, 0);
        if (ptr != 0) {
            int length = OS.strlen(ptr);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, ptr, length);
            OS.XtFree(ptr);
            this.filterPath = new String(Converter.mbcsToWcs(null, buffer));
        }
        OS.XmStringFree(xmString2);
        int length = this.filterPath.length();
        if (length > 0 && this.filterPath.charAt(length - 1) == SEPARATOR) {
            this.filterPath = this.filterPath.substring(0, length - 1);
        }
        this.fullPath = fullPath;
        this.fileName = fileName;
        this.fileNames = fileNames;
        OS.XtUnmanageChild(widget);
        return 0;
    }

    public String open() {
        Callback cancelCallback;
        int cancelAddress;
        int length;
        String filter;
        String string = this.title;
        if (string.length() == 0) {
            string = " ";
        }
        byte[] buffer1 = Converter.wcsToMbcs(null, string, true);
        int xmStringPtr1 = OS.XmStringParseText(buffer1, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        this.fullPath = null;
        this.fileNames = new String[0];
        String mask = FILTER;
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions.length != 0 && this.filterExtensions.length == 1 && (filter = this.filterExtensions[0]).indexOf(59, 0) == -1) {
            mask = filter;
        }
        byte[] buffer2 = Converter.wcsToMbcs(null, mask, true);
        int xmStringPtr2 = OS.XmStringParseText(buffer2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if ((length = this.filterPath.length()) == 0 || this.filterPath.charAt(length - 1) != SEPARATOR) {
            this.filterPath = String.valueOf(this.filterPath) + SEPARATOR;
        }
        byte[] buffer3 = Converter.wcsToMbcs(null, this.filterPath, true);
        int xmStringPtr3 = OS.XmStringParseText(buffer3, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        boolean defaultPos = this.parent.isVisible();
        Display display = this.parent.display;
        int[] nArray = new int[16];
        nArray[0] = OS.XmNresizePolicy;
        nArray[2] = OS.XmNdialogStyle;
        nArray[3] = 1;
        nArray[4] = OS.XmNwidth;
        nArray[5] = OS.XDisplayWidth(display.xDisplay, OS.XDefaultScreen(display.xDisplay)) * 4 / 9;
        nArray[6] = OS.XmNpathMode;
        nArray[8] = OS.XmNdialogTitle;
        nArray[9] = xmStringPtr1;
        nArray[10] = OS.XmNpattern;
        nArray[11] = xmStringPtr2;
        nArray[12] = OS.XmNdirMask;
        nArray[13] = xmStringPtr3;
        nArray[14] = OS.XmNdefaultPosition;
        nArray[15] = defaultPos ? 1 : 0;
        int[] argList1 = nArray;
        if (OS.IsAIX) {
            this.parent.realizeWidget();
        }
        int parentHandle = this.parent.shellHandle;
        byte[] name = new byte[1];
        this.dialog = OS.XmCreateFileSelectionDialog(parentHandle, name, argList1, argList1.length / 2);
        int child = OS.XmFileSelectionBoxGetChild(this.dialog, 7);
        if (child != 0) {
            OS.XtUnmanageChild(child);
        }
        OS.XmStringFree(xmStringPtr1);
        OS.XmStringFree(xmStringPtr2);
        OS.XmStringFree(xmStringPtr3);
        if (this.fileName != null && this.fileName.length() > 0) {
            int newDirSpec;
            byte[] buffer4 = Converter.wcsToMbcs(null, this.fileName, true);
            int xmStringPtr4 = OS.XmStringParseText(buffer4, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNdirSpec;
            int[] argList2 = nArray2;
            OS.XtGetValues(this.dialog, argList2, argList2.length / 2);
            int oldDirSpec = argList2[1];
            argList2[1] = newDirSpec = OS.XmStringConcat(oldDirSpec, xmStringPtr4);
            OS.XtSetValues(this.dialog, argList2, argList2.length / 2);
            OS.XmStringFree(xmStringPtr4);
            OS.XmStringFree(oldDirSpec);
            OS.XmStringFree(newDirSpec);
        }
        if ((cancelAddress = (cancelCallback = new Callback(this, "cancelPressed", 3)).getAddress()) == 0) {
            SWT.error(3);
        }
        OS.XtAddCallback(this.dialog, OS.XmNcancelCallback, cancelAddress, 0);
        Callback okCallback = new Callback(this, "okPressed", 3);
        int okAddress = okCallback.getAddress();
        if (okAddress == 0) {
            SWT.error(3);
        }
        OS.XtAddCallback(this.dialog, OS.XmNokCallback, okAddress, 0);
        Callback selectCallback = null;
        if ((this.style & 2) != 0 && (child = OS.XmFileSelectionBoxGetChild(this.dialog, 8)) != 0) {
            int[] argList3 = new int[]{OS.XmNselectionPolicy, 2};
            OS.XtSetValues(child, argList3, argList3.length / 2);
            selectCallback = new Callback(this, "itemSelected", 3);
            int selectAddress = selectCallback.getAddress();
            if (selectAddress == 0) {
                this.error(3);
            }
            OS.XtAddCallback(child, OS.XmNextendedSelectionCallback, selectAddress, 0);
        }
        if (!defaultPos) {
            OS.XtRealizeWidget(this.dialog);
            int[] nArray3 = new int[4];
            nArray3[0] = OS.XmNwidth;
            nArray3[2] = OS.XmNheight;
            int[] argList4 = nArray3;
            OS.XtGetValues(this.dialog, argList4, argList4.length / 2);
            Monitor monitor = this.parent.getMonitor();
            Rectangle bounds = monitor.getBounds();
            int x = bounds.x + (bounds.width - argList4[1]) / 2;
            int y = bounds.y + (bounds.height - argList4[3]) / 2;
            int[] argList5 = new int[]{OS.XmNx, x, OS.XmNy, y};
            OS.XtSetValues(this.dialog, argList5, argList5.length / 2);
        }
        OS.XtManageChild(this.dialog);
        while (OS.XtIsRealized(this.dialog) && OS.XtIsManaged(this.dialog)) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (OS.XtIsRealized(this.dialog)) {
            OS.XtDestroyWidget(this.dialog);
        }
        okCallback.dispose();
        cancelCallback.dispose();
        if (selectCallback != null) {
            selectCallback.dispose();
        }
        return this.fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean overwrite) {
    }
}

