/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.shared.common.internal.valueProviders;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.util.JavaScriptObjectProxy;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.shared.common.internal.ScriptEnvironmentManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptAttributeValueProvider
implements IValueSetProvider<Object>,
IValueProvider<Object>,
IDefaultValueProvider<Object> {
    private static final String SCRIPT = "script";
    private static final String CLASS = "class";

    public Object getValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        IScriptAttributeValueProvider valueProvider = this.getProvider(workItemCommon, attribute.getProjectArea(), configuration, monitor);
        Object value = valueProvider.getValue(attribute.getIdentifier(), workItem, configuration);
        return this.convert(attribute, value);
    }

    public Object getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        IScriptAttributeValueProvider valueProvider = this.getProvider(workItemCommon, attribute.getProjectArea(), configuration, monitor);
        Object value = valueProvider.getDefaultValue(attribute.getIdentifier(), workItem, configuration);
        return this.convert(attribute, value);
    }

    public List<Object> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        IScriptAttributeValueProvider valueProvider = this.getProvider(workItemCommon, attribute.getProjectArea(), configuration, monitor);
        Object[] values = valueProvider.getValueSet(attribute.getIdentifier(), workItem, configuration);
        return this.convert(attribute, values);
    }

    private IScriptAttributeValueProvider getProvider(IWorkItemCommon workItemCommon, IProjectAreaHandle projectArea, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        String providerClass;
        IConfiguration classCfg = configuration.getChild(SCRIPT);
        String string = providerClass = classCfg != null ? classCfg.getString(CLASS) : null;
        if (classCfg == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString((String)"ScriptAttributeValueProvider.MISSING_ATTRIBUTE"), (Object)CLASS, (Object[])new Object[0]));
        }
        IScriptEnvironment scriptEngine = ScriptEnvironmentManager.getScriptEnvironment(workItemCommon.getAuditableCommon(), projectArea, monitor);
        return (IScriptAttributeValueProvider)JavaScriptObjectProxy.newInstance((IScriptEnvironment)scriptEngine, IScriptAttributeValueProvider.class, (String)providerClass, (Object[])new Object[0]);
    }

    private Object convert(IAttribute attribute, Object value) {
        if ("integer".equals(attribute.getAttributeType())) {
            return ((Double)value).intValue();
        }
        if ("long".equals(attribute.getAttributeType())) {
            return ((Double)value).longValue();
        }
        AttributeType attributeType = AttributeTypes.getAttributeType((String)attribute.getAttributeType());
        return attributeType.valueOf(value.toString(), attribute.getOrigin());
    }

    private List<Object> convert(IAttribute attribute, Object[] values) {
        ArrayList<Object> converted = new ArrayList<Object>(values.length);
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            converted.add(this.convert(attribute, object));
            ++n2;
        }
        return converted;
    }

    private static interface IScriptAttributeValueProvider {
        public Object getValue(String var1, IWorkItem var2, IConfiguration var3);

        public Object getDefaultValue(String var1, IWorkItem var2, IConfiguration var3);

        public Object[] getValueSet(String var1, IWorkItem var2, IConfiguration var3);
    }
}

