/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.shared.common.internal;

import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.environment.FeatureScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.environment.dojo.DojoFeature;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.shared.common.CommonScriptFeatures;
import com.ibm.team.workitem.shared.common.internal.ProcessAttachmentScriptFeature;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemCommonScriptEnvironment
extends FeatureScriptEnvironment {
    private static final String PROCESS_ATTACHMENT_PATH_PREFIX = "/workitem/scripts/common/";
    private final IAuditableCommon fAuditableCommon;
    private final IProjectAreaHandle fProjectArea;

    public WorkItemCommonScriptEnvironment(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        super(new List[]{DojoFeature.DOJO_FEATURES, CommonScriptFeatures.ALL_FEATURES});
        this.fAuditableCommon = auditableCommon;
        this.fProjectArea = projectArea;
    }

    public void initializeProjectAttachmentScripts(IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemCommon workItemCommon = (WorkItemCommon)this.fAuditableCommon.getPeer(IWorkItemCommon.class);
        if (workItemCommon.allowProcessScripts(monitor)) {
            ItemQueryIterator query = WorkItemQueries.processAttachmentsByPathPrefix((IAuditableCommon)this.fAuditableCommon, (IProjectAreaHandle)this.fProjectArea, (String)PROCESS_ATTACHMENT_PATH_PREFIX);
            List processAttachments = this.fAuditableCommon.resolveAuditables(query.toList(monitor), ItemProfile.PROCESS_ATTACHMENT_DEFAULT, monitor);
            this.define(processAttachments);
        }
    }

    private void define(final List<IProcessAttachment> processAttachments) {
        this.execute((IScriptRunnable)new IScriptRunnable<Void, RuntimeException>(){

            public Void run(Context cx, Scriptable scope) throws RuntimeException {
                for (IProcessAttachment processAttachment : processAttachments) {
                    ProcessAttachmentScriptFeature feature = new ProcessAttachmentScriptFeature(processAttachment, WorkItemCommonScriptEnvironment.this.fAuditableCommon);
                    feature.define(cx, scope, (IScriptEnvironment)WorkItemCommonScriptEnvironment.this);
                }
                return null;
            }
        });
    }
}

